package com.floreantpos.model.util.pricecalc;

import java.lang.reflect.Method;

import com.floreantpos.model.TicketItem;

public class TicketItemCalcFactory {
	private static TicketItemCalc ticketItemCalcV2;

	public static TicketItemCalc getCalc(TicketItem ticketItem) {
		try {
			if (ticketItemCalcV2 != null) {
				return ticketItemCalcV2;
			}

			Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.TicketItemPriceCalcV2"); //$NON-NLS-1$
			Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
			ticketItemCalcV2 = (TicketItemCalc) method.invoke(null);

			return ticketItemCalcV2;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
