package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the DISCHARGE_RECORD table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DISCHARGE_RECORD"
 */

public abstract class BaseDischargeRecord  implements Comparable, Serializable {

	public static String REF = "DischargeRecord"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_ADMISSION_ID = "admissionId"; //$NON-NLS-1$
	public static String PROP_ROOM_ID = "roomId"; //$NON-NLS-1$
	public static String PROP_INSTRUCTION = "instruction"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_BED_ID = "bedId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_PROBLEMS = "problems"; //$NON-NLS-1$
	public static String PROP_DISCHARGE_SUMMARY = "dischargeSummary"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_DISCHARGE_DATE = "dischargeDate"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_MEDICATIONS = "medications"; //$NON-NLS-1$
	public static String PROP_DISCHARGE_REASON = "dischargeReason"; //$NON-NLS-1$
	public static String PROP_DIAGNOSIS = "diagnosis"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseDischargeRecord () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDischargeRecord (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date createdDate;
				private java.util.Date dischargeDate;
				private java.lang.String admissionId;
				private java.lang.String doctorId;
				private java.lang.String patientId;
				private java.lang.String roomId;
				private java.lang.String bedId;
				private java.lang.String status;
				private java.lang.String dischargeReason;
				private java.lang.String problems;
				private java.lang.String diagnosis;
				private java.lang.String medications;
				private java.lang.String instruction;
				private java.lang.String dischargeSummary;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: DISCHARGE_DATE
	 */

	public java.util.Date getDischargeDate () {
			return dischargeDate;
	}



	/**
	 * Set the value related to the column: DISCHARGE_DATE
	 * @param dischargeDate the DISCHARGE_DATE value
	 */
			public void setDischargeDate (java.util.Date dischargeDate) {
			this.dischargeDate = dischargeDate;
	}



	/**
	 * Return the value associated with the column: ADMISSION_ID
	 */

	public java.lang.String getAdmissionId () {
			return admissionId;
	}



	/**
	 * Set the value related to the column: ADMISSION_ID
	 * @param admissionId the ADMISSION_ID value
	 */
			public void setAdmissionId (java.lang.String admissionId) {
			this.admissionId = admissionId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: ROOM_ID
	 */

	public java.lang.String getRoomId () {
			return roomId;
	}



	/**
	 * Set the value related to the column: ROOM_ID
	 * @param roomId the ROOM_ID value
	 */
			public void setRoomId (java.lang.String roomId) {
			this.roomId = roomId;
	}



	/**
	 * Return the value associated with the column: BED_ID
	 */

	public java.lang.String getBedId () {
			return bedId;
	}



	/**
	 * Set the value related to the column: BED_ID
	 * @param bedId the BED_ID value
	 */
			public void setBedId (java.lang.String bedId) {
			this.bedId = bedId;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: DISCHARGE_REASON
	 */

	public java.lang.String getDischargeReason () {
			return dischargeReason;
	}



	/**
	 * Set the value related to the column: DISCHARGE_REASON
	 * @param dischargeReason the DISCHARGE_REASON value
	 */
			public void setDischargeReason (java.lang.String dischargeReason) {
			this.dischargeReason = dischargeReason;
	}



	/**
	 * Return the value associated with the column: PROBLEMS
	 */

	public java.lang.String getProblems () {
			return problems;
	}



	/**
	 * Set the value related to the column: PROBLEMS
	 * @param problems the PROBLEMS value
	 */
			public void setProblems (java.lang.String problems) {
			this.problems = problems;
	}



	/**
	 * Return the value associated with the column: DIAGNOSIS
	 */

	public java.lang.String getDiagnosis () {
			return diagnosis;
	}



	/**
	 * Set the value related to the column: DIAGNOSIS
	 * @param diagnosis the DIAGNOSIS value
	 */
			public void setDiagnosis (java.lang.String diagnosis) {
			this.diagnosis = diagnosis;
	}



	/**
	 * Return the value associated with the column: MEDICATIONS
	 */

	public java.lang.String getMedications () {
			return medications;
	}



	/**
	 * Set the value related to the column: MEDICATIONS
	 * @param medications the MEDICATIONS value
	 */
			public void setMedications (java.lang.String medications) {
			this.medications = medications;
	}



	/**
	 * Return the value associated with the column: INSTRUCTION
	 */

	public java.lang.String getInstruction () {
			return instruction;
	}



	/**
	 * Set the value related to the column: INSTRUCTION
	 * @param instruction the INSTRUCTION value
	 */
			public void setInstruction (java.lang.String instruction) {
			this.instruction = instruction;
	}



	/**
	 * Return the value associated with the column: DISCHARGE_SUMMARY
	 */

	public java.lang.String getDischargeSummary () {
			return dischargeSummary;
	}



	/**
	 * Set the value related to the column: DISCHARGE_SUMMARY
	 * @param dischargeSummary the DISCHARGE_SUMMARY value
	 */
			public void setDischargeSummary (java.lang.String dischargeSummary) {
			this.dischargeSummary = dischargeSummary;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DischargeRecord)) return false;
		else {
			com.floreantpos.model.DischargeRecord dischargeRecord = (com.floreantpos.model.DischargeRecord) obj;
			if (null == this.getId() || null == dischargeRecord.getId()) return this == obj;
			else return (this.getId().equals(dischargeRecord.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}