package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the TEST_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TEST_ITEM"
 */

public abstract class BaseTestItem  implements Serializable {

	public static String REF = "TestItem"; //$NON-NLS-1$
	public static String PROP_FORMULA_STRING = "formulaString"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_APPROVED_NOTE = "approvedNote"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_RESULT = "result"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_MACHINE_CODE = "machineCode"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_VISIBLE = "visible"; //$NON-NLS-1$
	public static String PROP_TEST_ITEM_GROUP_NAME = "testItemGroupName"; //$NON-NLS-1$
	public static String PROP_TEST_ITEM_GROUP_ID = "testItemGroupId"; //$NON-NLS-1$
	public static String PROP_NORMAL_VALUE = "normalValue"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseTestItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTestItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseTestItem (
		java.lang.String id,
		java.lang.String name) {

		this.setId(id);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String name;
				private java.lang.String testItemGroupId;
				private java.lang.String testItemGroupName;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String result;
				private java.lang.String unit;
				private java.lang.String machineCode;
				private java.lang.String normalValue;
				private java.lang.String approvedNote;
				private java.lang.Integer sortOrder;
				private java.lang.Boolean visible;
				private java.lang.String formulaString;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.NameBaseIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TEST_ITEM_GROUP_ID
	 */

	public java.lang.String getTestItemGroupId () {
			return testItemGroupId;
	}



	/**
	 * Set the value related to the column: TEST_ITEM_GROUP_ID
	 * @param testItemGroupId the TEST_ITEM_GROUP_ID value
	 */
			public void setTestItemGroupId (java.lang.String testItemGroupId) {
			this.testItemGroupId = testItemGroupId;
	}



	/**
	 * Return the value associated with the column: TEST_ITEM_GROUP_NAME
	 */

	public java.lang.String getTestItemGroupName () {
			return testItemGroupName;
	}



	/**
	 * Set the value related to the column: TEST_ITEM_GROUP_NAME
	 * @param testItemGroupName the TEST_ITEM_GROUP_NAME value
	 */
			public void setTestItemGroupName (java.lang.String testItemGroupName) {
			this.testItemGroupName = testItemGroupName;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: RESULT
	 */

	public java.lang.String getResult () {
			return result;
	}



	/**
	 * Set the value related to the column: RESULT
	 * @param result the RESULT value
	 */
			public void setResult (java.lang.String result) {
			this.result = result;
	}



	/**
	 * Return the value associated with the column: UNIT
	 */

	public java.lang.String getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: UNIT
	 * @param unit the UNIT value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: MACHINE_CODE
	 */

	public java.lang.String getMachineCode () {
			return machineCode;
	}



	/**
	 * Set the value related to the column: MACHINE_CODE
	 * @param machineCode the MACHINE_CODE value
	 */
			public void setMachineCode (java.lang.String machineCode) {
			this.machineCode = machineCode;
	}



	/**
	 * Return the value associated with the column: NORMAL_VALUE
	 */

	public java.lang.String getNormalValue () {
			return normalValue;
	}



	/**
	 * Set the value related to the column: NORMAL_VALUE
	 * @param normalValue the NORMAL_VALUE value
	 */
			public void setNormalValue (java.lang.String normalValue) {
			this.normalValue = normalValue;
	}



	/**
	 * Return the value associated with the column: APPROVED_NOTE
	 */

	public java.lang.String getApprovedNote () {
			return approvedNote;
	}



	/**
	 * Set the value related to the column: APPROVED_NOTE
	 * @param approvedNote the APPROVED_NOTE value
	 */
			public void setApprovedNote (java.lang.String approvedNote) {
			this.approvedNote = approvedNote;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: VISIBLE
	 */

	public java.lang.Boolean isVisible () {
						return visible == null ? Boolean.valueOf(true) : visible;
			}

	public java.lang.Boolean getVisible () {
					return visible == null ? Boolean.valueOf(true) : visible;
			}


	/**
	 * Set the value related to the column: VISIBLE
	 * @param visible the VISIBLE value
	 */
			public void setVisible (java.lang.Boolean visible) {
			this.visible = visible;
	}


	/**
	 * Custom property
	 */
	public static String getVisibleDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: FORMULA_STRING
	 */

	public java.lang.String getFormulaString () {
			return formulaString;
	}



	/**
	 * Set the value related to the column: FORMULA_STRING
	 * @param formulaString the FORMULA_STRING value
	 */
			public void setFormulaString (java.lang.String formulaString) {
			this.formulaString = formulaString;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.TestItem)) return false;
		else {
			com.floreantpos.model.TestItem testItem = (com.floreantpos.model.TestItem) obj;
			if (null == this.getId() || null == testItem.getId()) return this == obj;
			else return (this.getId().equals(testItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}