package com.floreantpos.model.util;

import java.util.List;

import com.floreantpos.model.BankAccount;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;

public class FeePaymentMapper {

	private CustomPayment customPayment;
	private String customPaymnetRef;
	private BankAccount bankAccount;
	private double unpaidAmount;
	private double tenderAmount;
	private boolean isDoctorPayment;
	private List<Ticket> unpaidTickets;
	private List<TicketItem> unpaidTicketItems;
	private Customer referrer;
	private Terminal terminal;
	private User user;

	private String ticketIds;
	private double payoutAmount;
	private CashDrawer cashDrawer;
	private Integer ticketTypeNo;
	private boolean isRefundPayment;

	public FeePaymentMapper(CustomPayment customPayment, String customPaymnetRef, double unpaidAmount, double tenderAmount, boolean isDoctorPayment,
			List<Ticket> unpaidTickets, List<TicketItem> unpaidTicketItems, Customer referrer, Terminal terminal, User user, Integer ticketTypeNo) {
		this(customPayment, customPaymnetRef, null, unpaidAmount, tenderAmount, isDoctorPayment, unpaidTickets, unpaidTicketItems, referrer, terminal, user,
				ticketTypeNo, false);
	}

	public FeePaymentMapper(CustomPayment customPayment, String customPaymnetRef, double unpaidAmount, double tenderAmount, boolean isDoctorPayment,
			List<Ticket> unpaidTickets, List<TicketItem> unpaidTicketItems, Customer referrer, Terminal terminal, User user, Integer ticketTypeNo,
			boolean isRefundPayment) {
		this(customPayment, customPaymnetRef, null, unpaidAmount, tenderAmount, isDoctorPayment, unpaidTickets, unpaidTicketItems, referrer, terminal, user,
				ticketTypeNo, isRefundPayment);
	}

	public FeePaymentMapper(CustomPayment customPayment, String customPaymnetRef, BankAccount bankAccount, double unpaidAmount, double tenderAmount,
			boolean isDoctorPayment, List<Ticket> unpaidTickets, List<TicketItem> unpaidTicketItems, Customer referrer, Terminal terminal, User user,
			Integer ticketTypeNo, boolean isRefundPayment) {
		super();
		this.customPayment = customPayment;
		this.customPaymnetRef = customPaymnetRef;
		this.bankAccount = bankAccount;
		this.unpaidAmount = unpaidAmount;
		this.tenderAmount = tenderAmount;
		this.isDoctorPayment = isDoctorPayment;
		this.unpaidTickets = unpaidTickets;
		this.unpaidTicketItems = unpaidTicketItems;
		this.referrer = referrer;
		this.terminal = terminal;
		this.user = user;
		this.setTicketTypeNo(ticketTypeNo);
		this.isRefundPayment = isRefundPayment;
	}

	public FeePaymentMapper(String ticketIds, Customer referrer, double payoutAmount, double tenderAmount, CustomPayment customPayment, String customPaymnetRef,
			User user, Terminal terminal, CashDrawer cashDrawer, Integer ticketTypeNo) {
		this(ticketIds, referrer, payoutAmount, tenderAmount, customPayment, customPaymnetRef, null, user, terminal, cashDrawer, ticketTypeNo, false);
	}

	public FeePaymentMapper(String ticketIds, Customer referrer, double payoutAmount, double tenderAmount, CustomPayment customPayment, String customPaymnetRef,
			User user, Terminal terminal, CashDrawer cashDrawer, Integer ticketTypeNo, boolean isRefundPayment) {
		this(ticketIds, referrer, payoutAmount, tenderAmount, customPayment, customPaymnetRef, null, user, terminal, cashDrawer, ticketTypeNo, isRefundPayment);
	}

	public FeePaymentMapper(String ticketIds, Customer referrer, double payoutAmount, double tenderAmount, CustomPayment customPayment, String customPaymnetRef,
			BankAccount bankAccount, User user, Terminal terminal, CashDrawer cashDrawer, Integer ticketTypeNo, boolean isRefundPayment) {
		super();
		this.ticketIds = ticketIds;
		this.referrer = referrer;
		this.payoutAmount = payoutAmount;
		this.tenderAmount = tenderAmount;
		this.customPayment = customPayment;
		this.customPaymnetRef = customPaymnetRef;
		this.bankAccount = bankAccount;
		this.user = user;
		this.terminal = terminal;
		this.cashDrawer = cashDrawer;
		this.setTicketTypeNo(ticketTypeNo);
		this.isRefundPayment = isRefundPayment;
	}

	public CustomPayment getCustomPayment() {
		return customPayment;
	}

	public void setCustomPayment(CustomPayment customPayment) {
		this.customPayment = customPayment;
	}

	public String getCustomPaymnetRef() {
		return customPaymnetRef;
	}

	public void setCustomPaymnetRef(String customPaymnetRef) {
		this.customPaymnetRef = customPaymnetRef;
	}

	public double getUnpaidAmount() {
		return unpaidAmount;
	}

	public void setUnpaidAmount(double unpaidAmount) {
		this.unpaidAmount = unpaidAmount;
	}

	public double getTenderAmount() {
		return tenderAmount;
	}

	public void setTenderAmount(double tenderAmount) {
		this.tenderAmount = tenderAmount;
	}

	public boolean isDoctorPayment() {
		return isDoctorPayment;
	}

	public void setDoctorPayment(boolean isDoctorPayment) {
		this.isDoctorPayment = isDoctorPayment;
	}

	public List<Ticket> getUnpaidTickets() {
		return unpaidTickets;
	}

	public void setUnpaidTickets(List<Ticket> unpaidTickets) {
		this.unpaidTickets = unpaidTickets;
	}

	public List<TicketItem> getUnpaidTicketItems() {
		return unpaidTicketItems;
	}

	public void setUnpaidTicketItems(List<TicketItem> unpaidTicketItems) {
		this.unpaidTicketItems = unpaidTicketItems;
	}

	public Customer getReferrer() {
		return referrer;
	}

	public void setReferrer(Customer referrer) {
		this.referrer = referrer;
	}

	public Terminal getTerminal() {
		return terminal;
	}

	public void setTerminal(Terminal terminal) {
		this.terminal = terminal;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getTicketIds() {
		return ticketIds;
	}

	public void setTicketIds(String ticketIds) {
		this.ticketIds = ticketIds;
	}

	public double getPayoutAmount() {
		return payoutAmount;
	}

	public void setPayoutAmount(double payoutAmount) {
		this.payoutAmount = payoutAmount;
	}

	public CashDrawer getCashDrawer() {
		return cashDrawer;
	}

	public void setCashDrawer(CashDrawer cashDrawer) {
		this.cashDrawer = cashDrawer;
	}

	public Integer getTicketTypeNo() {
		return ticketTypeNo;
	}

	public void setTicketTypeNo(Integer ticketTypeNo) {
		this.ticketTypeNo = ticketTypeNo;
	}

	public boolean isRefundPayment() {
		return isRefundPayment;
	}

	public BankAccount getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(BankAccount bankAccount) {
		this.bankAccount = bankAccount;
	}
}
