package com.floreantpos.model.util.pricecalc;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;

public interface TicketItemCalc {
	void calculatePrice(TicketItem ticket);

	void updateModifiersUnitPriceByGroup(TicketItem ticketItem, MenuItemModifierSpec group);

	double calculateDiscount(TicketItem ticketItem, double subtotalAmount);

	void doCalculateComboItemPrice(TicketItem calTicketItem, boolean editMode);

	void doCalculateComboItemPrice(TicketItem calTicketItem, boolean editMode, boolean useOnlinePrice);

	TicketItemModifier addTicketItemModifier(TicketItem ticketItem, MenuModifier menuModifier, int modifierType, OrderType type, Multiplier multiplier,
			double quantity);

	VoidItem createVoidItem(TicketItem ticketItem, String voidReason, boolean wasted, double quantity, User currentUser, CashDrawer cashdrawer);

	void markVoided(TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity, boolean returned);

	void setVoidProperties(TicketItem ticketItem, String voidReason, boolean wasted, double quantity, boolean printedToKitchen, User user);

	int countModifierFromGroup(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierGroup);

	boolean requiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec);

	boolean deleteTicketItemModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifierToRemove);

	boolean deleteTicketItemModifierByName(TicketItem ticketItem, TicketItemModifier ticketItemModifierToRemove);
}
