package com.orocube.medlogics.chemo;

import java.io.Serializable;
import java.util.Date;

/**
 * Helper POJO for storing chemotherapy day information
 * Contains doctor ID, date, and status for each day of the cycle
 */
public class ChemoDate implements Serializable {
	private static final long serialVersionUID = 1L;

	private String doctorId;
	private Date date;
	private String status;
	private String treatment;
	private String drugs;
	private String note;
	private Double bodyWeight;

	public ChemoDate() {
	}

	public ChemoDate(String doctorId, Date date) {
		this.doctorId = doctorId;
		this.date = date;
	}

	public ChemoDate(String doctorId, Date date, String status) {
		this.doctorId = doctorId;
		this.date = date;
		this.status = status;
	}

	public String getDoctorId() {
		return doctorId;
	}

	public void setDoctorId(String doctorId) {
		this.doctorId = doctorId;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getTreatment() {
		return treatment;
	}

	public void setTreatment(String treatment) {
		this.treatment = treatment;
	}

	public String getDrugs() {
		return drugs;
	}

	public void setDrugs(String drugs) {
		this.drugs = drugs;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Double getBodyWeight() {
		return bodyWeight;
	}

	public void setBodyWeight(Double bodyWeight) {
		this.bodyWeight = bodyWeight;
	}

	/**
	 * Get doctor name for display in templates.
	 * Loads doctor from database using doctorId.
	 * @return doctor name or empty string if not found
	 */
	public String getDoctorNameDisplay() {
		if (org.apache.commons.lang.StringUtils.isBlank(doctorId)) {
			return "";
		}

		try {
			com.floreantpos.model.Doctor doctor = com.floreantpos.model.dao.DoctorDAO.getInstance().get(doctorId);
			if (doctor != null) {
				return doctor.getName();
			}
		} catch (Exception e) {
			// Ignore - doctor might not be available
		}
		return "";
	}

	@Override
	public String toString() {
		return "ChemoDate{" +
				"doctorId='" + doctorId + '\'' +
				", date=" + date +
				", status='" + status + '\'' +
				", treatment='" + treatment + '\'' +
				", drugs='" + drugs + '\'' +
				", note='" + note + '\'' +
				", bodyWeight=" + bodyWeight +
				'}';
	}
}
