package com.floreantpos.model;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseConsent;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class Consent extends BaseConsent implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;
	private transient Patient patient;
	private transient Doctor doctor;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Consent() {
	}

	/**
	 * Constructor for primary key
	 */
	public Consent(java.lang.String id) {
		super(id);
	}

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public String getCreateDateDisplay() {
		if (getCreateDate() == null) {
			return null;
		}
		return DateUtil.formatReportDate(getCreateDate());
	}

	public String getPatientName() {
		if (getPatient() == null) {
			return StringUtils.EMPTY;
		}
		return patient.getName();
	}

	public String getDoctorName() {
		if (getDoctor() == null) {
			return StringUtils.EMPTY;
		}
		return doctor.getName();
	}

	public Patient getPatient() {
		if (patient == null && StringUtils.isNotBlank(getPatientId())) {
			patient = (Patient) DataProvider.get().getCustomer(getPatientId());
		}
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
		setPatientId(patient == null ? null : patient.getId());
	}

	public Doctor getDoctor() {
		if (doctor == null && StringUtils.isNotBlank(getDoctorId())) {
			doctor = (Doctor) DataProvider.get().getCustomer(getDoctorId());
		}
		return doctor;
	}

	public void setDoctor(Doctor doctor) {
		this.doctor = doctor;
		setDoctorId(doctor == null ? null : doctor.getId());
	}

	public String getConsentDateDisplay() {
		Date consentDate = getConsentDate();
		if (consentDate == null) {
			return StringUtils.EMPTY;
		}
		return DateUtil.formatDate(consentDate);
	}

	public Date getConsentDate() {
		String dateString = getProperty("consent_date");
		if (StringUtils.isNotBlank(dateString)) {
			try {
				return DateUtil.parseUTCString(dateString);
			} catch (Exception ignored) {
				return null;
			}
		}
		return null;
	}

	public void putConsentDate(Date consentDate) {
		addProperty("consent_date", DateUtil.formatDateAsUTCString(consentDate));
	}

	public void putParamValue(String paramName, String paramValue) {
		addProperty(paramName, paramValue);
	}

	public String getParamValue(String paramName) {
		return getProperty(paramName, StringUtils.EMPTY);
	}

	public Date getParamDateValue(String paramName) {
		return getDateProperty(paramName);
	}

	public void putParamDateValue(String paramName, Date consentDate) {
		addDateProperty(paramName, consentDate);
	}
}