package com.floreantpos.model;

import org.apache.commons.lang3.StringUtils;

public enum ShipmentStatus {
	CHALLAN_CREATED("Challan created"), PARTIAL_CHALAN_CREATED("Partial challan created"), CHALLAN_SHIPPED("Challan shipped");

	private String displayName;

	ShipmentStatus(String displayName) {
		this.displayName = displayName;
	}

	public String getDisplayName() {
		return displayName;
	}

	public static ShipmentStatus fromName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}

		for (ShipmentStatus status : ShipmentStatus.values()) {
			if (status.name().equals(name)) {
				return status;
			}
		}
		return null;
	}
}
