package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.BloodGroupType;
import com.floreantpos.model.Donor;
import com.floreantpos.swing.PaginatedListModel;

public class DonorDAO extends BaseDonorDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		Donor bean = (Donor) obj;
		if (bean == null) {
			throw new PosException("Donor not found!");
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	@Override
	public List<Donor> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Donor.class);
			addDeletedFilter(criteria);

			criteria.addOrder(Order.asc(Donor.PROP_FIRST_NAME));
			criteria.addOrder(Order.asc(Donor.PROP_LAST_NAME));
			return criteria.list();
		}
	}

	public void laodDonor(String donorName, String donorPhone, BloodGroupType groupType, PaginatedListModel<Donor> dataModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Donor.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(donorName)) {
				criteria.add(Restrictions.ilike(Donor.PROP_NAME, donorName, MatchMode.ANYWHERE));
			}

			if (StringUtils.isNotBlank(donorPhone)) {
				criteria.add(Restrictions.ilike(Donor.PROP_CONTACT_NUMBER, donorPhone, MatchMode.ANYWHERE));
			}

			if (groupType != null) {
				criteria.add(Restrictions.eq(Donor.PROP_BLOOD_GROUP, groupType.name()));
			}

			dataModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());

			dataModel.setData(criteria.list());
		}
	}
}