package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.DecimalFormat;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

import com.floreantpos.PosLog;
import com.floreantpos.model.Challan;
import com.floreantpos.model.dao.ChallanDAO;

public class ChallanIdGenerator implements IdentifierGenerator {
	@Override
	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
		Class<? extends Object> clazz = object.getClass();
		Serializable generatedId = null;
		try {
			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
			if (method != null) {
				Object id = method.invoke(object, (Object[]) null);
				if (id != null) {
					generatedId = (Serializable) id;
				}
			}

			if (generatedId == null && object instanceof Challan) {
				Challan challan = (Challan) object;
				generatedId = generateChallanId((Session) session, challan);
			}
			else {
				generatedId = GlobalIdGenerator.generateGlobalId();
			}
		} catch (Exception e) {
			PosLog.error(ChallanIdGenerator.class, e);
		}

		return generatedId;
	}

	private static String generateChallanId(Session session, Challan challan) {

		String ticketId = challan.getTicketId();
		if (StringUtils.isBlank(ticketId)) {
			return GlobalIdGenerator.generateGlobalId();
		}

		DecimalFormat twoDigitDecimalFormat = new DecimalFormat("00");
		int suffixNumber = ChallanDAO.getInstance().rowCountByTicketId(ticketId) + 1;

		challan.putChallanNo(String.valueOf(suffixNumber));

		return ticketId + "_" + twoDigitDecimalFormat.format(suffixNumber); //$NON-NLS-1$
	}
}
