/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.util.pricecalc.TicketItemModifierCalc;
import com.floreantpos.util.NumberUtil;
import com.orocube.pos.pricecalc.TicketItemPriceCalcV1;
import com.orocube.pos.pricecalc.TicketPriceCalcV1;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class TicketItemModifierPriceCalcV1
implements TicketItemModifierCalc {
    private static TicketItemModifierPriceCalcV1 instance = new TicketItemModifierPriceCalcV1();

    public void calculatePrice(TicketItemModifier modifier) {
        if (modifier.isInfoOnly().booleanValue()) {
            return;
        }
        BigDecimal unitPrice = NumberUtil.convertToBigDecimal((double)modifier.getUnitPrice());
        BigDecimal subTotalAmount = this.calculateSubTotal(modifier, unitPrice);
        BigDecimal discountAmount = this.calculateDiscount(modifier, subTotalAmount);
        BigDecimal taxAmount = this.calculateTax(modifier, subTotalAmount, discountAmount);
        BigDecimal serviceCharge = BigDecimal.ZERO;
        BigDecimal totalAmount = NumberUtil.convertToBigDecimal((double)0.0);
        double totalCost = this.calculateTotalCost(modifier, modifier.getUnitCost());
        TicketItem ticketItem = modifier.getTicketItem();
        if (ticketItem != null) {
            serviceCharge = TicketItemPriceCalcV1.getInstance().calculateServiceCharge(modifier.getTicketItem(), subTotalAmount);
            if (ticketItem.isTaxOnServiceCharge().booleanValue()) {
                taxAmount = this.calculateTax(modifier, subTotalAmount.add(serviceCharge), discountAmount);
            }
        }
        totalAmount = modifier.isTaxIncluded() != false ? subTotalAmount.subtract(discountAmount) : subTotalAmount.subtract(discountAmount).add(taxAmount);
        totalAmount = totalAmount.add(serviceCharge);
        modifier.setTotalCost(Double.valueOf(totalCost));
        modifier.setSubTotalAmount(Double.valueOf(subTotalAmount.doubleValue()));
        modifier.setDiscountAmount(Double.valueOf(discountAmount.doubleValue()));
        modifier.setTaxAmount(Double.valueOf(taxAmount.doubleValue()));
        modifier.setServiceCharge(Double.valueOf(serviceCharge.doubleValue()));
        modifier.setTotalAmount(Double.valueOf(totalAmount.doubleValue()));
        modifier.setAdjustedUnitPrice(modifier.getUnitPrice());
        modifier.setAdjustedDiscount(Double.valueOf(discountAmount.doubleValue()));
        modifier.setAdjustedSubtotal(modifier.getSubTotalAmount());
        modifier.setAdjustedTax(modifier.getTaxAmount());
        modifier.setAdjustedTotal(modifier.getTotalAmount());
    }

    void calculateAdjustedPrice(TicketItemModifier modifier) {
        TicketItem ticketItem = modifier.getTicketItem();
        Ticket ticket = ticketItem.getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal subTotalAmount = NumberUtil.convertToBigDecimal((double)modifier.getSubTotalAmount());
        BigDecimal discountAmount = NumberUtil.convertToBigDecimal((double)modifier.getDiscountAmount());
        BigDecimal subtotalAfterDiscount = NumberUtil.round((BigDecimal)subTotalAmount.subtract(discountAmount));
        BigDecimal ticketDiscountAmount = NumberUtil.round((BigDecimal)NumberUtil.convertToBigDecimal((double)ticket.getTicketDiscountAmount()));
        BigDecimal ticketSubtotalAmount = NumberUtil.round((BigDecimal)NumberUtil.convertToBigDecimal((double)ticket.getSubtotalAmountWithVoidItems()));
        BigDecimal totalItemDiscountAmount = NumberUtil.round((BigDecimal)NumberUtil.convertToBigDecimal((double)ticket.getItemDiscountAmount()));
        BigDecimal ticketSubtotalAfterItemDiscount = NumberUtil.round((BigDecimal)ticketSubtotalAmount.subtract(totalItemDiscountAmount));
        BigDecimal ticketSubtotalAfterAllDiscount = NumberUtil.round((BigDecimal)ticketSubtotalAfterItemDiscount.subtract(ticketDiscountAmount));
        BigDecimal adjustedSubtotal = subtotalAfterDiscount.multiply(ticketSubtotalAfterAllDiscount).divide(ticketSubtotalAfterItemDiscount, 4, RoundingMode.HALF_UP);
        BigDecimal adjustedDiscount = NumberUtil.round((BigDecimal)subTotalAmount.subtract(adjustedSubtotal));
        BigDecimal adjustedTax = NumberUtil.round((BigDecimal)this.calculateTax(modifier, adjustedSubtotal, new BigDecimal("0")));
        BigDecimal adjustedTotal = NumberUtil.convertToBigDecimal((double)0.0);
        if (adjustedTax.doubleValue() < 0.0) {
            adjustedTax = BigDecimal.ZERO;
        }
        adjustedTotal = modifier.isTaxIncluded() != false ? adjustedSubtotal : NumberUtil.round((BigDecimal)adjustedSubtotal.add(adjustedTax));
        adjustedTotal = adjustedTotal.add(NumberUtil.convertToBigDecimal((double)modifier.getServiceCharge()));
        modifier.setAdjustedUnitPrice(Double.valueOf(adjustedSubtotal.divide(NumberUtil.convertToBigDecimal((double)ticketItem.getQuantity()), 4, RoundingMode.HALF_UP).doubleValue()));
        modifier.setAdjustedDiscount(Double.valueOf(adjustedDiscount.doubleValue()));
        modifier.setAdjustedSubtotal(Double.valueOf(adjustedSubtotal.doubleValue()));
        modifier.setAdjustedTax(Double.valueOf(adjustedTax.doubleValue()));
        modifier.setAdjustedTotal(Double.valueOf(adjustedTotal.doubleValue()));
    }

    private BigDecimal calculateTax(TicketItemModifier modifier, BigDecimal subtotalAmount, BigDecimal discountAmount) {
        Ticket ticket = modifier.getTicketItem().getTicket();
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalTaxAmount = NumberUtil.convertToBigDecimal((String)"0");
        subtotalAmount = subtotalAmount.subtract(discountAmount);
        List taxList = modifier.getTaxes();
        if (taxList != null) {
            if (modifier.isTaxIncluded().booleanValue()) {
                BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal((double)0.0);
                for (TicketItemTax ticketItemModifierTax : taxList) {
                    taxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal((double)ticketItemModifierTax.getRate()).divide(NumberUtil.convertToBigDecimal((String)"100"), 4, RoundingMode.HALF_UP));
                }
                if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal((String)"0")) == 0) {
                    return totalTaxAmount;
                }
                BigDecimal totalTaxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal((double)1.0));
                double actualPrice = subtotalAmount.doubleValue() / totalTaxRatePercentage.doubleValue();
                for (TicketItemTax ticketItemModifierTax : taxList) {
                    taxRatePercentage = NumberUtil.convertToBigDecimal((double)ticketItemModifierTax.getRate()).divide(NumberUtil.convertToBigDecimal((String)"100"), 4, RoundingMode.HALF_UP);
                    BigDecimal tax = NumberUtil.convertToBigDecimal((double)actualPrice).multiply(taxRatePercentage);
                    ticketItemModifierTax.setTaxAmount(Double.valueOf(tax.doubleValue()));
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            } else {
                for (TicketItemTax ticketItemModifierTax : taxList) {
                    BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal((double)ticketItemModifierTax.getRate()).divide(NumberUtil.convertToBigDecimal((String)"100"), 4, RoundingMode.HALF_UP);
                    if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal((String)"0")) == 0) {
                        return totalTaxAmount;
                    }
                    BigDecimal tax = subtotalAmount.multiply(taxRatePercentage);
                    ticketItemModifierTax.setTaxAmount(Double.valueOf(tax.doubleValue()));
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            }
        }
        if (totalTaxAmount.doubleValue() < 0.0) {
            totalTaxAmount = BigDecimal.ZERO;
        }
        modifier.buildTaxes();
        return TicketPriceCalcV1.getInstance().applyFloridaTaxRule(ticket, subtotalAmount, totalTaxAmount);
    }

    private BigDecimal calculateSubTotal(TicketItemModifier modifier, BigDecimal unitPrice) {
        Double modifierQty = modifier.getItemQuantity();
        if (modifier.getTicketItem() != null) {
            modifierQty = modifierQty * Math.abs(modifier.getTicketItem().getQuantity());
        }
        return unitPrice.multiply(NumberUtil.convertToBigDecimal((double)modifierQty));
    }

    private double calculateTotalCost(TicketItemModifier modifier, double unitCost) {
        Double modifierQty = modifier.getItemQuantity();
        TicketItem ticketItem = modifier.getTicketItem();
        if (ticketItem != null) {
            modifierQty = modifierQty * Math.abs(ticketItem.getQuantity());
        }
        return unitCost * modifierQty;
    }

    private BigDecimal calculateDiscount(TicketItemModifier modifier, BigDecimal subtotalAmount) {
        BigDecimal discount = NumberUtil.convertToBigDecimal((double)0.0);
        List discounts = modifier.getTicketItem().getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    discount = discount.add(ticketItemDiscount.calculateDiscount(subtotalAmount));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double discountPercentage = ticketItemDiscount.getValue() * 100.0 / modifier.getTicketItem().getSubtotalAmount();
                TicketItemDiscount percentDiscount = new TicketItemDiscount();
                percentDiscount.setType(Integer.valueOf(1));
                percentDiscount.setValue(Double.valueOf(discountPercentage));
                percentDiscount.setTicketItem(modifier.getTicketItem());
                percentDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                discount = discount.add(percentDiscount.calculateDiscount(subtotalAmount));
            }
        }
        if (discount.compareTo(subtotalAmount.abs()) > 0) {
            return subtotalAmount;
        }
        return NumberUtil.round((BigDecimal)discount);
    }

    public static TicketItemModifierPriceCalcV1 getInstance() {
        return instance;
    }
}

