/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.util.pricecalc.TicketItemCalc;
import com.floreantpos.util.NumberUtil;
import com.orocube.pos.pricecalc.TicketItemModifierPriceCalcV1;
import com.orocube.pos.pricecalc.TicketItemPriceCalcV2;
import com.orocube.pos.pricecalc.TicketPriceCalcV1;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;

public class TicketItemPriceCalcV1
implements TicketItemCalc {
    private static TicketItemPriceCalcV1 instance = new TicketItemPriceCalcV1();

    public void calculatePrice(TicketItem ticketItem) {
        if (ticketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        BigDecimal unitPrice = NumberUtil.convertToBigDecimal((double)ticketItem.getUnitPrice());
        BigDecimal itemQuantity = NumberUtil.convertToBigDecimal((double)ticketItem.getQuantity());
        BigDecimal subtotalWithoutModifiers = unitPrice.multiply(itemQuantity);
        BigDecimal discountWithoutModifiers = this.calculateDiscount(ticketItem, subtotalWithoutModifiers);
        BigDecimal serviceCharge = this.calculateServiceCharge(ticketItem, subtotalWithoutModifiers.subtract(discountWithoutModifiers));
        BigDecimal modifierSubtotal = NumberUtil.convertToBigDecimal((String)"0");
        BigDecimal modifierDiscount = NumberUtil.convertToBigDecimal((String)"0");
        BigDecimal modifierTax = NumberUtil.convertToBigDecimal((String)"0");
        double cost = ticketItem.getUnitCost() * ticketItem.getQuantity();
        double modifierCost = 0.0;
        BigDecimal taxWithoutModifiers = null;
        taxWithoutModifiers = ticketItem.isTaxOnServiceCharge() != false ? this.calculateTax(ticketItem, subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(serviceCharge)) : this.calculateTax(ticketItem, subtotalWithoutModifiers.subtract(discountWithoutModifiers));
        List ticketItemModifiers = ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            HashSet<String> averagePricedModifierList = new HashSet<String>();
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.calculatePrice();
                if (modifier.isShouldSectionWisePrice().booleanValue() && averagePricedModifierList.contains(modifier.getItemId())) continue;
                modifierSubtotal = modifierSubtotal.add(NumberUtil.convertToBigDecimal((double)modifier.getSubTotalAmount()));
                modifierDiscount = modifierDiscount.add(NumberUtil.convertToBigDecimal((double)modifier.getDiscountAmount()));
                modifierTax = modifierTax.add(NumberUtil.convertToBigDecimal((double)modifier.getTaxAmount()));
                serviceCharge = serviceCharge.add(NumberUtil.convertToBigDecimal((double)modifier.getServiceCharge()));
                modifierCost += modifier.getTotalCost().doubleValue();
                averagePricedModifierList.add(modifier.getItemId());
            }
        }
        BigDecimal subtotal = subtotalWithoutModifiers.add(modifierSubtotal);
        BigDecimal discount = this.calculateDiscount(ticketItem, subtotal);
        BigDecimal tax = taxWithoutModifiers.add(modifierTax);
        BigDecimal total = NumberUtil.convertToBigDecimal((String)"0");
        BigDecimal totalWithoutModifiers = NumberUtil.convertToBigDecimal((String)"0");
        if (ticketItem.isTaxIncluded().booleanValue()) {
            total = subtotal.subtract(discount).add(serviceCharge);
            totalWithoutModifiers = subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(serviceCharge);
        } else {
            total = subtotal.subtract(discount).add(tax).add(serviceCharge);
            totalWithoutModifiers = subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(taxWithoutModifiers).add(serviceCharge);
        }
        ticketItem.setTotalCost(Double.valueOf(cost + modifierCost));
        ticketItem.setTotalAmountWithoutModifiers(Double.valueOf(cost));
        ticketItem.setSubtotalAmount(Double.valueOf(NumberUtil.round((double)subtotal.doubleValue())));
        ticketItem.setSubtotalAmountWithoutModifiers(Double.valueOf(NumberUtil.round((double)subtotalWithoutModifiers.doubleValue())));
        ticketItem.setDiscountAmount(Double.valueOf(NumberUtil.round((double)discount.doubleValue())));
        ticketItem.setDiscountWithoutModifiers(Double.valueOf(NumberUtil.round((double)discountWithoutModifiers.doubleValue())));
        ticketItem.setTaxAmount(Double.valueOf(NumberUtil.round((double)tax.doubleValue())));
        ticketItem.setTaxAmountWithoutModifiers(Double.valueOf(NumberUtil.round((double)taxWithoutModifiers.doubleValue())));
        ticketItem.setServiceCharge(Double.valueOf(NumberUtil.round((double)serviceCharge.doubleValue())));
        ticketItem.setTotalAmount(Double.valueOf(NumberUtil.round((double)total.doubleValue())));
        ticketItem.setTotalAmountWithoutModifiers(Double.valueOf(NumberUtil.round((double)totalWithoutModifiers.doubleValue())));
        ticketItem.setAdjustedUnitPrice(Double.valueOf(unitPrice.doubleValue()));
        ticketItem.setAdjustedDiscount(Double.valueOf(NumberUtil.round((double)discount.doubleValue())));
        ticketItem.setAdjustedDiscountWithoutModifiers(Double.valueOf(NumberUtil.round((double)discountWithoutModifiers.doubleValue())));
        ticketItem.setAdjustedSubtotal(Double.valueOf(NumberUtil.round((double)subtotal.doubleValue())));
        ticketItem.setAdjustedSubtotalWithoutModifiers(Double.valueOf(NumberUtil.round((double)subtotalWithoutModifiers.doubleValue())));
        ticketItem.setAdjustedTax(Double.valueOf(NumberUtil.round((double)tax.doubleValue())));
        ticketItem.setAdjustedTaxWithoutModifiers(Double.valueOf(NumberUtil.round((double)taxWithoutModifiers.doubleValue())));
        ticketItem.setAdjustedTotal(Double.valueOf(NumberUtil.round((double)total.doubleValue())));
        ticketItem.setAdjustedTotalWithoutModifiers(Double.valueOf(NumberUtil.round((double)totalWithoutModifiers.doubleValue())));
    }

    public void calculateAdjustedPrice(TicketItem ticketItem) {
        List ticketItemModifiers;
        BigDecimal subtotalAfterDiscount;
        if (ticketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        Ticket ticket = ticketItem.getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal ticketSubtotalAmount = NumberUtil.convertToBigDecimal((double)ticket.getSubtotalAmountWithVoidItems());
        BigDecimal ticketDiscountAmount = NumberUtil.convertToBigDecimal((double)ticket.getTicketDiscountAmount());
        BigDecimal itemDiscountAmount = NumberUtil.convertToBigDecimal((double)ticket.getItemDiscountAmount());
        BigDecimal ticketSubtotalAfterItemDiscount = ticketSubtotalAmount.subtract(itemDiscountAmount);
        BigDecimal ticketSubtotalAfterAllDiscount = ticketSubtotalAfterItemDiscount.subtract(ticketDiscountAmount);
        BigDecimal adjustedSubtotalWithoutModifiers = subtotalAfterDiscount = NumberUtil.convertToBigDecimal((double)ticketItem.getSubtotalAmountWithoutModifiers()).subtract(NumberUtil.convertToBigDecimal((double)ticketItem.getDiscountWithoutModifiers()));
        if (ticketSubtotalAfterItemDiscount.compareTo(BigDecimal.ZERO) != 0) {
            adjustedSubtotalWithoutModifiers = subtotalAfterDiscount.multiply(ticketSubtotalAfterAllDiscount).divide(ticketSubtotalAfterItemDiscount, 4, RoundingMode.HALF_UP);
        }
        BigDecimal serviceCharge = this.calculateServiceCharge(ticketItem, adjustedSubtotalWithoutModifiers);
        BigDecimal adjustedTaxWithoutModifiers = this.calculateTax(ticketItem, adjustedSubtotalWithoutModifiers.add(serviceCharge));
        BigDecimal itemQuantity = NumberUtil.convertToBigDecimal((double)ticketItem.getQuantity());
        BigDecimal adjustedUnitPrice = adjustedSubtotalWithoutModifiers.divide(itemQuantity, 4, RoundingMode.HALF_UP);
        BigDecimal modifierAdjustedSubtotal = NumberUtil.convertToBigDecimal((String)"0");
        BigDecimal modifierAdjustedDiscount = NumberUtil.convertToBigDecimal((String)"0");
        BigDecimal modifierAdjustedTax = NumberUtil.convertToBigDecimal((String)"0");
        if (adjustedSubtotalWithoutModifiers.doubleValue() < 0.0) {
            adjustedSubtotalWithoutModifiers = BigDecimal.ZERO;
        }
        if ((ticketItemModifiers = ticketItem.getTicketItemModifiers()) != null) {
            HashSet<String> averagePricedModifierList = new HashSet<String>();
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                TicketItemModifierPriceCalcV1.getInstance().calculateAdjustedPrice(modifier);
                if (!modifier.isShouldSectionWisePrice().booleanValue() && averagePricedModifierList.contains(modifier.getItemId())) continue;
                modifierAdjustedSubtotal = modifierAdjustedSubtotal.add(NumberUtil.convertToBigDecimal((double)modifier.getAdjustedSubtotal()).abs());
                modifierAdjustedDiscount = modifierAdjustedDiscount.add(NumberUtil.convertToBigDecimal((double)modifier.getAdjustedDiscount()).abs());
                modifierAdjustedTax = modifierAdjustedTax.add(NumberUtil.convertToBigDecimal((double)modifier.getAdjustedTax()).abs());
                averagePricedModifierList.add(modifier.getItemId());
            }
        }
        BigDecimal adjustedSubtotal = adjustedSubtotalWithoutModifiers.add(modifierAdjustedSubtotal);
        BigDecimal myAdjustedDiscountWithoutModifiers = NumberUtil.convertToBigDecimal((double)ticketItem.getSubtotalAmountWithoutModifiers()).subtract(adjustedSubtotalWithoutModifiers);
        BigDecimal adjustedDiscount = myAdjustedDiscountWithoutModifiers.add(modifierAdjustedDiscount);
        BigDecimal adjustedTax = adjustedTaxWithoutModifiers.add(modifierAdjustedTax);
        BigDecimal adjustedTotal = NumberUtil.convertToBigDecimal((double)0.0);
        BigDecimal adjustedTotalWithoutModifiers = NumberUtil.convertToBigDecimal((double)0.0);
        if (ticketItem.isTaxIncluded().booleanValue()) {
            adjustedTotal = adjustedSubtotal.add(serviceCharge);
            adjustedTotalWithoutModifiers = adjustedSubtotalWithoutModifiers.add(serviceCharge);
        } else {
            adjustedTotal = adjustedSubtotal.add(adjustedTax).add(serviceCharge);
            adjustedTotalWithoutModifiers = adjustedSubtotalWithoutModifiers.add(adjustedTaxWithoutModifiers).add(serviceCharge);
        }
        ticketItem.setAdjustedUnitPrice(Double.valueOf(NumberUtil.round((double)adjustedUnitPrice.doubleValue())));
        ticketItem.setAdjustedDiscount(Double.valueOf(NumberUtil.round((double)adjustedDiscount.doubleValue())));
        ticketItem.setAdjustedDiscountWithoutModifiers(Double.valueOf(NumberUtil.round((double)myAdjustedDiscountWithoutModifiers.doubleValue())));
        ticketItem.setAdjustedSubtotal(Double.valueOf(adjustedSubtotal.doubleValue()));
        ticketItem.setAdjustedSubtotalWithoutModifiers(Double.valueOf(NumberUtil.round((double)adjustedSubtotalWithoutModifiers.doubleValue())));
        ticketItem.setServiceCharge(Double.valueOf(NumberUtil.round((double)serviceCharge.doubleValue())));
        ticketItem.setAdjustedTax(Double.valueOf(NumberUtil.round((double)adjustedTax.doubleValue())));
        ticketItem.setAdjustedTaxWithoutModifiers(Double.valueOf(NumberUtil.round((double)adjustedTaxWithoutModifiers.doubleValue())));
        ticketItem.setAdjustedTotal(Double.valueOf(NumberUtil.round((double)adjustedTotal.doubleValue())));
        ticketItem.setAdjustedTotalWithoutModifiers(Double.valueOf(NumberUtil.round((double)adjustedTotalWithoutModifiers.doubleValue())));
    }

    private BigDecimal calculateTax(TicketItem ticketItem, BigDecimal subtotal) {
        Ticket ticket = ticketItem.getTicket();
        BigDecimal totalTaxAmount = NumberUtil.convertToBigDecimal((String)"0");
        List taxList = ticketItem.getTaxes();
        if (taxList != null) {
            if (ticketItem.isTaxIncluded().booleanValue()) {
                BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal((double)0.0);
                for (TicketItemTax ticketItemTax : taxList) {
                    taxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal((double)ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal((String)"100"), 4, RoundingMode.HALF_EVEN));
                }
                if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal((String)"0")) == 0) {
                    return totalTaxAmount;
                }
                BigDecimal totalTaxRatePercentage = taxRatePercentage.add(NumberUtil.convertToBigDecimal((double)1.0));
                BigDecimal actualPrice = subtotal.divide(totalTaxRatePercentage, 4, RoundingMode.HALF_EVEN);
                for (TicketItemTax ticketItemTax : taxList) {
                    taxRatePercentage = NumberUtil.convertToBigDecimal((double)ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal((String)"100"), 4, RoundingMode.HALF_EVEN);
                    BigDecimal tax = actualPrice.multiply(taxRatePercentage);
                    ticketItemTax.setTaxAmount(Double.valueOf(tax.doubleValue()));
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            } else {
                for (TicketItemTax ticketItemTax : taxList) {
                    BigDecimal taxRatePercentage = NumberUtil.convertToBigDecimal((double)ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal((String)"100"), 4, RoundingMode.HALF_EVEN);
                    if (taxRatePercentage.compareTo(NumberUtil.convertToBigDecimal((String)"0")) == 0) continue;
                    BigDecimal tax = subtotal.multiply(taxRatePercentage);
                    ticketItemTax.setTaxAmount(Double.valueOf(tax.doubleValue()));
                    totalTaxAmount = totalTaxAmount.add(tax);
                }
            }
        }
        if (totalTaxAmount.doubleValue() < 0.0) {
            totalTaxAmount = BigDecimal.ZERO;
        }
        ticketItem.buildTaxes();
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            ticketItem.setTaxExemptAmount(Double.valueOf(totalTaxAmount.doubleValue()));
            return BigDecimal.ZERO;
        }
        if (ticket != null && Boolean.valueOf(ticket.getProperty("customer.taxExempt")).booleanValue()) {
            ticketItem.setTaxExemptAmount(Double.valueOf(totalTaxAmount.doubleValue()));
            return BigDecimal.ZERO;
        }
        return TicketPriceCalcV1.getInstance().applyFloridaTaxRule(ticket, subtotal, totalTaxAmount);
    }

    BigDecimal calculateServiceCharge(TicketItem ticketItem, BigDecimal subtotalAmount) {
        if (!ticketItem.isServiceChargeApplicable().booleanValue()) {
            return BigDecimal.ZERO;
        }
        Ticket ticket = ticketItem.getTicket();
        if (ticket == null || ticket.getOrderType() == null) {
            return new BigDecimal("0");
        }
        Double serviceChargeRate = ticketItem.getServiceChargeRate();
        if (serviceChargeRate == 0.0) {
            serviceChargeRate = ticket.getOutletServiceChargeRate();
        }
        if (serviceChargeRate == 0.0 || !ticket.isServiceChargeApplicable()) {
            return new BigDecimal("0");
        }
        BigDecimal bdChargeRate = NumberUtil.convertToBigDecimal((double)(serviceChargeRate / 100.0));
        return NumberUtil.round((BigDecimal)subtotalAmount.multiply(bdChargeRate));
    }

    private BigDecimal calculateDiscount(TicketItem ticketItem, BigDecimal subtotalAmount) {
        BigDecimal discount = NumberUtil.convertToBigDecimal((double)0.0);
        List discounts = ticketItem.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    discount = discount.add(NumberUtil.convertToBigDecimal((double)ticketItemDiscount.calculateDiscount(subtotalAmount.doubleValue() - discount.doubleValue())));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double discountAmount = subtotalAmount.doubleValue() == 0.0 ? 0.0 : Math.abs(ticketItemDiscount.getValue() * 100.0 / subtotalAmount.doubleValue());
                TicketItemDiscount percentDiscount = new TicketItemDiscount();
                percentDiscount.setType(Integer.valueOf(1));
                percentDiscount.setMinimumAmount(ticketItemDiscount.getMinimumAmount());
                percentDiscount.setValue(Double.valueOf(discountAmount));
                percentDiscount.setTicketItem(ticketItem);
                percentDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                percentDiscount.setApplyIfDivisible(Boolean.FALSE);
                BigDecimal convertToBigDecimal = NumberUtil.convertToBigDecimal((double)percentDiscount.calculateDiscount(subtotalAmount.doubleValue()));
                discount = discount.add(convertToBigDecimal);
                ticketItemDiscount.setAmount(Double.valueOf(convertToBigDecimal.doubleValue()));
            }
        }
        ticketItem.buildDiscounts();
        if (discount.compareTo(subtotalAmount.abs()) > 0) {
            return subtotalAmount;
        }
        return NumberUtil.round((BigDecimal)discount);
    }

    public static TicketItemPriceCalcV1 getInstance() {
        return instance;
    }

    public void updateModifiersUnitPriceByGroup(TicketItem ticketItem, MenuItemModifierSpec group) {
    }

    public double calculateDiscount(TicketItem ticketItem, double subtotalAmount) {
        return 0.0;
    }

    public void doCalculateComboItemPrice(TicketItem ticketItem, boolean editMode) {
        this.doCalculateComboItemPrice(ticketItem, editMode, false);
    }

    public void doCalculateComboItemPrice(TicketItem ticketItem, boolean editMode, boolean useOnlinePrice) {
        TicketItemPriceCalcV2.getInstance().doCalculateComboItemPrice(ticketItem, editMode, useOnlinePrice);
    }

    public TicketItemModifier addTicketItemModifier(TicketItem ticketItem, MenuModifier menuModifier, int modifierType, OrderType type, Multiplier multiplier, double quantity) {
        return TicketItemPriceCalcV2.getInstance().addTicketItemModifier(ticketItem, menuModifier, modifierType, type, multiplier, quantity);
    }

    public VoidItem createVoidItem(TicketItem ticketItem, String voidReason, boolean wasted, double quantity, User currentUser, CashDrawer cashdrawer) {
        return TicketItemPriceCalcV2.getInstance().createVoidItem(ticketItem, voidReason, wasted, quantity, currentUser, cashdrawer);
    }

    public int countModifierFromGroup(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierGroup) {
        return TicketItemPriceCalcV2.getInstance().countModifierFromGroup(ticketItem, menuItemModifierGroup);
    }

    public boolean requiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        return TicketItemPriceCalcV2.getInstance().requiredModifiersAdded(ticketItem, menuItemModifierSpec);
    }

    public boolean deleteTicketItemModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifierToRemove) {
        return TicketItemPriceCalcV2.getInstance().deleteTicketItemModifier(ticketItem, ticketItemModifierToRemove);
    }

    public boolean deleteTicketItemModifierByName(TicketItem ticketItem, TicketItemModifier ticketItemModifierToRemove) {
        return TicketItemPriceCalcV2.getInstance().deleteTicketItemModifierByName(ticketItem, ticketItemModifierToRemove);
    }

    public void markVoided(TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity, boolean returned) {
        TicketItemPriceCalcV2.getInstance().markVoided(ticketItem, voidReason, itemWasted, quantity, returned);
    }

    public void setVoidProperties(TicketItem ticketItem, String voidReason, boolean wasted, double quantity, boolean printedToKitchen, User user) {
        TicketItemPriceCalcV2.getInstance().setVoidProperties(ticketItem, voidReason, wasted, quantity, printedToKitchen, user);
    }
}

