/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.ReferralCommissionType;
import com.floreantpos.model.util.ServiceChargeType;
import com.floreantpos.model.util.pricecalc.TicketItemCalc;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.orocube.pos.pricecalc.DataUtilCalc;
import com.orocube.pos.pricecalc.TicketItemModifierPriceCalcV2;
import com.orocube.pos.pricecalc.TicketPriceCalcV2;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TicketItemPriceCalcV2
implements TicketItemCalc {
    private static TicketItemPriceCalcV2 instance = new TicketItemPriceCalcV2();

    public void calculatePrice(TicketItem ticketItem) {
        if (ticketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        Ticket ticket = ticketItem.getTicket();
        double itemQuantity = ticketItem.getQuantity();
        double unitPrice = ticketItem.getUnitPrice();
        double subtotalWithoutModifiers = NumberUtil.round((double)(unitPrice * itemQuantity));
        double totalCalculatedDiscount = NumberUtil.round((double)this.calculateDiscount(ticketItem, subtotalWithoutModifiers));
        double unitDiscountWithoutModifiers = NumberUtil.round((double)(totalCalculatedDiscount / itemQuantity));
        double unitServiceChargeWithoutModifiers = 0.0;
        double modifierSubtotal = 0.0;
        double modifierDiscount = 0.0;
        double modifierTax = 0.0;
        double modifierServiceCharge = 0.0;
        double taxWithoutModifiers = 0.0;
        double modifierCost = 0.0;
        double cost = ticketItem.getUnitCost() * itemQuantity;
        unitServiceChargeWithoutModifiers = ticket != null && (ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount()) ? this.calculateUnitServiceCharge(ticketItem, unitPrice - unitDiscountWithoutModifiers) : this.calculateUnitServiceCharge(ticketItem, unitPrice);
        taxWithoutModifiers = ticketItem.isTaxOnServiceCharge() != false ? NumberUtil.round((double)this.calculateTax(ticketItem, unitPrice - unitDiscountWithoutModifiers + unitServiceChargeWithoutModifiers)) : NumberUtil.round((double)this.calculateTax(ticketItem, unitPrice - unitDiscountWithoutModifiers));
        List ticketItemModifiers = ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            for (TicketItemModifier modifier : ticketItemModifiers) {
                modifier.setTicketItem(ticketItem);
                if (modifier.isInfoOnly().booleanValue()) continue;
                TicketItemModifierPriceCalcV2.getInstance().calculatePrice(modifier);
                modifierSubtotal += modifier.getSubTotalAmount().doubleValue();
                modifierDiscount += modifier.getDiscountAmount().doubleValue();
                modifierTax += modifier.getTaxAmount().doubleValue();
                modifierServiceCharge += modifier.getServiceCharge().doubleValue();
                modifierCost += modifier.getTotalCost().doubleValue();
            }
        }
        double discountWithoutModifiers = totalCalculatedDiscount;
        double serviceChargeWithoutModifiers = NumberUtil.round((double)(unitServiceChargeWithoutModifiers * itemQuantity));
        double totalCost = NumberUtil.round((double)(cost + modifierCost));
        double subtotal = NumberUtil.round((double)(subtotalWithoutModifiers + modifierSubtotal));
        double discount = NumberUtil.round((double)(discountWithoutModifiers + modifierDiscount));
        double tax = NumberUtil.round((double)(taxWithoutModifiers + modifierTax));
        double serviceCharge = NumberUtil.round((double)(serviceChargeWithoutModifiers + modifierServiceCharge));
        double total = 0.0;
        double totalWithoutModifiers = 0.0;
        if (ticketItem.isTaxIncluded().booleanValue()) {
            total = NumberUtil.round((double)(subtotal - discount + serviceCharge));
            totalWithoutModifiers = NumberUtil.round((double)(subtotalWithoutModifiers - discountWithoutModifiers + serviceChargeWithoutModifiers));
        } else {
            total = NumberUtil.round((double)(subtotal - discount + tax + serviceCharge));
            totalWithoutModifiers = NumberUtil.round((double)(subtotalWithoutModifiers - discountWithoutModifiers + taxWithoutModifiers + serviceChargeWithoutModifiers));
        }
        ticketItem.setTotalCost(Double.valueOf(totalCost));
        ticketItem.setTotalCostWithoutModifiers(Double.valueOf(cost));
        ticketItem.setSubtotalAmount(Double.valueOf(subtotal));
        ticketItem.setSubtotalAmountWithoutModifiers(Double.valueOf(subtotalWithoutModifiers));
        ticketItem.setDiscountAmount(Double.valueOf(discount));
        ticketItem.setDiscountWithoutModifiers(Double.valueOf(discountWithoutModifiers));
        ticketItem.setTaxAmount(Double.valueOf(tax));
        ticketItem.setTaxAmountWithoutModifiers(Double.valueOf(taxWithoutModifiers));
        ticketItem.setServiceCharge(Double.valueOf(NumberUtil.round((double)serviceCharge)));
        ticketItem.setServiceChargeWithoutModifiers(serviceChargeWithoutModifiers);
        ticketItem.setTotalAmount(Double.valueOf(total));
        ticketItem.setTotalAmountWithoutModifiers(Double.valueOf(totalWithoutModifiers));
        ticketItem.setAdjustedUnitPrice(Double.valueOf(unitPrice));
        ticketItem.setAdjustedDiscount(Double.valueOf(NumberUtil.round((double)discount)));
        ticketItem.setAdjustedDiscountWithoutModifiers(Double.valueOf(discountWithoutModifiers));
        ticketItem.setAdjustedSubtotal(Double.valueOf(subtotal));
        ticketItem.setAdjustedSubtotalWithoutModifiers(Double.valueOf(subtotalWithoutModifiers));
        ticketItem.setAdjustedTax(Double.valueOf(tax));
        ticketItem.setAdjustedTaxWithoutModifiers(Double.valueOf(taxWithoutModifiers));
        ticketItem.setAdjustedTotal(Double.valueOf(total));
        ticketItem.setAdjustedTotalWithoutModifiers(Double.valueOf(totalWithoutModifiers));
        ticketItem.buildDiscounts();
        if (ProductType.match((String)ticketItem.getProductType(), (ProductType)ProductType.PATHOLOGY) || ProductType.match((String)ticketItem.getProductType(), (ProductType)ProductType.SERVICES)) {
            ticketItem.setReferrerFeeOnReport(Double.valueOf(this.calculateCommissionOnReport(ticketItem)));
        }
        PosLog.debug(this.getClass(), (String)String.format("%s, subtotal: %s, discount: %s, sc: %s, tax: %s, RF on report %s", ticketItem.getName(), ticketItem.getSubtotalAmount(), ticketItem.getDiscountWithoutModifiers(), ticketItem.getServiceCharge(), ticketItem.getTaxAmountWithoutModifiers(), ticketItem.getReferrerFeeOnReport()));
    }

    public void calculateAdjustedPrice(TicketItem ticketItem) {
        if (ticketItem.isTreatAsSeat().booleanValue() || !ticketItem.isTicketDiscountApplicable().booleanValue()) {
            return;
        }
        Ticket ticket = ticketItem.getTicket();
        if (ticket == null) {
            return;
        }
        double itemQuantity = ticketItem.getQuantity();
        double adjustedUnitPrice = this.calculateAdjustedUnitPrice(ticket, ticketItem);
        double adjustedSubtotalWithoutModifiers = NumberUtil.round((double)(adjustedUnitPrice * itemQuantity));
        double calculatedAdjustedDiscountWithoutModifiers = NumberUtil.round((double)(ticketItem.getSubtotalAmountWithoutModifiers() - adjustedSubtotalWithoutModifiers));
        double adjustedUnitDiscountWithoutModifiers = NumberUtil.round((double)(calculatedAdjustedDiscountWithoutModifiers / itemQuantity));
        double adjustedUnitScWithoutModifiers = 0.0;
        double adjustedTaxWithoutModifiers = 0.0;
        double modifierServiceCharge = 0.0;
        adjustedUnitScWithoutModifiers = ticket != null && ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount() ? this.calculateUnitServiceCharge(ticketItem, adjustedUnitPrice - adjustedUnitDiscountWithoutModifiers) : ticketItem.getServiceChargeWithoutModifiers() / itemQuantity;
        adjustedTaxWithoutModifiers = ticketItem.isTaxOnServiceCharge() != false ? NumberUtil.round((double)this.calculateTax(ticketItem, adjustedUnitPrice + adjustedUnitDiscountWithoutModifiers)) : NumberUtil.round((double)this.calculateTax(ticketItem, adjustedUnitPrice));
        double modifierAdjustedSubtotal = 0.0;
        double modifierAdjustedDiscount = 0.0;
        double modifierAdjustedTax = 0.0;
        List ticketItemModifiers = ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            for (TicketItemModifier modifier : ticketItemModifiers) {
                modifier.setTicketItem(ticketItem);
                if (modifier.isInfoOnly().booleanValue()) continue;
                TicketItemModifierPriceCalcV2.getInstance().calculateAdjustedPrice(modifier);
                modifierAdjustedSubtotal += modifier.getAdjustedSubtotal().doubleValue();
                modifierAdjustedDiscount += modifier.getAdjustedDiscount().doubleValue();
                modifierAdjustedTax += modifier.getAdjustedTax().doubleValue();
                modifierServiceCharge += modifier.getServiceCharge().doubleValue();
            }
        }
        double adjustedDiscountWithoutModifiers = NumberUtil.round((double)(adjustedUnitDiscountWithoutModifiers * itemQuantity));
        double adjustedScWithoutModifiers = NumberUtil.round((double)(adjustedUnitScWithoutModifiers * itemQuantity));
        double adjustedSubtotal = NumberUtil.round((double)(adjustedSubtotalWithoutModifiers + modifierAdjustedSubtotal));
        double adjustedDiscount = NumberUtil.round((double)(adjustedDiscountWithoutModifiers + modifierAdjustedDiscount));
        double adjustedTax = NumberUtil.round((double)(adjustedTaxWithoutModifiers + modifierAdjustedTax));
        double adjustedTotal = 0.0;
        double adjustedTotalWithoutModifiers = 0.0;
        double adjustedServiceCharge = NumberUtil.round((double)(adjustedScWithoutModifiers + modifierServiceCharge));
        if (ticketItem.isTaxIncluded().booleanValue()) {
            adjustedTotal = NumberUtil.round((double)(adjustedSubtotal + adjustedScWithoutModifiers));
            adjustedTotalWithoutModifiers = NumberUtil.round((double)(adjustedSubtotalWithoutModifiers + adjustedScWithoutModifiers));
        } else {
            adjustedTotal = NumberUtil.round((double)(adjustedSubtotal + adjustedTax + adjustedServiceCharge));
            adjustedTotalWithoutModifiers = NumberUtil.round((double)(adjustedSubtotalWithoutModifiers + adjustedTaxWithoutModifiers + adjustedScWithoutModifiers));
        }
        ticketItem.setAdjustedUnitPrice(Double.valueOf(adjustedUnitPrice));
        ticketItem.setAdjustedDiscount(Double.valueOf(NumberUtil.round((double)adjustedDiscount)));
        ticketItem.setAdjustedDiscountWithoutModifiers(Double.valueOf(adjustedDiscountWithoutModifiers));
        ticketItem.setServiceCharge(Double.valueOf(adjustedServiceCharge));
        ticketItem.setServiceChargeWithoutModifiers(adjustedScWithoutModifiers);
        ticketItem.setAdjustedSubtotal(Double.valueOf(adjustedSubtotal));
        ticketItem.setAdjustedSubtotalWithoutModifiers(Double.valueOf(adjustedSubtotalWithoutModifiers));
        ticketItem.setAdjustedTax(Double.valueOf(adjustedTax));
        ticketItem.setAdjustedTaxWithoutModifiers(Double.valueOf(adjustedTaxWithoutModifiers));
        ticketItem.setAdjustedTotal(Double.valueOf(adjustedTotal));
        ticketItem.setAdjustedTotalWithoutModifiers(Double.valueOf(adjustedTotalWithoutModifiers));
        if (ProductType.match((String)ticketItem.getProductType(), (ProductType)ProductType.PATHOLOGY) || ProductType.match((String)ticketItem.getProductType(), (ProductType)ProductType.SERVICES)) {
            ticketItem.setReferrerFeeOnReport(Double.valueOf(this.calculateCommissionOnReport(ticketItem)));
        }
        PosLog.debug(this.getClass(), (String)String.format("Adjusted RFOnReport for ticket item %s: %s", ticketItem.getId(), ticketItem.getReferrerFeeOnReport()));
    }

    private double calculateAdjustedUnitPrice(Ticket ticket, TicketItem ticketItem) {
        double itemQuantity = ticketItem.getQuantity();
        double unitPriceAfterDiscount = NumberUtil.round((double)((ticketItem.getSubtotalAmountWithoutModifiers() - ticketItem.getDiscountWithoutModifiers()) / itemQuantity));
        double adjustedUnitPrice = 0.0;
        double ticketAmountAfterDiscount = ticket.getDiscountableSubtotal() - ticket.getItemDiscountAmount();
        for (TicketDiscount ticketDiscount : ticket.getDiscounts()) {
            double discountPercentageRate = TicketPriceCalcV2.getInstance().getDiscountPercentageRate(ticket, ticketDiscount, ticketAmountAfterDiscount);
            unitPriceAfterDiscount = adjustedUnitPrice = unitPriceAfterDiscount - unitPriceAfterDiscount * discountPercentageRate;
            double discountAmount = ticketAmountAfterDiscount * discountPercentageRate;
            ticketAmountAfterDiscount -= discountAmount;
        }
        if (ticketItem.getUnitPrice() == 0.0) {
            adjustedUnitPrice = 0.0;
        }
        return NumberUtil.round((double)adjustedUnitPrice, (int)4);
    }

    public double calculateUnitServiceCharge(TicketItem ticketItem, double unitPrice) {
        if (!ticketItem.isServiceChargeApplicable().booleanValue()) {
            return 0.0;
        }
        Ticket ticket = ticketItem.getTicket();
        if (ticket == null || !ticket.isServiceChargeApplicable()) {
            return 0.0;
        }
        Double serviceChargePercentage = ticketItem.getServiceChargeRate();
        if (serviceChargePercentage == 0.0) {
            serviceChargePercentage = ticket.getOutletServiceChargeRate();
        }
        if (serviceChargePercentage == 0.0) {
            return 0.0;
        }
        double serviceCharge = 0.0;
        ServiceChargeType serviceChargeType = ticket.getServiceChargeType();
        switch (serviceChargeType) {
            case PERCENTAGE: 
            case EMPTY: {
                serviceCharge = unitPrice * (serviceChargePercentage / 100.0);
                break;
            }
            case FIXEDAMOUNT: {
                serviceCharge = 0.0;
            }
        }
        if (serviceCharge < 0.0 && !ticketItem.isServiceChargeRefundable().booleanValue()) {
            serviceCharge = 0.0;
        }
        return serviceCharge;
    }

    public double calculateDiscount(TicketItem ticketItem, double subtotalWithoutModifiers) {
        double discount = 0.0;
        List discounts = ticketItem.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    discount += NumberUtil.round((double)ticketItemDiscount.calculateDiscount(Math.abs(subtotalWithoutModifiers) - discount));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                Double subtotalAfterDiscountAmount = Math.abs(subtotalWithoutModifiers) - discount;
                double ticketItemDiscountAmount = ticketItemDiscount.getValue() * ticketItemDiscount.getCouponQuantity();
                if (subtotalWithoutModifiers < 0.0 && ticketItem.getUnitPriceWithoutModifierAfterDiscount() != null) {
                    double priceAfterDiscount = Math.abs(ticketItem.getUnitPriceWithoutModifierAfterDiscount() * ticketItem.getQuantity());
                    if (NumberUtil.isZero((Double)priceAfterDiscount)) {
                        Double value = ticketItemDiscount.getAmount();
                        ticketItemDiscountAmount = value < subtotalAfterDiscountAmount ? value.doubleValue() : subtotalAfterDiscountAmount.doubleValue();
                    } else {
                        double absSubtotalAmount = Math.abs(subtotalWithoutModifiers);
                        if (priceAfterDiscount < absSubtotalAmount) {
                            TicketItem origTicketItem = ticketItem.getTicket().getTicketItem(ticketItem.getVoidedItemId());
                            double totalDiscount = absSubtotalAmount - priceAfterDiscount;
                            double maxDiscount = ticketItemDiscount.getValue() * ticketItemDiscount.getCouponQuantity() / Math.abs(origTicketItem.getQuantity()) * Math.abs(ticketItem.getQuantity());
                            ticketItemDiscountAmount = totalDiscount > maxDiscount ? maxDiscount : totalDiscount;
                        } else {
                            ticketItemDiscountAmount = 0.0;
                        }
                    }
                } else if (ticketItemDiscountAmount >= subtotalAfterDiscountAmount) {
                    ticketItemDiscountAmount = subtotalAfterDiscountAmount;
                }
                ticketItemDiscount.setAmount(Double.valueOf(ticketItemDiscountAmount));
                ticketItemDiscount.setAmountWithoutModifiers(ticketItemDiscountAmount);
                discount += ticketItemDiscountAmount;
            }
        }
        if (subtotalWithoutModifiers < 0.0) {
            return -1.0 * Math.abs(discount);
        }
        if (discount > Math.abs(subtotalWithoutModifiers)) {
            return subtotalWithoutModifiers;
        }
        return discount;
    }

    private double calculateTax(TicketItem ticketItem, double unitPrice) {
        return NumberUtil.round((double)(ticketItem.getQuantity() * NumberUtil.round((double)this.calculateUnitTax(ticketItem, unitPrice))));
    }

    private double calculateUnitTax(TicketItem ticketItem, double unitPrice) {
        Ticket ticket = ticketItem.getTicket();
        double totalTaxAmount = 0.0;
        List taxList = ticketItem.getTaxes();
        if (taxList != null) {
            if (ticket != null && ticket.isTaxIncluded().booleanValue()) {
                for (TicketItemTax ticketItemTax : taxList) {
                    if (ticketItemTax.getRate() == 0.0) {
                        ticketItemTax.setTaxAmount(Double.valueOf(0.0));
                        continue;
                    }
                    double actualPrice = unitPrice / (ticketItemTax.getRate() / 100.0 + 1.0);
                    double tax = NumberUtil.round((double)(actualPrice * ticketItemTax.getRate() / 100.0));
                    ticketItemTax.setTaxAmount(Double.valueOf(tax * ticketItem.getQuantity()));
                    totalTaxAmount += tax;
                }
            } else {
                for (TicketItemTax ticketItemTax : taxList) {
                    if (ticketItemTax.getRate() == 0.0) continue;
                    double taxAmount = NumberUtil.round((double)(unitPrice * ticketItemTax.getRate() / 100.0));
                    ticketItemTax.setTaxAmount(Double.valueOf(taxAmount * ticketItem.getQuantity()));
                    totalTaxAmount += taxAmount;
                }
            }
        }
        totalTaxAmount = TicketPriceCalcV2.getInstance().applyFloridaTaxRuleV2(ticketItem.getTicket(), unitPrice, totalTaxAmount);
        ticketItem.buildTaxes();
        ticketItem.setTaxExemptAmount(Double.valueOf(0.0));
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            ticketItem.setTaxExemptAmount(Double.valueOf(totalTaxAmount));
            return 0.0;
        }
        return totalTaxAmount;
    }

    public void updateModifiersUnitPriceByGroup(TicketItem ticketItem, MenuItemModifierSpec group) {
        List ticketItemModifiers = ticketItem.getTicketItemModifiers();
        ArrayList<TicketItemModifier> groupModifiers = new ArrayList<TicketItemModifier>();
        if (ticketItemModifiers != null) {
            double numOfModifiers = 0.0;
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                if (ticketItemModifier.isInfoOnly().booleanValue() || !ticketItemModifier.getGroupId().equals(group.getId())) continue;
                ticketItemModifier.setMultiplierName(null);
                groupModifiers.add(ticketItemModifier);
                numOfModifiers += ticketItemModifier.getItemQuantity().doubleValue();
            }
            Double groupPrice = group.getPrice(Integer.valueOf((int)numOfModifiers));
            if (groupPrice != null && numOfModifiers > 0.0) {
                double priceRemainder = groupPrice;
                for (TicketItemModifier ticketItemModifier : groupModifiers) {
                    Double modifierPrice = ticketItemModifier.getMultiplierPrice(Double.valueOf(groupPrice / (double)((int)numOfModifiers)));
                    modifierPrice = NumberUtil.round((double)modifierPrice);
                    ticketItemModifier.setUnitPrice(modifierPrice);
                    priceRemainder -= modifierPrice.doubleValue();
                }
                TicketItemModifier lastTicketItemModifier = (TicketItemModifier)groupModifiers.get(groupModifiers.size() - 1);
                lastTicketItemModifier.setUnitPrice(Double.valueOf(lastTicketItemModifier.getUnitPrice() + priceRemainder));
            } else {
                this.updateTicketItemModifiersPrice(groupModifiers, group);
            }
        }
    }

    public void updateTicketItemModifiersPrice(List<TicketItemModifier> groupModifiers, MenuItemModifierSpec spec) {
        HashMap<String, Multiplier> multiplierMap = new HashMap<String, Multiplier>();
        for (TicketItemModifier ticketItemModifier : groupModifiers) {
            MenuModifier menuModifier;
            String multiplierName = ticketItemModifier.getMultiplierName();
            Multiplier multiplier = null;
            if (StringUtils.isNotBlank((String)multiplierName) && (multiplier = (Multiplier)multiplierMap.get(multiplierName)) == null) {
                multiplier = DataProvider.get().getMultiplierById(multiplierName);
                multiplierMap.put(multiplierName, multiplier);
            }
            if ((menuModifier = ticketItemModifier.getMenuModifier()) == null) {
                menuModifier = MenuModifierDAO.getInstance().get(ticketItemModifier.getItemId());
            }
            if (menuModifier == null) continue;
            ticketItemModifier.setUnitPrice(Double.valueOf(menuModifier.getPriceForMultiplier(multiplier)));
        }
    }

    public void doCalculateComboItemPrice(TicketItem ticketItem, boolean editMode) {
        this.doCalculateComboItemPrice(ticketItem, editMode, false);
    }

    public void doCalculateComboItemPrice(TicketItem calTicketItem, boolean editMode, boolean useOnlinePrice) {
        if (!(calTicketItem instanceof ComboTicketItem)) {
            return;
        }
        ComboTicketItem ticketItem = (ComboTicketItem)calTicketItem;
        MenuItem item = ticketItem.getMenuItem();
        if (editMode) {
            DataUtilCalc.getInstance().setTicketItemUnitPriceAndCost(item, (TicketItem)ticketItem, (IUnit)item.getUnit(), calTicketItem.getTicket(), true, useOnlinePrice);
            List comboItems = calTicketItem.getComboItems();
            if (comboItems != null && comboItems.size() > 0) {
                for (TicketItem comboTicketItem : comboItems) {
                    MenuItem comboMenuItem = comboTicketItem.getMenuItem();
                    if (comboMenuItem == null) continue;
                    comboMenuItem.setTicketItemUnitPriceAndCost(comboTicketItem, comboMenuItem, (IUnit)comboMenuItem.getUnit(), calTicketItem.getTicket(), false);
                }
            }
        }
        double extraModifiersPrice = this.getComboItemsModifierExtraPrice((TicketItem)ticketItem);
        if (item.isBasePriceForComboItem()) {
            ticketItem.setUnitPrice(Double.valueOf(ticketItem.getUnitPrice() + extraModifiersPrice));
            return;
        }
        double groupItemsModifiedPrice = this.getComboGroupItemsModifiedPrice(ticketItem, item);
        if (item.isBaseAndGroupPriceForComboItem()) {
            ticketItem.setUnitPrice(Double.valueOf(ticketItem.getUnitPrice() + extraModifiersPrice + groupItemsModifiedPrice));
            return;
        }
        if (item.isModifiablePriceForComboItem()) {
            ticketItem.setUnitPrice(Double.valueOf(ticketItem.getComboItemsPrice() + extraModifiersPrice + groupItemsModifiedPrice));
            return;
        }
        if (item.isHighestPricedComboItem()) {
            double highestPrice = groupItemsModifiedPrice;
            List comboItems = ticketItem.getComboItems();
            if (comboItems != null && comboItems.size() > 0) {
                for (TicketItem comboItem : comboItems) {
                    double comboItemPrice;
                    if (comboItem.getGroupId() != null || !((comboItemPrice = comboItem.getUnitPrice() * (comboItem.getQuantity() / ticketItem.getQuantity())) > highestPrice)) continue;
                    highestPrice = comboItemPrice;
                }
            }
            ticketItem.setUnitPrice(Double.valueOf(highestPrice + extraModifiersPrice));
            return;
        }
        ticketItem.setUnitPrice(Double.valueOf(ticketItem.getUnitPrice() + extraModifiersPrice));
    }

    private double getComboItemsModifierExtraPrice(TicketItem ticketItem) {
        double extraPrice = 0.0;
        List comboItems = ticketItem.getComboItems();
        if (comboItems != null) {
            for (TicketItem comboItem : comboItems) {
                comboItem.calculatePrice();
                extraPrice += (comboItem.getSubtotalAmount() - comboItem.getSubtotalAmountWithoutModifiers()) / ticketItem.getQuantity();
            }
        }
        return extraPrice;
    }

    private double getComboGroupItemsModifiedPrice(ComboTicketItem ticketItem, MenuItem item) {
        List comboGroups = item.getComboGroups();
        if (comboGroups == null || comboGroups.isEmpty()) {
            return 0.0;
        }
        double price = 0.0;
        boolean highestPricedComboItem = item.isHighestPricedComboItem();
        for (ComboGroup comboGroup : comboGroups) {
            List addedItems;
            List menuItems;
            if (comboGroup == null || (menuItems = comboGroup.getItems()) == null || menuItems.isEmpty() || (addedItems = ticketItem.getComboItems()) == null || addedItems.isEmpty()) continue;
            for (MenuItem menuItem : menuItems) {
                if (menuItem == null || StringUtils.isEmpty((String)menuItem.getId())) continue;
                for (TicketItem addedTicketItem : addedItems) {
                    if (addedTicketItem == null || StringUtils.isEmpty((String)addedTicketItem.getMenuItemId()) || !menuItem.getId().equals(addedTicketItem.getMenuItemId()) || addedTicketItem.getGroupId() == null) continue;
                    Double groupItemModifiedPrice = this.getComboGroupItemModifiedPrice(comboGroup, menuItem.getId(), addedTicketItem.getUnitPrice());
                    if (groupItemModifiedPrice == null) {
                        groupItemModifiedPrice = 0.0;
                    }
                    double groupItemModifiedTotalPrice = groupItemModifiedPrice * (addedTicketItem.getQuantity() / ticketItem.getQuantity());
                    if (highestPricedComboItem) {
                        double extraModifierPrice = addedTicketItem.getSubtotalAmount() - addedTicketItem.getSubtotalAmountWithoutModifiers();
                        if (extraModifierPrice > 0.0) {
                            groupItemModifiedTotalPrice += extraModifierPrice / addedTicketItem.getQuantity();
                        }
                        if (!(groupItemModifiedPrice > price)) continue;
                        price = groupItemModifiedPrice;
                        continue;
                    }
                    price += groupItemModifiedTotalPrice;
                }
            }
        }
        return price;
    }

    public TicketItemModifier addTicketItemModifier(TicketItem ticketItem, MenuModifier menuModifier, int modifierType, OrderType type, Multiplier multiplier, double quantity) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(DataProvider.get().getStore().isItemPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        ticketItemModifier.setPageItemId(menuModifier.getPageItemId());
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierSpec();
        if (menuItemModifierSpec != null) {
            ticketItemModifier.setGroupId(menuItemModifierSpec.getId());
        }
        ticketItemModifier.setItemQuantity(Double.valueOf(quantity));
        ticketItemModifier.setName(menuModifier.getDisplayName());
        double price = menuModifier.getPriceForMultiplier(multiplier);
        if (multiplier != null) {
            ticketItemModifier.setMultiplierName(multiplier.getId());
            ticketItemModifier.setName(multiplier.getTicketPrefixDisplay() + menuModifier.getDisplayName());
        }
        ticketItemModifier.setUnitPrice(Double.valueOf(price));
        this.setModifierUnitCost(menuModifier, multiplier, quantity, ticketItemModifier);
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(type, ticketItem));
        ticketItemModifier.setModifierType(Integer.valueOf(modifierType));
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(ticketItem);
        if (StringUtils.isNotEmpty((String)menuModifier.getTranslatedName())) {
            String multiplerName = multiplier != null ? multiplier.getTicketPrefixDisplay() : "";
            ticketItemModifier.addProperty("translatedName", multiplerName + menuModifier.getTranslatedName());
        }
        ticketItem.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    private void setModifierUnitCost(MenuModifier menuModifier, Multiplier multiplier, double quantity, TicketItemModifier ticketItemModifier) {
        double cost;
        double unitCost = cost = menuModifier.getCost().doubleValue();
        if (multiplier != null) {
            unitCost = cost * (multiplier.getRate() / 100.0);
        }
        ticketItemModifier.setUnitCost(Double.valueOf(unitCost));
    }

    public VoidItem createVoidItem(TicketItem ticketItem, String voidReason, boolean wasted, double quantity, User currentUser, CashDrawer cashdrawer) {
        TicketItem clonedTicket = ticketItem.cloneAsNew();
        clonedTicket.setQuantity(Double.valueOf(quantity));
        clonedTicket.calculatePrice();
        VoidItem newVoidItem = new VoidItem();
        if (clonedTicket.getTicket() != null) {
            newVoidItem.setTicketId(clonedTicket.getTicket().getId());
        }
        newVoidItem.setVoidReason(voidReason);
        newVoidItem.setItemId(clonedTicket.getId());
        newVoidItem.setMenuItemId(clonedTicket.getMenuItemId());
        newVoidItem.setMenuItemName(clonedTicket.getName());
        newVoidItem.setUnitPrice(clonedTicket.getUnitPrice());
        newVoidItem.setQuantity(Double.valueOf(quantity));
        newVoidItem.setItemWasted(Boolean.valueOf(wasted));
        newVoidItem.setVoidDate(new Date());
        newVoidItem.setModifier(Boolean.valueOf(false));
        newVoidItem.setPrinterGroup(clonedTicket.getPrinterGroup());
        newVoidItem.setVoidByUser(currentUser);
        newVoidItem.setTerminal(DataProvider.get().getCurrentTerminal());
        if (cashdrawer != null) {
            newVoidItem.setCashDrawerId(cashdrawer.getId());
        }
        newVoidItem.setTaxAmount(clonedTicket.getTaxAmountWithoutModifiers());
        newVoidItem.setTotalPrice(clonedTicket.getAdjustedTotalWithoutModifiers());
        double ticketItemQuantity = clonedTicket.getQuantity();
        double voidItemQuantity = newVoidItem.getQuantity();
        ArrayList<VoidItem> modifierVoidItems = new ArrayList<VoidItem>();
        if (clonedTicket.isHasModifiers().booleanValue()) {
            for (TicketItemModifier ticketItemModifier : clonedTicket.getTicketItemModifiers()) {
                VoidItem modifierVoidItem = new VoidItem();
                double voidModifierquantity = ticketItemModifier.getItemQuantity() * voidItemQuantity / ticketItemQuantity;
                if (!(voidModifierquantity > 0.0)) continue;
                String tfvoidItemReason = newVoidItem.getVoidReason();
                if (!StringUtils.isEmpty((String)tfvoidItemReason)) {
                    modifierVoidItem.setVoidReason(tfvoidItemReason);
                }
                modifierVoidItem.setModifierId(ticketItemModifier.getItemId());
                modifierVoidItem.setItemId(ticketItemModifier.getId());
                modifierVoidItem.setMenuItemName(ticketItemModifier.getNameDisplay());
                modifierVoidItem.setUnitPrice(ticketItemModifier.getUnitPrice());
                modifierVoidItem.setQuantity(Double.valueOf(voidModifierquantity));
                modifierVoidItem.setItemWasted(newVoidItem.isItemWasted());
                modifierVoidItem.setVoidDate(new Date());
                modifierVoidItem.setModifier(Boolean.valueOf(true));
                modifierVoidItem.setVoidByUser(currentUser);
                modifierVoidItem.setTerminal(DataProvider.get().getCurrentTerminal());
                if (cashdrawer != null) {
                    modifierVoidItem.setCashDrawerId(cashdrawer.getId());
                }
                modifierVoidItem.setTaxAmount(ticketItemModifier.getTaxAmount());
                modifierVoidItem.setTotalPrice(Double.valueOf(ticketItemModifier.getAdjustedSubtotal() + ticketItemModifier.getTaxAmount()));
                modifierVoidItem.setTicketId(newVoidItem.getTicketId());
                modifierVoidItems.add(modifierVoidItem);
            }
        }
        newVoidItem.setVoidModifiers(modifierVoidItems);
        return newVoidItem;
    }

    public void markVoided(TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity, boolean returned) {
        if (StringUtils.isEmpty((String)voidReason)) {
            if (returned) {
                throw new PosException("Return reason cannot be empty.");
            }
            throw new PosException("Void reason cannot be empty.");
        }
        ticketItem.setCreateDate(StoreDAO.getServerTimestamp());
        ticketItem.setVoidDate(StoreDAO.getServerTimestamp());
        double ticketItemQuantity = ticketItem.getQuantity();
        ticketItem.setQuantity(Double.valueOf(-1.0 * quantity));
        if (returned) {
            ticketItem.setReturned(Boolean.valueOf(true));
        } else {
            ticketItem.setVoided(Boolean.valueOf(true));
        }
        List ticketItemModifiers = ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                ticketItemModifier.setItemQuantity(Double.valueOf(-1.0 * ticketItemModifier.getItemQuantity()));
            }
        }
        if (ticketItem.isComboItem().booleanValue() && ticketItem.getComboItems() != null) {
            for (TicketItem comboTicketItem : ticketItem.getComboItems()) {
                comboTicketItem.markVoided(voidReason, itemWasted, comboTicketItem.getQuantity() / ticketItemQuantity * quantity, returned);
            }
        }
        ticketItem.setVoidProperties(voidReason, itemWasted, quantity);
    }

    public void markReturnedItemVoided(TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity) {
        ticketItem.setVoided(Boolean.valueOf(true));
        ticketItem.setVoidDate(StoreDAO.getServerTimestamp());
        ticketItem.setQuantity(Double.valueOf(quantity));
        ticketItem.setReturned(Boolean.valueOf(false));
        ticketItem.setVoidedItemId(ticketItem.getId());
        if (itemWasted) {
            ticketItem.setInventoryAdjustQty(Double.valueOf(quantity));
        } else {
            ticketItem.setInventoryAdjustQty(Double.valueOf(0.0));
        }
        ticketItem.setPrintedToKitchen(Boolean.valueOf(false));
        ticketItem.setVoidProperties(voidReason, itemWasted, quantity);
        ticketItem.addProperty("returnedVoided", String.valueOf(true));
    }

    public int countModifierFromGroup(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        List modifiers = ticketItem.getTicketItemModifiers();
        if (modifiers == null) {
            return 0;
        }
        int modifierFromGroupCount = 0;
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String groupId = ticketItemModifier.getGroupId();
            if (groupId == null || !groupId.equals(menuItemModifierSpec.getId())) continue;
            modifierFromGroupCount = (int)((double)modifierFromGroupCount + ticketItemModifier.getItemQuantity());
        }
        return modifierFromGroupCount;
    }

    public boolean requiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        int minQuantity = menuItemModifierSpec.getMinQuantity();
        if (menuItemModifierSpec.isUseModifierGroupSettings()) {
            minQuantity = menuItemModifierSpec.getModifierGroup().getMinQuantity();
        }
        if (minQuantity == 0) {
            return true;
        }
        return this.countModifierFromGroup(ticketItem, menuItemModifierSpec) >= minQuantity;
    }

    public boolean deleteTicketItemModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifierToRemove) {
        List modifiers = ticketItem.getTicketItemModifiers();
        if (modifiers == null || modifiers.isEmpty()) {
            return false;
        }
        Iterator iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)iterator.next();
            if (ticketItemModifier != ticketItemModifierToRemove) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean deleteTicketItemModifierByName(TicketItem ticketItem, TicketItemModifier ticketItemModifierToRemove) {
        List modifiers = ticketItem.getTicketItemModifiers();
        if (modifiers == null) {
            return false;
        }
        Iterator iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)iterator.next();
            if (!ticketItemModifier.getName().equals(ticketItemModifierToRemove.getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void removeVoidProperties(TicketItem ticketItem) {
        ticketItem.removeProperty("voidReason");
        ticketItem.removeProperty("wasted");
        ticketItem.removeProperty("voidQuantity");
        ticketItem.removeProperty("voidId");
    }

    public void setVoidProperties(TicketItem ticketItem, String voidReason, boolean wasted, double quantity, boolean printedToKitchen, User user) {
        ticketItem.addProperty("voidReason", voidReason);
        ticketItem.addProperty("wasted", String.valueOf(wasted));
        ticketItem.addProperty("voidQuantity", String.valueOf(quantity));
        ticketItem.addProperty("originalItemPrintedToKitchen", String.valueOf(printedToKitchen));
        if (user != null) {
            ticketItem.addProperty("voidedByUser", user.getId());
        }
        ticketItem.setVoidReason(voidReason);
        ticketItem.setItemWasted(Boolean.valueOf(wasted));
    }

    public Double getComboGroupItemModifiedPrice(ComboGroup comboGroup, String itemId, Double originalPrice) {
        JsonObject propertiesContainer = comboGroup.getPropertyStore();
        if (propertiesContainer == null) {
            return originalPrice;
        }
        JsonArray itemModifiedPrices = propertiesContainer.getAsJsonArray("itemModifiedPrices");
        if (itemModifiedPrices == null || itemModifiedPrices.isJsonNull()) {
            return originalPrice;
        }
        for (JsonElement jsonElement : itemModifiedPrices) {
            JsonElement id;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null || (id = jsonObject.get("menuItemId")) == null || !id.getAsString().equals(itemId)) continue;
            JsonElement price = jsonObject.get("price");
            if (price == null) {
                return originalPrice;
            }
            if (!price.getAsString().contains("%")) {
                return NumberUtil.parseOrGetZero((String)price.getAsString()).doubleValue();
            }
            double percentValue = POSUtil.parseDouble((String)price.getAsString().replaceAll("[\\s,%]", ""));
            if (percentValue == 0.0) {
                return originalPrice;
            }
            return originalPrice * (percentValue / 100.0);
        }
        return originalPrice;
    }

    public double calculateCommissionOnReport(TicketItem ticketItem) {
        if (ticketItem.isReturnedSource().booleanValue() || ticketItem.isReturned() || ticketItem.isVoided().booleanValue()) {
            return 0.0;
        }
        String reportChargeType = ticketItem.getRfOnReportType();
        Double unitPrice = ticketItem.getUnitPrice();
        if (!ticketItem.getTicket().isApplyDiscountOnReferral()) {
            unitPrice = ticketItem.getAdjustedUnitPrice();
        }
        if (NumberUtil.isZero((Double)unitPrice)) {
            return 0.0;
        }
        double commissionOnReport = 0.0;
        ReferralCommissionType referralCommissionType = ReferralCommissionType.fromName((String)reportChargeType);
        switch (referralCommissionType) {
            case STANDARD: {
                double rfRateOnReport = ticketItem.getRfRateOnReport();
                MenuItem menuItem = ticketItem.getMenuItem();
                String menuItemRFTypeName = menuItem.getRfOnReportType();
                ReferralCommissionType menuItemRFCommissionType = ReferralCommissionType.fromName((String)menuItemRFTypeName);
                if (menuItemRFCommissionType == ReferralCommissionType.GROUP) {
                    if (rfRateOnReport == 0.0) {
                        String menuGroupId = menuItem.getMenuGroupId();
                        if (StringUtils.isNotBlank((String)menuGroupId)) {
                            MenuGroup menuGroup = MenuGroupDAO.getInstance().get(menuGroupId);
                            double rateOnReport = menuGroup.getRefPercentage();
                            commissionOnReport = TicketItemPriceCalcV2.calculateCommission(unitPrice, rateOnReport);
                            break;
                        }
                    } else {
                        commissionOnReport = TicketItemPriceCalcV2.calculateCommission(unitPrice, rfRateOnReport);
                        break;
                    }
                }
                if (menuItemRFCommissionType == ReferralCommissionType.FIXEDAMOUNT) {
                    commissionOnReport = ticketItem.getRfRateOnReport();
                    break;
                }
                if (menuItemRFCommissionType == ReferralCommissionType.PERCENTAGE) {
                    double rateOnReport = ticketItem.getRfRateOnReport();
                    commissionOnReport = TicketItemPriceCalcV2.calculateCommission(unitPrice, rateOnReport);
                    break;
                }
            }
            case PERCENTAGE: {
                double rateOnReport = ticketItem.getRfRateOnReport();
                commissionOnReport = TicketItemPriceCalcV2.calculateCommission(unitPrice, rateOnReport);
                break;
            }
            case FIXEDAMOUNT: 
            case GREATER_THAN_SALES_PRICE: {
                commissionOnReport = ticketItem.getRfRateOnReport();
                break;
            }
        }
        if (ticketItem.getTicket().isApplyDiscountOnReferral()) {
            commissionOnReport -= ticketItem.getAdjustedDiscount().doubleValue();
        }
        if (commissionOnReport > unitPrice) {
            return unitPrice;
        }
        if (commissionOnReport < 0.0) {
            commissionOnReport = 0.0;
        }
        PosLog.debug(this.getClass(), (String)("Max RF: " + commissionOnReport));
        return NumberUtil.round((double)commissionOnReport);
    }

    private static double calculateCommission(double subtotalAmount, double commissionPercentage) {
        if (commissionPercentage > 0.0) {
            return subtotalAmount * (commissionPercentage / 100.0);
        }
        return 0.0;
    }

    public static TicketItemPriceCalcV2 getInstance() {
        return instance;
    }
}

