/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Agent;
import com.floreantpos.model.AgentTypeEnum;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.ReferralCommissionType;
import com.floreantpos.model.util.ServiceChargeType;
import com.floreantpos.model.util.pricecalc.DiscountCalcFactory;
import com.floreantpos.model.util.pricecalc.TicketCalc;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.pos.pricecalc.DiscountCalc;
import com.orocube.pos.pricecalc.TicketItemPriceCalcV2;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TicketPriceCalcV2
implements TicketCalc {
    private static TicketPriceCalcV2 instance = new TicketPriceCalcV2();

    public void calculatePrice(Ticket ticket) {
        Date maxDate;
        List ticketItems = ticket.getTicketItems();
        if (ticketItems == null) {
            return;
        }
        if (!ticket.isShouldCalculatePrice().booleanValue()) {
            ticket.setDiscountAmount(Double.valueOf(NumberUtil.round((double)this.calculateTicketDiscountV2(ticket, ticket.getSubtotalAmount()))));
            return;
        }
        double ticketDiscountAmount = 0.0;
        double itemDiscountAmount = 0.0;
        double subtotal = 0.0;
        double ticketDiscountableSubtotal = 0.0;
        double totalDiscount = 0.0;
        double serviceCharge = 0.0;
        double itemServiceCharge = 0.0;
        double taxAmount = 0.0;
        double taxExemptAmount = 0.0;
        double labDoctorFee = 0.0;
        double itemsReferrerFeeOnReport = 0.0;
        for (TicketItem ticketItem2 : ticketItems) {
            ticketItem2.setTicket(ticket);
            if (ticketItem2.isVoided().booleanValue()) continue;
            ticketItem2.calculatePrice();
            subtotal += ticketItem2.getSubtotalAmount().doubleValue();
            itemDiscountAmount += ticketItem2.getDiscountAmount().doubleValue();
            itemServiceCharge += ticketItem2.getServiceCharge().doubleValue();
            taxAmount += ticketItem2.getTaxAmount().doubleValue();
            labDoctorFee += ticketItem2.getLabDoctorFee().doubleValue();
            itemsReferrerFeeOnReport += ticketItem2.getReferrerFeeOnReport().doubleValue();
            taxExemptAmount += ticketItem2.getTaxExemptAmount().doubleValue();
            if (!ticketItem2.isTicketDiscountApplicable().booleanValue()) continue;
            ticketDiscountableSubtotal += ticketItem2.getDiscountableSubtotal();
        }
        subtotal = NumberUtil.round((double)subtotal);
        itemDiscountAmount = NumberUtil.round((double)itemDiscountAmount);
        ticket.setItemDiscountAmount(itemDiscountAmount);
        ticket.setLabDoctorFee(Double.valueOf(NumberUtil.round((double)labDoctorFee)));
        double ticketServiceCharge = this.calculateTicketServiceCharge(ticket);
        serviceCharge = NumberUtil.round((double)(itemServiceCharge + ticketServiceCharge));
        taxAmount = NumberUtil.round((double)taxAmount);
        ticketDiscountAmount = NumberUtil.round((double)this.calculateTicketDiscountV2(ticket, ticketDiscountableSubtotal - itemDiscountAmount));
        totalDiscount = NumberUtil.round((double)(ticketDiscountAmount + itemDiscountAmount));
        this.calculateGratuity(ticket, subtotal, totalDiscount);
        double deliveryChargeAmount = ticket.getDeliveryCharge();
        double gratuityAmount = ticket.getGratuityAmount();
        double feeAmount = ticket.getFeeAmount();
        double totalAmount = 0.0;
        totalAmount = ticket.isTaxIncluded() != false ? NumberUtil.round((double)(subtotal - totalDiscount + serviceCharge + deliveryChargeAmount + feeAmount)) : NumberUtil.round((double)(subtotal - totalDiscount + taxAmount + serviceCharge + deliveryChargeAmount + feeAmount));
        this.calculatePaidAmount(ticket);
        double dueAmount = NumberUtil.round((double)(totalAmount + gratuityAmount - ticket.getPaidAmount() + ticket.getRefundAmount()));
        double roundedAmount = ticket.getRoundedAmount();
        dueAmount = NumberUtil.round((double)this.calculateDueAfterTolerance(ticket, dueAmount + roundedAmount));
        totalAmount = NumberUtil.round((double)totalAmount);
        if (NumberUtil.isZero((Double)dueAmount)) {
            dueAmount = 0.0;
        }
        this.calculateReferrerCommission(ticket, subtotal, totalDiscount, itemsReferrerFeeOnReport);
        ticket.setSubtotalAmount(Double.valueOf(subtotal));
        ticket.setDiscountAmount(Double.valueOf(totalDiscount));
        ticket.setServiceCharge(Double.valueOf(serviceCharge));
        ticket.setTicketServiceCharge(Double.valueOf(ticketServiceCharge));
        ticket.setDeliveryCharge(Double.valueOf(deliveryChargeAmount));
        ticket.setTaxAmount(Double.valueOf(taxAmount));
        ticket.setTotalAmount(Double.valueOf(totalAmount));
        ticket.setDueAmount(Double.valueOf(dueAmount));
        ticket.setItemDiscountAmount(itemDiscountAmount);
        ticket.setTicketDiscountAmount(ticketDiscountAmount);
        if (!ticketItems.isEmpty() && (maxDate = (Date)ticketItems.stream().filter(ticketItem -> ticketItem.getDeliveryDate() != null).map(TicketItem::getDeliveryDate).max(Date::compareTo).orElse(null)) != null) {
            ticket.setDeliveryDate(maxDate);
        }
        ticket.addProperty("tax.exempt.amount", String.valueOf(taxExemptAmount));
        if (ticketDiscountAmount <= 0.0) {
            return;
        }
        this.calculateAdjustedPriceV2(ticket);
    }

    private void calculateReferrerCommission(Ticket ticket, double subtotal, double totalDiscount, double commissionOnItems) {
        AgentTypeEnum agentType;
        Customer referrer;
        String referrerId;
        double subtotalAfterDiscount = subtotal - totalDiscount;
        Double receivedAmount = ticket.getPaidAmount();
        if (receivedAmount > subtotalAfterDiscount) {
            receivedAmount = subtotalAfterDiscount;
        }
        double nonReferralCommission = NumberUtil.round((double)(subtotalAfterDiscount - commissionOnItems));
        String ticketId = StringUtils.isBlank((String)ticket.getId()) ? "New ticket" : ticket.getId();
        PosLog.debug(this.getClass(), (String)String.format("Non referral commission for ticket %s: %s", ticketId, nonReferralCommission));
        double referralCommission = Math.round(receivedAmount - nonReferralCommission);
        if (referralCommission < 0.0) {
            referralCommission = 0.0;
        }
        if (StringUtils.isNotBlank((String)(referrerId = ticket.getReferrerId())) && (referrer = CustomerDAO.getInstance().get(referrerId)) instanceof Agent && AgentTypeEnum.B2B == (agentType = AgentTypeEnum.fromString((String)referrer.getAgentType()))) {
            referralCommission = 0.0;
        }
        PosLog.debug(this.getClass(), (String)String.format("Expected referral commission for ticket %s: %s", ticketId, referralCommission));
        double officeNet = receivedAmount - ticket.getLabDoctorFee() - referralCommission;
        if (officeNet < 0.0) {
            officeNet = 0.0;
        }
        double commissionOnNetSales = NumberUtil.parseDouble((String)ticket.getRfRateOnNetSales());
        ReferralCommissionType onNetSalesChargeType = ReferralCommissionType.fromName((String)ticket.getRfOnNetSalesType());
        PosLog.debug(this.getClass(), (String)String.format("Referrer Rate for ticket %s: %s and charge type %s", ticketId, commissionOnNetSales, onNetSalesChargeType.getDisplayString()));
        if (ReferralCommissionType.PERCENTAGE == onNetSalesChargeType) {
            commissionOnNetSales = TicketPriceCalcV2.calculateAmountFromPercentage(officeNet, commissionOnNetSales);
        } else if (officeNet <= 0.0) {
            commissionOnNetSales = 0.0;
        } else if (officeNet <= commissionOnNetSales) {
            commissionOnNetSales = Math.round(officeNet);
        }
        PosLog.debug(this.getClass(), (String)String.format("RF commission on net sales for ticket %s: %s", ticketId, commissionOnNetSales));
        ticket.setReferrerFeeOnReport(Double.valueOf(NumberUtil.round((double)referralCommission)));
        ticket.setReferrerFeeOnNetSales(Double.valueOf(NumberUtil.round((double)commissionOnNetSales)));
        double totalRFCommission = NumberUtil.round((double)(referralCommission + commissionOnNetSales));
        if (!NumberUtil.isZero((Double)(ticket.getTotalReferrerFee() - totalRFCommission))) {
            ticket.setReferrerFeePaid(Boolean.valueOf(false));
        }
        ticket.setTotalReferrerFee(Double.valueOf(totalRFCommission));
        PosLog.debug(Ticket.class, (String)String.format("Ticket %s: RFOnReport : %s, RFOnNetSales : %s, totalRFComm : %s ", ticketId, ticket.getReferrerFeeOnReport(), ticket.getReferrerFeeOnNetSales(), totalRFCommission));
    }

    private void calculateAdjustedPriceV2(Ticket ticket) {
        double subtotalAfterDiscount = 0.0;
        double serviceCharge = 0.0;
        double itemServiceCharge = 0.0;
        double taxAmount = 0.0;
        double taxExemptAmount = 0.0;
        double discountAmount = 0.0;
        double itemsReferrerFeeOnReport = 0.0;
        List ticketItems = ticket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            ticketItem.setTicket(ticket);
            if (ticketItem.isVoided().booleanValue()) continue;
            TicketItemPriceCalcV2.getInstance().calculateAdjustedPrice(ticketItem);
            subtotalAfterDiscount += ticketItem.getAdjustedSubtotal().doubleValue();
            discountAmount += ticketItem.getAdjustedDiscount().doubleValue();
            itemServiceCharge += ticketItem.getServiceCharge().doubleValue();
            taxAmount += ticketItem.getAdjustedTax().doubleValue();
            taxExemptAmount += ticketItem.getTaxExemptAmount().doubleValue();
            itemsReferrerFeeOnReport += NumberUtil.round((double)ticketItem.getReferrerFeeOnReport());
        }
        double adjustableAmount = NumberUtil.round((double)(ticket.getTicketDiscountAmount() + ticket.getItemDiscountAmount() - discountAmount));
        if (!NumberUtil.isZero((Double)adjustableAmount)) {
            PosLog.debug(Ticket.class, (String)("Adjustable discount amount: " + adjustableAmount));
            int totalAdjustable = (int)Math.abs(adjustableAmount * 100.0);
            List adjustedTicketItems = ticket.getTicketItems();
            boolean isNagative = adjustableAmount < 0.0;
            int adjustedAmount = 0;
            for (int i = 0; i < totalAdjustable && adjustedAmount != totalAdjustable; ++i) {
                for (int j = 0; j < adjustedTicketItems.size() && adjustedAmount != totalAdjustable; ++adjustedAmount, ++j) {
                    TicketItem ticketItem = (TicketItem)adjustedTicketItems.get(j);
                    double adjAmount = 0.01;
                    if (isNagative) {
                        adjAmount = -0.01;
                    }
                    double adjustedDiscount = ticketItem.getAdjustedDiscount();
                    PosLog.debug(Ticket.class, (String)("Item name: " + ticketItem.getName() + ",Before adjusted discount: " + adjustedDiscount));
                    adjustedDiscount = NumberUtil.round((double)(adjustedDiscount + adjAmount));
                    ticketItem.setAdjustedDiscount(Double.valueOf(adjustedDiscount));
                    ticketItem.setAdjustedSubtotal(Double.valueOf(NumberUtil.round((double)ticketItem.getAdjustedSubtotal()) - adjAmount));
                    ticketItem.setAdjustedTotal(Double.valueOf(NumberUtil.round((double)ticketItem.getAdjustedTotal()) - adjAmount));
                    subtotalAfterDiscount = NumberUtil.round((double)subtotalAfterDiscount) - adjAmount;
                    ticketItem.setAdjustedDiscountWithoutModifiers(Double.valueOf(NumberUtil.round((double)ticketItem.getAdjustedDiscountWithoutModifiers()) + adjAmount));
                    ticketItem.setAdjustedSubtotalWithoutModifiers(Double.valueOf(NumberUtil.round((double)ticketItem.getAdjustedSubtotalWithoutModifiers()) - adjAmount));
                    discountAmount = NumberUtil.round((double)(discountAmount + adjAmount));
                    StringBuilder builder = new StringBuilder();
                    builder.append("Item name: " + ticketItem.getName());
                    builder.append(", ");
                    builder.append("After adjusted discount: " + adjustedDiscount);
                    builder.append(", ");
                    builder.append("discount amount: " + discountAmount);
                    builder.append(", ");
                    builder.append("subtotal after discount: " + subtotalAfterDiscount);
                    PosLog.debug(Ticket.class, (String)builder.toString());
                }
            }
            itemsReferrerFeeOnReport = 0.0;
            for (TicketItem ticketItem : ticketItems) {
                if (ProductType.match((String)ticketItem.getProductType(), (ProductType)ProductType.PATHOLOGY) || ProductType.match((String)ticketItem.getProductType(), (ProductType)ProductType.SERVICES)) {
                    ticketItem.setReferrerFeeOnReport(Double.valueOf(TicketItemPriceCalcV2.getInstance().calculateCommissionOnReport(ticketItem)));
                }
                if (ticketItem.isVoided().booleanValue()) continue;
                itemsReferrerFeeOnReport += NumberUtil.round((double)ticketItem.getReferrerFeeOnReport());
            }
        }
        subtotalAfterDiscount = NumberUtil.round((double)subtotalAfterDiscount);
        discountAmount = NumberUtil.round((double)discountAmount);
        itemServiceCharge = NumberUtil.round((double)itemServiceCharge);
        double ticketServiceCharge = this.calculateTicketServiceCharge(ticket);
        serviceCharge = NumberUtil.round((double)(itemServiceCharge + ticketServiceCharge));
        taxAmount = NumberUtil.round((double)taxAmount);
        this.calculateGratuity(ticket, subtotalAfterDiscount, discountAmount);
        double deliveryChargeAmount = ticket.getDeliveryCharge();
        double gratuityAmount = ticket.getGratuityAmount();
        double feeAmount = ticket.getFeeAmount();
        double totalAmount = 0.0;
        totalAmount = ticket.isTaxIncluded() != false ? NumberUtil.round((double)(subtotalAfterDiscount + serviceCharge + deliveryChargeAmount + feeAmount)) : NumberUtil.round((double)(subtotalAfterDiscount + taxAmount + serviceCharge + deliveryChargeAmount + feeAmount));
        double dueAmount = NumberUtil.round((double)(totalAmount + gratuityAmount - ticket.getPaidAmount() + ticket.getRefundAmount()));
        double roundedAmount = ticket.getRoundedAmount();
        dueAmount = NumberUtil.round((double)this.calculateDueAfterTolerance(ticket, dueAmount + roundedAmount));
        totalAmount = NumberUtil.round((double)totalAmount);
        if (NumberUtil.isZero((Double)dueAmount)) {
            dueAmount = 0.0;
        }
        ticket.setDiscountAmount(Double.valueOf(discountAmount));
        ticket.setServiceCharge(Double.valueOf(serviceCharge));
        ticket.setTicketServiceCharge(Double.valueOf(ticketServiceCharge));
        ticket.setDeliveryCharge(Double.valueOf(deliveryChargeAmount));
        ticket.setTaxAmount(Double.valueOf(taxAmount));
        ticket.setTotalAmount(Double.valueOf(totalAmount));
        ticket.setDueAmount(Double.valueOf(dueAmount));
        ticket.addProperty("tax.exempt.amount", String.valueOf(taxExemptAmount));
        this.calculateReferrerCommission(ticket, subtotalAfterDiscount, 0.0, itemsReferrerFeeOnReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double calculateDueAfterTolerance(Ticket ticket, double dueAmount) {
        double toleranceAmount = 0.0;
        try {
            if (ticket.getPaidAmount() <= 0.0) {
                double d = dueAmount;
                return d;
            }
            if (Math.abs(dueAmount) <= ticket.getToleranceFactor()) {
                toleranceAmount = toleranceAmount < 0.0 ? dueAmount : -1.0 * dueAmount;
                double d = 0.0;
                return d;
            }
            double d = dueAmount;
            return d;
        }
        finally {
            ticket.setToleranceAmount(toleranceAmount);
        }
    }

    private double calculateTicketServiceCharge(Ticket ticket) {
        if (!ticket.isServiceChargeApplicable()) {
            return 0.0;
        }
        double serviceCharge = 0.0;
        ServiceChargeType serviceChargeType = ticket.getServiceChargeType();
        switch (serviceChargeType) {
            case PERCENTAGE: 
            case EMPTY: {
                serviceCharge = 0.0;
                break;
            }
            case FIXEDAMOUNT: {
                serviceCharge = ticket.getOutletServiceChargeRate();
            }
        }
        return serviceCharge;
    }

    private double calculateTicketDiscountV2(Ticket ticket, double totalAmount) {
        double ticketDiscountAmount = 0.0;
        List ticketCouponAndDiscounts = ticket.getDiscounts();
        if (ticketCouponAndDiscounts != null) {
            for (TicketDiscount ticketDiscount : ticketCouponAndDiscounts) {
                Double calculateDiscountAmount;
                double discountForThisCoupon = 0.0;
                Integer discountType = ticketDiscount.getType();
                if (discountType == 2) {
                    discountForThisCoupon = DiscountCalcFactory.getCalc().calculateRepriceDiscount(ticket, ticketDiscount.getValue());
                } else if (discountType == 3) {
                    discountForThisCoupon = ticketDiscount.getValue() * ticketDiscount.getCouponQuantity();
                } else if (discountType == 1) {
                    calculateDiscountAmount = 0.0;
                    calculateDiscountAmount = ticketDiscount.getOriginalType() == 2 ? DiscountCalcFactory.getCalc().calculateDiscountAmount(totalAmount - ticketDiscountAmount, ticketDiscount) : DiscountCalcFactory.getCalc().calculateDiscountAmount(totalAmount - ticketDiscountAmount, ticketDiscount);
                    discountForThisCoupon = calculateDiscountAmount;
                } else {
                    calculateDiscountAmount = DiscountCalcFactory.getCalc().calculateDiscountAmount(totalAmount, ticketDiscount);
                    discountForThisCoupon = calculateDiscountAmount * ticketDiscount.getCouponQuantity();
                }
                if (NumberUtil.isZero((Double)totalAmount) || totalAmount < ticketDiscount.getMinimumAmount()) {
                    discountForThisCoupon = 0.0;
                }
                ticketDiscount.setTotalDiscountAmount(Double.valueOf(discountForThisCoupon));
                ticketDiscountAmount += discountForThisCoupon;
            }
        }
        ticket.buildDiscounts();
        return ticketDiscountAmount;
    }

    public void calculateGratuity(Ticket ticket, double subtotalAmount, double discountAmount) {
        Double gratuityPercentage = ticket.getOutletGratuityRate();
        if (gratuityPercentage <= 0.0) {
            return;
        }
        Gratuity gratuity = ticket.getGratuity();
        if (gratuity != null && !gratuity.isAutoCalculated()) {
            return;
        }
        if (gratuity == null) {
            gratuity = new Gratuity();
            gratuity.setAutoCalculated(true);
            gratuity.setOutletId(DataProvider.get().getCurrentOutletId());
        }
        double gratuityAmount = 0.0;
        if (gratuityPercentage > 0.0) {
            gratuityAmount = (subtotalAmount - discountAmount) * (gratuityPercentage / 100.0);
        }
        if (gratuityAmount > 0.0) {
            gratuity.setAmount(Double.valueOf(NumberUtil.round((double)gratuityAmount)));
        } else {
            gratuity.setAmount(Double.valueOf(0.0));
        }
        ticket.setGratuity(gratuity);
    }

    private void calculatePaidAmount(Ticket ticket) {
        double totalCredit = 0.0;
        Set transactionsAfterMerged = ticket.getTransactions();
        if (transactionsAfterMerged != null && transactionsAfterMerged.size() > 0) {
            for (PosTransaction t : transactionsAfterMerged) {
                if (t.isVoided().booleanValue() || !t.getTransactionType().equals(TransactionType.CREDIT.toString())) continue;
                totalCredit += t.getAmount().doubleValue();
            }
        }
        ticket.setPaidAmount(Double.valueOf(NumberUtil.round((double)totalCredit)));
        this.calculateRefundAmount(ticket);
        if (ticket.getRefundAmount() > 0.0) {
            ticket.setRefunded(Boolean.valueOf(true));
        }
    }

    public void calculateRefundAmount(Ticket ticket) {
        double refundAmount = 0.0;
        double voidAmount = 0.0;
        Set transactions = ticket.getTransactions();
        if (transactions != null) {
            for (PosTransaction t : transactions) {
                if (!(t instanceof RefundTransaction) || t.isVoided().booleanValue()) continue;
                refundAmount += t.getAmount().doubleValue();
            }
        }
        ticket.setRefundAmount(Double.valueOf(refundAmount + voidAmount));
    }

    public double applyFloridaTaxRuleV2(Ticket ticket, double subtotal, double totalTaxAmount) {
        double roundedTax = totalTaxAmount;
        if (ticket != null && ticket.isApplyFloridaTaxRule()) {
            int intValueOfSubtotal = (int)(subtotal * 100.0);
            if (roundedTax == 1.0 && ((intValueOfSubtotal %= 100) == 8 || intValueOfSubtotal == 9)) {
                roundedTax = totalTaxAmount - 0.01;
            } else if (intValueOfSubtotal > 9 && roundedTax < totalTaxAmount) {
                roundedTax += 0.01;
            }
        }
        return roundedTax;
    }

    public static TicketPriceCalcV2 getInstance() {
        return instance;
    }

    public TicketDiscount convertToTicketDiscount(Discount discount, Ticket ticket) {
        TicketDiscount ticketDiscount = new TicketDiscount();
        ticketDiscount.setDiscountId(discount.getId());
        ticketDiscount.setName(discount.getName());
        ticketDiscount.setType(Integer.valueOf(1));
        ticketDiscount.setMinimumAmount(discount.getMinimumBuy());
        ticketDiscount.setOriginalType(discount.getType().intValue());
        ticketDiscount.setOriginalValue(discount.getOriginalValue());
        if (discount.getType() == 0) {
            ticketDiscount.setType(Integer.valueOf(0));
            ticketDiscount.setValue(discount.getValue());
        } else if (discount.getType() == 2) {
            double percentageForTotal = DiscountCalc.getInstance().calculatePercentageForTotal(discount.getValue(), ticket.getTotalAmount());
            ticketDiscount.setValue(Double.valueOf(percentageForTotal));
        } else {
            ticketDiscount.setValue(discount.getValue());
        }
        ticketDiscount.setCouponQuantity(Double.valueOf(1.0));
        ticketDiscount.setTicket(ticket);
        return ticketDiscount;
    }

    public TicketDiscount buildLoyaltyDiscount(Ticket ticket) {
        TicketDiscount loyaltyDiscount = new TicketDiscount();
        loyaltyDiscount.setDiscountId(Discount.getLoyaltyDiscountId());
        loyaltyDiscount.setName("Loyalty");
        loyaltyDiscount.setType(Integer.valueOf(3));
        loyaltyDiscount.setMinimumAmount(Double.valueOf(1.0));
        loyaltyDiscount.setValue(null);
        loyaltyDiscount.setCouponQuantity(Double.valueOf(1.0));
        loyaltyDiscount.setTicket(ticket);
        return loyaltyDiscount;
    }

    public double calculateDiscountFromType(Ticket ticket, TicketDiscount coupon, double subtotal) {
        List ticketItems = ticket.getTicketItems();
        double discount = 0.0;
        int type = coupon.getType();
        double couponValue = coupon.getValue();
        switch (type) {
            case 3: {
                discount += couponValue;
                break;
            }
            case 1: {
                HashSet<String> categoryIds = new HashSet<String>();
                for (TicketItem item : ticketItems) {
                    String itemId = item.getMenuItemId();
                    if (categoryIds.contains(itemId)) continue;
                    discount += couponValue;
                    categoryIds.add(itemId);
                }
                break;
            }
            case 2: {
                for (TicketItem item : ticketItems) {
                    discount += couponValue * item.getQuantity();
                }
                break;
            }
            case 6: {
                discount += subtotal * couponValue / 100.0;
                break;
            }
            case 4: {
                HashSet<String> categoryIds = new HashSet<String>();
                for (TicketItem item : ticketItems) {
                    String itemId = item.getMenuItemId();
                    if (categoryIds.contains(itemId)) continue;
                    discount += item.getUnitPrice() * couponValue / 100.0;
                    categoryIds.add(itemId);
                }
                break;
            }
            case 5: {
                for (TicketItem item : ticketItems) {
                    discount += item.getSubtotalAmountWithoutModifiers() * couponValue / 100.0;
                }
                break;
            }
            case 0: {
                discount += couponValue;
            }
        }
        return discount;
    }

    public double getDiscountPercentageRate(Ticket ticket, TicketDiscount ticketDiscount, double ticketAmountAfterDiscount) {
        Double minimumAmount = ticketDiscount.getMinimumAmount();
        double subtotalAfterItemDiscount = ticket.getDiscountableSubtotal() - ticket.getItemDiscountAmount();
        if (minimumAmount > 0.0 && subtotalAfterItemDiscount < minimumAmount) {
            return 0.0;
        }
        double percentage = 0.0;
        if (ticketDiscount.getType() == 3 || ticketDiscount.getType() == 0) {
            Double discountValue = ticketDiscount.getValue() * ticketDiscount.getCouponQuantity();
            double discountPercent = 100.0 * discountValue / ticketAmountAfterDiscount;
            percentage += discountPercent;
        } else {
            percentage += ticketDiscount.getValue() * ticketDiscount.getCouponQuantity();
        }
        if (percentage > 100.0) {
            percentage = 100.0;
        }
        return percentage / 100.0;
    }

    public void voidItem(Ticket ticket, TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity) {
        List ticketItemModifiers;
        if (ticketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        if (StringUtils.isEmpty((String)voidReason)) {
            throw new PosException("Void reason cannot be empty.");
        }
        if (quantity == 0.0) {
            throw new PosException("Invalid quantity.");
        }
        if (quantity > Math.abs(ticketItem.getQuantity())) {
            throw new PosException("Void quantity cannot be greater than item quantity.");
        }
        double ticketItemQuantity = ticketItem.getQuantity();
        boolean fullVoid = ticketItem.getQuantity() == quantity;
        TicketItem voidTicketItem = null;
        if (fullVoid) {
            ticketItem.setVoided(Boolean.valueOf(true));
            ticketItem.setQuantity(Double.valueOf(-quantity));
            ticketItem.setVoidedItemId(ticketItem.getId());
            voidTicketItem = ticketItem;
        } else {
            ticketItem.setQuantity(Double.valueOf(ticketItem.getQuantity() - quantity));
            voidTicketItem = ticketItem.cloneAsNew();
            voidTicketItem.setId(null);
            voidTicketItem.setQuantity(Double.valueOf(-1.0 * quantity));
        }
        Boolean printedToKitchen = ticketItem.isPrintedToKitchen();
        voidTicketItem.setDiscounts(null);
        voidTicketItem.setDiscountsProperty(null);
        voidTicketItem.setPrintedToKitchen(Boolean.valueOf(false));
        voidTicketItem.setVoided(Boolean.valueOf(true));
        voidTicketItem.setCloudSynced(Boolean.valueOf(false));
        voidTicketItem.setVoidDate(StoreDAO.getServerTimestamp());
        voidTicketItem.setVoidedItemId(ticketItem.getId());
        voidTicketItem.setInventoryAdjustQty(Double.valueOf(itemWasted ? -quantity : 0.0));
        if (voidTicketItem.isHasModifiers().booleanValue() && (ticketItemModifiers = voidTicketItem.getTicketItemModifiers()) != null) {
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.setItemQuantity(Double.valueOf(-modifier.getItemQuantity().doubleValue()));
            }
        }
        voidTicketItem.setVoidProperties(voidReason, itemWasted, quantity, printedToKitchen.booleanValue());
        if (ticketItem.isComboItem().booleanValue()) {
            if (voidTicketItem.getComboItems() != null) {
                for (TicketItem comboTicketItem : voidTicketItem.getComboItems()) {
                    double toBeVoidComboQuantity = comboTicketItem.getQuantity() / ticketItemQuantity * quantity;
                    comboTicketItem.setQuantity(Double.valueOf(-toBeVoidComboQuantity));
                    voidTicketItem.setInventoryAdjustQty(Double.valueOf(itemWasted ? -toBeVoidComboQuantity : 0.0));
                    comboTicketItem.setVoidProperties(voidReason, itemWasted, toBeVoidComboQuantity);
                    comboTicketItem.setVoided(Boolean.valueOf(true));
                    List ticketItemModifiers2 = comboTicketItem.getTicketItemModifiers();
                    if (ticketItemModifiers2 != null && ticketItemModifiers2.size() > 0) {
                        for (TicketItemModifier ticketItemModifier : ticketItemModifiers2) {
                            ticketItemModifier.setItemQuantity(Double.valueOf(-1.0 * ticketItemModifier.getItemQuantity()));
                            ticketItemModifier.calculatePrice();
                        }
                    }
                    comboTicketItem.calculatePrice();
                }
            }
            if (!fullVoid && ticketItem.getComboItems() != null) {
                for (TicketItem comboTicketItem : ticketItem.getComboItems()) {
                    comboTicketItem.setQuantity(Double.valueOf(comboTicketItem.getQuantity() - comboTicketItem.getQuantity() / ticketItemQuantity * quantity));
                }
            }
        }
        voidTicketItem.calculatePrice();
        if (voidTicketItem != ticketItem) {
            ticket.addToticketItems(voidTicketItem);
        }
    }

    public void voidReturnedItem(TicketItem voidTicketItem, String voidReason, boolean itemWasted) {
        if (voidTicketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        if (StringUtils.isEmpty((String)voidReason)) {
            throw new PosException("Return reason cannot be empty.");
        }
        TicketItemPriceCalcV2.getInstance().markReturnedItemVoided(voidTicketItem, voidReason, itemWasted, voidTicketItem.getQuantity());
        if (voidTicketItem.isComboItem().booleanValue() && voidTicketItem.getComboItems() != null) {
            for (TicketItem comboTicketItem : voidTicketItem.getComboItems()) {
                TicketItemPriceCalcV2.getInstance().markReturnedItemVoided(comboTicketItem, voidReason, itemWasted, comboTicketItem.getQuantity());
            }
        }
    }

    public TicketItem undoVoidItem(Ticket ticket, TicketItem voidedTicketItem) {
        List ticketItemModifiers;
        boolean fullVoid;
        TicketItem origTicketItem = this.getTicketItem(ticket, voidedTicketItem.getVoidedItemId());
        if (origTicketItem == null) {
            return null;
        }
        double quantity = Math.abs(voidedTicketItem.getQuantity());
        if (origTicketItem.getVoidedItemId() != null) {
            origTicketItem = voidedTicketItem;
        }
        boolean itemWasted = POSUtil.getBoolean((String)voidedTicketItem.getProperty("wasted"));
        double ticketItemQuantity = origTicketItem.getQuantity();
        boolean bl = fullVoid = voidedTicketItem == origTicketItem;
        if (fullVoid) {
            origTicketItem.setQuantity(Double.valueOf(quantity));
        } else {
            origTicketItem.setQuantity(Double.valueOf(origTicketItem.getQuantity() + quantity));
        }
        origTicketItem.setPrintedToKitchen(Boolean.valueOf(POSUtil.getBoolean((String)voidedTicketItem.getProperty("originalItemPrintedToKitchen"))));
        origTicketItem.setVoided(Boolean.valueOf(false));
        origTicketItem.setVoidDate(null);
        origTicketItem.setVoidedItemId(null);
        origTicketItem.setCloudSynced(Boolean.valueOf(false));
        origTicketItem.setHasSyncError(Boolean.valueOf(false));
        origTicketItem.removeProperty("returned");
        if (voidedTicketItem.isInventoryAdjusted() && !itemWasted) {
            origTicketItem.setInventoryAdjustQty(Double.valueOf(Math.abs(origTicketItem.getInventoryAdjustQty()) - quantity));
        } else {
            origTicketItem.setInventoryAdjustQty(Double.valueOf(Math.abs(fullVoid ? origTicketItem.getQuantity() : origTicketItem.getQuantity() + quantity)));
        }
        if (origTicketItem.isHasModifiers().booleanValue() && (ticketItemModifiers = origTicketItem.getTicketItemModifiers()) != null) {
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.setItemQuantity(Double.valueOf(Math.abs(modifier.getItemQuantity())));
            }
        }
        TicketItemPriceCalcV2.getInstance().removeVoidProperties(origTicketItem);
        if (voidedTicketItem.isComboItem().booleanValue()) {
            if (voidedTicketItem.getComboItems() != null) {
                for (TicketItem comboTicketItem : voidedTicketItem.getComboItems()) {
                    double toBeVoidComboQuantity = Math.abs(comboTicketItem.getQuantity() / ticketItemQuantity * quantity);
                    comboTicketItem.setQuantity(Double.valueOf(toBeVoidComboQuantity));
                    voidedTicketItem.setInventoryAdjustQty(Double.valueOf(itemWasted ? -toBeVoidComboQuantity : 0.0));
                    TicketItemPriceCalcV2.getInstance().removeVoidProperties(comboTicketItem);
                    comboTicketItem.setVoided(Boolean.valueOf(false));
                }
            }
            if (!fullVoid && origTicketItem.getComboItems() != null) {
                for (TicketItem comboTicketItem : origTicketItem.getComboItems()) {
                    comboTicketItem.setQuantity(Double.valueOf(comboTicketItem.getQuantity() + comboTicketItem.getQuantity() / ticketItemQuantity * quantity));
                }
            }
        }
        origTicketItem.calculatePrice();
        return origTicketItem;
    }

    private TicketItem getTicketItem(Ticket ticket, String ticketItemId) {
        if (StringUtils.isBlank((String)ticketItemId)) {
            return null;
        }
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getId() == null || !ticketItem.getId().equals(ticketItemId)) continue;
            return ticketItem;
        }
        return null;
    }

    public void mergeTicket(Ticket currentTicket, Ticket localTicket) {
        List ticketItems = currentTicket.getTicketItems();
        if (ticketItems != null && ticketItems.size() > 0) {
            for (TicketItem ticketItem : ticketItems) {
                List ticketItemDiscounts;
                if (ticketItem.isHasModifiers().booleanValue() && ticketItem.getTicketItemModifiers() != null && ticketItem.getTicketItemModifiers().size() > 0) {
                    for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                        ticketItemModifier.setTicketItem(ticketItem);
                    }
                }
                if ((ticketItemDiscounts = ticketItem.getDiscounts()) == null || ticketItemDiscounts.size() <= 0) continue;
                for (TicketItemDiscount ticketItemDiscount : ticketItemDiscounts) {
                    ticketItemDiscount.setTicketItem(ticketItem);
                }
            }
        }
        this.mergeTicketItems(currentTicket, localTicket.getTicketItems());
        this.mergeTransactions(currentTicket, localTicket.getTransactions());
        currentTicket.calculatePrice();
    }

    private void mergeTicketItems(Ticket currentTicket, List<TicketItem> localTicketItems) {
        if (localTicketItems.isEmpty()) {
            return;
        }
        List thisTicketItems = currentTicket.getTicketItems();
        for (TicketItem localTicketItem : localTicketItems) {
            int idx = thisTicketItems.indexOf(localTicketItem);
            if (idx != -1) {
                TicketItem thisTicketItem = (TicketItem)thisTicketItems.get(idx);
                if (localTicketItem.isPrintedToKitchen().booleanValue()) {
                    thisTicketItem.setPrintedToKitchen(Boolean.valueOf(true));
                }
                if (localTicketItem.getQuantity() == thisTicketItem.getQuantity()) continue;
            }
            localTicketItem.setTicket(currentTicket);
            currentTicket.addToticketItems(localTicketItem);
        }
    }

    private void mergeTransactions(Ticket currentTicket, Set<PosTransaction> otherTransactions) {
        if (otherTransactions == null || otherTransactions.isEmpty()) {
            return;
        }
        ArrayList thisTransactions = new ArrayList(currentTicket.getTransactions());
        for (PosTransaction otherTransaction : otherTransactions) {
            int idx = thisTransactions.indexOf(otherTransaction);
            if (idx != -1) continue;
            otherTransaction.setTicket(currentTicket);
            currentTicket.addTotransactions(otherTransaction);
        }
    }

    private static double calculateAmountFromPercentage(double subtotalAmount, double commissionPercentage) {
        if (commissionPercentage > 0.0) {
            return NumberUtil.round((double)Math.round(subtotalAmount * (commissionPercentage / 100.0)));
        }
        return 0.0;
    }
}

