/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.PosLog;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.util.pricecalc.TicketItemModifierCalc;
import com.floreantpos.util.NumberUtil;
import com.orocube.pos.pricecalc.TicketItemPriceCalcV2;
import com.orocube.pos.pricecalc.TicketPriceCalcV2;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.json.JSONArray;

public class TicketItemModifierPriceCalcV2
implements TicketItemModifierCalc {
    private static TicketItemModifierPriceCalcV2 instance = new TicketItemModifierPriceCalcV2();

    public void calculatePrice(TicketItemModifier modifier) {
        if (modifier.isInfoOnly().booleanValue()) {
            return;
        }
        double unitPrice = modifier.getUnitPrice();
        Double itemQuantity = this.calculateModifierQty(modifier);
        double subTotalAmount = NumberUtil.round((double)this.calculateSubTotal(modifier, unitPrice));
        double calculateDiscountAmount = NumberUtil.round((double)this.calculateDiscount(modifier, subTotalAmount));
        double unitDiscountAmount = NumberUtil.round((double)(calculateDiscountAmount / itemQuantity));
        double totalCost = NumberUtil.round((double)this.calculateTotalCost(modifier, modifier.getUnitCost()));
        double taxAmount = 0.0;
        double unitServiceCharge = 0.0;
        double totalAmount = 0.0;
        TicketItem ticketItem = modifier.getTicketItem();
        Ticket ticket = ticketItem.getTicket();
        if (ticketItem != null && ticket != null) {
            unitServiceCharge = ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount() ? TicketItemPriceCalcV2.getInstance().calculateUnitServiceCharge(ticketItem, unitPrice - unitDiscountAmount) : TicketItemPriceCalcV2.getInstance().calculateUnitServiceCharge(ticketItem, unitPrice);
        }
        taxAmount = ticketItem != null && ticketItem.isTaxOnServiceCharge() != false ? NumberUtil.round((double)this.calculateTax(modifier, itemQuantity, unitPrice + unitServiceCharge, unitDiscountAmount)) : NumberUtil.round((double)this.calculateTax(modifier, itemQuantity, unitPrice, unitDiscountAmount));
        double discountAmount = NumberUtil.round((double)(unitDiscountAmount * itemQuantity));
        double serviceCharge = NumberUtil.round((double)(unitServiceCharge * itemQuantity));
        totalAmount = modifier.isTaxIncluded() != false ? NumberUtil.round((double)(subTotalAmount - discountAmount + serviceCharge)) : NumberUtil.round((double)(subTotalAmount - discountAmount + taxAmount + serviceCharge));
        modifier.setTotalCost(Double.valueOf(totalCost));
        modifier.setSubTotalAmount(Double.valueOf(subTotalAmount));
        modifier.setDiscountAmount(Double.valueOf(discountAmount));
        modifier.setTaxAmount(Double.valueOf(taxAmount));
        modifier.setServiceCharge(Double.valueOf(serviceCharge));
        modifier.setTotalAmount(Double.valueOf(totalAmount));
        modifier.setAdjustedUnitPrice(modifier.getUnitPrice());
        modifier.setAdjustedDiscount(Double.valueOf(discountAmount));
        modifier.setAdjustedSubtotal(Double.valueOf(subTotalAmount));
        modifier.setAdjustedTax(Double.valueOf(taxAmount));
        modifier.setAdjustedTotal(Double.valueOf(totalAmount));
        if (modifier.isLabDoctorFee()) {
            modifier.getTicketItem().setLabDoctorFee(Double.valueOf(modifier.getUnitPrice() - discountAmount));
        }
        PosLog.debug(this.getClass(), (String)String.format("%s, subtotal: %s, discount: %s, sc: %s, tax: %s", modifier.getName(), modifier.getSubtotalAmount(), modifier.getDiscountAmount(), modifier.getServiceCharge(), modifier.getTaxAmount()));
    }

    public void calculateAdjustedPrice(TicketItemModifier modifier) {
        if (modifier.isLabDoctorFee() && !modifier.isApplyDiscountOnDoctorFee()) {
            return;
        }
        TicketItem ticketItem = modifier.getTicketItem();
        Ticket ticket = null;
        if (ticketItem != null) {
            ticket = modifier.getTicketItem().getTicket();
        }
        double adjustedUnitServiceCharge = modifier.getServiceCharge();
        double adjustedTax = 0.0;
        double itemQuantity = modifier.getItemQuantity();
        double adjustedUnitPrice = this.calculateAdjustedUnitPrice(modifier);
        if (ticket != null && ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount()) {
            adjustedUnitServiceCharge = TicketItemPriceCalcV2.getInstance().calculateUnitServiceCharge(ticketItem, adjustedUnitPrice);
        }
        double adjustedSubtotal = NumberUtil.round((double)(adjustedUnitPrice * itemQuantity));
        double adjustedServiceCharge = NumberUtil.round((double)(adjustedUnitServiceCharge * itemQuantity));
        double adjustedDiscount = NumberUtil.round((double)(modifier.getSubtotalAmount() - adjustedSubtotal));
        adjustedTax = ticketItem != null && ticketItem.isTaxOnServiceCharge() != false ? NumberUtil.round((double)this.calculateTax(modifier, itemQuantity, adjustedSubtotal + adjustedServiceCharge, 0.0)) : NumberUtil.round((double)this.calculateTax(modifier, itemQuantity, adjustedSubtotal, 0.0));
        double adjustedTotal = 0.0;
        adjustedTotal = modifier.isTaxIncluded() != false ? NumberUtil.round((double)(adjustedSubtotal + adjustedServiceCharge)) : NumberUtil.round((double)(adjustedSubtotal + adjustedTax + adjustedServiceCharge));
        modifier.setAdjustedUnitPrice(Double.valueOf(adjustedUnitPrice));
        modifier.setAdjustedDiscount(Double.valueOf(adjustedDiscount));
        modifier.setAdjustedSubtotal(Double.valueOf(adjustedSubtotal));
        modifier.setAdjustedTax(Double.valueOf(adjustedTax));
        modifier.setServiceCharge(Double.valueOf(adjustedServiceCharge));
        modifier.setAdjustedTotal(Double.valueOf(adjustedTotal));
        if (modifier.isLabDoctorFee()) {
            modifier.getTicketItem().setLabDoctorFee(Double.valueOf(adjustedUnitPrice));
        }
    }

    private double calculateTax(TicketItemModifier modifier, Double itemQuantity, double unitPrice, double unitDiscountAmount) {
        return NumberUtil.round((double)(itemQuantity * NumberUtil.round((double)this.calculateUnitTax(modifier, unitPrice - unitDiscountAmount))));
    }

    private double calculateUnitTax(TicketItemModifier modifier, double unitPriceWithoutDiscount) {
        TicketItem ticketItem = modifier.getTicketItem();
        Ticket ticket = ticketItem.getTicket();
        double totalUnitTaxAmount = 0.0;
        List modifierTaxList = modifier.getTaxes();
        if (modifierTaxList != null) {
            if (modifier.isTaxIncluded().booleanValue()) {
                double taxRatePercentage = 0.0;
                for (TicketItemTax ticketItemModifierTax : modifierTaxList) {
                    taxRatePercentage += ticketItemModifierTax.getRate() / 100.0;
                }
                if (taxRatePercentage == 0.0) {
                    return totalUnitTaxAmount;
                }
                double totalTaxRatePercentage = taxRatePercentage + 1.0;
                double actualPrice = unitPriceWithoutDiscount / totalTaxRatePercentage;
                for (TicketItemTax ticketItemModifierTax : modifierTaxList) {
                    taxRatePercentage = ticketItemModifierTax.getRate() / 100.0;
                    double tax = NumberUtil.round((double)(actualPrice * taxRatePercentage));
                    ticketItemModifierTax.setTaxAmount(Double.valueOf(tax * ticketItem.getQuantity()));
                    totalUnitTaxAmount += tax;
                }
            } else {
                for (TicketItemTax ticketItemModifierTax : modifierTaxList) {
                    double taxRatePercentage = ticketItemModifierTax.getRate() / 100.0;
                    if (taxRatePercentage == 0.0) {
                        return totalUnitTaxAmount;
                    }
                    double tax = NumberUtil.round((double)(unitPriceWithoutDiscount * taxRatePercentage));
                    ticketItemModifierTax.setTaxAmount(Double.valueOf(tax * ticketItem.getQuantity()));
                    totalUnitTaxAmount += tax;
                }
            }
        }
        totalUnitTaxAmount = TicketPriceCalcV2.getInstance().applyFloridaTaxRuleV2(ticketItem.getTicket(), unitPriceWithoutDiscount, totalUnitTaxAmount);
        modifier.buildTaxes();
        modifier.setTaxExemptAmount(Double.valueOf(0.0));
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            modifier.setTaxExemptAmount(Double.valueOf(NumberUtil.round((double)totalUnitTaxAmount)));
            return 0.0;
        }
        return totalUnitTaxAmount;
    }

    private double calculateAdjustedUnitPrice(TicketItemModifier modifier) {
        Ticket ticket = modifier.getTicketItem().getTicket();
        double itemQuantity = modifier.getItemQuantity();
        double unitPriceAfterDiscount = (modifier.getSubtotalAmount() - modifier.getDiscountAmount()) / itemQuantity;
        double adjustedUnitPrice = 0.0;
        for (TicketDiscount discount : ticket.getDiscounts()) {
            double discountPercentageRate = TicketPriceCalcV2.getInstance().getDiscountPercentageRate(ticket, discount);
            unitPriceAfterDiscount = adjustedUnitPrice = unitPriceAfterDiscount - unitPriceAfterDiscount * discountPercentageRate;
        }
        if (modifier.getUnitPrice() == 0.0) {
            adjustedUnitPrice = 0.0;
        }
        return NumberUtil.round((double)adjustedUnitPrice, (int)2);
    }

    private double calculateTotalCost(TicketItemModifier modifier, double unitCost) {
        Double modifierQty = modifier.getItemQuantity();
        TicketItem ticketItem = modifier.getTicketItem();
        if (ticketItem != null) {
            modifierQty = modifierQty * Math.abs(ticketItem.getQuantity());
        }
        return unitCost * modifierQty;
    }

    public double calculateDiscount(TicketItemModifier modifier, double subtotalAmount) {
        double discount = 0.0;
        if (modifier.isLabDoctorFee() && !modifier.isApplyDiscountOnDoctorFee()) {
            return discount;
        }
        JSONArray jsonArray = new JSONArray();
        TicketItem ticketItem = modifier.getTicketItem();
        if (ticketItem == null) {
            return 0.0;
        }
        List discounts = ticketItem.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                Integer dataVersion;
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    TicketItemDiscount modifierDiscount = (TicketItemDiscount)SerializationUtils.clone((Serializable)ticketItemDiscount);
                    double newModifierDiscount = modifierDiscount.calculateDiscount(subtotalAmount - discount);
                    jsonArray.put((Object)modifierDiscount.toJson());
                    ticketItemDiscount.setAmount(Double.valueOf(ticketItemDiscount.getAmount() + Math.abs(newModifierDiscount)));
                    discount += newModifierDiscount;
                    continue;
                }
                if (ticketItemDiscount.getType() != 0 || (dataVersion = ticketItemDiscount.getDataVersion()) == null || dataVersion <= 1) continue;
                double discountAmount = subtotalAmount == 0.0 ? 0.0 : Math.abs(ticketItemDiscount.getValue() * 100.0 / subtotalAmount);
                TicketItemDiscount percentDiscount = new TicketItemDiscount();
                percentDiscount.setType(Integer.valueOf(1));
                percentDiscount.setOriginalType(0);
                percentDiscount.setMinimumAmount(ticketItemDiscount.getMinimumAmount());
                percentDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                percentDiscount.setDiscountId(ticketItemDiscount.getDiscountId());
                percentDiscount.setApplyIfDivisible(Boolean.FALSE);
                percentDiscount.setTicketItem(ticketItem);
                percentDiscount.setOriginalValue(ticketItemDiscount.getValue().doubleValue());
                percentDiscount.setValue(Double.valueOf(NumberUtil.round((double)discountAmount)));
                double calculatedDiscount = percentDiscount.calculateDiscount(Math.abs(subtotalAmount - discount));
                if (subtotalAmount < 0.0) {
                    double modifierDiscountAmount;
                    TicketItemDiscount itemModifierDiscount = null;
                    List modifierDiscounts = modifier.getDiscounts();
                    if (modifierDiscounts != null) {
                        for (TicketItemDiscount modifierDiscount : modifierDiscounts) {
                            if (!ticketItemDiscount.getDiscountId().equals(modifierDiscount.getDiscountId())) continue;
                            itemModifierDiscount = modifierDiscount;
                            break;
                        }
                    }
                    double maxDiscount = Math.abs(itemModifierDiscount == null ? 0.0 : itemModifierDiscount.getAmount());
                    double d = modifierDiscountAmount = calculatedDiscount > maxDiscount ? maxDiscount : calculatedDiscount;
                    if (modifierDiscountAmount < 0.0) {
                        modifierDiscountAmount = 0.0;
                    }
                    double amount = ticketItemDiscount.getAmount() + modifierDiscountAmount;
                    ticketItemDiscount.setAmount(Double.valueOf(amount));
                    modifierDiscountAmount = -1.0 * modifierDiscountAmount;
                    percentDiscount.setAmount(Double.valueOf(modifierDiscountAmount));
                    discount += modifierDiscountAmount;
                } else {
                    double remainingDiscount = ticketItemDiscount.getValue() * ticketItemDiscount.getCouponQuantity() - Math.abs(ticketItemDiscount.getAmount() + discount);
                    if (remainingDiscount < 0.0) {
                        remainingDiscount = 0.0;
                    }
                    if (calculatedDiscount > remainingDiscount) {
                        calculatedDiscount = remainingDiscount;
                    }
                    percentDiscount.setAmount(Double.valueOf(ticketItem.isItemReturned() != false ? -1.0 * calculatedDiscount : calculatedDiscount));
                    discount += calculatedDiscount;
                    ticketItemDiscount.setAmountWithoutModifiers(ticketItemDiscount.getAmount().doubleValue());
                    ticketItemDiscount.setAmount(Double.valueOf(ticketItemDiscount.getAmount() + calculatedDiscount));
                }
                jsonArray.put((Object)percentDiscount.toJson());
            }
            modifier.addProperty("discountDetail", jsonArray.toString());
        }
        if (discount > Math.abs(subtotalAmount)) {
            return subtotalAmount;
        }
        return discount;
    }

    private double calculateSubTotal(TicketItemModifier modifier, double unitPrice) {
        return unitPrice * this.calculateModifierQty(modifier);
    }

    private Double calculateModifierQty(TicketItemModifier modifier) {
        Double modifierQty = modifier.getItemQuantity();
        if (modifier.getTicketItem() != null) {
            modifierQty = modifierQty * Math.abs(modifier.getTicketItem().getQuantity());
        }
        return modifierQty;
    }

    public static TicketItemModifierPriceCalcV2 getInstance() {
        return instance;
    }
}

