/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.util.pricecalc.PriceRuleService;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.NullPrecedence;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class PriceRuleServiceImpl
implements PriceRuleService {
    private static PriceRuleServiceImpl instance = new PriceRuleServiceImpl();

    public static PriceRuleServiceImpl getInstance() {
        return instance;
    }

    public Double getPrice(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, Customer customer, String unit) {
        try (Session session = PriceRuleDAO.getInstance().createNewSession();){
            Double d = this.getPrice(menuItem, orderType, department, salesArea, customer, unit, session);
            return d;
        }
    }

    private Double getPrice(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, Customer customer, String unitId, Session session) {
        String priceTableId = this.getPriceTableId(orderType, department, salesArea, customer, session);
        if (StringUtils.isBlank((String)priceTableId)) {
            return null;
        }
        Criteria criteria = session.createCriteria(PriceTableItem.class);
        criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
        if (StringUtils.isNotBlank((String)unitId)) {
            if (menuItem.getUnit() != null && menuItem.getUnit().getId().equals(unitId)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceTableItem.PROP_UNIT), (Criterion)Restrictions.eq((String)PriceTableItem.PROP_UNIT, (Object)unitId)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_UNIT, (Object)unitId));
            }
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceTableItem.PROP_DELETED), (Criterion)Restrictions.eq((String)PriceTableItem.PROP_DELETED, (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Object)priceTableId));
        criteria.setMaxResults(1);
        PriceTableItem item = (PriceTableItem)criteria.uniqueResult();
        if (item == null) {
            return null;
        }
        return item.getPrice();
    }

    private String getPriceTableId(OrderType orderType, Department department, SalesArea salesArea, Customer customer, Session session) {
        Criteria priceRuleCriteria = session.createCriteria(PriceRule.class);
        priceRuleCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_DELETED), (Criterion)Restrictions.eq((String)PriceRule.PROP_DELETED, (Object)Boolean.FALSE)));
        priceRuleCriteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_ACTIVE, (Object)true));
        boolean includeOrderTypeFilter = orderType != null;
        Criterion ordertypeIdNull = Restrictions.isNull((String)PriceRule.PROP_ORDER_TYPE_ID);
        if (includeOrderTypeFilter) {
            priceRuleCriteria.add((Criterion)Restrictions.or((Criterion)ordertypeIdNull, (Criterion)Restrictions.eq((String)PriceRule.PROP_ORDER_TYPE_ID, (Object)orderType.getId())));
        } else {
            priceRuleCriteria.add(ordertypeIdNull);
        }
        Criterion departmentIdNull = Restrictions.isNull((String)PriceRule.PROP_DEPARTMENT_ID);
        if (department != null) {
            priceRuleCriteria.add((Criterion)Restrictions.or((Criterion)departmentIdNull, (Criterion)Restrictions.eq((String)PriceRule.PROP_DEPARTMENT_ID, (Object)department.getId())));
        } else {
            priceRuleCriteria.add(departmentIdNull);
        }
        Criterion salesAreaIdNull = Restrictions.isNull((String)PriceRule.PROP_SALES_AREA_ID);
        if (salesArea != null) {
            priceRuleCriteria.add((Criterion)Restrictions.or((Criterion)salesAreaIdNull, (Criterion)Restrictions.eq((String)PriceRule.PROP_SALES_AREA_ID, (Object)salesArea.getId())));
        } else {
            priceRuleCriteria.add(salesAreaIdNull);
        }
        List currentPriceShifts = ShiftUtil.getCurrentPriceShifts();
        List priceShiftIds = null;
        if (currentPriceShifts != null && !currentPriceShifts.isEmpty()) {
            priceShiftIds = POSUtil.getStringIds((List)currentPriceShifts, Shift.class);
        }
        Criterion priceShiftIdNull = Restrictions.isNull((String)PriceRule.PROP_PRICE_SHIFT_ID);
        if (priceShiftIds != null && !priceShiftIds.isEmpty()) {
            priceRuleCriteria.add((Criterion)Restrictions.or((Criterion)priceShiftIdNull, (Criterion)Restrictions.in((String)PriceRule.PROP_PRICE_SHIFT_ID, (Collection)priceShiftIds)));
        } else {
            priceRuleCriteria.add(priceShiftIdNull);
        }
        Criterion customerGroupIdNull = Restrictions.isNull((String)PriceRule.PROP_CUSTOMER_GROUP_ID);
        if (customer != null) {
            DetachedCriteria customerGroupFilter = DetachedCriteria.forClass(CustomerGroup.class);
            customerGroupFilter.createAlias("customers", "ccg");
            customerGroupFilter.add((Criterion)Restrictions.eq((String)("ccg." + Customer.PROP_ID), (Object)customer.getId()));
            customerGroupFilter.setProjection((Projection)Property.forName((String)CustomerGroup.PROP_ID));
            priceRuleCriteria.add((Criterion)Restrictions.or((Criterion)customerGroupIdNull, (Criterion)Property.forName((String)PriceRule.PROP_CUSTOMER_GROUP_ID).in(customerGroupFilter)));
        } else {
            priceRuleCriteria.add(customerGroupIdNull);
        }
        boolean membershipActive = customer == null ? false : customer.isMembershipActive();
        priceRuleCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_CUSTOMER_IS_MEMBER), (Criterion)Restrictions.eq((String)PriceRule.PROP_CUSTOMER_IS_MEMBER, (Object)membershipActive)));
        priceRuleCriteria.addOrder(Order.desc((String)PriceRule.PROP_PRIORITY).nulls(NullPrecedence.LAST));
        priceRuleCriteria.setProjection((Projection)Property.forName((String)PriceRule.PROP_PRICE_TABLE_ID));
        priceRuleCriteria.setMaxResults(1);
        String priceTableId = (String)priceRuleCriteria.uniqueResult();
        PosLog.info(PriceRuleServiceImpl.class, (String)("Price table id: " + priceTableId));
        return priceTableId;
    }
}

