/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.util.pricecalc.DiscountCalculator;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiscountCalc
implements DiscountCalculator {
    private static DiscountCalc instance = new DiscountCalc();

    public double calculateDiscount(TicketItemDiscount ticketItemDiscount, double subtotalAmount) {
        return this.calculateDiscount(ticketItemDiscount, subtotalAmount, false);
    }

    public double calculateDiscount(TicketItemDiscount ticketItemDiscount, double subtotalAmount, boolean modifier) {
        double discountAmount;
        double quantity = 1.0;
        double couponQuantity = ticketItemDiscount.getCouponQuantity();
        if (ticketItemDiscount.getMinimumAmount() > 1.0 && (quantity = Math.abs(Math.floor(ticketItemDiscount.getTicketItem().getQuantity() / ticketItemDiscount.getMinimumAmount()))) < 1.0) {
            couponQuantity = quantity;
        }
        if ((discountAmount = NumberUtil.round((double)this.calculateDiscountAmount(ticketItemDiscount, subtotalAmount)) * couponQuantity) > 0.0 && discountAmount > Math.abs(subtotalAmount)) {
            discountAmount = subtotalAmount;
        }
        if (modifier) {
            ticketItemDiscount.setAmount(Double.valueOf(NumberUtil.round((double)(ticketItemDiscount.getAmount() + discountAmount))));
        } else {
            ticketItemDiscount.setAmountWithoutModifiers(NumberUtil.round((double)discountAmount));
            ticketItemDiscount.setAmount(Double.valueOf(NumberUtil.round((double)discountAmount)));
        }
        return discountAmount;
    }

    @Deprecated
    public BigDecimal calculateDiscount(TicketItemDiscount ticketItemDiscount, BigDecimal subtotalAmount) {
        BigDecimal discountAmount;
        BigDecimal quantity = NumberUtil.convertToBigDecimal((String)"1");
        BigDecimal couponQuantity = NumberUtil.convertToBigDecimal((double)ticketItemDiscount.getCouponQuantity());
        BigDecimal minAmount = NumberUtil.convertToBigDecimal((double)ticketItemDiscount.getMinimumAmount());
        if (minAmount.compareTo(BigDecimal.ONE) > 0 && couponQuantity.compareTo(quantity = NumberUtil.convertToBigDecimal((double)ticketItemDiscount.getTicketItem().getQuantity()).divide(minAmount, 4, RoundingMode.HALF_DOWN)) >= 0) {
            couponQuantity = quantity;
        }
        if ((discountAmount = this.calculateDiscountAmount(ticketItemDiscount, subtotalAmount).multiply(couponQuantity)).compareTo(BigDecimal.ZERO) > 0 && discountAmount.compareTo(subtotalAmount) > 0) {
            discountAmount = subtotalAmount;
        }
        ticketItemDiscount.setAmount(Double.valueOf(discountAmount.doubleValue()));
        return discountAmount;
    }

    public double calculatePercentageForTotal(Double expectedTotal, Double currentTotal) {
        double d = expectedTotal / currentTotal * 100.0;
        d = 100.0 - d;
        return d;
    }

    public Double calculateDiscountPercentageFromAmount(Double subtotalAmount, Double discountAmount) {
        double d = (subtotalAmount - discountAmount) / subtotalAmount;
        double d2 = d * 100.0;
        return 100.0 - d2;
    }

    public Double calculateDiscountAmount(TicketItemDiscount ticketItemDiscount, double subtotalAmount) {
        TicketItem ticketItem = ticketItemDiscount.getTicketItem();
        if (ticketItemDiscount.getType() == 2) {
            return ticketItemDiscount.getValue();
        }
        double itemCount = ticketItem.getQuantity();
        double unitAmount = NumberUtil.round((double)(subtotalAmount / itemCount));
        if (ticketItemDiscount.getMinimumAmount() > 1.0) {
            double minQuantity = ticketItemDiscount.getMinimumAmount();
            switch (ticketItemDiscount.getType()) {
                case 0: {
                    return Math.floor(itemCount / minQuantity) * ticketItemDiscount.getValue();
                }
                case 1: {
                    if (ticketItemDiscount.isApplyIfDivisible().booleanValue()) {
                        return Math.floor(itemCount / minQuantity) * (unitAmount * ticketItemDiscount.getValue() / 100.0) * minQuantity;
                    }
                    return NumberUtil.round((double)(unitAmount * ticketItemDiscount.getValue() / 100.0)) * itemCount;
                }
            }
        }
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return ticketItemDiscount.getValue();
            }
            case 1: {
                return NumberUtil.round((double)(unitAmount * ticketItemDiscount.getValue() / 100.0)) * itemCount;
            }
        }
        return 0.0;
    }

    public BigDecimal calculateDiscountAmount(TicketItemDiscount ticketItemDiscount, BigDecimal subtotalAmount) {
        TicketItem ticketItem = ticketItemDiscount.getTicketItem();
        BigDecimal discountValue = NumberUtil.convertToBigDecimal((double)ticketItemDiscount.getValue());
        BigDecimal percentage = discountValue.divide(NumberUtil.convertToBigDecimal((String)"100.0"), 4, RoundingMode.FLOOR);
        if (ticketItemDiscount.getType() == 2) {
            return discountValue;
        }
        if (ticketItemDiscount.getMinimumAmount() > 1.0) {
            BigDecimal minQuantity = NumberUtil.convertToBigDecimal((double)ticketItemDiscount.getMinimumAmount());
            BigDecimal itemCount = NumberUtil.convertToBigDecimal((double)ticketItem.getQuantity());
            switch (ticketItemDiscount.getType()) {
                case 0: {
                    return itemCount.divide(minQuantity, 4, RoundingMode.FLOOR).multiply(discountValue);
                }
                case 1: {
                    BigDecimal itemCountDivideQuantity = itemCount.divide(minQuantity, 4, RoundingMode.FLOOR);
                    BigDecimal subtotalDivideItemCount = subtotalAmount.divide(itemCount, 4, RoundingMode.FLOOR);
                    return itemCountDivideQuantity.multiply(subtotalDivideItemCount).multiply(percentage);
                }
            }
        }
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return discountValue;
            }
            case 1: {
                return subtotalAmount.multiply(percentage);
            }
        }
        return new BigDecimal("0");
    }

    public Double calculateDiscountAmount(double ticketSubTotal, TicketDiscount discount) {
        switch (discount.getType()) {
            case 2: {
                return ticketSubTotal == 0.0 ? 0.0 : discount.getValue();
            }
            case 0: {
                return discount.getValue();
            }
            case 1: {
                double d = ticketSubTotal * (discount.getValue() * discount.getCouponQuantity() / 100.0);
                if (d > ticketSubTotal) {
                    return ticketSubTotal;
                }
                return d;
            }
        }
        return ticketSubTotal * discount.getValue() / 100.0;
    }

    public TicketItemDiscount getMaxDiscount(List<TicketItemDiscount> discounts) {
        if (discounts == null || discounts.isEmpty()) {
            return null;
        }
        TicketItemDiscount maxDiscount = Collections.max(discounts, new Comparator<TicketItemDiscount>(){

            @Override
            public int compare(TicketItemDiscount o1, TicketItemDiscount o2) {
                return (int)(o1.getAmount() - o2.getAmount());
            }
        });
        return maxDiscount;
    }

    public TicketDiscount getMaxDiscount(List<TicketDiscount> discounts, final double price) {
        if (discounts == null || discounts.isEmpty()) {
            return null;
        }
        TicketDiscount maxDiscount = Collections.max(discounts, new Comparator<TicketDiscount>(){

            @Override
            public int compare(TicketDiscount o1, TicketDiscount o2) {
                return (int)(DiscountCalc.this.calculateDiscountAmount(price, o1) - DiscountCalc.this.calculateDiscountAmount(price, o2));
            }
        });
        return maxDiscount;
    }

    public Double calculatePercentDiscount(double amount, double percentage) {
        return amount * percentage;
    }

    public Double calculateRepriceDiscount(Ticket ticket, Double repriceValue) {
        Double ticketTotalAmount = ticket.getTotalAmount();
        Double ticketTaxAmount = ticket.getTaxAmount();
        if (ticketTotalAmount == 0.0) {
            return 0.0;
        }
        double repricedTaxAmount = repriceValue * ticketTaxAmount / ticketTotalAmount;
        if (ticket.isTaxIncluded().booleanValue()) {
            repricedTaxAmount = 0.0;
        }
        Double discountValue = ticket.getSubtotalAmount() - ticket.getItemDiscountAmount() - (repriceValue - repricedTaxAmount);
        return discountValue;
    }

    public static DiscountCalc getInstance() {
        return instance;
    }
}

