/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.model.Currency;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.pricecalc.DiscountCalcFactory;
import com.floreantpos.model.util.pricecalc.TicketCalc;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.orocube.pos.pricecalc.TicketItemPriceCalcV1;
import com.orocube.pos.pricecalc.TicketPriceCalcV2;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Set;

public class TicketPriceCalcV1
implements TicketCalc {
    private static TicketPriceCalcV1 instance = new TicketPriceCalcV1();

    public void calculatePrice(Ticket ticket) {
        List ticketItems = ticket.getTicketItems();
        if (ticketItems == null) {
            return;
        }
        if (!ticket.isShouldCalculatePrice().booleanValue()) {
            ticket.setDiscountAmount(Double.valueOf(this.calculateTicketDiscount(ticket, ticket.getSubtotalAmount(), 0.0, 0.0)));
            return;
        }
        BigDecimal subtotal = NumberUtil.convertToBigDecimal((double)0.0);
        BigDecimal discount = NumberUtil.convertToBigDecimal((double)0.0);
        BigDecimal itemsServiceChargeAmount = NumberUtil.convertToBigDecimal((double)0.0);
        BigDecimal taxAmount = NumberUtil.convertToBigDecimal((double)0.0);
        BigDecimal itemDiscountAmountWithVoidItems = NumberUtil.convertToBigDecimal((double)0.0);
        double voidSubtotal = 0.0;
        double voidTotal = 0.0;
        double itemDiscountAmount = 0.0;
        double ticketDiscountAmount = 0.0;
        double taxAmountProperty = 0.0;
        for (TicketItem ticketItem : ticketItems) {
            if (!ticket.isPriceApplicable(ticketItem)) {
                if (!ticketItem.isVoided().booleanValue() || ticketItem.isItemReturned().booleanValue()) continue;
                voidSubtotal += Math.abs(ticketItem.getSubtotalAmount());
                voidTotal += Math.abs(ticketItem.getSubtotalAmount()) + Math.abs(ticketItem.getTaxAmount());
                continue;
            }
            ticketItem.calculatePrice();
            subtotal = NumberUtil.round((BigDecimal)subtotal.add(NumberUtil.convertToBigDecimal((double)ticketItem.getSubtotalAmount())));
            itemsServiceChargeAmount = NumberUtil.round((BigDecimal)itemsServiceChargeAmount.add(NumberUtil.convertToBigDecimal((double)ticketItem.getServiceCharge())));
            taxAmount = NumberUtil.round((BigDecimal)taxAmount.add(NumberUtil.convertToBigDecimal((double)ticketItem.getTaxAmount())));
            taxAmountProperty += ticketItem.getTaxExemptAmount().doubleValue();
            itemDiscountAmountWithVoidItems = NumberUtil.round((BigDecimal)itemDiscountAmountWithVoidItems.add(NumberUtil.convertToBigDecimal((double)ticketItem.getDiscountAmount())));
            if (ticketItem.isVoided().booleanValue()) {
                if (ticketItem.getVoidedItemId() == null) continue;
                voidSubtotal += Math.abs(ticketItem.getSubtotalAmount());
                voidTotal += Math.abs(ticketItem.getSubtotalAmount()) + Math.abs(ticketItem.getTaxAmount());
                continue;
            }
            itemDiscountAmount += ticketItem.getDiscountAmount().doubleValue();
        }
        ticket.addProperty("tax.exempt.amount", String.valueOf(taxAmountProperty));
        ticket.setItemDiscountAmount(itemDiscountAmount);
        ticket.setVoidSubtotal(voidSubtotal);
        ticket.setVoidTotal(voidTotal);
        ticketDiscountAmount = this.calculateTicketDiscount(ticket, subtotal.doubleValue(), voidSubtotal, itemDiscountAmount);
        if (ticketDiscountAmount > subtotal.doubleValue()) {
            ticketDiscountAmount = subtotal.doubleValue();
        }
        ticket.setTicketDiscountAmount(ticketDiscountAmount);
        discount = NumberUtil.convertToBigDecimal((double)this.calculateTotalDiscountAmount(ticket, subtotal.doubleValue(), voidSubtotal, ticketDiscountAmount, itemDiscountAmountWithVoidItems.doubleValue()));
        double deliveryChargeAmount = ticket.getDeliveryCharge();
        double totalServiceCharge = itemsServiceChargeAmount.doubleValue();
        BigDecimal totalAmount = NumberUtil.convertToBigDecimal((double)0.0);
        if (ticketDiscountAmount > 0.0) {
            BigDecimal itemDiscountedSubtotal = subtotal.subtract(NumberUtil.convertToBigDecimal((double)itemDiscountAmount));
            BigDecimal discountSubtotal = itemDiscountedSubtotal.subtract(NumberUtil.convertToBigDecimal((double)ticketDiscountAmount));
            BigDecimal newTax = NumberUtil.convertToBigDecimal((double)0.0);
            if (itemDiscountedSubtotal.compareTo(BigDecimal.ZERO) > 0) {
                newTax = discountSubtotal.multiply(taxAmount).divide(itemDiscountedSubtotal, 4, RoundingMode.HALF_UP);
            }
            taxAmount = NumberUtil.round((BigDecimal)newTax);
            totalAmount = ticket.isTaxIncluded().booleanValue() ? totalAmount.add(discountSubtotal) : totalAmount.add(discountSubtotal).add(NumberUtil.convertToBigDecimal((double)newTax.doubleValue()));
        } else {
            totalAmount = ticket.isTaxIncluded() != false ? totalAmount.add(subtotal).subtract(discount) : totalAmount.add(subtotal).subtract(discount).add(taxAmount);
        }
        this.calculateGratuity(ticket, subtotal.doubleValue(), discount.doubleValue());
        double gratuityAmount = ticket.getGratuityAmount();
        BigDecimal deliveryChargeBG = NumberUtil.convertToBigDecimal((double)deliveryChargeAmount);
        BigDecimal totalServiceChargeBG = NumberUtil.convertToBigDecimal((double)totalServiceCharge);
        BigDecimal feeAmountBG = NumberUtil.convertToBigDecimal((double)ticket.getFeeAmount());
        totalAmount = NumberUtil.round((BigDecimal)totalAmount.add(deliveryChargeBG).add(totalServiceChargeBG).add(feeAmountBG)).subtract(NumberUtil.convertToBigDecimal((double)ticket.getOldDataTolerance()));
        BigDecimal gratuityBG = NumberUtil.convertToBigDecimal((double)gratuityAmount);
        BigDecimal paidAmountBG = NumberUtil.convertToBigDecimal((double)ticket.getPaidAmount());
        BigDecimal dueAmount = NumberUtil.round((BigDecimal)totalAmount.add(gratuityBG).subtract(paidAmountBG));
        dueAmount = this.calculateToleranceAmount(ticket, dueAmount);
        ticket.setSubtotalAmount(Double.valueOf(NumberUtil.round((double)subtotal.doubleValue())));
        ticket.setDiscountAmount(Double.valueOf(NumberUtil.round((double)discount.doubleValue())));
        ticket.setItemDiscountAmount(itemDiscountAmount);
        ticket.setServiceCharge(Double.valueOf(NumberUtil.round((double)totalServiceCharge)));
        ticket.setDeliveryCharge(Double.valueOf(NumberUtil.round((double)deliveryChargeAmount)));
        ticket.setTaxAmount(Double.valueOf(NumberUtil.round((double)taxAmount.doubleValue())));
        ticket.setTotalAmount(Double.valueOf(totalAmount.doubleValue()));
        ticket.setDueAmount(Double.valueOf(dueAmount.doubleValue()));
        if (ticketDiscountAmount <= 0.0) {
            return;
        }
        double newServiceCharge = 0.0;
        double newTaxAmount = 0.0;
        for (TicketItem ticketItem : ticketItems) {
            if (!ticket.isPriceApplicable(ticketItem)) continue;
            new TicketItemPriceCalcV1().calculateAdjustedPrice(ticketItem);
            newServiceCharge += ticketItem.getServiceCharge().doubleValue();
            newTaxAmount += ticketItem.getAdjustedTax().doubleValue();
        }
        totalAmount = NumberUtil.round((BigDecimal)totalAmount.subtract(NumberUtil.convertToBigDecimal((double)totalServiceCharge)).add(NumberUtil.convertToBigDecimal((double)newServiceCharge)));
        dueAmount = NumberUtil.round((BigDecimal)totalAmount.add(gratuityBG).subtract(paidAmountBG));
        dueAmount = this.calculateToleranceAmount(ticket, dueAmount);
        ticket.setTaxAmount(Double.valueOf(newTaxAmount));
        ticket.setTotalAmount(Double.valueOf(totalAmount.doubleValue()));
        ticket.setDueAmount(Double.valueOf(dueAmount.doubleValue()));
        if (NumberUtil.isZero((Double)ticket.getDueAmount())) {
            ticket.setDueAmount(Double.valueOf(0.0));
        }
        ticket.setServiceCharge(Double.valueOf(newServiceCharge));
    }

    private double calculateTicketDiscount(Ticket ticket, double subtotal, double voidSubtotal, double itemDiscount) {
        double subtotalAfterItemDiscount = subtotal - itemDiscount;
        double ticketDisount = 0.0;
        List ticketCouponAndDiscounts = ticket.getDiscounts();
        if (ticketCouponAndDiscounts != null) {
            for (TicketDiscount ticketDiscount : ticketCouponAndDiscounts) {
                Double calculateDiscountAmount;
                double discountForThisCoupon = 0.0;
                Integer discountType = ticketDiscount.getType();
                if (discountType == 2) {
                    discountForThisCoupon = DiscountCalcFactory.getCalc().calculateRepriceDiscount(ticket, ticketDiscount.getValue());
                } else if (discountType == 3) {
                    discountForThisCoupon = ticketDiscount.getValue() * ticketDiscount.getCouponQuantity();
                } else if (discountType == 1) {
                    calculateDiscountAmount = DiscountCalcFactory.getCalc().calculateDiscountAmount(subtotal - itemDiscount, ticketDiscount);
                    discountForThisCoupon = calculateDiscountAmount * ticketDiscount.getCouponQuantity();
                } else {
                    calculateDiscountAmount = DiscountCalcFactory.getCalc().calculateDiscountAmount(subtotalAfterItemDiscount, ticketDiscount);
                    discountForThisCoupon = calculateDiscountAmount * ticketDiscount.getCouponQuantity();
                }
                if (subtotal < ticketDiscount.getMinimumAmount()) {
                    discountForThisCoupon = 0.0;
                }
                ticketDiscount.setTotalDiscountAmount(Double.valueOf(discountForThisCoupon));
                ticketDisount += discountForThisCoupon;
            }
        }
        ticket.buildDiscounts();
        return NumberUtil.round((double)ticketDisount);
    }

    private double calculateTotalDiscountAmount(Ticket ticket, double subtotal, double voidSubtotal, double ticketDiscountAmount, double itemDiscountAmountWithVoidItems) {
        if (ticket.getDiscounts() == null || ticket.getDiscounts().size() == 0) {
            return itemDiscountAmountWithVoidItems;
        }
        double totalDiscountAmount = 0.0;
        totalDiscountAmount += itemDiscountAmountWithVoidItems;
        totalDiscountAmount += ticketDiscountAmount;
        if (subtotal > 0.0 && totalDiscountAmount > subtotal) {
            totalDiscountAmount = subtotal;
        }
        if (ticketDiscountAmount > subtotal) {
            ticketDiscountAmount = subtotal;
        }
        if (totalDiscountAmount < 0.0) {
            totalDiscountAmount = 0.0;
        }
        return NumberUtil.round((double)totalDiscountAmount);
    }

    public void calculateGratuity(Ticket ticket, double subtotalAmount, double discountAmount) {
        Double gratuityPercentage = ticket.getOutletGratuityRate();
        if (gratuityPercentage <= 0.0) {
            return;
        }
        Gratuity gratuity = ticket.getGratuity();
        if (gratuity != null && !gratuity.isAutoCalculated()) {
            return;
        }
        if (gratuity == null) {
            gratuity = new Gratuity();
            gratuity.setAutoCalculated(true);
            gratuity.setOutletId(DataProvider.get().getCurrentOutletId());
        }
        double gratuityAmount = 0.0;
        if (gratuityPercentage > 0.0) {
            gratuityAmount = (subtotalAmount - discountAmount) * (gratuityPercentage / 100.0);
        }
        if (gratuityAmount > 0.0) {
            gratuity.setAmount(Double.valueOf(NumberUtil.round((double)gratuityAmount)));
        } else {
            gratuity.setAmount(Double.valueOf(0.0));
        }
        ticket.setGratuity(gratuity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal calculateToleranceAmount(Ticket ticket, BigDecimal dueAmount) {
        double toleranceAmount = 0.0;
        try {
            if (ticket.getPaidAmount() <= 0.0) {
                BigDecimal bigDecimal = dueAmount;
                return bigDecimal;
            }
            double dueAmountDouble = dueAmount.doubleValue();
            Store store = DataProvider.get().getStore();
            double roundedDueAmount = 0.0;
            if (store != null) {
                roundedDueAmount = store.isAllowPenyRounding() ? (double)Math.round(dueAmountDouble * 100.0 / 5.0) * 5.0 / 100.0 : dueAmountDouble;
            }
            toleranceAmount = roundedDueAmount - dueAmountDouble;
            double toleranceAmountFactor = 0.0;
            Currency mainCurrency = CurrencyUtil.getMainCurrency();
            if (mainCurrency != null) {
                toleranceAmountFactor = mainCurrency.getTolerance();
            }
            if (Math.abs(roundedDueAmount) <= toleranceAmountFactor) {
                toleranceAmount = toleranceAmount < 0.0 || roundedDueAmount > 0.0 ? (toleranceAmount += -roundedDueAmount) : (toleranceAmount += roundedDueAmount);
                BigDecimal bigDecimal = BigDecimal.ZERO;
                return bigDecimal;
            }
            if (roundedDueAmount == 0.0 || roundedDueAmount <= 0.05) {
                BigDecimal bigDecimal = NumberUtil.convertToBigDecimal((double)roundedDueAmount);
                return bigDecimal;
            }
            BigDecimal bigDecimal = dueAmount;
            return bigDecimal;
        }
        finally {
            ticket.setToleranceAmount(toleranceAmount);
        }
    }

    public void calculateRefundAmount(Ticket ticket) {
        double refundAmount = 0.0;
        double voidAmount = 0.0;
        Set transactions = ticket.getTransactions();
        if (transactions != null) {
            for (PosTransaction t : transactions) {
                if (!(t instanceof RefundTransaction) || t.isVoided().booleanValue()) continue;
                refundAmount += t.getAmount().doubleValue();
            }
        }
        ticket.setRefundAmount(Double.valueOf(refundAmount + voidAmount));
    }

    public static TicketPriceCalcV1 getInstance() {
        return instance;
    }

    public double applyFloridaTaxRuleV2(Ticket ticket, double subtotal, double totalTaxAmount) {
        return this.applyFloridaTaxRule(ticket, NumberUtil.convertToBigDecimal((double)subtotal), NumberUtil.convertToBigDecimal((double)totalTaxAmount)).doubleValue();
    }

    public BigDecimal applyFloridaTaxRule(Ticket ticket, BigDecimal subtotal, BigDecimal totalTaxAmount) {
        BigDecimal roundedTax = NumberUtil.round((BigDecimal)totalTaxAmount);
        Store store = DataProvider.get().getStore();
        if (store != null && store.isEnableFloridaTaxRule()) {
            int intValueOfSubtotal = subtotal.multiply(new BigDecimal(100)).intValue();
            if (roundedTax.compareTo(totalTaxAmount) == 1 && ((intValueOfSubtotal %= 100) == 8 || intValueOfSubtotal == 9)) {
                roundedTax = NumberUtil.round((BigDecimal)NumberUtil.round((BigDecimal)totalTaxAmount).subtract(new BigDecimal(0.01)));
            } else if (intValueOfSubtotal > 9 && roundedTax.compareTo(totalTaxAmount) == -1) {
                roundedTax = NumberUtil.round((BigDecimal)roundedTax.add(new BigDecimal(0.01)));
            }
        }
        return roundedTax;
    }

    public TicketDiscount convertToTicketDiscount(Discount discount, Ticket ticket) {
        return null;
    }

    public TicketDiscount buildLoyaltyDiscount(Ticket ticket) {
        return null;
    }

    public double calculateDiscountFromType(Ticket ticket, TicketDiscount coupon, double subtotal) {
        return 0.0;
    }

    public void voidItem(Ticket ticket, TicketItem ticketItem, String voidReason, boolean itemWasted, double quantity) {
        TicketPriceCalcV2.getInstance().voidItem(ticket, ticketItem, voidReason, itemWasted, quantity);
    }

    public void voidReturnedItem(TicketItem voidTicketItem, String voidReason, boolean itemWasted) {
        TicketPriceCalcV2.getInstance().voidReturnedItem(voidTicketItem, voidReason, itemWasted);
    }

    public TicketItem undoVoidItem(Ticket ticket, TicketItem voidedTicketItem) {
        return TicketPriceCalcV2.getInstance().undoVoidItem(ticket, voidedTicketItem);
    }

    public void mergeTicket(Ticket currentTicket, Ticket localTicket) {
        TicketPriceCalcV2.getInstance().mergeTicket(currentTicket, localTicket);
    }
}

