/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Agent;
import com.floreantpos.model.AgentTypeEnum;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Specimen;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TestItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.UnitType;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.ext.LabWorkStatus;
import com.floreantpos.model.ext.UnitBaseItemPrice;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.InventoryUnitConversionRule;
import com.floreantpos.model.util.ReferralCommissionType;
import com.floreantpos.model.util.ServiceChargeType;
import com.floreantpos.model.util.pricecalc.DataUtilCalculator;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class DataUtilCalc
implements DataUtilCalculator {
    private static DataUtilCalc instance = new DataUtilCalc();

    public TicketItem convertToTicketItem(MenuItem selectedMenuItem, Ticket ticket, double itemQuantity, boolean hasComboModifiers, IUnit destinationUnit, boolean checkEditablePrice, boolean useOnlinePrice) {
        List discountList;
        Object ticketItem = null;
        MenuItem menuItem = selectedMenuItem;
        boolean isComboItem = selectedMenuItem.isComboItem();
        if (selectedMenuItem.isVariant().booleanValue()) {
            menuItem = selectedMenuItem.getParentMenuItem();
            if (menuItem == null) {
                throw new PosException("Parent menu item is not set for variant " + selectedMenuItem.getId() + " : " + selectedMenuItem.getDisplayName());
            }
            isComboItem = menuItem.isComboItem();
            if (destinationUnit == null) {
                destinationUnit = selectedMenuItem.getUnit();
            }
        }
        ticketItem = isComboItem ? new ComboTicketItem() : (menuItem.isLabDoctorRequired() || menuItem.hasModifiers() || hasComboModifiers ? new ModifiableTicketItem() : new TicketItem());
        ticketItem.setTaxIncluded(DataProvider.get().getOutlet().isItemPriceIncludesTax());
        ticketItem.setDataVersion(Integer.valueOf(2));
        ticketItem.setMenuItemId(selectedMenuItem.getId());
        ticketItem.setProductType(menuItem.getProductType());
        ticketItem.putReportType(menuItem.getReportType());
        ticketItem.putFoldType(menuItem.getFoldType().name());
        ticketItem.putPlainReportResultTemplate(menuItem.getPlainReportResultTemplate());
        ticketItem.putHeaderNote(menuItem.getHeaderNote());
        ticketItem.putReportDescription(menuItem.getReportDescription());
        ticketItem.setBrandId(selectedMenuItem.getBrandId());
        ticketItem.setMenuItem(selectedMenuItem);
        ticketItem.setComboItem(menuItem.isComboItem());
        ticketItem.setFractionalUnit(menuItem.isFractionalUnit());
        ticketItem.setName(selectedMenuItem.getDisplayName());
        ticketItem.setGroupId(menuItem.getMenuGroupId());
        ticketItem.setGroupName(menuItem.getMenuGroupName());
        ticketItem.setCategoryName(menuItem.getMenuCategoryName());
        ticketItem.setCategoryId(menuItem.getMenuCategoryId());
        ticketItem.setServiceChargeApplicable(menuItem.isServiceChargeApplicable());
        ticketItem.setServiceChargeRate(menuItem.getServiceCharge());
        ticketItem.setTaxOnServiceCharge(menuItem.isTaxOnServiceCharge());
        ticketItem.setUnitSelection(menuItem.isAllowUnitSelection());
        if (StringUtils.isNotEmpty((String)selectedMenuItem.getTranslatedName())) {
            ticketItem.addProperty("translatedName", selectedMenuItem.getTranslatedName());
        }
        this.setTicketItemUnitPriceAndCost(selectedMenuItem, (TicketItem)ticketItem, destinationUnit, ticket, checkEditablePrice, useOnlinePrice);
        ticketItem.setQuantity(Double.valueOf(itemQuantity));
        ticketItem.setInventoryItem(menuItem.isInventoryItem());
        ticketItem.setTicket(ticket);
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setBeverage(menuItem.isBeverage());
        ticketItem.setPrinterGroup(menuItem.getPrinterGroup());
        ticketItem.setTicketDiscountApplicable(menuItem.isTicketDiscountApplicable());
        ticketItem.setReportGroupId(menuItem.getReportGroupId());
        ticketItem.setDeliveryDate(DateUtil.prepareDate((String)menuItem.getPreparationTime()));
        String specimenId = selectedMenuItem.getSpecimenId();
        if (StringUtils.isNotBlank((String)specimenId)) {
            Specimen specimen = (Specimen)DataProvider.get().getObjectOf(Specimen.class, (Serializable)((Object)specimenId));
            ticketItem.putSpecimen(specimen);
        }
        ticketItem.putLabTestRoomNo(selectedMenuItem.getLabTestRoomNo());
        ticketItem.putLabTestMethod(selectedMenuItem.getLabTestMethod());
        ticketItem.setFixedAsset(menuItem.isFixedAsset());
        ticketItem.setIncludeInSales(menuItem.isIncludeInSales());
        ticketItem.setSharedItem(menuItem.isSharedItem());
        ticketItem.setSharingRule(menuItem.getSharingRule());
        ticketItem.setRequiredShipping(selectedMenuItem.getRequiredShipping());
        ticketItem.setShipped(selectedMenuItem.getShipped());
        ticketItem.setShippedDate(selectedMenuItem.getShippedDate());
        ticketItem.putDescription(selectedMenuItem.getDescription());
        ticketItem.putWarrantyDuration(selectedMenuItem.getWarrantyDuration());
        ticketItem.putWarrantyDurationType(selectedMenuItem.getWarrantyDurationType());
        ticketItem.putPatientRequired(menuItem.isPatientRequired());
        if (!ProductType.match((String)ticketItem.getProductType(), (ProductType)ProductType.RADIOLOGY)) {
            boolean isSampleCollectionNeeded = menuItem.isSampleCollectionNeeded();
            ticketItem.putSampleCollectionNeeded(isSampleCollectionNeeded);
            if (!isSampleCollectionNeeded) {
                ticketItem.setLabWorkStatusValue(LabWorkStatus.RUN_TEST);
            }
        }
        boolean isLabDoctorRequired = menuItem.isLabDoctorRequired();
        ticketItem.setLabDoctorRequired(isLabDoctorRequired);
        boolean isPriceIncludesDoctorFee = menuItem.isPriceIncludesDoctorFee();
        ticketItem.setPriceIncludesDoctorFee(isPriceIncludesDoctorFee);
        if (isLabDoctorRequired) {
            double labDoctorFee = menuItem.getLabDoctorFee();
            ticketItem.setLabDoctorFee(Double.valueOf(labDoctorFee));
            if (menuItem.isService().booleanValue()) {
                ticketItem.putDoctorFeeRate(menuItem.getDoctorFeeRate());
                ticketItem.putDoctorFeeType(menuItem.getDoctorFeeType());
            } else {
                ticketItem.putDoctorFeeRate(NumberUtil.round((double)labDoctorFee));
                ticketItem.putDoctorFeeType(ServiceChargeType.FIXEDAMOUNT.name());
            }
            TicketItemModifier labDoctorFeeModifier = new TicketItemModifier();
            labDoctorFeeModifier.setItemQuantity(Double.valueOf(1.0));
            labDoctorFeeModifier.setName("Lab doctor fee");
            if (isPriceIncludesDoctorFee) {
                labDoctorFeeModifier.setInfoOnly(Boolean.valueOf(true));
            }
            labDoctorFeeModifier.setUnitCost(Double.valueOf(labDoctorFee));
            labDoctorFeeModifier.setUnitPrice(Double.valueOf(labDoctorFee));
            labDoctorFeeModifier.putApplyDiscountOnDoctorFee(DataProvider.get().getOutlet().isApplyDiscountOnDoctorFee());
            labDoctorFeeModifier.addProperty("labDoctorFee", String.valueOf(true));
            labDoctorFeeModifier.setTicketItem((TicketItem)ticketItem);
            ticketItem.addToticketItemModifiers(labDoctorFeeModifier);
        }
        ticketItem.setAllowDrFeeBeforeLabwork(Boolean.valueOf(menuItem.isAllowDrFeeBeforeLabwork()));
        String referrerId = ticket.getReferrerId();
        if (StringUtils.isNotBlank((String)referrerId)) {
            Customer referrer = CustomerDAO.getInstance().get(referrerId);
            if (referrer != null && referrer instanceof Agent) {
                ticketItem.putRfRateOnReport(POSUtil.parseDouble((String)referrer.getRfRateOnReport()));
                if (menuItem.isLabTest() && AgentTypeEnum.B2B == AgentTypeEnum.fromString((String)referrer.getAgentType())) {
                    ticketItem.setUnitPrice(Double.valueOf(menuItem.getB2bPrice()));
                    ticketItem.putRfOnReportType(ReferralCommissionType.GREATER_THAN_SALES_PRICE.name());
                } else {
                    ticketItem.putRfOnReportType(referrer.getRfOnReportType());
                }
            }
            String chargeType = ticketItem.getRfOnReportType();
            ReferralCommissionType referralCommissionType = ReferralCommissionType.fromName((String)chargeType);
            ticketItem.putRfOnReportType(chargeType);
            ticketItem.putRfRateOnReport(this.calculateReferrerCommissionRate((TicketItem)ticketItem, referralCommissionType, menuItem));
        }
        PosLog.debug(DataUtilCalc.class, (String)(ticketItem.getRfOnReportType() + " < > " + ticketItem.getRfRateOnReport()));
        OrderType orderType = ticket.getOrderType();
        this.setItemTaxes((TicketItem)ticketItem, selectedMenuItem.getTaxGroup(), orderType);
        List testItems = selectedMenuItem.getTestItems();
        if (testItems != null) {
            testItems.removeIf(Objects::isNull);
            int sortorder = 1;
            for (TestItem testItem : testItems) {
                if (testItem == null) continue;
                testItem.setSortOrder(Integer.valueOf(sortorder));
                ++sortorder;
            }
        }
        ticketItem.setTestItems(testItems);
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setPrintKitchenSticker(menuItem.isPrintKitchenSticker());
        Boolean serviceChargeApplicable = orderType != null ? orderType.isServiceChargeApplicable() : false;
        if (serviceChargeApplicable.booleanValue()) {
            ticketItem.setServiceChargeApplicable(serviceChargeApplicable);
            ticketItem.setServiceChargeRate(ticket.getOutletServiceChargeRate());
        }
        if ((discountList = menuItem.getDiscounts()) != null) {
            for (Discount discount : discountList) {
                if (!discount.isAutoApply().booleanValue() || !discount.isEnabled().booleanValue() || discount.isExpired()) continue;
                TicketItemDiscount ticketItemDiscount = this.convertToTicketItemDiscount(discount, (TicketItem)ticketItem);
                ticketItem.addTodiscounts(ticketItemDiscount);
            }
        }
        if (menuItem.isService().booleanValue()) {
            ticketItem.setService(Boolean.valueOf(true));
            ticketItem.setServiceType(menuItem.getServiceType());
            ticketItem.setPaymentType(menuItem.getPaymentType());
            ticketItem.setCustomerRequired(menuItem.isCustomerRequired());
        }
        return ticketItem;
    }

    public double calculateReferrerCommissionRate(TicketItem ticketItem, ReferralCommissionType referralCommissionType, MenuItem menuItem) {
        if (referralCommissionType == ReferralCommissionType.STANDARD) {
            String menuItemRFTypeName = menuItem.getRfOnReportType();
            ReferralCommissionType menuItemRFCommissionType = ReferralCommissionType.fromName((String)menuItemRFTypeName);
            if (menuItemRFCommissionType == ReferralCommissionType.CATEGORY) {
                String categoryId = menuItem.getMenuCategoryId();
                if (StringUtils.isNotBlank((String)categoryId)) {
                    MenuCategory menuCategory = MenuCategoryDAO.getInstance().get(categoryId);
                    return menuCategory.getRfRateOnReport(ticketItem.getTicket() == null ? null : ticketItem.getTicket().getReferrer());
                }
                return 0.0;
            }
            if (menuItemRFCommissionType == ReferralCommissionType.GROUP) {
                MenuGroup menuGroup;
                String menuGroupId = menuItem.getMenuGroupId();
                if (StringUtils.isNotBlank((String)menuGroupId) && (menuGroup = MenuGroupDAO.getInstance().get(menuGroupId)) != null) {
                    return menuGroup.getRfRateOnReport(ticketItem.getTicket() == null ? null : ticketItem.getTicket().getReferrer());
                }
                return 0.0;
            }
            ticketItem.putRfOnReportType(menuItemRFTypeName);
            return POSUtil.parseDouble((String)menuItem.getRfRateOnReport());
        }
        return ticketItem.getRfRateOnReport();
    }

    public void setTicketItemUnitPriceAndCost(MenuItem selectedMenuItem, TicketItem ticketItem, IUnit destinationUnit, Ticket ticket, boolean checkEditablePrice, boolean useOnlinePrice) {
        String unitId = selectedMenuItem.getUnitId();
        if (selectedMenuItem.isEditablePrice().booleanValue() && checkEditablePrice) {
            if (destinationUnit != null) {
                double unitQuantity = selectedMenuItem.getUnitQuantity((IUnit)selectedMenuItem.getUnit(), destinationUnit);
                Double unitCost = selectedMenuItem.getItemCost() / unitQuantity;
                ticketItem.setUnitName(destinationUnit.getId());
                ticketItem.setUnitType(destinationUnit.getUnitType());
                ticketItem.setUnitCost(unitCost);
            } else {
                if (StringUtils.isBlank((String)unitId)) {
                    ticketItem.setUnitType(UnitType.PACKAGING_UNIT.name());
                } else {
                    ticketItem.setUnitType(UnitType.UNIT.name());
                }
                ticketItem.setUnitName(unitId);
                ticketItem.setUnitCost(Double.valueOf(selectedMenuItem.getItemCost()));
            }
            ticketItem.setUnitPrice(selectedMenuItem.getPrice());
        } else {
            Double priceRulePrice = useOnlinePrice ? selectedMenuItem.getOnlinePrice(ticket.getOutletId()).doubleValue() : this.getPriceFromPriceRule(selectedMenuItem, ticket, ticketItem);
            ticketItem.setUnitPrice(priceRulePrice);
            if (destinationUnit != null) {
                double unitQuantity = selectedMenuItem.getUnitQuantity((IUnit)selectedMenuItem.getUnit(), destinationUnit);
                Double unitPrice = this.getDestinationUnitPrice(selectedMenuItem, destinationUnit, ticketItem.getUnitPrice(), unitQuantity);
                Double unitCost = (destinationUnit instanceof InventoryStockUnit ? ((InventoryStockUnit)destinationUnit).getCost().doubleValue() : selectedMenuItem.getItemCost()) / unitQuantity;
                ticketItem.setUnitName(destinationUnit.getId());
                ticketItem.setUnitType(destinationUnit.getUnitType());
                ticketItem.setUnitCost(unitCost);
                ticketItem.setUnitPrice(unitPrice);
            } else {
                ticketItem.setUnitName(unitId);
                ticketItem.setUnitCost(Double.valueOf(selectedMenuItem.getItemCost()));
            }
        }
        if (destinationUnit != null) {
            ticketItem.addProperty("unit_Name", destinationUnit.getName());
            ticketItem.addProperty("unit_Code", destinationUnit.getUniqueCode());
            ticketItem.addProperty("unit_display_name", destinationUnit.getDisplayName());
            ticketItem.addProperty("unit_Id", destinationUnit.getId());
            ticketItem.addProperty("unit_stock_countable", String.valueOf(destinationUnit.isStockCountable()));
            ticketItem.addProperty("unit_conversion_rate", String.valueOf(destinationUnit.getConversionRate()));
            if (destinationUnit instanceof InventoryUnit) {
                ticketItem.addProperty("unit_conversion_rule", String.valueOf(((InventoryUnit)destinationUnit).getConversionRule().getName()));
            }
        } else {
            InventoryUnit inventoryUnit = selectedMenuItem.getUnit();
            if (inventoryUnit != null) {
                ticketItem.addProperty("unit_Name", inventoryUnit.getName());
                ticketItem.addProperty("unit_Code", inventoryUnit.getCode());
                ticketItem.addProperty("unit_display_name", inventoryUnit.getDisplayName());
                ticketItem.addProperty("unit_Id", inventoryUnit.getId());
                ticketItem.addProperty("unit_stock_countable", String.valueOf(inventoryUnit.isStockCountable()));
                ticketItem.addProperty("unit_conversion_rate", String.valueOf(inventoryUnit.getConversionRate()));
                ticketItem.addProperty("unit_conversion_rule", String.valueOf(inventoryUnit.getConversionRule().getName()));
            }
        }
    }

    public void setItemTaxes(TicketItem ticketItem, TaxGroup itemTaxGroup, OrderType orderType) {
        SubOrderType subOrderType;
        TaxGroup orderBaseTaxGroup;
        MenuItem menuItem = ticketItem.getMenuItem();
        if (menuItem != null && orderType != null && (orderBaseTaxGroup = this.getOrderBaseTaxGroup(menuItem, "", orderType.getId())) != null) {
            itemTaxGroup = orderBaseTaxGroup;
        }
        if (ticketItem.getTicket() != null && (subOrderType = ticketItem.getTicket().getSubOrderType()) != null) {
            TaxGroup orderBaseTaxGroup2;
            if (subOrderType == SubOrderType.FOR_HERE) {
                orderBaseTaxGroup2 = this.getOrderBaseTaxGroup(menuItem, orderType.getId(), ".for_here");
                itemTaxGroup = orderBaseTaxGroup2 != null ? orderBaseTaxGroup2 : orderType.getForHereTaxGroup();
            } else if (subOrderType == SubOrderType.TO_GO) {
                orderBaseTaxGroup2 = this.getOrderBaseTaxGroup(menuItem, orderType.getId(), ".to_go");
                itemTaxGroup = orderBaseTaxGroup2 != null ? orderBaseTaxGroup2 : orderType.getToGoTaxGroup();
            }
        }
        if (itemTaxGroup == null && menuItem != null) {
            itemTaxGroup = menuItem.getTaxGroup();
        }
        if (itemTaxGroup == null && orderType != null) {
            TaxGroup orderTypeTaxGroup = orderType.getDefaultTaxGroup();
            itemTaxGroup = orderTypeTaxGroup != null ? orderTypeTaxGroup : this.getOutletTaxGroup();
        }
        if (itemTaxGroup == null) {
            ticketItem.setTaxes(null);
            return;
        }
        List taxes = itemTaxGroup.getTaxes();
        if (taxes != null) {
            ArrayList<TicketItemTax> ticketItemTaxes = new ArrayList<TicketItemTax>();
            for (Tax tax : taxes) {
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(tax.getId());
                ticketItemTax.setName(tax.getName());
                ticketItemTax.setRate(tax.getRate());
                ticketItemTaxes.add(ticketItemTax);
            }
            ticketItem.setTaxes(ticketItemTaxes);
        }
    }

    private TaxGroup getOutletTaxGroup() {
        Outlet outlet = DataProvider.get().getOutlet();
        if (outlet != null) {
            TaxGroup outletTaxGroup = outlet.getTaxGroup();
            return outletTaxGroup;
        }
        return null;
    }

    private TaxGroup getOrderBaseTaxGroup(MenuItem menuItem, String orderTypeId, String subOrderType) {
        if (menuItem == null) {
            return null;
        }
        String orderTypeTaxGroupId = menuItem.getProperty(orderTypeId + subOrderType + ".taxgroup");
        if (StringUtils.isBlank((String)orderTypeTaxGroupId)) {
            return null;
        }
        return DataProvider.get().getTaxGroupById(orderTypeTaxGroupId);
    }

    public TicketItemDiscount convertToTicketItemDiscount(Discount discount, TicketItem ticketItem) {
        TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
        ticketItemDiscount.setDiscountId(discount.getId());
        ticketItemDiscount.setAutoApply(discount.isAutoApply());
        ticketItemDiscount.setName(discount.getName());
        ticketItemDiscount.setType(discount.getType());
        ticketItemDiscount.setMinimumAmount(discount.getMinimumBuy());
        ticketItemDiscount.setValue(discount.getValue());
        ticketItemDiscount.setAmount(discount.getValue());
        ticketItemDiscount.setCouponQuantity(Double.valueOf(1.0));
        ticketItemDiscount.setTicketItem(ticketItem);
        ticketItemDiscount.setApplyIfDivisible(discount.isApplyIfDivisible());
        ticketItemDiscount.setDataVersion(Integer.valueOf(2));
        ticketItemDiscount.putDiscountGivenByUser(DataProvider.get().getCurrentUser());
        return ticketItemDiscount;
    }

    public List<IUnit> getUnits(MenuItem selectedMenuItem, boolean includeStockUnits, boolean includeRecipeUnits, boolean skipStockNotCountableUnits) {
        ArrayList<IUnit> units;
        block4: {
            InventoryUnit unit;
            block5: {
                block6: {
                    units = new ArrayList<IUnit>();
                    if (ProductType.match((String)selectedMenuItem.getProductType(), (ProductType)ProductType.MEDICINE) || (unit = selectedMenuItem.getUnit()) == null) break block4;
                    if (unit.getUnitGroup() != null) break block5;
                    if (skipStockNotCountableUnits) break block6;
                    units.add((IUnit)unit);
                    break block4;
                }
                if (!unit.isStockCountable()) break block4;
                units.add((IUnit)unit);
                break block4;
            }
            List groupUnits = unit.getUnitGroup().getUnits();
            if (groupUnits != null && groupUnits.size() > 0) {
                for (InventoryUnit groupUnit : groupUnits) {
                    if (groupUnit.isDeleted().booleanValue() || skipStockNotCountableUnits && !groupUnit.isStockCountable()) continue;
                    units.add((IUnit)groupUnit);
                }
            }
        }
        List variantStockUnits = selectedMenuItem.getVariantStockUnits();
        if (includeStockUnits && variantStockUnits != null) {
            for (InventoryStockUnit stockUnit : variantStockUnits) {
                if (stockUnit.isRecipeUnit().booleanValue() && !includeRecipeUnits) continue;
                units.add((IUnit)stockUnit);
            }
        }
        return units;
    }

    public double getPriceFromPriceRule(MenuItem menuItem, Ticket ticket) {
        return this.getPriceFromPriceRule(menuItem, ticket, null);
    }

    public double getPriceFromPriceRule(MenuItem menuItem, Ticket ticket, TicketItem ticketItem) {
        Double priceFromPriceRule = this.getPriceByUnitFromPriceRule(menuItem, ticket, null);
        if (priceFromPriceRule != null) {
            if (menuItem.isVariant().booleanValue()) {
                return priceFromPriceRule + menuItem.getPrice();
            }
            return priceFromPriceRule;
        }
        priceFromPriceRule = menuItem.getPrice();
        if (menuItem.isVariant().booleanValue()) {
            MenuItem parentMenuItem = menuItem.getParentMenuItem();
            if (parentMenuItem != null) {
                return priceFromPriceRule + parentMenuItem.getPrice();
            }
            PosLog.error(this.getClass(), (String)("Parent menu item is not set for variant " + menuItem.getId()));
        }
        return priceFromPriceRule;
    }

    public double getDestinationUnitPrice(Ticket ticket, MenuItem menuItem, IUnit destinationUnit, double unitQuantity) {
        return this.getDestinationUnitPrice(ticket, menuItem, destinationUnit, unitQuantity, null);
    }

    public double getDestinationUnitPrice(Ticket ticket, MenuItem menuItem, IUnit destinationUnit, double unitQuantity, TicketItem ticketItem) {
        Double priceFromPriceRule = this.getPriceByUnitFromPriceRule(menuItem, ticket, destinationUnit);
        if (priceFromPriceRule != null) {
            if (menuItem.isVariant().booleanValue()) {
                return priceFromPriceRule + this.calculatePrice(menuItem.getPrice(), (IUnit)menuItem.getUnit(), destinationUnit, menuItem);
            }
            return priceFromPriceRule;
        }
        priceFromPriceRule = menuItem.getPrice();
        if (menuItem.isVariant().booleanValue()) {
            priceFromPriceRule = priceFromPriceRule + menuItem.getParentMenuItem().getPrice();
        }
        return this.getDestinationUnitPrice(menuItem, destinationUnit, priceFromPriceRule, unitQuantity);
    }

    public double getDestinationUnitPrice(MenuItem menuItem, IUnit destinationUnit, Double priceFromPriceRule, double unitQuantity) {
        double destinationUnitPrice = 0.0;
        if (destinationUnit != null) {
            destinationUnitPrice = priceFromPriceRule / unitQuantity;
            if ((menuItem.isAllowUnitSelection() || menuItem.isAllowUnitWiseSelection()) && destinationUnit instanceof InventoryStockUnit) {
                InventoryStockUnit inventoryStockUnit = (InventoryStockUnit)destinationUnit;
                destinationUnitPrice = inventoryStockUnit.getPrice();
            }
        }
        return destinationUnitPrice;
    }

    public Double getPriceByUnitFromPriceRule(MenuItem menuItem, Ticket ticket, IUnit unit) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Department department = terminal == null ? null : terminal.getDepartment();
        SalesArea salesArea = null;
        OrderType orderType = null;
        Customer customer = null;
        if (ticket != null) {
            orderType = ticket.getOrderType();
            salesArea = ticket.getSalesArea();
            customer = ticket.getCustomer();
        }
        return DataProvider.get().getPriceFromPriceRule(menuItem.isVariant() != false ? menuItem.getParentMenuItem() : menuItem, orderType, department, salesArea, customer, unit);
    }

    public Double getVariantCost(MenuItem menuItem, IUnit selectedUnit) {
        if (selectedUnit == null) {
            return menuItem.getVariantCost();
        }
        InventoryUnit unit = menuItem.getUnit();
        if (unit != null && selectedUnit.getId().equals(unit.getId())) {
            return menuItem.getVariantCost();
        }
        return this.calculateCost(menuItem.getVariantCost(), (IUnit)menuItem.getUnit(), selectedUnit, menuItem);
    }

    public Double getCost(MenuItem menuItem, String unitId) {
        if (unitId == null) {
            return menuItem.getCost();
        }
        InventoryUnit unit = menuItem.getUnit();
        if (unit != null) {
            List stockUnits;
            InventoryUnitGroup unitGroup = unit.getUnitGroup();
            if (unitGroup != null && unitGroup.getUnits() != null) {
                for (InventoryUnit inventoryUnit : unitGroup.getUnits()) {
                    if (!inventoryUnit.getId().equals(unitId)) continue;
                    return this.getCost(menuItem, (IUnit)inventoryUnit);
                }
            }
            if ((stockUnits = menuItem.getStockUnits()) != null && stockUnits.size() > 0) {
                for (InventoryStockUnit itemStockUnit : stockUnits) {
                    if (!unitId.equals(itemStockUnit.getId())) continue;
                    return itemStockUnit.getCost();
                }
            }
        }
        return menuItem.getCost();
    }

    public Double getCost(MenuItem menuItem, IUnit selectedUnit) {
        if (selectedUnit == null) {
            return menuItem.getCost();
        }
        InventoryUnit unit = menuItem.getUnit();
        if (unit != null && selectedUnit.getId().equals(unit.getId())) {
            return menuItem.getCost();
        }
        return this.calculateCost(menuItem.getCost(), (IUnit)menuItem.getUnit(), selectedUnit, menuItem);
    }

    public double calculateCost(Double unitCost, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem) {
        if (sourceUnit == null || targetUnit == null) {
            return unitCost;
        }
        if (targetUnit instanceof InventoryUnit) {
            InventoryUnit targetInventoryUnit = (InventoryUnit)targetUnit;
            if (!sourceUnit.getId().equals(targetInventoryUnit.getId())) {
                return this.getInventoryUnitCost(unitCost, (InventoryUnit)sourceUnit, targetInventoryUnit);
            }
        }
        return unitCost == null ? 0.0 : unitCost;
    }

    private double getInventoryUnitCost(Double unitCost, InventoryUnit sourceUnit, InventoryUnit targetUnit) {
        double newUnitCost = unitCost;
        InventoryUnit inventoryUnit = targetUnit;
        String inventoryUnitConversionRuleName = inventoryUnit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        if (!sourceUnit.isBaseUnit().booleanValue() && sourceUnit.getConversionRate() != 1.0) {
            newUnitCost = unitCost * sourceUnit.getConversionRate();
        }
        if (newUnitCost == 0.0) {
            return 0.0;
        }
        double conversionRate = inventoryUnit.getConversionRate();
        if (conversionRate == 0.0) {
            return 0.0;
        }
        InventoryUnitConversionRule inventoryUnitConversionRule = InventoryUnitConversionRule.fromName((String)inventoryUnitConversionRuleName);
        if (inventoryUnitConversionRule == InventoryUnitConversionRule.MULTIPLICATION) {
            return newUnitCost * 1.0 / conversionRate;
        }
        return newUnitCost / conversionRate;
    }

    public double calculatePrice(Double unitPrice, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem) {
        if (sourceUnit == null || targetUnit == null) {
            return unitPrice;
        }
        InventoryUnit targetInventoryUnit = (InventoryUnit)targetUnit;
        if (!sourceUnit.getId().equals(targetInventoryUnit.getId())) {
            return this.getInventoryUnitPrice(unitPrice, (InventoryUnit)sourceUnit, targetInventoryUnit);
        }
        return unitPrice == null ? 0.0 : unitPrice;
    }

    private double getInventoryUnitPrice(Double unitPrice, InventoryUnit sourceUnit, InventoryUnit targetUnit) {
        InventoryUnitConversionRule inventoryUnitConversionRule;
        double newUnitPrice = unitPrice;
        InventoryUnit inventoryUnit = targetUnit;
        String inventoryUnitConversionRuleName = inventoryUnit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        if (!sourceUnit.isBaseUnit().booleanValue() && sourceUnit.getConversionRate() != 1.0) {
            newUnitPrice = unitPrice * sourceUnit.getConversionRate();
        }
        if ((inventoryUnitConversionRule = InventoryUnitConversionRule.fromName((String)inventoryUnitConversionRuleName)) == InventoryUnitConversionRule.MULTIPLICATION) {
            return newUnitPrice * 1.0 / inventoryUnit.getConversionRate();
        }
        return newUnitPrice / inventoryUnit.getConversionRate();
    }

    public double getUnitQuantity(IUnit sourceInventoryUnit, IUnit destinationInventoryUnit, MenuItem menuItem) {
        if (sourceInventoryUnit instanceof InventoryStockUnit && destinationInventoryUnit instanceof InventoryStockUnit) {
            return sourceInventoryUnit.getConversionRate() == 0.0 ? destinationInventoryUnit.getConversionRate() : sourceInventoryUnit.getConversionRate() / destinationInventoryUnit.getConversionRate();
        }
        if (sourceInventoryUnit != null && destinationInventoryUnit != null) {
            return sourceInventoryUnit.getConversionRate() == 0.0 ? destinationInventoryUnit.getConversionRate() : destinationInventoryUnit.getConversionRate() / sourceInventoryUnit.getConversionRate();
        }
        return 1.0;
    }

    public double getBaseUnitQuantity(String unitId, MenuItem menuItem) {
        InventoryUnit menuItemInvUnit = menuItem.getUnit();
        boolean isMedicine = ProductType.match((String)menuItem.getProductType(), (ProductType)ProductType.MEDICINE);
        if (!isMedicine && (menuItemInvUnit == null || menuItemInvUnit.getId().equals(unitId))) {
            return 1.0;
        }
        if (menuItem.getStockUnits() != null) {
            for (InventoryStockUnit inventoryStockUnit : menuItem.getStockUnits()) {
                if (!inventoryStockUnit.getId().equals(unitId)) continue;
                if (isMedicine) {
                    return inventoryStockUnit.getBaseUnitValue();
                }
                if (!menuItemInvUnit.isBaseUnit().booleanValue()) {
                    return menuItemInvUnit.getConversionRate() * inventoryStockUnit.getBaseUnitValue();
                }
                return inventoryStockUnit.getBaseUnitValue();
            }
        }
        if (menuItemInvUnit.getUnitGroup() != null && menuItemInvUnit.getUnitGroup().getUnits() != null) {
            for (InventoryUnit groupUnit : menuItemInvUnit.getUnitGroup().getUnits()) {
                if (!groupUnit.getId().equals(unitId)) continue;
                return menuItemInvUnit.getConversionRate() / groupUnit.getConversionRate();
            }
        }
        return 1.0;
    }

    public List<UnitBaseItemPrice> buildUnitBasePriceList(MenuItem menuItem, boolean regeneratePrice) {
        ArrayList<UnitBaseItemPrice> unitBasePrices = new ArrayList<UnitBaseItemPrice>();
        for (IUnit unit : menuItem.getUnits()) {
            InventoryUnit inventoryUnit;
            if (unit.equals(inventoryUnit = menuItem.getUnit())) continue;
            Double unitBaseItemPrice = this.calculateUnitBaseItemPrice(menuItem, unit, regeneratePrice);
            UnitBaseItemPrice itemPrice = new UnitBaseItemPrice(unit.getName(), unit.getId(), unitBaseItemPrice);
            unitBasePrices.add(itemPrice);
        }
        return unitBasePrices;
    }

    private Double calculateUnitBaseItemPrice(MenuItem menuItem, IUnit unit, boolean regeneratePrice) {
        Double price = 0.0;
        if (unit instanceof InventoryStockUnit) {
            InventoryStockUnit inventoryStockUnit = (InventoryStockUnit)unit;
            price = inventoryStockUnit.getPrice();
            if (!regeneratePrice) {
                regeneratePrice = NumberUtil.isZero((Double)price);
            }
        }
        if (regeneratePrice) {
            price = this.calculatePrice(menuItem.getPrice(), (IUnit)menuItem.getUnit(), unit, menuItem);
        }
        return price;
    }

    public double calculateTestItemPrice(Double unitPrice, IUnit sourceUnit, IUnit targetUnit) {
        if (sourceUnit == null || targetUnit == null) {
            return unitPrice;
        }
        InventoryUnit targetInventoryUnit = (InventoryUnit)targetUnit;
        if (!sourceUnit.getId().equals(targetInventoryUnit.getId())) {
            return this.getInventoryUnitPrice(unitPrice, (InventoryUnit)sourceUnit, targetInventoryUnit);
        }
        return unitPrice == null ? 0.0 : unitPrice;
    }

    public static DataUtilCalc getInstance() {
        return instance;
    }
}

