/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.extension.FloreantPlugin;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.InvalidPluginDialog;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFloreantPlugin
implements FloreantPlugin,
LicenseSelectionListener {
    private OroLicense license;

    @Override
    public boolean requireLicense() {
        return true;
    }

    @Override
    public void initLicense() {
        try {
            this.license = LicenseUtil.loadAndValidate((String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
        }
        catch (InvalidLicenseException e) {
            InvalidPluginDialog.show((LicenseSelectionListener)this, (Component)this.getParent(), (String)e.getMessage(), (String)"Plugin error!", (String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    @Override
    public abstract String getId();

    public abstract String getProductName();

    public abstract String getProductVersion();

    public abstract Component getParent();

    public void licenseFileSelected(File pluginFile) throws Exception {
        try {
            OroLicense newLicense = LicenseUtil.loadAndValidate((File)pluginFile, (String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
            LicenseUtil.copyLicenseFile((File)pluginFile, (String)this.getProductName());
            this.setLicense(newLicense);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
            throw e;
        }
    }

    @Override
    public boolean hasValidLicense() {
        if (this.license != null) {
            return this.license.isValid();
        }
        return false;
    }

    public OroLicense getLicense() {
        return this.license;
    }

    public void setLicense(OroLicense license) {
        this.license = license;
    }

    @Override
    public void initBackoffice() {
    }

    @Override
    public void initConfigurationView(JDialog dialog) {
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public void initUI() {
    }

    public void restartPOS(boolean restart) {
    }
}

