/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static Date startOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static boolean isStartOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.get(7) == 1;
    }

    public static boolean isStartOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.get(5) == 1;
    }

    public static boolean between(Date date, Date date2, Date date3) {
        if (date == null || date2 == null) {
            return false;
        }
        return !(!date3.equals(date) && !date3.after(date) || !date3.equals(date2) && !date3.before(date2));
    }

    public static String getReportDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d h:mm:ss a");
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    public static boolean isToday(Date date) {
        return DateUtil.isSameDay(date, Calendar.getInstance().getTime());
    }

    public static boolean isToday(Calendar calendar) {
        return DateUtil.isSameDay(calendar, Calendar.getInstance());
    }

    public static String formatDateAsString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm a");
        String string = simpleDateFormat.format(date);
        return "TODAY " + string;
    }

    public static boolean isSameDay(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtil.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }
}

