/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.common.util;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;

public class TerminalUtil {
    private static final String a = "system_id";
    private static final String b = "a$@d55#";
    private static String c;

    private static PropertiesConfiguration a() throws ConfigurationException {
        File file = new File(System.getProperty("user.home") + "/.config/com.orocube");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, "orocube.config");
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(file2);
        propertiesConfiguration.setAutoSave(true);
        return propertiesConfiguration;
    }

    public static String getOldSystemUID() {
        SystemInfo systemInfo = new SystemInfo();
        String string = systemInfo.getHardware().getProcessor().getProcessorIdentifier().getProcessorID();
        UUID uUID = UUID.nameUUIDFromBytes(string.getBytes());
        return uUID.toString();
    }

    public static String getSystemUID() {
        return c;
    }

    public static void resetTerminalKey() {
        try {
            PropertiesConfiguration propertiesConfiguration = TerminalUtil.a();
            propertiesConfiguration.clearProperty(a);
            Preferences preferences = Preferences.userNodeForPackage(TerminalUtil.class);
            c = UUID.randomUUID().toString();
            preferences.put(b, null);
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException);
        }
    }

    private static boolean a(String string) {
        return !StringUtils.isBlank((String)string) && !"unknown".equalsIgnoreCase(string);
    }

    private static String b() {
        try {
            String string;
            Object object2;
            SystemInfo systemInfo = new SystemInfo();
            ComputerSystem computerSystem = systemInfo.getHardware().getComputerSystem();
            Baseboard baseboard = computerSystem.getBaseboard();
            CentralProcessor centralProcessor = systemInfo.getHardware().getProcessor();
            String string2 = computerSystem.getHardwareUUID();
            if (TerminalUtil.a(string2)) {
                TerminalUtil.b("terminal key from hardware uid: " + string2);
                return string2;
            }
            String string3 = systemInfo.getOperatingSystem().getManufacturer();
            String string4 = centralProcessor.getProcessorIdentifier().getIdentifier();
            String string5 = centralProcessor.getProcessorIdentifier().getProcessorID();
            String string6 = computerSystem.getModel();
            String string7 = computerSystem.getSerialNumber();
            String string8 = baseboard.getSerialNumber();
            String string9 = baseboard.getModel();
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("os vendor", string3);
            linkedHashMap.put("processor identifier", string4);
            linkedHashMap.put("processor id", string5);
            linkedHashMap.put("computer model", string6);
            linkedHashMap.put("computer serial no", string7);
            linkedHashMap.put("baseboard serial", string8);
            linkedHashMap.put("baseboard model", string9);
            StringBuilder stringBuilder = new StringBuilder();
            Set set = linkedHashMap.keySet();
            for (Object object2 : set) {
                string = (String)linkedHashMap.get(object2);
                if (!TerminalUtil.a(string)) continue;
                stringBuilder.append(string);
                TerminalUtil.b((String)object2 + ": " + string);
            }
            String string10 = stringBuilder.toString();
            object2 = null;
            object2 = StringUtils.isBlank((String)string10) ? UUID.randomUUID() : UUID.nameUUIDFromBytes(string10.getBytes());
            string = ((UUID)object2).toString();
            TerminalUtil.b("terminal key: " + string);
            return string;
        }
        catch (Exception exception) {
            LogFactory.getLog(TerminalUtil.class).error((Object)exception);
            String string = UUID.randomUUID().toString();
            String string11 = "Terminal key generation failed in first iteration. Trying second iteration...";
            TerminalUtil.b(string11);
            TerminalUtil.b("terminal key generated in second iteration: " + string);
            return string;
        }
    }

    private static void b(String string) {
        LogFactory.getLog(TerminalUtil.class).info((Object)string);
    }

    public static void main(String[] stringArray) {
        TerminalUtil.b();
    }

    static {
        block4: {
            try {
                PropertiesConfiguration propertiesConfiguration = TerminalUtil.a();
                c = (String)propertiesConfiguration.getProperty(a);
                if (StringUtils.isBlank((String)c)) {
                    Preferences preferences = Preferences.userNodeForPackage(TerminalUtil.class);
                    c = preferences.get(b, null);
                    if (StringUtils.isBlank((String)c)) {
                        c = TerminalUtil.b();
                    }
                    propertiesConfiguration.addProperty(a, (Object)c);
                }
            }
            catch (ConfigurationException configurationException) {
                LogFactory.getLog(TerminalUtil.class).error((Object)configurationException);
                if (!StringUtils.isBlank((String)c)) break block4;
                c = TerminalUtil.b();
            }
        }
    }
}

