/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.tablebooking.model.dao;

import com.orocube.tablebooking.model.BookingRequest;
import com.orocube.tablebooking.model.Customer;
import com.orocube.tablebooking.model.Store;
import com.orocube.tablebooking.model.base.BaseBookingRequestDAO;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BookingRequestDAO
extends BaseBookingRequestDAO {
    public void saveOrUpdateList(List<BookingRequest> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (BookingRequest bookingRequest : list) {
                session.saveOrUpdate((Object)bookingRequest);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingRequest initialize(BookingRequest bookingRequest) {
        if (bookingRequest == null || bookingRequest.getId() == null) {
            return bookingRequest;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)bookingRequest);
            BookingRequest bookingRequest2 = bookingRequest;
            return bookingRequest2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findOpenStatusReq() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_IS_PROCESSED, (Object)Boolean.FALSE));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<BookingRequest> list3 = null;
            return list3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingReqByStore(Store store) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_STORE, (Object)store));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<BookingRequest> list3 = null;
            return list3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingReqByCustomer(Customer customer) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_CUSTOMER, (Object)customer));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<BookingRequest> list3 = null;
            return list3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingReqByTimeAndDate(String string, Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)BookingRequest.PROP_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)BookingRequest.PROP_DATE, (Object)date2));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<BookingRequest> list3 = null;
            return list3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingRequests(Store store, BookingRequest bookingRequest, Date date, Date date2) {
        Session session = null;
        System.out.println("From TIME: " + date);
        System.out.println("To TIME: " + date2);
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_STORE, (Object)store));
            criteria.add((Criterion)Restrictions.ge((String)BookingRequest.PROP_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)BookingRequest.PROP_DATE, (Object)date2));
            if (bookingRequest != null) {
                criteria.add((Criterion)Restrictions.ne((String)BookingRequest.PROP_ID, (Object)bookingRequest.getId()));
            }
            if (!(list = criteria.list()).isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<BookingRequest> list3 = null;
            return list3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }
}

