/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.tablebooking.model.dao;

import com.orocube.tablebooking.model.Store;
import com.orocube.tablebooking.model.base.BaseStoreDAO;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StoreDAO
extends BaseStoreDAO {
    public Store findByUserName(String storeIdName) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Store.class);
            if (StringUtils.isNotEmpty((String)storeIdName)) {
                criteria.add((Criterion)Restrictions.eq((String)Store.PROP_STORE_ID, (Object)storeIdName));
                if (criteria.list().isEmpty()) {
                    return null;
                }
                Store store = (Store)criteria.list().get(0);
                return store;
            }
            return null;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public Store findByUserNameAndPassword(String userName, String password) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Store.class);
            if (StringUtils.isNotEmpty((String)userName)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Store.PROP_USER_NAME, (Object)userName), (Criterion)Restrictions.eq((String)Store.PROP_EMAIL, (Object)userName)));
                criteria.add((Criterion)Restrictions.eq((String)Store.PROP_PASSWORD, (Object)password));
                if (criteria.list().isEmpty()) {
                    return null;
                }
                Store store = (Store)criteria.list().get(0);
                return store;
            }
            return null;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public Store findByEmailOrContact(String email, String contact) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Store.class);
            if (StringUtils.isNotEmpty((String)email) || StringUtils.isNotEmpty((String)contact)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Store.PROP_EMAIL, (Object)email), (Criterion)Restrictions.eq((String)Store.PROP_PHONE, (Object)contact)));
                if (criteria.list().isEmpty()) {
                    return null;
                }
                Store store = (Store)criteria.list().get(0);
                return store;
            }
            return null;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public Store findByID(String storeId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Store.class);
            if (StringUtils.isNotEmpty((String)storeId)) {
                criteria.add((Criterion)Restrictions.eq((String)Store.PROP_STORE_ID, (Object)storeId));
                if (criteria.list().isEmpty()) {
                    return null;
                }
                Store store = (Store)criteria.list().get(0);
                return store;
            }
            return null;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

