/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.common.util;

import java.util.UUID;
import java.util.prefs.Preferences;
import org.apache.commons.lang.StringUtils;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

public class TerminalUtil {
    private static final String FLUID = "a$@d55#";
    private static String systemUID;

    public static String getOldSystemUID() {
        SystemInfo systemInfo = new SystemInfo();
        String identifier = systemInfo.getHardware().getProcessor().getProcessorID();
        UUID uuidFromBytes = UUID.nameUUIDFromBytes(identifier.getBytes());
        return uuidFromBytes.toString();
    }

    public static String getSystemUID() {
        return systemUID;
    }

    private static String generateLicenseKey() {
        try {
            SystemInfo systemInfo = new SystemInfo();
            OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
            HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
            CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
            ComputerSystem computerSystem = hardwareAbstractionLayer.getComputerSystem();
            String vendor = operatingSystem.getManufacturer();
            String processorSerialNumber = computerSystem.getSerialNumber();
            String processorIdentifier = centralProcessor.getIdentifier();
            int processors = centralProcessor.getLogicalProcessorCount();
            String delimiter = "#";
            return vendor + delimiter + processorSerialNumber + delimiter + processorIdentifier + delimiter + processors;
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        Preferences preferences = Preferences.userNodeForPackage(TerminalUtil.class);
        systemUID = preferences.get(FLUID, null);
        if (StringUtils.isEmpty((String)systemUID)) {
            String licenseKey = TerminalUtil.generateLicenseKey();
            if (StringUtils.isNotEmpty((String)licenseKey)) {
                UUID uuidFromBytes = UUID.nameUUIDFromBytes(licenseKey.getBytes());
                systemUID = uuidFromBytes.toString();
            } else {
                systemUID = UUID.randomUUID().toString();
            }
            preferences.put(FLUID, systemUID);
        }
    }
}

