/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.common.about;

import com.orocube.common.about.ChangesXMLParserHandler;
import com.orocube.common.about.Modes;
import com.orocube.common.about.Version;
import com.orocube.common.util.ProductInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WhatIsNewDialog
extends JDialog {
    private boolean canceled;
    private JEditorPane taChanges;
    private Modes readMode;
    private ProductInfo productInfo;

    public WhatIsNewDialog(Component parent, ProductInfo productInfo) {
        this(parent, Modes.FILE, productInfo);
    }

    public WhatIsNewDialog(Component parent, Modes modes, ProductInfo productInfo) {
        super((Frame)((JFrame)parent), true);
        String title = ((JFrame)parent).getTitle();
        this.setTitle(title.substring(0, title.indexOf(".") - 2));
        this.readMode = modes;
        this.productInfo = productInfo;
        this.setIconImage(((JFrame)parent).getIconImage());
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel headerPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 0", "", ""));
        headerPanel.setBackground(Color.white);
        JLabel lblUpdateTitle = new JLabel("Changes");
        lblUpdateTitle.setFont(new Font(null, 1, 16));
        lblUpdateTitle.setOpaque(false);
        headerPanel.add((Component)lblUpdateTitle, "gapleft 10,growx,span");
        headerPanel.add((Component)new JSeparator(), "growx,span");
        this.add((Component)headerPanel, "North");
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 20"));
        this.taChanges = new JEditorPane("text/html", "");
        this.taChanges.setEditable(false);
        this.taChanges.setBackground(Color.white);
        this.taChanges.setBorder(BorderFactory.createCompoundBorder(null, BorderFactory.createEmptyBorder(10, 8, 5, 5)));
        JScrollPane scrollPane = new JScrollPane(this.taChanges);
        scrollPane.setBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)));
        contentPanel.add((Component)scrollPane, "grow,span");
        this.add(contentPanel);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fillx,center,ins 0 0 5 0"));
        buttonPanel.add((Component)new JSeparator(), "growx,span,gapbottom 5");
        JButton btnCancel = new JButton("OK ");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WhatIsNewDialog.this.canceled = false;
                WhatIsNewDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)btnCancel, "center,h 35!,w 90!");
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (WhatIsNewDialog.this.readMode == Modes.FILE) {
                        WhatIsNewDialog.this.showCurrentChanges();
                    }
                }
            });
        }
        super.setVisible(b);
    }

    protected void showCurrentChanges() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            this.appendChanges(builder);
            builder.append("</html>");
            this.taChanges.setText(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendChanges(StringBuilder builder) {
        try {
            ArrayList<Version> versions = this.parse();
            if (versions == null) {
                return;
            }
            for (Version version : versions) {
                builder.append("<b>Version: " + version.getVersionNo() + "</b><br>");
                if (version.getChanges() == null) continue;
                for (String change : version.getChanges()) {
                    builder.append("&nbsp;&nbsp;&nbsp;" + change + "<br>");
                }
                builder.append("<br>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTitle(String title, String labelText) {
        this.setTitle(title);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public ArrayList<Version> parse() throws SAXException, FileNotFoundException, IOException, InterruptedException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        ChangesXMLParserHandler handler = new ChangesXMLParserHandler();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        if (this.productInfo.getChangeLogURL() == null) {
            return null;
        }
        URLConnection conn = this.productInfo.getChangeLogURL().openConnection();
        InputStream in = conn.getInputStream();
        reader.parse(new InputSource(in));
        return handler.getVersions();
    }
}

