/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.tablebooking.model.dao;

import com.orocube.tablebooking.model.BookingRequest;
import com.orocube.tablebooking.model.Customer;
import com.orocube.tablebooking.model.Store;
import com.orocube.tablebooking.model.base.BaseBookingRequestDAO;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BookingRequestDAO
extends BaseBookingRequestDAO {
    public void saveOrUpdateList(List<BookingRequest> bookingRequestList) {
        if (bookingRequestList == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (BookingRequest bookingRequest : bookingRequestList) {
                session.saveOrUpdate((Object)bookingRequest);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingRequest initialize(BookingRequest bookingRequest) {
        if (bookingRequest == null || bookingRequest.getId() == null) {
            return bookingRequest;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)bookingRequest);
            BookingRequest bookingRequest2 = bookingRequest;
            return bookingRequest2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findOpenStatusReq() {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_IS_PROCESSED, (Object)Boolean.FALSE));
            List allRequList = criteria.list();
            if (!allRequList.isEmpty()) {
                List list = allRequList;
                return list;
            }
            List<BookingRequest> list = null;
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingReqByStore(Store store) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_STORE, (Object)store));
            List allRequList = criteria.list();
            if (!allRequList.isEmpty()) {
                List list = allRequList;
                return list;
            }
            List<BookingRequest> list = null;
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingReqByCustomer(Customer customer) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_CUSTOMER, (Object)customer));
            List allRequList = criteria.list();
            if (!allRequList.isEmpty()) {
                List list = allRequList;
                return list;
            }
            List<BookingRequest> list = null;
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingReqByTimeAndDate(String time, Date startDate, Date endDate) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)BookingRequest.PROP_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)BookingRequest.PROP_DATE, (Object)endDate));
            List allRequList = criteria.list();
            if (!allRequList.isEmpty()) {
                List list = allRequList;
                return list;
            }
            List<BookingRequest> list = null;
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingRequest> findBookingRequests(Store store, BookingRequest bookingRequest, Date fromTime, Date toTime) {
        Session session = null;
        System.out.println("From TIME: " + fromTime);
        System.out.println("To TIME: " + toTime);
        try {
            List allRequList;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingRequest.PROP_STORE, (Object)store));
            criteria.add((Criterion)Restrictions.ge((String)BookingRequest.PROP_DATE, (Object)fromTime));
            criteria.add((Criterion)Restrictions.le((String)BookingRequest.PROP_DATE, (Object)toTime));
            if (bookingRequest != null) {
                criteria.add((Criterion)Restrictions.ne((String)BookingRequest.PROP_ID, (Object)bookingRequest.getId()));
            }
            if (!(allRequList = criteria.list()).isEmpty()) {
                List list = allRequList;
                return list;
            }
            List<BookingRequest> list = null;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }
}

