/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.oropos.rest;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.GlobalConfigDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.UpdatableView;
import com.floreantpos.util.StoreUtil;
import com.orocube.oropos.rest.RestServiceMessages;
import com.orocube.oropos.rest.server.util.EmbeddedTomcat;
import com.orocube.oropos.rest.server.util.TomcatServerListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;

public class EmbeddedTomcatImpl
implements EmbeddedTomcat {
    private static final String LOCALHOST = "127.0.0.1";
    private Tomcat tomcat;
    private UpdatableView updatableView;
    private Set<TomcatServerListener> tomcatServerListener = new HashSet<TomcatServerListener>();

    public void startServer(boolean isShowDialog, final int serverPort) {
        if (!this.isAvailable(serverPort)) {
            String errorMessage = RestServiceMessages.getString("EmbeddedTomcat.1") + serverPort + RestServiceMessages.getString("EmbeddedTomcat.2");
            PosLog.error(EmbeddedTomcatImpl.class, (String)errorMessage);
            if (isShowDialog) {
                throw new PosException(errorMessage);
            }
            this.fireTomcatServerStopped(errorMessage);
            return;
        }
        this.tomcat = new Tomcat();
        File catalinaHome = new File("server");
        String baseDir = catalinaHome.getAbsolutePath();
        this.tomcat.setPort(serverPort);
        this.tomcat.setBaseDir(baseDir);
        this.tomcat.getHost().setAppBase(baseDir);
        this.tomcat.getHost().setAutoDeploy(true);
        this.tomcat.enableNaming();
        this.createAndConfigureSimulatedWebXml();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    EmbeddedTomcatImpl.this.tomcat.start();
                    EmbeddedTomcatImpl.this.fireTomcatServerStarted();
                    EmbeddedTomcatImpl.this.saveDataServiceInfo();
                    if (EmbeddedTomcatImpl.this.updatableView != null) {
                        EmbeddedTomcatImpl.this.updatableView.updateView();
                    }
                    PosLog.info(this.getClass(), (String)("Tomcat Server started successfully on port :" + serverPort));
                    EmbeddedTomcatImpl.this.tomcat.getServer().await();
                }
                catch (LifecycleException e) {
                    throw new PosException(RestServiceMessages.getString("EmbeddedTomcat.0"));
                }
            }
        };
        thread.start();
    }

    private void createAndConfigureSimulatedWebXml() {
        String contextPath = "/";
        String docBase = new File(".").getAbsolutePath();
        Context context = this.tomcat.addContext(contextPath, docBase);
        Tomcat.initWebappDefaults((Context)context);
        context.setDisplayName("cloud");
        Wrapper servlet = this.tomcat.addServlet("/", "rest-ws", "com.sun.jersey.spi.container.servlet.ServletContainer");
        servlet.addInitParameter("com.sun.jersey.config.property.packages", "com.orocube.oropos.rest.service");
        context.addServletMappingDecoded("/service/*", "rest-ws");
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName("rest-filter");
        filterDef.setFilterClass("com.orocube.oropos.rest.filter.UserRequestServletFilter");
        context.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName("rest-filter");
        filterMap.addURLPattern("/service/*");
        context.addFilterMap(filterMap);
        HttpServlet emptyServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                PrintWriter writer = resp.getWriter();
                writer.println("<html><title>OROPOS Mobile</title><body>");
                writer.println("<h1>Server running!</h1>");
                writer.println("</body></html>");
            }
        };
        String servletName = "Servlet1";
        this.tomcat.addServlet(contextPath, servletName, (Servlet)emptyServlet);
        context.addServletMappingDecoded(contextPath, servletName);
        PosLog.debug(EmbeddedTomcatImpl.class, (String)("Starting tomcat in: " + new File(this.tomcat.getHost().getAppBase()).getAbsolutePath()));
    }

    public void stopServer() {
        try {
            if (this.isRunning()) {
                this.tomcat.stop();
                this.tomcat.destroy();
                this.fireTomcatServerStopped("");
                if (this.updatableView != null) {
                    this.updatableView.updateView();
                }
            }
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
    }

    public String getApplicationUrl(String appName) {
        return String.format("http://%s:%d/%s", this.tomcat.getHost().getName(), this.tomcat.getConnector().getLocalPort(), appName);
    }

    public boolean isRunning() {
        String hostAddress = StoreUtil.getEmbdedServerHostAddress((Store)DataProvider.get().getStore());
        String portNo = GlobalConfigDAO.getInstance().getValueByKey("data_service.port");
        String requestPath = "http://" + hostAddress + ":" + portNo + "/";
        try {
            URL url = new URL(requestPath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(1000);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public boolean isNetAvailable() {
        return !LOCALHOST.equals(this.getHostAddress());
    }

    public String getHostAddress() {
        try {
            AtomicReference address = new AtomicReference();
            ArrayList<NetworkInterface> netInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            netInterfaces.forEach(nif -> {
                try {
                    if (nif.isUp() && !nif.isLoopback()) {
                        nif.getInterfaceAddresses().forEach(t -> {
                            InetAddress inetAddress = t.getAddress();
                            if (inetAddress instanceof Inet4Address) {
                                address.set(inetAddress);
                            }
                        });
                    }
                }
                catch (SocketException e1) {
                    PosLog.error(EmbeddedTomcatImpl.class, (Exception)e1);
                }
            });
            InetAddress localHost = address.get() == null ? InetAddress.getLocalHost() : (InetAddress)address.get();
            String hostAddress = localHost.getHostAddress();
            if (LOCALHOST.equals(hostAddress)) {
                throw new PosException("IP address could not be determind");
            }
            return hostAddress;
        }
        catch (Exception e) {
            throw new PosException("IP address could not be determind");
        }
    }

    public void setUpdatableViewListener(UpdatableView updatableView) {
        this.updatableView = updatableView;
    }

    public void addTomcatServerListener(TomcatServerListener serverListener) {
        this.tomcatServerListener.add(serverListener);
    }

    private void fireTomcatServerStopped(String errorMessage) {
        for (TomcatServerListener tomcatServerListener : this.tomcatServerListener) {
            tomcatServerListener.tomcatServerStopped(errorMessage);
        }
    }

    private void fireTomcatServerStarted() {
        for (TomcatServerListener tomcatServerListener : this.tomcatServerListener) {
            tomcatServerListener.tomcatServerStarted();
        }
    }

    private void saveDataServiceInfo() {
        Store store = DataProvider.get().getStore();
        String currentHostAddress = "";
        try {
            currentHostAddress = this.getHostAddress();
            String storeHostAddress = StoreUtil.getEmbdedServerHostAddress((Store)store);
            if (!currentHostAddress.equals(storeHostAddress)) {
                StoreUtil.setEmbdedServerHostAddress((Store)store, (String)currentHostAddress);
            }
        }
        catch (Exception e) {
            StoreUtil.setEmbdedServerHostAddress((Store)store, (String)"");
        }
        StoreDAO.getInstance().saveOrUpdate(store);
        DataProvider.get().refreshStore();
    }
}

