/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.oropos.rest.service;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketSource;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.CashBreakdownDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CookingInstructionDAO;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DeclaredTipsDAO;
import com.floreantpos.model.dao.DeliveryAddressDAO;
import com.floreantpos.model.dao.DeliveryChargeDAO;
import com.floreantpos.model.dao.DeliveryInstructionDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.GratuityPaymentHistoryDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.InventoryClosingBalanceDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.InventoryStockUnitDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PackagingUnitDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.PizzaPriceDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopFloorTemplateDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.dao.StockCountDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import com.floreantpos.util.XMLTransientUtil;
import com.google.gson.ExclusionStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.orocube.oropos.rest.RestServiceMessages;
import com.orocube.oropos.rest.server.util.EmbeddedTomcatFactory;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="data")
public class ClientDataService {
    protected static Map<String, String> storeLockMap = new HashMap<String, String>();
    protected static final SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SSSZ");
    protected static final String JSON_DATA = "data_json";

    @GET
    @Path(value="store/{store_id}/isEmpty")
    @Produces(value={"application/json"})
    public boolean getEmpty(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        int rowCount = TerminalDAO.getInstance().rowCount(OrderType.class, null);
        if (rowCount > 0) {
            return false;
        }
        rowCount = TerminalDAO.getInstance().rowCount(MenuItem.class, null);
        return rowCount <= 0;
    }

    @GET
    @Path(value="stopDataServer")
    @Produces(value={"application/json"})
    public void stopDataServer(@Context HttpServletRequest request) {
        EmbeddedTomcatFactory.getEmbeddedTomcat().stopServer();
    }

    @GET
    @Path(value="store/{store_id}/ServerTimeZone")
    @Produces(value={"application/json"})
    public String getServerTimeZone(@Context HttpServletRequest request) {
        return TimeZone.getDefault().getID();
    }

    @GET
    @Path(value="store/{store_id}/item_price")
    @Produces(value={"application/json"})
    public Double getItemPrice(@Context HttpServletRequest request) {
        String menuItemId = request.getParameter("menu_item_id");
        String orderTypeId = request.getParameter("order_type_id");
        String departmentId = request.getParameter("department_id");
        String salesAreaId = request.getParameter("sales_area_id");
        String customerId = request.getParameter("customer_id");
        String unitUniqueCode = request.getParameter("unit_unique_code");
        MenuItem menuItem = null;
        if (StringUtils.isNotBlank((String)menuItemId)) {
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItemId);
        }
        OrderType orderType = null;
        if (StringUtils.isNotBlank((String)orderTypeId)) {
            orderType = OrderTypeDAO.getInstance().get(orderTypeId);
        }
        Department department = null;
        if (StringUtils.isNotBlank((String)departmentId)) {
            department = DepartmentDAO.getInstance().get(departmentId);
        }
        SalesArea salesArea = null;
        if (StringUtils.isNotBlank((String)salesAreaId)) {
            salesArea = SalesAreaDAO.getInstance().get(salesAreaId);
        }
        Customer customer = null;
        if (StringUtils.isNotBlank((String)customerId)) {
            customer = CustomerDAO.getInstance().get(customerId);
        }
        Double priceFromPriceRule = PriceRuleDAO.getInstance().getPrice(menuItem, null, orderType, department, salesArea, customer, unitUniqueCode);
        return priceFromPriceRule;
    }

    @GET
    @Path(value="store/{store_id}/currentTime")
    @Produces(value={"application/json"})
    public String getCurrentTime(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return formatter.format(new Date());
    }

    @GET
    @Path(value="store/{store_id}/lastUpdateTime")
    @Produces(value={"application/json"})
    public String getLastUpdateTime(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String outletId = this.getClientOutletId(request, storeId);
        Date lastUpdateTime = TerminalDAO.getInstance().getLastUpdateTime(outletId);
        if (lastUpdateTime == null) {
            return null;
        }
        return formatter.format(lastUpdateTime);
    }

    @GET
    @Path(value="store/{store_id}/store")
    @Produces(value={"application/json"})
    public List getStore(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List dataList = this.findAll(request, Store.class, storeId);
        return dataList;
    }

    protected String getClientOutletId(HttpServletRequest request, String storeId) {
        return "";
    }

    @GET
    @Path(value="store/{store_id}/outlet")
    @Produces(value={"application/json"})
    public List getOutlets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List outlets = this.findAll(request, Outlet.class, storeId);
        if (outlets != null && outlets.size() > 0) {
            for (Outlet outlet : outlets) {
                this.removeBlankOutletProperties(outlet);
                outlet.setDepartments(null);
                outlet.setProperties(null);
            }
        }
        return outlets;
    }

    private void removeBlankOutletProperties(Outlet outlet) {
        Set outletProperties = outlet.getPropertyStore().keySet();
        if (outletProperties == null || outletProperties.size() == 0) {
            return;
        }
        ArrayList<String> emptyProperties = new ArrayList<String>();
        for (String key : outletProperties) {
            try {
                String value = outlet.getProperty(key);
                if (value != null) continue;
                emptyProperties.add(key);
            }
            catch (UnsupportedOperationException e) {
                emptyProperties.add(key);
            }
        }
        for (String key : emptyProperties) {
            outlet.removeProperty(key);
        }
    }

    @GET
    @Path(value="store/{store_id}/ordertype")
    @Produces(value={"application/json"})
    public List getOrderTypes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List orderTypeList = this.findAll(request, OrderType.class, storeId);
        if (orderTypeList != null && orderTypeList.size() > 0) {
            for (OrderType orderType : orderTypeList) {
                OrderTypeDAO.getInstance().initialize(orderType);
                XMLTransientUtil.makeLazy((OrderType)orderType);
            }
        }
        return orderTypeList;
    }

    @GET
    @Path(value="store/{store_id}/kitchenTickets")
    @Produces(value={"application/json"})
    public List getKitchenTickets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        Date date = this.getLastUpdateDate(request);
        List kitchenTickets = KitchenTicketDAO.getInstance().findAllOpen(date);
        if (kitchenTickets != null && kitchenTickets.size() > 0) {
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                List items = kitchenTicket.getTicketItems();
                if (items == null || items.size() <= 0) continue;
                for (KitchenTicketItem item : items) {
                    item.setKitchenTicket(null);
                }
            }
        }
        return kitchenTickets;
    }

    @GET
    @Path(value="store/{store_id}/ticket/{ticket_id}")
    @Produces(value={"application/json"})
    public Ticket getTicketById(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="ticket_id") String ticketId) {
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(ticketId);
        if (ticket != null) {
            XMLTransientUtil.makeXMLTransient((Ticket)ticket);
        }
        return ticket;
    }

    @GET
    @Path(value="store/{store_id}/userpermission")
    @Produces(value={"application/json"})
    public List getUserPermissions(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, UserPermission.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/usertype")
    @Produces(value={"application/json"})
    public List getUserTypes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, UserType.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/user")
    @Produces(value={"application/json"})
    public List getUsers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            List users = this.findAll(request, User.class, storeId, this.getClientOutletId(request, storeId));
            if (users != null && users.size() > 0) {
                for (User user : users) {
                    String parentUserId;
                    user.setLinkedUser(null);
                    if (user.isRoot().booleanValue() || (parentUserId = user.getParentUserId()) == null) continue;
                    user.setParentUser(null);
                    user.setParentUserId(parentUserId);
                }
            }
            return users;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            throw e;
        }
    }

    @Deprecated
    @GET
    @Path(value="store/{store_id}/mobileUsers")
    @Produces(value={"application/json"})
    public List getFilteredUsers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List users = this.findAll(request, User.class, storeId);
        for (User user : users) {
            String passwordAsPlainText = user.getPasswordAsPlainText();
            if (!StringUtils.isNotEmpty((String)passwordAsPlainText)) continue;
            user.setPassword(Base64.getEncoder().withoutPadding().encodeToString(passwordAsPlainText.getBytes(StandardCharsets.UTF_8)));
        }
        return users;
    }

    @GET
    @Path(value="store/{store_id}/currency")
    @Produces(value={"application/json"})
    public List getCurrencies(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, Currency.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/shift")
    @Produces(value={"application/json"})
    public List getShifts(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, Shift.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/address")
    @Produces(value={"application/json"})
    public List getAddressList(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, Address.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/attendencehistory")
    @Produces(value={"application/json"})
    public List getAttendenceHistoryList(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, AttendenceHistory.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/terminal/{terminal_key}")
    @Produces(value={"application/json"})
    public Terminal getTerminal(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="terminal_key") String terminalKey) {
        Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(terminalKey);
        if (terminal != null) {
            terminal.setProperties(null);
        }
        return terminal;
    }

    @GET
    @Path(value="store/{store_id}/address/{address_id}")
    @Produces(value={"application/json"})
    public List getAddress(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="address_id") String addressId) {
        Address address = AddressDAO.getInstance().get(addressId);
        if (address == null) {
            return null;
        }
        return Arrays.asList(address);
    }

    @GET
    @Path(value="store/{store_id}/taxGroup/{tax_group_id}")
    @Produces(value={"application/json"})
    public List getTaxGroup(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="tax_group_id") String taxGroupId) {
        TaxGroup taxGroup = TaxGroupDAO.getInstance().get(taxGroupId);
        if (taxGroup == null) {
            return new ArrayList();
        }
        return Arrays.asList(taxGroup);
    }

    @GET
    @Path(value="store/{store_id}/imageResource/{image_resource_id}")
    @Produces(value={"application/json"})
    public ImageResource getImageResource(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="image_resource_id") String imageResourceId) {
        return ImageResourceDAO.getInstance().findById(imageResourceId);
    }

    @GET
    @Path(value="store/{store_id}/salesarea")
    @Produces(value={"application/json"})
    public List getSalesArea(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, SalesArea.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/cronJob")
    @Produces(value={"application/json"})
    public List getCronJobs(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, CronJob.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/reportGroup")
    @Produces(value={"application/json"})
    public List getReportGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, ReportGroup.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/printerGroup")
    @Produces(value={"application/json"})
    public List getPrinterGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, PrinterGroup.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/printer")
    @Produces(value={"application/json"})
    public List getVirtualPrinters(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, VirtualPrinter.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/actionHistory")
    @Produces(value={"application/json"})
    public List getActionHistories(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List actionHistories = this.findAll(request, ActionHistory.class, storeId, this.getClientOutletId(request, storeId));
        if (actionHistories != null && actionHistories.size() > 0) {
            for (ActionHistory history : actionHistories) {
                if (history.getPerformer() == null) continue;
                XMLTransientUtil.makeXMLTransient((User)history.getPerformer());
            }
        }
        return actionHistories;
    }

    @GET
    @Path(value="store/{store_id}/recipe")
    @Produces(value={"application/json"})
    public List getRecipes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List recipes = this.findAll(request, Recepie.class, storeId);
        for (Recepie recipe : recipes) {
            XMLTransientUtil.makeLazy((Recepie)recipe);
        }
        return recipes;
    }

    @GET
    @Path(value="store/{store_id}/purchaseOrder")
    @Produces(value={"application/json"})
    public List getPurchaseOrders(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List recipes = this.findAll(request, PurchaseOrder.class, storeId, this.getClientOutletId(request, storeId));
        for (PurchaseOrder purchaseOrder : recipes) {
            XMLTransientUtil.makeLazy((PurchaseOrder)purchaseOrder);
        }
        return recipes;
    }

    @GET
    @Path(value="store/{store_id}/stockCount")
    @Produces(value={"application/json"})
    public List getStockCounts(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List recipes = this.findAll(request, StockCount.class, storeId, this.getClientOutletId(request, storeId));
        for (StockCount stockCount : recipes) {
            XMLTransientUtil.makeLazy((StockCount)stockCount);
        }
        return recipes;
    }

    @GET
    @Path(value="store/{store_id}/department")
    @Produces(value={"application/json"})
    public List getDeparments(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List departments = this.findAll(request, Department.class, storeId);
        if (departments != null) {
            for (Department department : departments) {
                try (Session session = DepartmentDAO.getInstance().createNewSession();){
                    session.refresh((Object)department);
                    Hibernate.initialize((Object)department.getOutlets());
                    Hibernate.initialize((Object)department.getOrderTypes());
                }
                XMLTransientUtil.makeLazy((Department)department);
            }
        }
        return departments;
    }

    @GET
    @Path(value="store/{store_id}/terminaltype")
    @Produces(value={"application/json"})
    public List getTerminalTypes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List terminalTypes = this.findAll(request, TerminalType.class, storeId, this.getClientOutletId(request, storeId));
        if (terminalTypes != null && terminalTypes.size() > 0) {
            for (TerminalType terminalType : terminalTypes) {
                TerminalTypeDAO.getInstance().initialize(terminalType);
                XMLTransientUtil.makeLazy((TerminalType)terminalType);
            }
        }
        return terminalTypes;
    }

    @GET
    @Path(value="store/{store_id}/terminal")
    @Produces(value={"application/json"})
    public List getTerminals(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List terminals = this.findAll(request, Terminal.class, storeId, this.getClientOutletId(request, storeId));
        for (Terminal terminal : terminals) {
            terminal.setProperties(null);
        }
        return terminals;
    }

    @GET
    @Path(value="store/{store_id}/tax")
    @Produces(value={"application/json"})
    public List getTaxes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, Tax.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/slideShowImage")
    @Produces(value={"application/json"})
    public List getSlideShowImages(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, SlideShowImage.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/taxgroup")
    @Produces(value={"application/json"})
    public List getTaxGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, TaxGroup.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/shopfloor")
    @Produces(value={"application/json"})
    public List getFloors(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List floors = this.findAll(request, ShopFloor.class, storeId);
        if (floors != null && floors.size() > 0) {
            for (ShopFloor shopFloor : floors) {
                XMLTransientUtil.makeXMLTransient((ShopFloor)shopFloor);
            }
        }
        return floors;
    }

    @GET
    @Path(value="store/{store_id}/inventoryUnit")
    @Produces(value={"application/json"})
    public List getInventoryUnits(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List inventoryUnits = this.findAll(request, InventoryUnit.class, storeId);
        return inventoryUnits;
    }

    @GET
    @Path(value="store/{store_id}/packagingUnit")
    @Produces(value={"application/json"})
    public List getPackagingUnits(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List packagingUnits = this.findAll(request, PackagingUnit.class, storeId);
        return packagingUnits;
    }

    @GET
    @Path(value="store/{store_id}/inventoryUnitGroup")
    @Produces(value={"application/json"})
    public List getInventoryUnitGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, InventoryUnitGroup.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/inventoryLocation")
    @Produces(value={"application/json"})
    public List getInventoryLocations(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List locations = this.findAll(request, InventoryLocation.class, storeId);
        if (locations != null && locations.size() > 0) {
            ArrayList<String> outletLocationIds = new ArrayList<String>();
            String outletId = this.getClientOutletId(request, storeId);
            Iterator iterator = locations.iterator();
            while (iterator.hasNext()) {
                InventoryLocation location = (InventoryLocation)iterator.next();
                if (!outletId.equals(location.getOutletId())) {
                    if (outletLocationIds.contains(location.getId())) {
                        iterator.remove();
                        continue;
                    }
                    location.setDeleted(Boolean.valueOf(true));
                    continue;
                }
                outletLocationIds.add(location.getId());
            }
        }
        return locations;
    }

    @GET
    @Path(value="store/{store_id}/shoptable")
    @Produces(value={"application/json"})
    public List getShopTables(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List shopTables = this.findAll(request, ShopTable.class, storeId, this.getClientOutletId(request, storeId));
        if (shopTables != null && shopTables.size() > 0) {
            for (ShopTable table : shopTables) {
                XMLTransientUtil.makeXMLTransient((ShopTable)table);
            }
        }
        return shopTables;
    }

    @GET
    @Path(value="store/{store_id}/shopTableType")
    @Produces(value={"application/json"})
    public List getShopTableTypes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, ShopTableType.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/shopTableStatus")
    @Produces(value={"application/json"})
    public List getShopTableStatus(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, ShopTableStatus.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/shopTableTickets/{shop_table_id}")
    @Produces(value={"application/json"})
    public List getShopTableTickets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="shop_table_id") Integer shopTableId) {
        if (shopTableId == null) {
            return null;
        }
        ShopTableStatus status = ShopTableStatusDAO.getInstance().get(shopTableId);
        List openTickets = ShopTableStatusDAO.getInstance().findOpenTickets(status);
        this.initializeTicket(openTickets);
        return openTickets;
    }

    @GET
    @Path(value="store/{store_id}/cashBreakdown")
    @Produces(value={"application/json"})
    public List getCashBreakdown(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, CashBreakdown.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/combogroup")
    @Produces(value={"application/json"})
    public List getComboGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, ComboGroup.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/MenuCategory")
    @Produces(value={"application/json"})
    public List getMenuCategories(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List categories = this.findAll(request, MenuCategory.class, storeId);
        if (categories != null && categories.size() > 0) {
            String outletId = this.getClientOutletId(request, storeId);
            for (MenuCategory c : categories) {
                c = MenuCategoryDAO.getInstance().initialize(c);
                Set menuShifts = c.getMenuShifts();
                if (menuShifts != null && menuShifts.size() > 0) {
                    Iterator iterator2 = menuShifts.iterator();
                    while (iterator2.hasNext()) {
                        MenuShift menuShift = (MenuShift)iterator2.next();
                        if (menuShift.getOutletId() == null || menuShift.getOutletId().equals(outletId)) continue;
                        iterator2.remove();
                    }
                }
                XMLTransientUtil.makeXMLTransientCollection((MenuCategory)c);
            }
        }
        return categories;
    }

    @GET
    @Path(value="store/{store_id}/MenuGroup")
    @Produces(value={"application/json"})
    public List getMenuGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, MenuGroup.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/menuItem/{menu_item_id}")
    @Produces(value={"application/json"})
    public List<MenuItem> getMenuItems(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="menu_item_id") String menuItemId) {
        HashSet dataList = new HashSet();
        List menuItemsById = MenuItemDAO.getInstance().findMenuItemsById(menuItemId);
        for (MenuItem menuItem : menuItemsById) {
            List items = XMLTransientUtil.makeXMLTransientMenuItem((MenuItem)menuItem);
            if (items == null || items.size() <= 0) continue;
            dataList.addAll(items);
        }
        return new ArrayList<MenuItem>(dataList);
    }

    @GET
    @Path(value="store/{store_id}/MenuItemSize")
    @Produces(value={"application/json"})
    public List getMenuItemSizes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, MenuItemSize.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/MenuItem")
    @Produces(value={"application/json"})
    public List<MenuItem> getMenuItems(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List dataList = this.getSyncableMenuItems(request, storeId);
        for (MenuItem menuItem : dataList) {
            XMLTransientUtil.makeTransientCommonMenuItem((MenuItem)menuItem);
            if (!menuItem.isHasVariant().booleanValue() || menuItem.getParentMenuItemId() == null) continue;
            PosLog.info(this.getClass(), (String)String.format("Store id: %s>> Menu item: %s %s has variant %s but parent menu item id %s which is not valid.", storeId, menuItem.getId(), menuItem.getName(), menuItem.isHasVariant(), menuItem.getParentMenuItemId()));
            menuItem.setParentMenuItemId(null);
        }
        return dataList;
    }

    @GET
    @Path(value="store/{store_id}/ImageResourceIds")
    @Produces(value={"application/json"})
    public List<String> getImageResourceIds(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        Date lastUpdateTime = this.getLastUpdateDate(request);
        return ImageResourceDAO.getInstance().getImageResourceIds(lastUpdateTime);
    }

    @GET
    @Path(value="store/{store_id}/ImageResource")
    @Produces(value={"application/json"})
    public Map<String, String> getImageResources(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List imageResources = this.findAll(request, ImageResource.class, storeId);
        if (imageResources == null || imageResources.isEmpty()) {
            return null;
        }
        HashMap<String, String> encodedImageDataMap = new HashMap<String, String>();
        for (ImageResource imageResource : imageResources) {
            byte[] imageData = ServiceUtils.convertImageResourceToByteArray((ImageResource)imageResource);
            if (imageData == null) continue;
            encodedImageDataMap.put(imageResource.getId(), new String(imageData));
        }
        return encodedImageDataMap;
    }

    @GET
    @Path(value="store/{store_id}/imageResources")
    @Produces(value={"application/json"})
    public List getAllImageResources(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, ImageResource.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/ImageResource/{image_id}")
    @Produces(value={"application/json"})
    public Map<String, String> getImageResources(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, @PathParam(value="image_id") String imageId) {
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(imageId);
        if (imageResource == null) {
            return null;
        }
        HashMap<String, String> encodedImageDataMap = new HashMap<String, String>();
        byte[] imageData = ServiceUtils.convertImageResourceToByteArray((ImageResource)imageResource);
        if (imageData != null) {
            encodedImageDataMap.put(imageResource.getId(), new String(imageData));
        }
        return encodedImageDataMap;
    }

    @GET
    @Path(value="store/{store_id}/ModifierGroup")
    @Produces(value={"application/json"})
    public List getModifierGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List modifierGroups = this.findAll(request, ModifierGroup.class, storeId);
        if (modifierGroups != null) {
            for (ModifierGroup modifierGroup : modifierGroups) {
                XMLTransientUtil.makeXMLTransient((ModifierGroup)modifierGroup);
            }
        }
        return modifierGroups;
    }

    @GET
    @Path(value="store/{store_id}/MenuModifier")
    @Produces(value={"application/json"})
    public List getMenuModifiers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List modifiers = this.findAll(request, MenuModifier.class, storeId);
        if (modifiers != null && modifiers.size() > 0) {
            for (MenuModifier modifier : modifiers) {
                XMLTransientUtil.makeXMLTransient((MenuModifier)modifier);
                this.removeDuplicatePizzaModifierPriceIfNeeded(modifier.getPizzaModifierPriceList());
            }
        }
        return modifiers;
    }

    private void removeDuplicatePizzaModifierPriceIfNeeded(List<PizzaModifierPrice> pizzaModifierPriceList) {
        if (pizzaModifierPriceList == null || pizzaModifierPriceList.isEmpty()) {
            return;
        }
        List modifierPriceList = pizzaModifierPriceList.stream().distinct().collect(Collectors.toList());
        pizzaModifierPriceList.clear();
        pizzaModifierPriceList.addAll(modifierPriceList);
    }

    @GET
    @Path(value="store/{store_id}/cookingInstruction")
    @Produces(value={"application/json"})
    public List getCookingInstructions(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, CookingInstruction.class, storeId);
    }

    @Deprecated
    @GET
    @Path(value="store/{store_id}/deletedData")
    @Produces(value={"application/json"})
    public List getDeletedData(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return null;
    }

    @GET
    @Path(value="store/{store_id}/voidReason")
    @Produces(value={"application/json"})
    public List getVoidReasons(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, VoidReason.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/voidItem")
    @Produces(value={"application/json"})
    public List getVoidItems(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, VoidItem.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/courses")
    @Produces(value={"application/json"})
    public List getCourses(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, Course.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/CustomerGroup")
    @Produces(value={"application/json"})
    public List getCustomerGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List customerGroupList = this.findAll(request, CustomerGroup.class, storeId);
        for (CustomerGroup customerGroup : customerGroupList) {
            XMLTransientUtil.makeXMLTransient((CustomerGroup)customerGroup);
        }
        return customerGroupList;
    }

    @GET
    @Path(value="store/{store_id}/CustomPayment")
    @Produces(value={"application/json"})
    public List getCustomPayment(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, CustomPayment.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/DeclaredTips")
    @Produces(value={"application/json"})
    public List getDeclaredTips(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, DeclaredTips.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/MenuPage")
    @Produces(value={"application/json"})
    public List getMenuPages(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List menuPageList = this.findAll(request, MenuPage.class, storeId, this.getClientOutletId(request, storeId));
        for (MenuPage menuPage : menuPageList) {
            XMLTransientUtil.makeXMLTransient((MenuPage)menuPage);
        }
        return menuPageList;
    }

    @GET
    @Path(value="store/{store_id}/PizzaPrice")
    @Produces(value={"application/json"})
    public List getPizzaPrices(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, PizzaPrice.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/PizzaCrust")
    @Produces(value={"application/json"})
    public List getPizzaCrusts(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, PizzaCrust.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/MenuItemModifierPage")
    @Produces(value={"application/json"})
    public List getMenuItemModifierPage(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List menuItemModifierSpecList = this.findAll(request, MenuItemModifierPage.class, storeId);
        for (MenuItemModifierPage page : menuItemModifierSpecList) {
            XMLTransientUtil.makeXMLTransient((MenuItemModifierPage)page);
        }
        return menuItemModifierSpecList;
    }

    @GET
    @Path(value="store/{store_id}/MenuItemModifierSpec")
    @Produces(value={"application/json"})
    public List getMenuItemModifierSpecs(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List menuItemModifierSpecList = this.findAll(request, MenuItemModifierSpec.class, storeId);
        for (MenuItemModifierSpec spec : menuItemModifierSpecList) {
            XMLTransientUtil.makeXMLTransientSpec((MenuItemModifierSpec)spec);
        }
        return menuItemModifierSpecList;
    }

    @GET
    @Path(value="store/{store_id}/Multiplier")
    @Produces(value={"application/json"})
    public List getMultipliers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, Multiplier.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/DeliveryInstruction")
    @Produces(value={"application/json"})
    public List getDeliveryInstructions(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, DeliveryInstruction.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/GratuityPaymentHistory")
    @Produces(value={"application/json"})
    public List getGratuityPaymentHistory(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List gratuityPaymentHistoryList = this.findAll(request, GratuityPaymentHistory.class, storeId, this.getClientOutletId(request, storeId));
        for (GratuityPaymentHistory gPaymentHistory : gratuityPaymentHistoryList) {
            XMLTransientUtil.makeXMLTransient((GratuityPaymentHistory)gPaymentHistory);
        }
        return gratuityPaymentHistoryList;
    }

    @GET
    @Path(value="store/{store_id}/GiftCard")
    @Produces(value={"application/json"})
    public List getGiftCard(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, GiftCard.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/Gratuity")
    @Produces(value={"application/json"})
    public List getGratuity(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, Gratuity.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/Discount")
    @Produces(value={"application/json"})
    public List getDiscount(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List discounts = this.findAll(request, Discount.class, storeId, this.getClientOutletId(request, storeId));
        if (discounts != null && discounts.size() > 0) {
            for (Discount discount : discounts) {
                XMLTransientUtil.makeLazy((Discount)discount);
            }
        }
        return discounts;
    }

    @GET
    @Path(value="store/{store_id}/DeliveryCharge")
    @Produces(value={"application/json"})
    public List getDeliveryCharge(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, DeliveryCharge.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/DeliveryAddress")
    @Produces(value={"application/json"})
    public List getDeliveryAddress(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List deliveryAddressList = this.findAll(request, DeliveryAddress.class, storeId);
        for (DeliveryAddress address : deliveryAddressList) {
            String customerId = address.getCustomerId();
            address.setCustomer(null);
            address.setCustomerId(customerId);
        }
        return deliveryAddressList;
    }

    @GET
    @Path(value="store/{store_id}/cashDrawer")
    @Produces(value={"application/json"})
    public List getCashDrawers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        if (StringUtils.isEmpty((String)request.getParameter("ids"))) {
            return this.findAll(request, CashDrawer.class, storeId, this.getClientOutletId(request, storeId));
        }
        JSONArray ids = new JSONArray(request.getParameter("ids"));
        ArrayList<CashDrawer> cashDrawers = new ArrayList<CashDrawer>();
        if (ids != null && ids.length() > 0) {
            for (int i = 0; i < ids.length(); ++i) {
                CashDrawer cashDrawer = CashDrawerDAO.getInstance().get(ids.getString(i));
                if (cashDrawer == null) continue;
                cashDrawers.add(cashDrawer);
            }
        }
        return cashDrawers;
    }

    @GET
    @Path(value="store/{store_id}/customer")
    @Produces(value={"application/json"})
    public List getCustomers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List customers = this.findAll(request, Customer.class, storeId);
        if (customers != null && customers.size() > 0) {
            for (Customer customer : customers) {
                CustomerDAO.getInstance().initialize(customer);
            }
        }
        return customers;
    }

    @GET
    @Path(value="store/{store_id}/balanceUpdateTransactions")
    @Produces(value={"application/json"})
    public List getBalanceUpdateTransactions(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, BalanceUpdateTransaction.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/attribute")
    @Produces(value={"application/json"})
    public List getAttributes(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List attributeList = this.findAll(request, Attribute.class, storeId);
        for (Attribute attribute : attributeList) {
            AttributeGroup group = attribute.getGroup();
            if (group == null) continue;
            group.setAttributes(null);
        }
        return attributeList;
    }

    @GET
    @Path(value="store/{store_id}/attributegroup")
    @Produces(value={"application/json"})
    public List getAttributeGroups(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List attributeGroupList = this.findAll(request, AttributeGroup.class, storeId);
        for (AttributeGroup attributeGroup : attributeGroupList) {
            attributeGroup.setAttributes(null);
        }
        return attributeGroupList;
    }

    @GET
    @Path(value="store/{store_id}/PriceRule")
    @Produces(value={"application/json"})
    public List getPriceRules(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, PriceRule.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/PriceTable")
    @Produces(value={"application/json"})
    public List getPriceList1(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List priceTable = this.findAll(request, PriceTable.class, storeId, this.getClientOutletId(request, storeId), Restrictions.not((Criterion)Restrictions.ilike((String)PriceTable.PROP_ID, (String)"menugreat_online", (MatchMode)MatchMode.START)));
        for (PriceTable item : priceTable) {
            item.setPriceTableItems(PriceTableItemDAO.getInstance().getItemsByPriceTable(item));
        }
        return priceTable;
    }

    @GET
    @Path(value="store/{store_id}/PriceShift")
    @Produces(value={"application/json"})
    public List getPriceShifts(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, PriceShift.class, storeId, this.getClientOutletId(request, storeId));
    }

    @POST
    @Path(value="store/{store_id}/sync/count")
    public List<DataSyncInfo> getDataUpdateInfo(List<DataSyncInfo> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            if (dataList == null || dataList.isEmpty()) {
                return null;
            }
            ArrayList<DataSyncInfo> updatedDataList = new ArrayList<DataSyncInfo>();
            for (DataSyncInfo dataUpdateInfo : dataList) {
                Class beanClass = dataUpdateInfo.getBeanClass();
                if (beanClass == null) continue;
                Criterion restriction = null;
                if (beanClass == PriceTable.class) {
                    restriction = Restrictions.not((Criterion)Restrictions.ilike((String)PriceTable.PROP_ID, (String)"menugreat_online", (MatchMode)MatchMode.START));
                }
                if (beanClass == PosTransaction.class) {
                    restriction = Restrictions.isNull((String)PosTransaction.PROP_TICKET);
                }
                dataUpdateInfo.setRowCount(Integer.valueOf(TerminalDAO.getInstance().rowCount(beanClass, dataUpdateInfo.getLastUpdateTime(), dataUpdateInfo.getOutletId(), restriction)));
                if (dataUpdateInfo.getRowCount() <= 0) continue;
                GenericDAO.getInstance().updateLastUpdateTimeIfNull(dataUpdateInfo.getRef());
                updatedDataList.add(dataUpdateInfo);
            }
            return updatedDataList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            return null;
        }
    }

    @GET
    @Path(value="store/{store_id}/menugreatOrders/count")
    @Produces(value={"application/json"})
    public Integer getMenugreatOrdersCount(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            int rowCount = TerminalDAO.getInstance().rowCount(Ticket.class, this.getLastUpdateDate(request), this.getClientOutletId(request, storeId), (Criterion)Restrictions.eq((String)Ticket.PROP_SOURCE, (Object)TicketSource.Online.name()));
            if (rowCount > 0) {
                GenericDAO.getInstance().updateLastUpdateTimeIfNull(Ticket.REF);
            }
            return rowCount;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            throw e;
        }
    }

    @POST
    @Path(value="store/{store_id}/data/count")
    @Produces(value={"application/json"})
    public List<DataSyncInfo> getDataUpdateInfoForAndroid(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, MultivaluedMap<String, String> map) {
        try {
            Map params = request.getParameterMap();
            String source = ((String[])params.get("request"))[0];
            JSONObject rootElement = new JSONObject(source);
            JSONArray dataArray = rootElement.getJSONArray("data");
            ArrayList<DataSyncInfo> dataList = new ArrayList<DataSyncInfo>();
            for (int i = 0; i < dataArray.length(); ++i) {
                JSONObject json = dataArray.getJSONObject(i);
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
                DataSyncInfo dataSyncInfo = (DataSyncInfo)gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(new Class[]{MenuShift.class})}).create().fromJson(json.toString(), DataSyncInfo.class);
                if (dataSyncInfo == null) continue;
                dataList.add(dataSyncInfo);
            }
            if (dataList == null || dataList.isEmpty()) {
                return null;
            }
            ArrayList<DataSyncInfo> updatedDataList = new ArrayList<DataSyncInfo>();
            for (DataSyncInfo dataUpdateInfo : dataList) {
                Class<?> beanClass = Class.forName(dataUpdateInfo.getClass().getPackage().getName() + "." + dataUpdateInfo.getRef());
                if (beanClass == null) continue;
                dataUpdateInfo.setRowCount(Integer.valueOf(TerminalDAO.getInstance().rowCount(beanClass, dataUpdateInfo.getLastUpdateTime())));
                if (dataUpdateInfo.getRowCount() <= 0) continue;
                GenericDAO.getInstance().updateLastUpdateTimeIfNull(dataUpdateInfo.getRef());
                updatedDataList.add(dataUpdateInfo);
            }
            return updatedDataList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            return null;
        }
    }

    @GET
    @Path(value="store/{store_id}/inventoryVendor")
    @Produces(value={"application/json"})
    public List getVendors(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, InventoryVendor.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/inventoryVendorItem")
    @Produces(value={"application/json"})
    public List getVendorItems(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List inventoryVendor = this.findAll(request, InventoryVendorItems.class, storeId);
        for (InventoryVendorItems item : inventoryVendor) {
            XMLTransientUtil.makeXMLTransientMenuItem((MenuItem)item.getItem());
        }
        return inventoryVendor;
    }

    @GET
    @Path(value="store/{store_id}/inventorylocation")
    @Produces(value={"application/json"})
    public List getLocations(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List locations = this.findAll(request, InventoryLocation.class, storeId);
        if (locations != null && locations.size() > 0) {
            String outletId = this.getClientOutletId(request, storeId);
            for (InventoryLocation location : locations) {
                if (outletId.equals(location.getOutletId())) continue;
                location.setId(location.getId() + "_" + location.getOutletId());
                location.setDeleted(Boolean.valueOf(true));
            }
        }
        return locations;
    }

    @GET
    @Path(value="store/{store_id}/inventoryTransaction")
    @Produces(value={"application/json"})
    public List getInventoryTrans(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List inventoryTransactionList = this.findAll(request, InventoryTransaction.class, storeId, this.getClientOutletId(request, storeId));
        String clientOutletId = this.getClientOutletId(request, storeId);
        for (InventoryTransaction item : inventoryTransactionList) {
            XMLTransientUtil.makeXMLTransient((InventoryTransaction)item);
            this.updateLocationIdForDiffOutlet(item, clientOutletId);
        }
        return inventoryTransactionList;
    }

    private void updateLocationIdForDiffOutlet(InventoryTransaction tran, String clientOutletId) {
        if (tran.getReason() == null || !tran.getReason().equalsIgnoreCase("TRANSFER")) {
            return;
        }
    }

    private void revertLocationIdForDiffOutlet(InventoryTransaction item, String clientOutletId) {
        if (item.getReason() == null) {
            return;
        }
        if (!item.getReason().equalsIgnoreCase("TRANSFER")) {
            return;
        }
        try {
            item.setFromLocationId(this.getRevertedLocationId(clientOutletId, item.getFromLocationId()));
            item.setToLocationId(this.getRevertedLocationId(clientOutletId, item.getToLocationId()));
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
        }
    }

    private String getRevertedLocationId(String clientOutletId, String invLocationId) {
        if (invLocationId != null && invLocationId.contains("_")) {
            String[] splits = invLocationId.split("_");
            String locationId = splits[0];
            String outletId = splits[1];
            if (outletId.length() > 3 && !clientOutletId.equalsIgnoreCase(outletId)) {
                return locationId;
            }
        }
        return invLocationId;
    }

    @GET
    @Path(value="store/{store_id}/shopFloorTemplate")
    @Produces(value={"application/json"})
    public List getShopFloorTemplates(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List shopFloorTemplates = this.findAll(request, ShopFloorTemplate.class, storeId, this.getClientOutletId(request, storeId));
        for (ShopFloorTemplate shopFloorTemplate : shopFloorTemplates) {
            XMLTransientUtil.makeXMLTransient((ShopFloorTemplate)shopFloorTemplate);
        }
        return shopFloorTemplates;
    }

    @GET
    @Path(value="store/{store_id}/menuItemInvStatus")
    @Produces(value={"application/json"})
    public List getMenuItemInvStatus(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, MenuItemInventoryStatus.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/inventoryStockUnits")
    @Produces(value={"application/json"})
    public List getInventoryStockUnit(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, InventoryStockUnit.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/inventoryStock")
    @Produces(value={"application/json"})
    public List getInventoryStock(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, InventoryStock.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/inventoryClosingBlance")
    @Produces(value={"application/json"})
    public List getInventoryCloseBalance(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, InventoryClosingBalance.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/shopFloors")
    @Produces(value={"application/json"})
    public List getShopFloor(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List shopFloors = this.findAll(request, ShopFloor.class, storeId, this.getClientOutletId(request, storeId));
        for (ShopFloor item : shopFloors) {
            XMLTransientUtil.makeXMLTransient((ShopFloor)item);
        }
        return shopFloors;
    }

    @GET
    @Path(value="store/{store_id}/shopTables")
    @Produces(value={"application/json"})
    public List getShopTable(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List shopTables = this.findAll(request, ShopTable.class, storeId, this.getClientOutletId(request, storeId));
        if (shopTables != null && shopTables.size() > 0) {
            for (ShopTable table : shopTables) {
                XMLTransientUtil.makeXMLTransient((ShopTable)table);
            }
        }
        return shopTables;
    }

    @GET
    @Path(value="store/{store_id}/bookingInfos")
    @Produces(value={"application/json"})
    public List getBookingInfo(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List bookingInfoList = this.findAll(request, BookingInfo.class, storeId, this.getClientOutletId(request, storeId));
        for (BookingInfo item : bookingInfoList) {
            XMLTransientUtil.makeXMLTransient((BookingInfo)item);
        }
        return bookingInfoList;
    }

    @GET
    @Path(value="store/{store_id}/storeSession")
    @Produces(value={"application/json"})
    public List getStoreSessions(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, StoreSession.class, storeId, this.getClientOutletId(request, storeId));
    }

    @GET
    @Path(value="store/{store_id}/storeSessionControl")
    @Produces(value={"application/json"})
    public List getStoreSessionControls(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        List storeSessionControlList = this.findAll(request, StoreSessionControl.class, storeId);
        if (storeSessionControlList != null && storeSessionControlList.size() > 0) {
            for (StoreSessionControl item : storeSessionControlList) {
                XMLTransientUtil.makeXMLTransient((StoreSessionControl)item);
            }
        }
        return storeSessionControlList;
    }

    @GET
    @Path(value="store/{store_id}/allCashDrawer")
    @Produces(value={"application/json"})
    public List getAllCashDrawers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return this.findAll(request, CashDrawer.class, storeId);
    }

    @GET
    @Path(value="store/{store_id}/ticket")
    @Produces(value={"application/json"})
    public List getTickets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            Date date = this.getLastUpdateDate(request);
            PosLog.debug(this.getClass(), (String)("get ticket list for store: " + storeId + " those are updated after: " + date));
            List ticketList = this.findAll(request, Ticket.class, this.getClientOutletId(request, storeId), date, null);
            PosLog.debug(this.getClass(), (String)("Found " + ticketList.size() + " tickets"));
            for (Ticket ticket : ticketList) {
                XMLTransientUtil.makeXMLTransient((Ticket)ticket);
            }
            PosLog.debug(this.getClass(), (String)("initialized " + ticketList.size() + " tickets"));
            return ticketList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            throw e;
        }
    }

    @GET
    @Path(value="store/{store_id}/menugreatOrders")
    @Produces(value={"application/json"})
    public List getMenugreatOrders(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            Date date = this.getLastUpdateDate(request);
            PosLog.debug(this.getClass(), (String)("get menugreat ticket list for store: " + storeId + " those are updated after: " + date));
            List ticketList = this.findAll(request, Ticket.class, this.getClientOutletId(request, storeId), date, (Criterion)Restrictions.eq((String)Ticket.PROP_SOURCE, (Object)TicketSource.Online.name()));
            PosLog.debug(this.getClass(), (String)("Found " + ticketList.size() + " menugreat tickets"));
            for (Ticket ticket : ticketList) {
                XMLTransientUtil.makeXMLTransient((Ticket)ticket);
            }
            PosLog.debug(this.getClass(), (String)("initialized " + ticketList.size() + " menugreat tickets"));
            return ticketList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            throw e;
        }
    }

    @GET
    @Path(value="store/{store_id}/transactions")
    @Produces(value={"application/json"})
    public List getPosTransactions(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            Date date = this.getLastUpdateDate(request);
            return this.findAll(request, PosTransaction.class, this.getClientOutletId(request, storeId), date, Restrictions.isNull((String)PosTransaction.PROP_TICKET));
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            throw e;
        }
    }

    @GET
    @Path(value="store/{store_id}/openTickets")
    @Produces(value={"application/json"})
    public List getOpenTickets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            Date date = this.getLastUpdateDate(request);
            String outletId = this.getClientOutletId(request, storeId);
            String deviceId = request.getParameter("device_id");
            if (StringUtils.isBlank((String)deviceId)) {
                return null;
            }
            Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(deviceId);
            if (terminal == null) {
                return null;
            }
            List ticketList = TicketDAO.getInstance().findTicketsByOutletId(date, outletId, false, terminal.getId());
            this.initializeTicket(ticketList);
            this.updatePosTransactionClassType(ticketList);
            return ticketList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            return null;
        }
    }

    @GET
    @Path(value="store/{store_id}/cashdrawerTickets")
    @Produces(value={"application/json"})
    public List getCashdrawerTickets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            Date date = this.getLastUpdateDate(request);
            String deviceId = request.getParameter("device_id");
            if (StringUtils.isBlank((String)deviceId)) {
                return null;
            }
            Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(deviceId);
            if (terminal == null) {
                return null;
            }
            CashDrawer cashDrawer = terminal.getCurrentCashDrawer();
            List ticketList = TicketDAO.getInstance().findCashDrawerTickets(date, cashDrawer == null ? "" : cashDrawer.getId(), terminal.getId());
            this.initializeTicket(ticketList);
            this.updatePosTransactionClassType(ticketList);
            return ticketList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            return null;
        }
    }

    @POST
    @Path(value="store/{store_id}/get_close_tickets_by_date_or_id")
    @Produces(value={"application/json"})
    public List getCloseTicketsByDate(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            String outletId = this.getClientOutletId(request, storeId);
            String ticketId = request.getParameter("order_id");
            String fromDate = request.getParameter("from_date");
            String toDate = request.getParameter("to_date");
            List ticketList = TicketDAO.getInstance().findClosedOnlineTickets(DateUtil.formatDateWithDefaultTimeAndSec((String)fromDate), DateUtil.formatDateWithDefaultTimeAndSec((String)toDate), outletId, ticketId);
            this.initializeTicket(ticketList);
            this.updatePosTransactionClassType(ticketList);
            return ticketList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            return null;
        }
    }

    @POST
    @Path(value="store/{store_id}/closedTickets")
    @Produces(value={"application/json"})
    public List getClosedTicketsByOpenTicketIds(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            Date date = this.getLastUpdateDate(request);
            Map params = request.getParameterMap();
            String dataJson = ((String[])params.get(JSON_DATA))[0];
            JSONObject rootElement = new JSONObject(dataJson);
            JSONArray dataArray = rootElement.getJSONArray("data");
            ArrayList<String> openTicketIds = new ArrayList<String>();
            for (int i = 0; i < dataArray.length(); ++i) {
                openTicketIds.add(dataArray.getString(i));
            }
            List ticketList = TicketDAO.getInstance().findClosedTicketsByOpenTicketIds(date, openTicketIds);
            this.initializeTicket(ticketList);
            this.updatePosTransactionClassType(ticketList);
            return ticketList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            return null;
        }
    }

    private void updatePosTransactionClassType(List ticketList) throws Exception {
        if (ticketList != null && ticketList.size() > 0) {
            for (Ticket ticket : ticketList) {
                Set transactions = ticket.getTransactions();
                if (transactions == null || transactions.size() <= 0) continue;
                for (PosTransaction posTransaction : transactions) {
                    ServiceUtils.updatePosTransactionUsingClassType((PosTransaction)posTransaction);
                }
            }
        }
    }

    @GET
    @Path(value="store/{store_id}/session/status")
    @Produces(value={"application/json"})
    public Boolean isStoreOpen(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return StoreUtil.isStoreOpen();
    }

    @GET
    @Path(value="store/{store_id}/session/id")
    @Produces(value={"application/json"})
    public String getCurrentSessionId(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return StoreUtil.isStoreOpen() ? StoreUtil.getCurrentStoreSession().getId() : null;
    }

    @GET
    @Path(value="store/{store_id}/session")
    @Produces(value={"application/json"})
    public StoreSession getCurrentSession(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        return StoreUtil.getCurrentStoreSession();
    }

    @GET
    @Path(value="store/{store_id}/session/open")
    @Produces(value={"application/json"})
    public StoreSession openStore(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId, String openedBy, String outletId) {
        if (StoreUtil.isStoreOpen()) {
            return StoreUtil.getCurrentStoreSession();
        }
        if (StringUtils.isEmpty((String)openedBy)) {
            return null;
        }
        User openByUser = UserDAO.getInstance().get(openedBy);
        if (openByUser == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)outletId)) {
            return null;
        }
        StoreUtil.openStore((User)openByUser, (String)outletId);
        return StoreUtil.getCurrentStoreSession();
    }

    @GET
    @Path(value="store/{store_id}/session/close")
    @Produces(value={"application/json"})
    public StoreSession closeStore(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String userId = request.getParameter("user_id");
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        User closedBy = UserDAO.getInstance().get(userId);
        if (closedBy == null) {
            return null;
        }
        try {
            return this.doCloseStore(closedBy);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/address/save")
    public DataSyncInfo saveAddress(List<Address> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                AddressDAO.getInstance().saveOrUpdateAddressList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/store/save")
    public DataSyncInfo saveStores(List<Store> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                StoreDAO.getInstance().saveOrUpdateStore(dataList, true, true, false);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/outlet/save")
    public DataSyncInfo saveOutlet(List<Outlet> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null && dataList.size() > 0) {
                    for (Outlet outlet : dataList) {
                        this.removeBlankOutletProperties(outlet);
                    }
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/outlet/json/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveOutlets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                Map params = request.getParameterMap();
                JSONObject rootElement = new JSONObject(((String[])params.get("request"))[0]);
                JSONArray dataArray = rootElement.getJSONArray("data");
                ArrayList<Outlet> dataList = new ArrayList<Outlet>();
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject json = dataArray.getJSONObject(i);
                    GsonBuilder gsonBuilder = new GsonBuilder();
                    gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
                    Outlet outlet = (Outlet)gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(new Class[]{MenuShift.class})}).create().fromJson(json.toString(), Outlet.class);
                    if (outlet == null) continue;
                    dataList.add(outlet);
                }
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                this.saveOutlet(dataList, request, storeId);
                DataSyncInfo dataSyncInfo = this.success(lastUpdateTime);
                return dataSyncInfo;
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (Exception)e);
            }
            finally {
                storeLockMap.remove(storeLock);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/tax/save")
    public DataSyncInfo saveTaxes(List<Tax> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOuletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                TaxDAO.getInstance().saveOrUpdateTaxs(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/taxgroup/save")
    public DataSyncInfo saveTaxGroups(List<TaxGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOuletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                TaxGroupDAO.getInstance().saveOrUpdateTaxGroups(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/modifiergroup/save")
    public DataSyncInfo saveMenuModifierGroups(List<ModifierGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                ModifierGroupDAO.getInstance().saveOrUpdateModifierGroups(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    private DataSyncInfo success() {
        return DataSyncInfo.success((String)"success", null);
    }

    private DataSyncInfo success(Date lastUpdateTime) {
        return DataSyncInfo.success((String)"success", (Date)lastUpdateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/modifier/save")
    public DataSyncInfo saveMenuModifiers(List<MenuModifier> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                BaseDataServiceDao.get().saveOrUpdateMenuModifiers(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menuitem/save")
    public DataSyncInfo saveMenuItems(List<MenuItem> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                BaseDataServiceDao.get().saveOrUpdateMenuItems(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menuitemsizes/save")
    public DataSyncInfo saveMenuItemSizes(List<MenuItemSize> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                MenuItemSizeDAO.getInstance().saveOrUpdateMenuItemSize(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventorystock/save")
    public DataSyncInfo saveInventorystocks(List<InventoryStock> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                InventoryStockDAO.getInstance().saveOrUpdateInventoryStock(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventorystockunits/save")
    public DataSyncInfo saveInventorystockUnits(List<InventoryStockUnit> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                InventoryStockUnitDAO.getInstance().saveOrUpdateInventoryStockUnits(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventorylocation/save")
    public DataSyncInfo saveInventoryLocations(List<InventoryLocation> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                ArrayList<InventoryLocation> parentDataList = new ArrayList<InventoryLocation>();
                ArrayList<InventoryLocation> chieldDataList = new ArrayList<InventoryLocation>();
                String clientOutletId = this.getClientOutletId(request, storeId);
                Iterator<InventoryLocation> iterator = dataList.iterator();
                while (iterator.hasNext()) {
                    InventoryLocation item = iterator.next();
                    if (item.getOutletId() != null && !item.getOutletId().equals(clientOutletId)) {
                        iterator.remove();
                        continue;
                    }
                    if (item.isRoot().booleanValue()) {
                        parentDataList.add(item);
                        continue;
                    }
                    chieldDataList.add(item);
                }
                InventoryLocationDAO.getInstance().saveOrUpdateInventoryLocation(parentDataList, false, true);
                InventoryLocationDAO.getInstance().saveOrUpdateInventoryLocation(chieldDataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventorytransactions/save")
    public DataSyncInfo saveInventoryTransactions(List<InventoryTransaction> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOutletId = this.getClientOutletId(request, storeId);
                if (dataList != null && dataList.size() > 0) {
                    for (InventoryTransaction inventoryTransaction : dataList) {
                        if (StringUtils.isBlank((String)inventoryTransaction.getOutletId())) {
                            inventoryTransaction.setOutletId(clientOutletId);
                        }
                        this.revertLocationIdForDiffOutlet(inventoryTransaction, clientOutletId);
                    }
                }
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOutletId);
                BaseDataServiceDao.get().saveOrUpdateInventoryTransactions(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventorytransbyticket/save")
    public DataSyncInfo saveInventoryTransactionsByTicket(List<InventoryTransaction> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                BaseDataServiceDao.get().saveOrUpdateInventoryTransactions(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menuiteminventorystatus/save")
    public DataSyncInfo saveMenuItemInventorystatus(List<MenuItemInventoryStatus> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String outletId = request.getParameter("outletId");
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                MenuItemInventoryStatusDAO.getInstance().saveOrUpdateMenuItemInventoryStatus(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventoryunitgroups/save")
    public DataSyncInfo saveInventoryUnitGroups(List<InventoryUnitGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                InventoryUnitGroupDAO.getInstance().saveOrUpdateInventoryUnitGroups(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventoryunits/save")
    public DataSyncInfo saveInventoryUnits(List<InventoryUnit> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                InventoryUnitDAO.getInstance().saveOrUpdateInventoryUnits(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/packagingunits/save")
    public DataSyncInfo savePackagingUnits(List<PackagingUnit> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                PackagingUnitDAO.getInstance().saveOrUpdatePackagingUnits(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventoryvendors/save")
    public DataSyncInfo saveInventoryVendors(List<InventoryVendor> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                InventoryVendorDAO.getInstance().saveOrUpdateInventoryVendors(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventoryvendoritems/save")
    public DataSyncInfo saveInventoryVendorItems(List<InventoryVendorItems> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                InventoryVendorItemsDAO.getInstance().saveOrUpdateInventoryVendorItems(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/inventoryclosingbalances/save")
    public DataSyncInfo saveInventoryclosingbalances(List<InventoryClosingBalance> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                InventoryClosingBalanceDAO.getInstance().saveOrUpdateInventoryClosingBalances(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menucategory/save")
    public DataSyncInfo saveMenuCategories(List<MenuCategory> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                MenuCategoryDAO.getInstance().saveOrUpdateMenuCategories(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menugroup/save")
    public DataSyncInfo saveMenuGroups(List<MenuGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                MenuGroupDAO.getInstance().saveOrUpdateMenuGroups(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/storesession/save")
    public DataSyncInfo saveStoreSession(List<StoreSession> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                List storeSessionControls;
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                StoreSessionDAO.getInstance().saveOrUpdateStoreSessions(dataList, false, true);
                StoreSession storeSession = StoreSessionDAO.getInstance().getLastOpenSession();
                if (storeSession != null && (storeSessionControls = StoreSessionControlDAO.getInstance().findAll()) != null && storeSessionControls.size() > 0) {
                    StoreSessionControl sessionControl = (StoreSessionControl)storeSessionControls.get(0);
                    sessionControl.setCurrentData(storeSession);
                    StoreSessionControlDAO.getInstance().saveOrUpdate(sessionControl);
                    if (storeSessionControls.size() > 1) {
                        for (int i = 1; i < storeSessionControls.size(); ++i) {
                            StoreSessionControlDAO.getInstance().delete((StoreSessionControl)storeSessionControls.get(i));
                        }
                    }
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/storesessioncontrol/save")
    public DataSyncInfo saveStoreSessionControl(List<StoreSessionControl> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    for (StoreSessionControl item : dataList) {
                        StoreSessionControlDAO dao = StoreSessionControlDAO.getInstance();
                        StoreSessionControl existingItem = dao.get(item.getId());
                        if (existingItem != null) {
                            String id = existingItem.getId();
                            long version = existingItem.getVersion();
                            PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                            existingItem.setId(id);
                            existingItem.setVersion(version);
                            dao.update(existingItem);
                            continue;
                        }
                        item.setVersion(0L);
                        dao.save(item);
                    }
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/terminal/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveTerminal(List<Terminal> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                if (dataList != null) {
                    TerminalDAO.getInstance().saveOrUpdateTerminal(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/terminalType/save")
    public DataSyncInfo saveTerminalTypes(List<TerminalType> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOutletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOutletId);
                if (dataList != null) {
                    TerminalTypeDAO.getInstance().saveOrUpdateTerminalTypes(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/terminalType/categories/save")
    public DataSyncInfo saveTerminalTypeCategories(List<TerminalType> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null && dataList.size() > 0) {
                    for (TerminalType terminalType : dataList) {
                        TerminalType existingTerminalType = TerminalTypeDAO.getInstance().get(terminalType.getId());
                        if (existingTerminalType == null) continue;
                        existingTerminalType.setCategories(terminalType.getCategories());
                        List orderTypes = terminalType.getOrderTypes();
                        existingTerminalType.setOrderTypes(orderTypes);
                        existingTerminalType.setUpdateLastUpdateTime(false);
                        TerminalTypeDAO.getInstance().update(existingTerminalType);
                    }
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    private DataSyncInfo error(Exception e) {
        PosLog.error(this.getClass(), (Exception)e);
        return DataSyncInfo.error((String)e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/cashdrawers/save")
    public DataSyncInfo saveCashDrawers(List<CashDrawer> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                CashDrawerDAO.getInstance().saveOrUpdateCashDrawer(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/transactions/save")
    public DataSyncInfo saveTransactions(List<PosTransaction> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                PosTransactionDAO.getInstance().saveOrUpdatePosTransactions(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    private String getTicketLimitExceedErrMsg() {
        return RestServiceMessages.getString("ClientDataService.21");
    }

    private String getStoreLock(String storeId) {
        String storeLock = storeLockMap.get(storeId);
        if (storeLock == null) {
            storeLock = storeId.intern();
            storeLockMap.put(storeId, storeLock);
        }
        return storeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/usertypes/save")
    public DataSyncInfo saveUserType(List<UserType> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    UserTypeDAO.getInstance().saveOrUpdateUserTypes(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/users/save")
    public DataSyncInfo saveUser(List<User> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                BaseDataServiceDao.getInstance().saveOrUpdateUsers(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/departments/save")
    public DataSyncInfo saveDepartment(List<Department> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    DepartmentDAO.getInstance().saveOrUpdateDepartments(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/departments/orderTypesAndOutlets/save")
    public DataSyncInfo saveDepartmentOrderTypesAndOutlets(List<Department> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null && dataList.size() > 0) {
                    for (Department department : dataList) {
                        Department existingDepartment = DepartmentDAO.getInstance().get(department.getId());
                        if (existingDepartment == null) continue;
                        existingDepartment.setOrderTypes(department.getOrderTypes());
                        existingDepartment.setUpdateLastUpdateTime(false);
                        DepartmentDAO.getInstance().update(existingDepartment);
                    }
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/salesAreas/save")
    public DataSyncInfo saveSalesAreas(List<SalesArea> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    SalesAreaDAO.getInstance().saveOrUpdateSalesArea(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/cronJobs/save")
    public DataSyncInfo saveCronJobs(List<CronJob> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    CronJobDAO.getInstance().saveOrUpdateCronJob(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/recipes/save")
    public DataSyncInfo saveRecipes(List<Recepie> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    RecepieDAO.getInstance().saveOrUpdateRecipes(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/purchaseOrders/save")
    public DataSyncInfo savePurchaseOrders(List<PurchaseOrder> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                if (dataList != null) {
                    PurchaseOrderDAO.getInstance().saveOrUpdatePurchaseOrders(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/stockCounts/save")
    public DataSyncInfo saveStockCounts(List<StockCount> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                if (dataList != null) {
                    StockCountDAO.getInstance().saveOrUpdateStockCounts(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/reportGroups/save")
    public DataSyncInfo saveReportGroups(List<ReportGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    ReportGroupDAO.getInstance().saveOrUpdateReportGroup(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/printerGroups/save")
    public DataSyncInfo savePrinterGroups(List<PrinterGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    PrinterGroupDAO.getInstance().saveOrUpdatePrinterGroup(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/voidReasons/save")
    public DataSyncInfo saveVoidReasons(List<VoidReason> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    VoidReasonDAO.getInstance().saveOrUpdateVoidReason(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/printers/save")
    public DataSyncInfo saveVirtualPrinters(List<VirtualPrinter> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    VirtualPrinterDAO.getInstance().saveOrUpdateVirtualPrinter(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/shopTableTypes/save")
    public DataSyncInfo saveShopTableTypes(List<ShopTableType> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    ShopTableTypeDAO.getInstance().saveOrUpdateShopTableType(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/slideShowImages/save")
    public DataSyncInfo saveSlideShowImages(List<SlideShowImage> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    SlideShowImageDAO.getInstance().saveOrUpdateSlideShowImage(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/actionHistories/save")
    public DataSyncInfo saveActionHistories(List<ActionHistory> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                if (dataList != null) {
                    ActionHistoryDAO.getInstance().saveOrUpdateActionHistory(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/voidItems/save")
    public DataSyncInfo saveVoidItems(List<VoidItem> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOutletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOutletId);
                if (dataList != null && dataList.size() > 0) {
                    VoidItemDAO.getInstance().saveOrUpdateVoidItem(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/ordertype/save")
    public DataSyncInfo saveOrderType(List<OrderType> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOutletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOutletId);
                if (dataList != null) {
                    OrderTypeDAO.getInstance().saveOrUpdateOrderTypes(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/ordertype/categories/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveOrderTypeCategories(List<OrderType> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null && dataList.size() > 0) {
                    String clientOutletId = this.getClientOutletId(request, storeId);
                    OrderTypeDAO.getInstance().saveOrUpdateOrderTypeCollections(dataList);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/customer/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveCustomer(List<Customer> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    CustomerDAO.getInstance().saveOrUpdateCustomers(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/balanceUpdateTransactions/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveBalanceUpdateTransactions(List<BalanceUpdateTransaction> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                if (dataList != null) {
                    BalanceUpdateTransactionDAO.getInstance().saveOrUpdateBalanceUpdateTransactions(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/ticket/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveTicket(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                Map params = request.getParameterMap();
                String jsonData = ((String[])params.get("ticket_json"))[0];
                JSONObject rootElement = new JSONObject(jsonData);
                JSONArray ticketsArray = rootElement.getJSONArray("data");
                PosLog.debug(this.getClass(), (String)("Request received: " + request));
                BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.getInstance();
                List dataList = baseDataServiceDao.populateCloudTickets(ticketsArray.toString());
                boolean subscriptionTicketLimitExceed = false;
                baseDataServiceDao.saveOrUpdateTickets(rootElement, dataList, true);
                if (subscriptionTicketLimitExceed) {
                    throw new PosException(this.getTicketLimitExceedErrMsg());
                }
                DataSyncInfo dataSyncInfo = DataSyncInfo.success((String)"success");
                return dataSyncInfo;
            }
            catch (PosException e) {
                DataSyncInfo error = DataSyncInfo.error((String)e.getMessage());
                error.setResponseCode(510);
                DataSyncInfo dataSyncInfo = error;
                return dataSyncInfo;
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo = this.error(e);
                return dataSyncInfo;
            }
            finally {
                storeLockMap.remove(storeLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/send_to_kitchen")
    @Produces(value={"application/json"})
    public DataSyncInfo saveTicketAndSend(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                Map params = request.getParameterMap();
                String jsonData = ((String[])params.get("ticket_json"))[0];
                JSONObject rootElement = new JSONObject(jsonData);
                JSONArray ticketsArray = rootElement.getJSONArray("data");
                PosLog.debug(this.getClass(), (String)("Request received: " + request));
                BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.getInstance();
                List dataList = baseDataServiceDao.populateCloudTickets(ticketsArray.toString());
                baseDataServiceDao.saveOrUpdateTickets(rootElement, dataList, true);
                for (Ticket ticket : dataList) {
                    SendToKitchenAction.doSendNewItemsToKitchen((Ticket)ticket, (boolean)false);
                }
                DataSyncInfo dataSyncInfo = DataSyncInfo.success((String)"success");
                return dataSyncInfo;
            }
            catch (PosException e) {
                DataSyncInfo error = DataSyncInfo.error((String)e.getMessage());
                error.setResponseCode(510);
                DataSyncInfo dataSyncInfo = error;
                return dataSyncInfo;
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo = this.error(e);
                return dataSyncInfo;
            }
            finally {
                storeLockMap.remove(storeLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/attendance/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveAttendanceHistory(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                Map params = request.getParameterMap();
                JSONObject rootElement = new JSONObject(((String[])params.get(JSON_DATA))[0]);
                JSONArray dataArray = rootElement.getJSONArray("data");
                BaseDataServiceDao instance = BaseDataServiceDao.get();
                ArrayList<AttendenceHistory> dataList = new ArrayList<AttendenceHistory>();
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject json = dataArray.getJSONObject(i);
                    AttendenceHistory attendanceHistory = (AttendenceHistory)instance.getGsonBuilder().create().fromJson(json.toString(), AttendenceHistory.class);
                    if (attendanceHistory == null) continue;
                    dataList.add(attendanceHistory);
                }
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                instance.saveOrUpdateAttendanceHistory(dataList);
                DataSyncInfo dataSyncInfo = this.success(lastUpdateTime);
                return dataSyncInfo;
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (Exception)e);
            }
            finally {
                storeLockMap.remove(storeLock);
            }
            return null;
        }
    }

    @POST
    @Path(value="store/{store_id}/setup/store")
    @Produces(value={"application/json"})
    public DataSyncInfo doSetUpStore(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            String jsonData = ((String[])request.getParameterMap().get("data"))[0];
            Store store = (Store)this.convertJsonToObject(jsonData, Store.class);
            if (store == null) {
                throw new Exception("Invalid request.");
            }
            Store existingStore = StoreDAO.getInstance().getCloudRestaurant(storeId);
            if (existingStore == null) {
                throw new Exception("Store not found.");
            }
            existingStore.setName(store.getName());
            existingStore.setUpdateLastUpdateTime(true);
            existingStore.setUpdateSyncTime(true);
            StoreDAO.getInstance().update(existingStore);
            return this.success();
        }
        catch (Exception e) {
            return this.error(e);
        }
    }

    @POST
    @Path(value="store/{store_id}/setup/currency")
    @Produces(value={"application/json"})
    public DataSyncInfo doSetupCurrency(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            String jsonData = ((String[])request.getParameterMap().get("data"))[0];
            Currency currency = (Currency)this.convertJsonToObject(jsonData, Currency.class);
            if (currency == null) {
                throw new Exception("Invalid request.");
            }
            ArrayList<Currency> dataList = new ArrayList<Currency>();
            dataList.add(currency);
            Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
            CurrencyDAO.getInstance().saveOrUpdateCurrency(dataList, true, true);
            return this.success(lastUpdateTime);
        }
        catch (Exception e) {
            return this.error(e);
        }
    }

    @POST
    @Path(value="store/{store_id}/setup/ordertype")
    @Produces(value={"application/json"})
    public DataSyncInfo doSetUpOrderType(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            String jsonData = ((String[])request.getParameterMap().get("data"))[0];
            OrderType orderType = (OrderType)this.convertJsonToObject(jsonData, OrderType.class);
            if (orderType == null) {
                throw new Exception("Invalid request.");
            }
            ArrayList<OrderType> dataList = new ArrayList<OrderType>();
            dataList.add(orderType);
            Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
            OrderTypeDAO.getInstance().saveOrUpdateOrderTypes(dataList, true, true);
            return this.success(lastUpdateTime);
        }
        catch (Exception e) {
            return this.error(e);
        }
    }

    @POST
    @Path(value="store/{store_id}/setup/item")
    @Produces(value={"application/json"})
    public DataSyncInfo doSaveMenuItem(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            String jsonData = ((String[])request.getParameterMap().get("data"))[0];
            MenuItem item = (MenuItem)this.convertJsonToObject(jsonData, MenuItem.class);
            if (item == null) {
                throw new Exception("Invalid request.");
            }
            ArrayList<MenuItem> dataList = new ArrayList<MenuItem>();
            dataList.add(item);
            Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
            BaseDataServiceDao.get().saveOrUpdateMenuItems(dataList, true, true);
            return this.success(lastUpdateTime);
        }
        catch (Exception e) {
            return this.error(e);
        }
    }

    public Object convertJsonToObject(String request, Class<?> typeClass) throws Exception {
        JSONObject json = new JSONObject(request);
        GsonBuilder gsonBuilder = BaseDataServiceDao.getGsonBuilder();
        return gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(new Class[]{MenuShift.class})}).create().fromJson(json.toString(), typeClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/users/attendance")
    @Produces(value={"application/json"})
    public DataSyncInfo saveUserLast(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                Map params = request.getParameterMap();
                BaseDataServiceDao.getInstance().saveOrUpdateUsersClockInOutTime(((String[])params.get(JSON_DATA))[0]);
                DataSyncInfo dataSyncInfo = DataSyncInfo.success((String)"success");
                return dataSyncInfo;
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (Exception)e);
            }
            finally {
                storeLockMap.remove(storeLock);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/voiditem/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveVoidItems(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                Map params = request.getParameterMap();
                BaseDataServiceDao.getInstance().saveOrUpdateVoidItems(((String[])params.get("void_json"))[0]);
                DataSyncInfo dataSyncInfo = DataSyncInfo.success((String)"success");
                return dataSyncInfo;
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (Exception)e);
            }
            finally {
                storeLockMap.remove(storeLock);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/kitchenTicket/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveKitchenTickets(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                Map params = request.getParameterMap();
                JSONObject rootElement = new JSONObject(((String[])params.get("kitchen_ticket_json"))[0]);
                Boolean isUpdateTicketItemStatus = params.get("updateTicketItemStatus") != null ? Boolean.valueOf(((String[])params.get("updateTicketItemStatus"))[0]) : false;
                JSONArray dataArray = rootElement.getJSONArray("data");
                ArrayList<KitchenTicket> dataList = new ArrayList<KitchenTicket>();
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject json = dataArray.getJSONObject(i);
                    GsonBuilder gsonBuilder = new GsonBuilder();
                    gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
                    KitchenTicket kitchenTicket = (KitchenTicket)gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(new Class[]{MenuShift.class})}).create().fromJson(json.toString(), KitchenTicket.class);
                    if (kitchenTicket == null) continue;
                    dataList.add(kitchenTicket);
                }
                if (isUpdateTicketItemStatus.booleanValue()) {
                    this.doUpdateKitchenStatusOfTicketItem(dataList);
                }
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                BaseDataServiceDao.getInstance().saveOrUpdateKitTickets(dataList);
                DataSyncInfo dataSyncInfo = DataSyncInfo.success((String)"success");
                return dataSyncInfo;
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (Exception)e);
            }
            finally {
                storeLockMap.remove(storeLock);
            }
            return null;
        }
    }

    private void doUpdateKitchenStatusOfTicketItem(List<KitchenTicket> kitchenTickets) throws Exception {
        if (kitchenTickets != null && kitchenTickets.size() > 0) {
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                TicketDAO ticketDAO;
                Ticket parentTicket;
                if (StringUtils.isEmpty((String)kitchenTicket.getTicketId()) || (parentTicket = (ticketDAO = TicketDAO.getInstance()).get(kitchenTicket.getTicketId())) == null) continue;
                ticketDAO.loadFullTicket(parentTicket);
                if (kitchenTicket.getTicketItems() != null && kitchenTicket.getTicketItems().size() > 0) {
                    block1: for (KitchenTicketItem kitchenTicketItem : kitchenTicket.getTicketItems()) {
                        double itemQuantity = kitchenTicketItem.getQuantity();
                        for (TicketItem item : parentTicket.getTicketItems()) {
                            KitchenStatus ticketItemStatus = item.getKitchenStatusValue();
                            if (kitchenTicketItem.getMenuItemCode() == null || !kitchenTicketItem.getMenuItemCode().equals(item.getMenuItemId()) || kitchenTicketItem.getKitchenStatusValue() == ticketItemStatus) continue;
                            if (itemQuantity == 0.0) continue block1;
                            item.setKitchenStatusValue(kitchenTicketItem.getKitchenStatusValue());
                            itemQuantity -= item.getQuantity().doubleValue();
                        }
                    }
                }
                if (parentTicket == null) continue;
                ticketDAO.saveOrUpdate(parentTicket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/cashdrawer/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveCashDrawer(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                String cashDrawerJson;
                Map params = request.getParameterMap();
                String outletId = this.getOutletId(params);
                if (!StoreUtil.isStoreOpen()) {
                    this.openStore(request, storeId, ((String[])params.get("user_id"))[0], outletId);
                }
                if (StringUtils.isEmpty((String)(cashDrawerJson = ((String[])params.get("cash_drawer"))[0]))) {
                    DataSyncInfo dataSyncInfo = DataSyncInfo.success((String)"empty data");
                    return dataSyncInfo;
                }
                BaseDataServiceDao.getInstance().saveOrUpdateCashDrawers(cashDrawerJson, outletId);
                DataSyncInfo dataSyncInfo = DataSyncInfo.success((String)"sucess");
                return dataSyncInfo;
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (Exception)e);
            }
            finally {
                storeLockMap.remove(storeLock);
            }
            return null;
        }
    }

    private Date getLastUpdateDate(HttpServletRequest request) {
        try {
            String lastUpdateTime = request.getParameter("lastUpdateTime");
            if (StringUtils.isNotEmpty((String)lastUpdateTime)) {
                long parseLong = Long.parseLong(lastUpdateTime);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(parseLong);
                return calendar.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/bookinginfos/save")
    public DataSyncInfo saveBookingInfo(List<BookingInfo> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                String clientOutletId = this.getClientOutletId(request, storeId);
                if (dataList != null && dataList.size() > 0) {
                    for (BookingInfo bookingInfo : dataList) {
                        List tables;
                        if (bookingInfo.getOutletId() == null) {
                            bookingInfo.setOutletId(clientOutletId);
                        }
                        if ((tables = bookingInfo.getTables()) == null || tables.size() <= 0) continue;
                        for (ShopTable shopTable : tables) {
                            if (shopTable.getOutletId() != null) continue;
                            shopTable.setOutletId(clientOutletId);
                        }
                    }
                    BookingInfoDAO.getInstance().saveOrUpdateBookingInfos(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/shopfloors/save")
    public DataSyncInfo saveShopFloor(List<ShopFloor> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                String outletId = this.getClientOutletId(request, storeId);
                if (dataList != null && dataList.size() > 0) {
                    for (ShopFloor shopFloor : dataList) {
                        if (!StringUtils.isBlank((String)shopFloor.getOutletId())) continue;
                        shopFloor.setOutletId(outletId);
                    }
                }
                ShopFloorDAO.getInstance().saveOrUpdateShopFloors(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/shopFloorTemplates/save")
    public DataSyncInfo saveShopFloorTemplates(List<ShopFloorTemplate> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOutletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOutletId);
                if (dataList != null && dataList.size() > 0) {
                    for (ShopFloorTemplate shopFloorTemplate : dataList) {
                        ShopFloor shopFloor = shopFloorTemplate.getFloor();
                        if (shopFloor == null) continue;
                        shopFloor.setOutletId(clientOutletId);
                    }
                    ShopFloorTemplateDAO.getInstance().saveOrUpdateShopFloorTemplates(dataList, false, true);
                }
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/shoptables/save")
    public DataSyncInfo saveShopTables(List<ShopTable> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                ShopTableDAO.getInstance().saveOrUpdateShoptables(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/shoptablesstatus/save")
    public DataSyncInfo saveShoptablestatus(List<ShopTableStatus> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOuletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOuletId);
                ShopTableStatusDAO.getInstance().saveOrUpdateShopTableStatus(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="store/{store_id}/tableStatus/save")
    @Produces(value={"application/json"})
    public DataSyncInfo saveShopTableStatus(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            try {
                JSONObject jsonObject = new JSONObject(request.getParameter("shop_table_status"));
                JSONArray jsonArray = new JSONArray(jsonObject.getJSONArray("data").toString());
                ArrayList<ShopTableStatus> dataList = new ArrayList<ShopTableStatus>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject json = jsonArray.getJSONObject(i);
                    ShopTableStatus shopTableStatus = (ShopTableStatus)BaseDataServiceDao.getGsonBuilder().create().fromJson(json.toString(), ShopTableStatus.class);
                    if (shopTableStatus == null) continue;
                    dataList.add(shopTableStatus);
                }
                String clientOuletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOuletId);
                if (dataList != null && dataList.size() > 0) {
                    for (ShopTableStatus shopTableStatus : dataList) {
                        ShopTableStatus existShopTable = ShopTableStatusDAO.getInstance().get(shopTableStatus.getId());
                        if (existShopTable == null) continue;
                        long version = existShopTable.getVersion();
                        shopTableStatus.setVersion(version);
                    }
                }
                ShopTableStatusDAO.getInstance().saveOrUpdateShopTableStatus(dataList, false, true);
                DataSyncInfo dataSyncInfo = this.success(lastUpdateTime);
                return dataSyncInfo;
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), (Exception)e);
            }
            finally {
                storeLockMap.remove(storeLock);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/currencies/save")
    public DataSyncInfo saveCurrencies(List<Currency> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOuletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOuletId);
                CurrencyDAO.getInstance().saveOrUpdateCurrency(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/cashbreakdowns/save")
    public DataSyncInfo saveCashbreakdowns(List<CashBreakdown> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                CashBreakdownDAO.getInstance().saveOrUpdateCashBreakdown(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/shifts/save")
    public DataSyncInfo saveShifts(List<Shift> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                ShiftDAO.getInstance().saveOrUpdateShifts(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/attendenceHistory/save")
    public DataSyncInfo saveAttendenceHistories(List<AttendenceHistory> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                AttendenceHistoryDAO.getInstance().saveOrUpdateAttendenceHistoryList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/attributeGroup/save")
    public DataSyncInfo saveAttributeGroups(List<AttributeGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                AttributeGroupDAO.getInstance().saveOrUpdateAttributeGroupList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/attribute/save")
    public DataSyncInfo saveAttributes(List<Attribute> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                AttributeDAO.getInstance().saveOrUpdateAttributeList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/cookingInstruction/save")
    public DataSyncInfo saveCookingInstructions(List<CookingInstruction> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                CookingInstructionDAO.getInstance().saveOrUpdateCookingInstructionList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    @Deprecated
    @POST
    @Path(value="store/{store_id}/deletedData/save")
    public DataSyncInfo saveDeletedData(List dataList, @PathParam(value="store_id") String storeId) {
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/course/save")
    public DataSyncInfo saveCourses(List<Course> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                CourseDAO.getInstance().saveOrUpdateCourseList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/customerGroup/save")
    public DataSyncInfo saveCustomerGroups(List<CustomerGroup> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                CustomerGroupDAO.getInstance().saveOrUpdateCustomerGroupList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/customPayment/save")
    public DataSyncInfo saveCustomPayments(List<CustomPayment> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String outletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, outletId);
                CustomPaymentDAO.getInstance().saveOrUpdateCustomPaymentList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/declaredTips/save")
    public DataSyncInfo saveDeclaredTipss(List<DeclaredTips> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                DeclaredTipsDAO.getInstance().saveOrUpdateDeclaredTipsList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/deliveryAddress/save")
    public DataSyncInfo saveDeliveryAddress(List<DeliveryAddress> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                DeliveryAddressDAO.getInstance().saveOrUpdateDeliveryAddressList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/deliveryCharge/save")
    public DataSyncInfo saveDeliveryCharges(List<DeliveryCharge> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOutletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOutletId);
                DeliveryChargeDAO.getInstance().saveOrUpdateDeliveryChargeList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/discount/save")
    public DataSyncInfo saveDiscounts(List<Discount> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOuletId = this.getClientOutletId(request, storeId);
                if (dataList != null && dataList.size() > 0) {
                    for (Discount discount : dataList) {
                        discount.setOutletId(clientOuletId);
                    }
                }
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                DiscountDAO.getInstance().saveOrUpdateDiscountList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/deliveryInstruction/save")
    public DataSyncInfo saveDeliveryInstraction(List<DeliveryInstruction> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                DeliveryInstructionDAO.getInstance().saveOrUpdateDeliveryInstructionList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/giftCard/save")
    public DataSyncInfo saveGiftCard(List<GiftCard> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                GiftCardDAO.getInstance().saveOrUpdateGiftCardList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/gratuity/save")
    public DataSyncInfo saveGratuity(List<Gratuity> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                GratuityDAO.getInstance().saveOrUpdateGratuityList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/gratuityPaymentHistory/save")
    public DataSyncInfo saveGratuityPaymentHistory(List<GratuityPaymentHistory> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String outletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, outletId);
                GratuityPaymentHistoryDAO.getInstance().saveOrUpdateGratuityPaymentHistoryList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/imageResources/save")
    public DataSyncInfo saveImageResources(List<ImageResource> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                ImageResourceDAO.getInstance().saveOrUpdateImageResourceList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/multiplier/save")
    public DataSyncInfo saveMultipliers(List<Multiplier> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                MultiplierDAO.getInstance().saveOrUpdateMultiplierList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menuItemModierSpec/save")
    public DataSyncInfo saveMenuItemModierSpec(List<MenuItemModifierSpec> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                MenuItemModifierSpecDAO.getInstance().saveOrUpdateMenuItemModifierSpecList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menuItemModierPage/save")
    public DataSyncInfo saveMenuItemModierPage(List<MenuItemModifierPage> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                MenuItemModifierPageDAO.getInstance().saveOrUpdateMenuItemModifierPageList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/pizzaCrust/save")
    public DataSyncInfo savePizzaCrusts(List<PizzaCrust> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                PizzaCrustDAO.getInstance().saveOrUpdatePizzaCrustList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/pizzaPrice/save")
    public DataSyncInfo savePizzaPrices(List<PizzaPrice> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request);
                PizzaPriceDAO.getInstance().saveOrUpdatePizzaPriceList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/priceRule/save")
    public DataSyncInfo savePriceRule(List<PriceRule> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                PriceRuleDAO.getInstance().saveOrUpdatePriceRuleList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/priceTable/save")
    public DataSyncInfo savePriceTable(List<PriceTable> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, this.getClientOutletId(request, storeId));
                PriceTableDAO.getInstance().saveOrUpdatePriceTableList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="store/{store_id}/menuPage/save")
    public DataSyncInfo saveMenuPages(List<MenuPage> dataList, @Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        String storeLock;
        String string = storeLock = this.getStoreLock(storeId);
        synchronized (string) {
            DataSyncInfo dataSyncInfo;
            try {
                String clientOutletId = this.getClientOutletId(request, storeId);
                Date lastUpdateTime = this.setLastUpdateTime(dataList, request, clientOutletId);
                if (dataList != null && dataList.size() > 0) {
                    for (MenuPage menuPage : dataList) {
                        if (menuPage.getOutletId() != null) continue;
                        menuPage.setOutletId(clientOutletId);
                    }
                }
                MenuPageDAO.getInstance().saveOrUpdateMenuPageList(dataList, false, true);
                dataSyncInfo = this.success(lastUpdateTime);
                storeLockMap.remove(storeLock);
            }
            catch (Exception e) {
                DataSyncInfo dataSyncInfo2;
                try {
                    dataSyncInfo2 = this.error(e);
                    storeLockMap.remove(storeLock);
                }
                catch (Throwable throwable) {
                    storeLockMap.remove(storeLock);
                    throw throwable;
                }
                return dataSyncInfo2;
            }
            return dataSyncInfo;
        }
    }

    private List findAll(HttpServletRequest request, Class referenceClass, String storeId) {
        return this.findAll(request, referenceClass, storeId, null);
    }

    protected List findAll(HttpServletRequest request, Class referenceClass, String storeId, String outletId) {
        return this.findAll(request, referenceClass, storeId, outletId, null);
    }

    private List findAll(HttpServletRequest request, Class referenceClass, String storeId, String outletId, Criterion restriction) {
        Date lastUpdateTime = this.getLastUpdateDate(request);
        return this.findAll(request, referenceClass, outletId, lastUpdateTime, restriction);
    }

    private List findAll(HttpServletRequest request, Class referenceClass, String outletId, Date date, Criterion restriction) {
        int offset = -1;
        int limit = 0;
        try {
            limit = POSUtil.parseInteger((String)((String[])request.getParameterMap().get("limit"))[0]);
            if (limit > 0) {
                offset = POSUtil.parseInteger((String)((String[])request.getParameterMap().get("offset"))[0]);
                PosLog.debug(this.getClass(), (String)(referenceClass.getSimpleName() + " offset: " + offset + " limit: " + limit));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TerminalDAO.getInstance().findDataList(referenceClass, date, outletId, restriction, offset, limit);
    }

    private List getSyncableMenuItems(HttpServletRequest request, String storeId) {
        Date lastUpdateTime = this.getLastUpdateDate(request);
        int offset = -1;
        int limit = 0;
        try {
            limit = POSUtil.parseInteger((String)((String[])request.getParameterMap().get("limit"))[0]);
            if (limit > 0) {
                offset = POSUtil.parseInteger((String)((String[])request.getParameterMap().get("offset"))[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MenuItemDAO.getInstance().getSyncableMenuItems(lastUpdateTime, storeId, offset, limit);
    }

    private StoreSession doCloseStore(User user) throws Exception {
        List clockInUsers;
        boolean hasClockedInUser;
        if (!user.isClockedIn().booleanValue()) {
            throw new Exception(RestServiceMessages.getString("ClientDataService.2"));
        }
        if (PosTransactionDAO.getInstance().hasUnauthorizedTransactions(null).booleanValue()) {
            throw new Exception(RestServiceMessages.getString("ClientDataService.3"));
        }
        StoreSession currentData = StoreUtil.getCurrentStoreSession();
        List reportList = CashDrawerDAO.getInstance().findByStoreOperationData(currentData, Boolean.valueOf(true));
        if (reportList != null) {
            for (CashDrawer report : reportList) {
                if (report.getReportTime() != null) continue;
                String message = RestServiceMessages.getString("ClientDataService.4");
                throw new Exception(message);
            }
        }
        boolean bl = hasClockedInUser = (clockInUsers = UserDAO.getInstance().findClockedInUsers()) != null && clockInUsers.size() > 0;
        if (hasClockedInUser && clockInUsers.size() == 1) {
            boolean bl2 = hasClockedInUser = !((User)clockInUsers.get(0)).getId().equals(user.getId());
        }
        if (hasClockedInUser) {
            String message = RestServiceMessages.getString("ClientDataService.5");
            throw new Exception(message);
        }
        if (user.isClockedIn().booleanValue()) {
            UserDAO.getInstance().doForceClockOutUser(user, user);
        }
        currentData.setCloseTime(new Date());
        currentData.setClosedBy(user);
        StoreUtil.closeStore((User)user);
        return currentData;
    }

    private String getOutletId(Map<String, String[]> params) {
        return StoreDAO.getRestaurant().getDefaultOutletId();
    }

    private Date setLastUpdateTime(List dataList, HttpServletRequest request) {
        return this.setLastUpdateTime(dataList, request, null);
    }

    private Date setLastUpdateTime(List dataList, HttpServletRequest request, String clientOutletId) {
        int rowCount;
        Date lastSyncTime = this.getLastUpdateDate(request);
        if (dataList == null || dataList.size() == 0) {
            return lastSyncTime;
        }
        if (!(dataList.get(0) instanceof TimedModel)) {
            return lastSyncTime;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(StoreDAO.getServerTimestamp());
        calendar.set(14, calendar.getMinimum(14));
        Date lastUpdateTime = calendar.getTime();
        for (TimedModel timedModel : dataList) {
            timedModel.setLastUpdateTime(lastUpdateTime);
        }
        if (lastSyncTime != null && (rowCount = TerminalDAO.getInstance().rowCount(dataList.get(0).getClass(), lastSyncTime, clientOutletId)) > 0) {
            return lastSyncTime;
        }
        return lastUpdateTime;
    }

    public List<Ticket> initializeTicket(List<Ticket> ticketList) {
        if (ticketList == null) {
            return null;
        }
        for (Ticket ticket : ticketList) {
            TicketDAO.getInstance().loadFullTicket(ticket);
            XMLTransientUtil.makeXMLTransient((Ticket)ticket);
        }
        return ticketList;
    }

    public class DateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement element, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
            String date = element.getAsString();
            SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
            formatter.setTimeZone(TimeZone.getDefault());
            try {
                return formatter.parse(date);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }
}

