/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.oropos.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.model.User;
import com.orocube.oropos.rest.server.model.UserV2;
import com.orocube.oropos.rest.service.ClientDataService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.springframework.beans.BeanUtils;

@Path(value="data/v2")
public class ClientDataServiceV2
extends ClientDataService {
    @Override
    @GET
    @Path(value="store/{store_id}/user")
    @Produces(value={"application/json"})
    public List getUsers(@Context HttpServletRequest request, @PathParam(value="store_id") String storeId) {
        try {
            List users = this.findAll(request, User.class, storeId, this.getClientOutletId(request, storeId));
            ArrayList<UserV2> userList = new ArrayList<UserV2>();
            if (users != null && users.size() > 0) {
                for (User user : users) {
                    String parentUserId;
                    user.setLinkedUser(null);
                    if (!user.isRoot().booleanValue() && (parentUserId = user.getParentUserId()) != null) {
                        user.setParentUser(null);
                        user.setParentUserId(parentUserId);
                    }
                    UserV2 user2 = new UserV2();
                    BeanUtils.copyProperties((Object)user, (Object)user2);
                    userList.add(user2);
                }
            }
            return userList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            throw e;
        }
    }
}

