/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.oropos.rest.service;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.GlobalConfigDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.DeviceType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.OroMobileLicenceActivation;
import com.floreantpos.ui.dialog.PosNotificationDialog;
import com.floreantpos.util.POSUtil;
import com.google.gson.GsonBuilder;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.oropos.rest.RestServiceMessages;
import com.orocube.rest.service.PosResponse;
import java.io.File;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import jersey.repackaged.com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;

@Path(value="/")
public class LoginService {
    @GET
    @Path(value="store/error/{error_message}")
    @Produces(value={"application/json"})
    public String createErrorMessage(@Context HttpServletRequest request, @PathParam(value="error_message") String errorMessage) {
        String string = StringUtils.isBlank((String)errorMessage) ? RestServiceMessages.getString("ClientDataService.6") : errorMessage;
        PosLog.error(this.getClass(), (String)string);
        return PosResponse.build((String)"", null, (int)0, (String)string);
    }

    @POST
    @Path(value="store/login")
    @Produces(value={"application/json"})
    public String login(@Context ServletContext servletContext, @Context HttpServletRequest servletRequest) {
        Map parameterMap = servletRequest.getParameterMap();
        String deviceId = ((String[])parameterMap.get("device_id"))[0];
        String deviceName = ((String[])parameterMap.get("device_name"))[0];
        String dataServiceOtp = ((String[])parameterMap.get("data_service.otp"))[0];
        DeviceType deviceType = DeviceType.fromType((int)POSUtil.parseInteger((String)((String[])parameterMap.get("device_type"))[0]));
        try {
            PosResponse response = this.login(servletRequest, deviceId, deviceName, deviceType, dataServiceOtp);
            return new GsonBuilder().create().toJson((Object)response);
        }
        catch (PosException e) {
            return PosResponse.build((String)"", null, (int)0, (String)e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
            String mesg = RestServiceMessages.getString("LoginService.0");
            return PosResponse.build((String)"", null, (int)0, (String)mesg);
        }
    }

    public PosResponse login(HttpServletRequest servletRequest, String deviceId, String deviceName, DeviceType deviceType, String dataServiceOtp) throws Exception {
        String msg = "";
        int responseCode = 0;
        Store store = StoreDAO.getRestaurant();
        String storeId = store.getUuid();
        String storeName = store.getName();
        Terminal terminal = null;
        if (StringUtils.isNotEmpty((String)deviceId)) {
            TerminalDAO terminalDao = TerminalDAO.getInstance();
            terminal = terminalDao.getByTerminalKey(deviceId);
            if (terminal != null && !terminal.isDeleted().booleanValue()) {
                if (!terminal.isActive().booleanValue()) {
                    terminal = this.checkTerminal(deviceId, terminal);
                }
                if (!terminal.isActive().booleanValue()) {
                    throw new PosException(LoginService.getTerminalNameDisplay(terminal));
                }
            }
            if (deviceType == DeviceType.ANDROID) {
                Integer terminalId;
                if (StringUtils.isEmpty((String)deviceName)) {
                    PosResponse response = PosResponse.buildResponse((String)storeId, null, (int)201, (String)RestServiceMessages.getString("LoginService.2"));
                    response.setStoreName(storeName);
                    return response;
                }
                boolean newTerminal = false;
                if (terminal == null) {
                    terminalId = terminalDao.createNewTerminalId(deviceId);
                    terminal = terminalDao.get(terminalId);
                } else {
                    terminalId = terminal.getId();
                }
                if (terminal == null) {
                    terminal = new Terminal();
                    terminal.setId(terminalId);
                    terminal.setDeviceType(Integer.valueOf(deviceType.getDeviceType()));
                    if (StringUtils.isNotBlank((String)dataServiceOtp) && Objects.equal((Object)GlobalConfigDAO.getInstance().getValueByKey("data_service.otp"), (Object)dataServiceOtp)) {
                        terminal.setActive(Boolean.valueOf(true));
                        GlobalConfigDAO.getInstance().saveOrUpdate("data_service.otp", "");
                    } else {
                        terminal = this.checkTerminal(deviceId, terminal);
                    }
                    newTerminal = true;
                }
                if (terminal.isDeleted().booleanValue()) {
                    terminal.setDeleted(Boolean.valueOf(false));
                    terminal.setActive(Boolean.valueOf(false));
                    terminal = this.checkTerminal(deviceId, terminal);
                }
                terminal.setOutletId(DataProvider.get().getCurrentOutletId());
                terminal.setTerminalKey(deviceId);
                if (StringUtils.isEmpty((String)deviceName)) {
                    terminal.setName(terminalDao.createNewTerminalName());
                } else {
                    terminal.setName(deviceName);
                }
                if (newTerminal) {
                    terminalDao.save(terminal);
                } else {
                    terminalDao.update(terminal);
                }
                if (!terminal.isActive().booleanValue()) {
                    throw new PosException(LoginService.getTerminalNameDisplay(terminal));
                }
            } else if (terminal != null && terminal.isDeleted().booleanValue()) {
                throw new PosException(LoginService.getTerminalNameDisplay(terminal));
            }
        }
        responseCode = 200;
        msg = "success";
        PosResponse response = PosResponse.buildResponse((String)storeId, null, (int)responseCode, (String)msg);
        response.setStoreName(storeName);
        PosNotificationDialog.showPosNotificationMessage((String)(RestServiceMessages.getString("LoginService.5") + terminal.getName() + RestServiceMessages.getString("LoginService.7")));
        return response;
    }

    @GET
    @Path(value="store/license-status")
    @Produces(value={"application/json"})
    public String getLicenseStatus(@Context ServletContext servletContext, @Context HttpServletRequest servletRequest) {
        Map parameterMap = servletRequest.getParameterMap();
        String deviceId = ((String[])parameterMap.get("device_id"))[0];
        String msg = "";
        Store store = StoreDAO.getRestaurant();
        String storeId = store.getUuid();
        String storeName = store.getName();
        Boolean data = Boolean.TRUE;
        TerminalDAO terminalDAO = TerminalDAO.getInstance();
        Terminal terminal = terminalDAO.getByTerminalKey(deviceId);
        if (terminal == null || !terminal.isActive().booleanValue()) {
            data = Boolean.FALSE;
            msg = LoginService.getTerminalNameDisplay(terminal);
        }
        String terminalKey = terminal.getTerminalKey();
        File licenseFile = OroMobileLicenceActivation.getLicenseFile((String)terminalKey);
        try {
            LicenseUtil.loadAndValidate((File)licenseFile, (String)"Oro Mobile", null, (String)terminalKey);
        }
        catch (LicenseNotFoundException e) {
            msg = RestServiceMessages.getString("LoginService.8");
            terminal.setActive(Boolean.valueOf(false));
        }
        catch (InvalidLicenseException e) {
            msg = e.getMessage();
            terminal.setActive(Boolean.valueOf(false));
        }
        catch (Exception e) {
            msg = RestServiceMessages.getString("LoginService.8");
            terminal.setActive(Boolean.valueOf(false));
        }
        if (!terminal.isActive().booleanValue()) {
            terminalDAO.saveOrUpdate(terminal);
            data = Boolean.FALSE;
        }
        int responseCode = 200;
        PosResponse response = PosResponse.buildResponse((String)storeId, null, (int)responseCode, (String)msg);
        response.setData((Object)data);
        response.setStoreName(storeName);
        return new GsonBuilder().create().toJson((Object)response);
    }

    private Terminal checkTerminal(final String deviceId, final Terminal updatedTerminal) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    LoginService.this.createYesNoMessage(deviceId, updatedTerminal, new PosNotificationDialog.PosNotificationListener(){

                        public void notificationResponse(boolean shouldAllow) {
                            updatedTerminal.setActive(Boolean.valueOf(shouldAllow));
                            latch.countDown();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
        latch.await();
        if (updatedTerminal.isActive().booleanValue()) {
            this.doCheckOroposMobileLicense(updatedTerminal);
        }
        return updatedTerminal;
    }

    private void doCheckOroposMobileLicense(Terminal terminal) {
        this.doCheckOroposMobileLicense(terminal, true);
    }

    private void doCheckOroposMobileLicense(Terminal terminal, boolean isPromntLicenceActivationDialog) {
        OroMobileLicenceActivation mobileLicenceActivation = new OroMobileLicenceActivation();
        mobileLicenceActivation.setShowLicenseActivationDialog(isPromntLicenceActivationDialog);
        mobileLicenceActivation.doCheckLicense(terminal);
        terminal.setActive(Boolean.valueOf(mobileLicenceActivation.isLicensefound()));
    }

    private void createYesNoMessage(String deviceId, Terminal terminal, PosNotificationDialog.PosNotificationListener listener) {
        String message = RestServiceMessages.getString("LoginService.9");
        if (terminal != null && StringUtils.isNotBlank((String)terminal.getName())) {
            message = message + "<br> " + RestServiceMessages.getString("LoginService.10") + terminal.getName();
        }
        message = message + "<br> " + RestServiceMessages.getString("LoginService.11") + deviceId;
        new PosNotificationDialog(message, 30000, listener);
    }

    public static String getTerminalNameDisplay(Terminal terminal) {
        StringBuilder builder = new StringBuilder();
        builder.append(RestServiceMessages.getString("LoginService.1"));
        builder.append("\n");
        String terminalId = String.valueOf(terminal.getId());
        if (StringUtils.isBlank((String)terminal.getName()) || terminalId.equalsIgnoreCase(terminal.getName())) {
            builder.append("\n");
            builder.append(RestServiceMessages.getString("LoginService.3"));
            builder.append(terminalId);
            return builder.toString();
        }
        builder.append("\n");
        builder.append(RestServiceMessages.getString("LoginService.3") + terminalId);
        builder.append("\n");
        builder.append(RestServiceMessages.getString("LoginService.6") + terminal.getName());
        return builder.toString();
    }
}

