/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import javax.swing.JOptionPane;

public class AssignDriverAction
extends PosAction {
    public AssignDriverAction() {
        super(POSConstants.ASSIGN_DRIVER_BUTTON_TEXT);
    }

    public AssignDriverAction(DataChangeListener listener) {
        super(POSConstants.ASSIGN_DRIVER_BUTTON_TEXT, listener);
    }

    @Override
    public void execute() {
        try {
            int option;
            Object selectedObject = this.getSelectedObject();
            if (selectedObject == null) {
                return;
            }
            Ticket ticket = null;
            ticket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
            if (ticket == null) {
                return;
            }
            if (!ticket.getOrderType().isDelivery().booleanValue()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SwitchboardView.8"));
                return;
            }
            User assignedDriver = ticket.getAssignedDriver();
            if (assignedDriver != null && (option = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.9"), POSConstants.CONFIRM, 0, 3, null, null, null)) != 0) {
                return;
            }
            OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderServiceExtension == null) {
                orderServiceExtension = new DefaultOrderServiceExtension();
            }
            orderServiceExtension.assignDriver(ticket.getId());
            if (this.listener != null) {
                this.listener.dataChanged(ticket);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }
}

