/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;

public class RefundAction
extends PosAction {
    public RefundAction(DataChangeListener listener) {
        super(Messages.getString("RefundAction.0"), listener);
        super.setRequiredPermission(UserPermission.REFUND);
    }

    @Override
    public void execute() {
        try {
            if (this.listener == null) {
                return;
            }
            Ticket ticket = null;
            Object selectedObject = this.getSelectedObject();
            if (selectedObject == null) {
                return;
            }
            if (selectedObject instanceof Ticket) {
                ticket = (Ticket)selectedObject;
            }
            VoidTicketAction action = new VoidTicketAction(ticket);
            action.execute();
            if (this.listener != null) {
                this.listener.dataChanged(ticket);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }
}

