/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.Iterator;
import java.util.List;

public class ReorderTicketAction
extends PosAction {
    private Ticket ticket;

    public ReorderTicketAction(Ticket ticket) {
        this.ticket = ticket;
    }

    public ReorderTicketAction(DataChangeListener listener) {
        super("REORDER", listener);
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            Ticket cloneTicket = this.ticket.clone(this.ticket);
            List<TicketItem> ticketItems = cloneTicket.getTicketItems();
            Iterator<TicketItem> iterator = ticketItems.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.isPrintedToKitchen().booleanValue()) continue;
                iterator.remove();
            }
            if (cloneTicket.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No items to reorder.");
                return;
            }
            ReorderDialog dialog = new ReorderDialog(cloneTicket);
            dialog.setTitle("OROPOS");
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(1024, 650));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<TicketItem> ticketItemList = dialog.getTicketItems();
            if (ticketItemList == null) {
                return;
            }
            for (TicketItem ticketItem : ticketItemList) {
                ticketItem.setTicket(this.ticket);
                this.ticket.addToticketItems(ticketItem);
            }
            this.ticket.calculatePrice();
            OrderController.saveOrder(this.ticket);
            if (this.ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && this.ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.ticket);
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }
}

