/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.SeatSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import java.util.ArrayList;
import java.util.List;

public class SeatSelectionAction
extends PosAction {
    private PosButton btnSeat;

    public SeatSelectionAction() {
        super("SEAT");
    }

    public void setSource(PosButton btnSeat) {
        this.btnSeat = btnSeat;
    }

    @Override
    public void execute() {
        this.doAddSeatNumber();
    }

    protected void doAddSeatNumber() {
        Ticket currentTicket = OrderView.getInstance().getCurrentTicket();
        SeatSelectionDialog seatDialog = new SeatSelectionDialog(currentTicket, this.getSeatNumbers(currentTicket));
        seatDialog.setTitle(Messages.getString("OrderView.12"));
        seatDialog.pack();
        seatDialog.open();
        if (seatDialog.isCanceled()) {
            return;
        }
        int seatNumber = seatDialog.getSeatNumber();
        if (seatNumber == -1) {
            NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
            dialog.setTitle(Messages.getString("OrderView.13"));
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            seatNumber = (int)dialog.getValue();
        }
        this.btnSeat.setText(Messages.getString("OrderView.14") + seatNumber);
        this.btnSeat.putClientProperty("SEAT_NO", seatNumber);
        this.doAddSeatTreatTicketItem(seatNumber, currentTicket);
    }

    private void doAddSeatTreatTicketItem(Integer seatNumber, Ticket currentTicket) {
        TicketItem ticketItem = new TicketItem();
        if (seatNumber == 0) {
            ticketItem.setName(Messages.getString("OrderView.16"));
        } else {
            ticketItem.setName(Messages.getString("OrderView.17") + seatNumber);
        }
        ticketItem.setShouldPrintToKitchen(true);
        ticketItem.setTreatAsSeat(true);
        ticketItem.setSeatNumber(seatNumber);
        ticketItem.setTicket(currentTicket);
        OrderView.getInstance().getTicketView().addTicketItem(ticketItem);
    }

    public Object getLastSeat(Ticket currentTicket) {
        Integer lastSeatNumber = 0;
        List<TicketItem> ticketItems = currentTicket.getTicketItems();
        if (ticketItems != null && !ticketItems.isEmpty()) {
            TicketItem lastTicketItem = ticketItems.get(ticketItems.size() - 1);
            lastSeatNumber = lastTicketItem.getSeatNumber();
        }
        return lastSeatNumber;
    }

    public Object getSelectedSeatNumber() {
        Ticket currentTicket = OrderView.getInstance().getCurrentTicket();
        Object seatNumber = this.btnSeat.getClientProperty("SEAT_NO");
        if (seatNumber == null) {
            return 0;
        }
        Integer seatNo = (Integer)seatNumber;
        boolean sendToKitchen = false;
        for (TicketItem ticketItem : currentTicket.getTicketItems()) {
            int existingSeatNumber;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (existingSeatNumber = ticketItem.getSeatNumber().intValue()) != seatNo) continue;
            sendToKitchen = ticketItem.isPrintedToKitchen();
        }
        if (sendToKitchen) {
            this.doAddSeatTreatTicketItem(seatNo, currentTicket);
        }
        return seatNo;
    }

    protected List<Integer> getSeatNumbers(Ticket currentTicket) {
        ArrayList<Integer> seatNumbers = new ArrayList<Integer>();
        for (TicketItem ticketItem : currentTicket.getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue() || seatNumbers.contains(ticketItem.getSeatNumber())) continue;
            seatNumbers.add(ticketItem.getSeatNumber());
        }
        return seatNumbers;
    }

    public boolean updateSeatNumber(TicketItem ticketItem) {
        Ticket ticket = ticketItem.getTicket();
        SeatSelectionDialog seatDialog = new SeatSelectionDialog(ticket.getTableNumbers(), this.getSeatNumbers(ticket));
        seatDialog.setTitle(Messages.getString("TicketView.16"));
        seatDialog.pack();
        seatDialog.open();
        if (seatDialog.isCanceled()) {
            return false;
        }
        int seatNumber = seatDialog.getSeatNumber();
        if (seatNumber == -1) {
            NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
            dialog.setTitle(Messages.getString("TicketView.17"));
            dialog.setValue(ticketItem.getSeatNumber().intValue());
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return false;
            }
            seatNumber = (int)dialog.getValue();
        }
        ticketItem.setName(Messages.getString("TicketView.18") + seatNumber);
        ticketItem.setSeatNumber(seatNumber);
        this.updateTicketItemsSeatNumber(ticketItem);
        return true;
    }

    private void updateTicketItemsSeatNumber(TicketItem ticketItem) {
        boolean updateSeatNumber = false;
        for (TicketItem item : ticketItem.getTicket().getTicketItems()) {
            if (item == ticketItem) {
                updateSeatNumber = true;
                continue;
            }
            if (!updateSeatNumber) continue;
            if (item.isTreatAsSeat().booleanValue()) break;
            item.setSeatNumber(ticketItem.getSeatNumber());
        }
    }

    public void clearSelectedSeat() {
        this.btnSeat.putClientProperty("SEAT_NO", null);
    }
}

