/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.SendToKitchenOptionSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class SendToKitchenAction
extends PosAction {
    public SendToKitchenAction() {
        super("SEND");
    }

    public SendToKitchenAction(DataChangeListener listener) {
        super("SEND", listener);
    }

    @Override
    public void execute() {
        try {
            Object selectedObject = this.getSelectedObject();
            if (selectedObject == null) {
                return;
            }
            Ticket ticket = null;
            ticket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), "The order type does not support printing to kitchen");
                return;
            }
            if (ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            TicketDAO.getInstance().loadFullTicket(ticket);
            SendToKitchenOptionSelectionDialog sendTicketDialog = new SendToKitchenOptionSelectionDialog(ticket);
            sendTicketDialog.pack();
            sendTicketDialog.open();
            if (sendTicketDialog.isCanceled()) {
                return;
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }
}

