/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.util.Date;

public class StaffBankStartStopAction
extends PosAction {
    public static final double FORCE_CLOSE_RECONCILE_AMOUNT = 0.0;
    private User assignToUser;

    public StaffBankStartStopAction(User assignedToUser) {
        super("Start Staff Bank");
        this.assignToUser = assignedToUser;
        this.updateActionText();
    }

    public void updateActionText() {
    }

    @Override
    public void execute() {
        try {
            if (this.assignToUser.isStaffBankStarted().booleanValue()) {
                int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Are you sure you want to close staff bank?", "Confirm");
                if (option != 0) {
                    return;
                }
                this.performCloseStaffBank();
            } else {
                this.performStartStaffBank();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void performStartStaffBank() throws Exception {
        if (!this.assignToUser.isClockedIn().booleanValue()) {
            POSMessageDialog.showError("Can't start staff bank. You are not clocked in.");
            return;
        }
        CashDrawer staffBankReport = new CashDrawer();
        staffBankReport.setStartTime(new Date());
        staffBankReport.setAssignedUser(this.assignToUser);
        staffBankReport.setTerminal(Application.getInstance().getTerminal());
        staffBankReport.setStoreOperationData(StoreUtil.getCurrentStoreOperation().getCurrentData());
        staffBankReport.setDrawerType(DrawerType.STAFF_BANK);
        staffBankReport.setAssignedBy(this.assignToUser);
        this.assignToUser.setStaffBankStarted(true);
        this.assignToUser.setCurrentCashDrawer(staffBankReport);
        TerminalDAO.getInstance().performBatchSave(staffBankReport, this.assignToUser);
        this.updateActionText();
    }

    public void performCloseStaffBank() throws Exception {
        CashDrawer report = this.assignToUser.getActiveDrawerPullReport();
        CashDrawerReportService reportService = new CashDrawerReportService(report);
        reportService.populateReport();
        Double reconcileAmount = 0.0;
        Application application = Application.getInstance();
        if (application.getStore().isUseDetailedReconciliation().booleanValue()) {
            CashReconciliationDialog dialog = new CashReconciliationDialog(report);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            reconcileAmount = dialog.getTotalReconcilieAmount();
        } else if (application.getTerminal().isEnableMultiCurrency().booleanValue()) {
            MultiCurrencyAmountSelectionDialog multiCurrencyDialog = new MultiCurrencyAmountSelectionDialog(report, report.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
            multiCurrencyDialog.setTitle("Cash reconciliation");
            multiCurrencyDialog.setCaption("Cash reconciliation");
            multiCurrencyDialog.setReconcile(true);
            multiCurrencyDialog.pack();
            multiCurrencyDialog.open();
            if (multiCurrencyDialog.isCanceled()) {
                return;
            }
            reconcileAmount = multiCurrencyDialog.getTotalAmount();
        } else {
            reconcileAmount = this.getReconcileAmount(report);
            if (reconcileAmount.isNaN()) {
                return;
            }
        }
        report.setCashToDeposit(reconcileAmount);
        TerminalDAO dao = new TerminalDAO();
        dao.resetStaffBank(this.assignToUser, report);
        User currentUser = Application.getCurrentUser();
        if (currentUser != null && currentUser.getId().equals(report.getAssignedUser().getId())) {
            Application.getInstance().setCurrentUser(UserDAO.getInstance().get(currentUser.getId()));
        }
        PosPrintService.printDrawerPullReport(report);
        this.updateActionText();
    }

    private Double getReconcileAmount(CashDrawer report) {
        Double reconcileAmount = NumberSelectionDialog2.takeDoubleInput("Enter reconcile amount & tips", "Reconcile", this.assignToUser.isBlindAccountableAmount() != false ? 0.0 : report.getDrawerAccountable());
        if (reconcileAmount.isNaN()) {
            return Double.NaN;
        }
        if (reconcileAmount < report.getDrawerAccountable()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to save partial reconciliation?", "Confirm") == 0) {
                return reconcileAmount;
            }
            return this.getReconcileAmount(report);
        }
        return reconcileAmount;
    }
}

