/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.TicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.List;
import javax.swing.JOptionPane;

public class TicketCloseAction
extends PosAction {
    public TicketCloseAction() {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
    }

    public TicketCloseAction(DataChangeListener listener) {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT, listener);
    }

    @Override
    public void execute() {
        try {
            Object selectedObject = this.getSelectedObject();
            if (selectedObject != null) {
                if (!this.hasPermissionToAccessTicket((Ticket)selectedObject)) {
                    return;
                }
                this.closeSingleTicket(selectedObject);
            } else {
                this.closeMultipleTickets();
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void closeMultipleTickets() {
        List<Ticket> tickets = TicketDAO.getInstance().getTicketsWithSpecificFields(Ticket.PROP_ID, Ticket.PROP_DUE_AMOUNT, Ticket.PROP_TOKEN_NO, Ticket.PROP_TICKET_TABLE_NUMBERS);
        TicketSelectionDialog ticketSelectionDialog = new TicketSelectionDialog(tickets);
        ticketSelectionDialog.setCaption("Select tickets to close");
        ticketSelectionDialog.openFullScreen();
        if (ticketSelectionDialog.isCanceled()) {
            return;
        }
        List<Ticket> selectedTickets = ticketSelectionDialog.getSelectedTickets();
        if (selectedTickets == null) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Are you sure to close tickets?", "Confirmation to close");
        if (option == 0) {
            TicketDAO.closeOrders(selectedTickets.toArray(new Ticket[selectedTickets.size()]));
        }
    }

    private void closeSingleTicket(Object selectedObject) {
        int option;
        Ticket ticket = null;
        ticket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
        if (ticket == null) {
            return;
        }
        if (ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int due = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (due != 0 && (option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Ticket is not fully paid, do you still want to close it?", "Confirm")) != 0) {
            return;
        }
        option = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (option != 0) {
            return;
        }
        OrderController.closeOrder(ticket);
        if (this.listener != null) {
            this.listener.dataChanged(ticket);
        }
    }
}

