/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidPaymentDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class VoidPaymentAction
extends PosAction {
    public VoidPaymentAction() {
        super("VOID PAYMENT");
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
    }

    public VoidPaymentAction(DataChangeListener listener) {
        super("VOID PAYMENT", listener);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
    }

    @Override
    public void execute() {
        try {
            Object selectedObject = this.getSelectedObject();
            if (selectedObject == null) {
                return;
            }
            Ticket ticket = null;
            ticket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
            if (ticket == null) {
                return;
            }
            TicketDAO.getInstance().loadFullTicket(ticket);
            VoidPaymentDialog refundDialog = new VoidPaymentDialog(POSUtil.getFocusedWindow(), ticket);
            refundDialog.setSize(PosUIManager.getSize(800, 600));
            refundDialog.open();
            if (!ticket.isPaid().booleanValue()) {
                new SettleTicketAction(ticket).actionPerformed(null);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }
}

