/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DataResetDialog
extends OkCancelOptionDialog
implements ProgressObserver {
    private JTabbedPane tabPane;
    private JLabel lblProgress;
    private JPanel progressPanel;
    private CheckBoxList chkDataTables = new CheckBoxList();

    public DataResetDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.setTitle("Cleanup DB");
        this.setOkButtonText("Cleanup DB");
        this.setCaption("Cleanup DB");
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout(new BorderLayout());
        ArrayList<String> beans = new ArrayList<String>();
        beans.add("Ticket");
        beans.add("Cash Drawer & Session History");
        beans.add("Inventory Transaction");
        beans.add("Inventory Stock");
        beans.add("Reset Item Stock Avaiable & On Hand Qty");
        beans.add("Purchase Order");
        beans.add("Stock Count");
        this.chkDataTables.setModel(beans);
        this.chkDataTables.selectItems(beans);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        JPanel dataListPanel = new JPanel(new BorderLayout());
        dataListPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        dataListPanel.setBackground(Color.white);
        dataListPanel.add(this.chkDataTables);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Data Table", dataListPanel);
        contentPanel.add(this.tabPane);
        this.progressPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.lblProgress = new JLabel("Deleting..");
        this.progressPanel.add((Component)this.lblProgress, "grow,span,wrap");
        this.progressPanel.setVisible(false);
        contentPanel.add((Component)this.progressPanel, "South");
    }

    @Override
    public void doOk() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Operation cannot be undone.\nAre you sure you want to cleanup db?", POSConstants.CONFIRM) != 0) {
            return;
        }
        this.progressPanel.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                DataResetDialog.this.doResetData();
                if (!StoreUtil.isStoreOpen()) {
                    Application.getInstance().doLogout();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResetData() {
        try {
            this.getButtonPanel().getComponent(0).setEnabled(false);
            this.progressPanel.setVisible(true);
            this.progress(0, "Deleting tables data.. Please wait..");
            try {
                List beanTables = this.chkDataTables.getCheckedValues();
                Iterator iterator = beanTables.iterator();
                while (iterator.hasNext()) {
                    String string;
                    switch (string = (String)iterator.next()) {
                        case "Ticket": {
                            this.doDeleteTickets();
                            break;
                        }
                        case "Cash Drawer & Session History": {
                            this.doDeleteCashDrawerAndSessionHistory();
                            break;
                        }
                        case "Inventory Transaction": {
                            this.doDeleteInventoryTransactions();
                            break;
                        }
                        case "Inventory Stock": {
                            this.doDeleteInventoryStock();
                            break;
                        }
                        case "Reset Item Stock Avaiable & On Hand Qty": {
                            this.doUpdateMenuItemStockQuantity();
                            break;
                        }
                        case "Purchase Order": {
                            this.doDeletePurchaseOrder();
                            break;
                        }
                        case "Stock Count": {
                            this.doDeleteStockCount();
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                BOMessageDialog.showError(e.getMessage());
            }
            this.progress(100, "Complete..");
            this.progressPanel.setVisible(false);
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Successfully clear table data.");
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            BOMessageDialog.showError(e);
            this.progress(0, "Data reset failed");
        }
        finally {
            this.getButtonPanel().getComponent(0).setEnabled(true);
        }
    }

    private void doDeleteCashDrawerAndSessionHistory() {
        ArrayList<String> dataTables0 = new ArrayList<String>();
        dataTables0.add("Terminal set currentCashDrawer=null, assignedUser=null");
        dataTables0.add("User set currentCashDrawer=null");
        this.executeQuery(dataTables0, "update ");
        ArrayList<String> dataTables1 = new ArrayList<String>();
        dataTables1.add("OTHER_REVENUE_CATEGORY");
        this.doDelete(dataTables1, true);
        ArrayList<String> dataTables = new ArrayList<String>();
        dataTables.add("ActionHistory");
        dataTables.add("AttendenceHistory");
        dataTables.add("CashDrawer");
        dataTables.add("CashBreakdown");
        dataTables.add("StoreSessionControl");
        dataTables.add("StoreSession where closeTime!=null");
        this.doDelete(dataTables);
        Application instance = Application.getInstance();
        User user = Application.getCurrentUser();
        AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
        AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
        if (attendenceHistory == null) {
            attendenceHistory = new AttendenceHistory();
            Date lastClockInTime = user.getLastClockInTime();
            Calendar c = Calendar.getInstance();
            c.setTime(lastClockInTime);
            attendenceHistory.setClockInTime(lastClockInTime);
            attendenceHistory.setClockInHour((short)c.get(10));
            attendenceHistory.setUser(user);
            attendenceHistory.setTerminal(Application.getInstance().getTerminal());
            attendenceHistory.setShift(user.getCurrentShift());
        }
        Shift shift = user.getCurrentShift();
        Calendar calendar = Calendar.getInstance();
        user.doClockOut(attendenceHistory, shift, calendar);
        instance.refreshAndGetTerminal();
        instance.refreshCurrentUser();
    }

    private void doUpdateMenuItemStockQuantity() {
        ArrayList<String> sqlList = new ArrayList<String>();
        String sql = String.format("MenuItemInventoryStatus set availableUnit =  %s,unitOnHand = %s", new Double(0.0), new Double(0.0));
        sqlList.add(sql);
        this.executeQuery(sqlList, "update ");
    }

    private void doDeleteTickets() {
        List<Ticket> tickets = TicketDAO.getInstance().findAll();
        for (Ticket ticket : tickets) {
            TicketDAO.getInstance().delete(ticket);
        }
        ArrayList<String> dataSqlTables = new ArrayList<String>();
        dataSqlTables.add("KIT_TICKET_TABLE_NUM");
        this.doDelete(dataSqlTables, true);
        ArrayList<String> dataTables = new ArrayList<String>();
        dataTables.add("VoidItem");
        dataTables.add("KitchenTicketItem");
        dataTables.add("KitchenTicket");
        this.doDelete(dataTables);
    }

    private void doDeletePurchaseOrder() {
        ArrayList<String> dataTables = new ArrayList<String>();
        dataTables.add("PurchaseOrderItem");
        dataTables.add("PurchaseOrder");
        this.doDelete(dataTables);
    }

    private void doDeleteInventoryTransactions() {
        ArrayList<String> dataTables = new ArrayList<String>();
        dataTables.add("InventoryTransaction");
        this.doDelete(dataTables);
    }

    private void doDeleteInventoryStock() {
        ArrayList<String> dataTables = new ArrayList<String>();
        dataTables.add("InventoryStock");
        this.doDelete(dataTables);
    }

    private void doDeleteStockCount() {
        ArrayList<String> dataTables = new ArrayList<String>();
        dataTables.add("StockCountItem");
        dataTables.add("StockCount");
        this.doDelete(dataTables);
    }

    private void doDelete(List<String> dataTables) {
        this.executeQuery(dataTables, "delete from ");
    }

    private void doDelete(List<String> dataTables, boolean tableSql) {
        this.executeQuery(dataTables, "delete from ", tableSql);
    }

    private void executeQuery(List<String> dataTables, String action) {
        this.executeQuery(dataTables, action, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(List<String> dataTables, String action, boolean tableSql) {
        Transaction tx = null;
        Session session = null;
        GenericDAO dao = new GenericDAO();
        try {
            session = dao.createNewSession();
            tx = session.beginTransaction();
            for (String tableClass : dataTables) {
                SQLQuery createQuery;
                String sql = action + tableClass;
                if (tableSql) {
                    createQuery = session.createSQLQuery(sql);
                    createQuery.executeUpdate();
                    continue;
                }
                createQuery = session.createQuery(sql);
                createQuery.executeUpdate();
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            dao.closeSession(session);
        }
    }

    @Override
    public void progress(int percent, String text) {
        this.lblProgress.setText(text);
    }

    @Override
    public void progress(int percent) {
    }

    @Override
    public Component getParentComponent() {
        return POSUtil.getFocusedWindow();
    }

    @Override
    public void progress(String text) {
        this.lblProgress.setText("Deleting... " + text);
    }
}

