/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.Course;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.CourseForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class CourseExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable table;
    private BeanTableModel<Course> tableModel = new BeanTableModel(Course.class);

    public CourseExplorer() {
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), Course.PROP_NAME);
        this.tableModel.addColumn("SHORT NAME", Course.PROP_SHORT_NAME);
        this.tableModel.addColumn(POSConstants.SORT_ORDER.toUpperCase(), Course.PROP_SORT_ORDER);
        this.tableModel.addColumn("ICON", "icon");
        this.table = new JXTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    CourseExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.addButtonPanel();
        this.initData();
    }

    private void addButtonPanel() {
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CourseForm editor = new CourseForm();
                    editor.setExistingCourses(CourseExplorer.this.tableModel.getRows());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setPreferredSize(PosUIManager.getSize(500, 450));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Course foodCategory = (Course)editor.getBean();
                    CourseExplorer.this.tableModel.addRow(foodCategory);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CourseExplorer.this.editSelectedRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = CourseExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = CourseExplorer.this.table.convertRowIndexToModel(index);
                    Course course = (Course)CourseExplorer.this.tableModel.getRow(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    CourseDAO dao = new CourseDAO();
                    dao.delete(course);
                    CourseExplorer.this.tableModel.removeRow(index);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    public void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Course course = this.tableModel.getRow(index);
            CourseForm editor = new CourseForm(course);
            editor.setExistingCourses(this.tableModel.getRows());
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(500, 450));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public void initData() {
        this.tableModel.setRows(CourseDAO.getInstance().findAll());
    }
}

