/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuGroupExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable table;
    private BeanTableModel<MenuGroup> tableModel;

    public MenuGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(MenuGroup.class);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.addColumn(POSConstants.TRANSLATED_NAME.toUpperCase(), "translatedName");
        this.tableModel.addColumn(POSConstants.VISIBLE.toUpperCase(), "visible");
        this.tableModel.addColumn(POSConstants.SORT_ORDER.toUpperCase(), "sortOrder");
        this.tableModel.addColumn(POSConstants.BUTTON_COLOR.toUpperCase(), "buttonColor");
        this.tableModel.addColumn(POSConstants.TEXT_COLOR.toUpperCase(), "textColor");
        this.table = new JXTable(this.tableModel);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuGroupExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.add((Component)this.northRefreshPanel(), "North");
        this.add(new JScrollPane((Component)this.table));
        this.createButtonPanel();
    }

    private JPanel northRefreshPanel() {
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout(""));
        northPanel.setBorder(BorderFactory.createTitledBorder("Refresh"));
        JButton btnRefresh = new JButton(POSConstants.REFRESH);
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuGroupExplorer.this.initData();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        });
        northPanel.add(btnRefresh);
        return northPanel;
    }

    private void createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupExplorer.this.editSelectedRow();
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuGroupForm editor = new MenuGroupForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuGroup foodGroup = (MenuGroup)editor.getBean();
                    MenuGroupExplorer.this.tableModel.addRow(foodGroup);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = MenuGroupExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = MenuGroupExplorer.this.table.convertRowIndexToModel(index);
                    MenuGroup group = (MenuGroup)MenuGroupExplorer.this.tableModel.getRow(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    MenuItemDAO menuItemDao = new MenuItemDAO();
                    boolean hasMenuItems = menuItemDao.existsMenuItem(group);
                    if (hasMenuItems && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuGroupExplorer.0"), POSConstants.DELETE) != 0) {
                        return;
                    }
                    MenuGroupDAO foodGroupDAO = new MenuGroupDAO();
                    foodGroupDAO.releaseParentAndDelete(group);
                    MenuGroupExplorer.this.tableModel.removeRow(index);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuGroup menuGroup = this.tableModel.getRow(index);
            MenuGroupForm editor = new MenuGroupForm(menuGroup);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public void initData() {
        this.tableModel.setRows(MenuGroupDAO.getInstance().findAll());
    }
}

