/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.menuitem.variant.VariantForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class MenuItemExplorer
extends TransparentPanel
implements ExplorerView {
    private MenuItemExplorerTable menuItemExplorerTable;
    private BeanTableModel<MenuItem> tableModel;
    private JComboBox cbCategory;
    private JTextField tfName;
    private JCheckBox cbItem;
    private JButton btnFirst;
    private JButton btnLast;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox cbGroup;
    private boolean variant;
    private JPanel buttonPanel;
    private JPanel buildSearchForm;

    public MenuItemExplorer() {
        this(false);
    }

    public MenuItemExplorer(boolean variant) {
        this.variant = variant;
        this.init();
    }

    private void init() {
        this.tableModel = new BeanTableModel(MenuItem.class, 20);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.addColumn(POSConstants.TRANSLATED_NAME.toUpperCase(), "translatedName");
        this.tableModel.addColumn("BARCODE", "barcode");
        this.tableModel.addColumn("COMBO", MenuItem.PROP_COMBO_ITEM);
        this.tableModel.addColumn("HAS MODIFIER", MenuItem.PROP_HAS_MODIFIERS);
        this.tableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.14"), "availableUnit");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.26"), "unitOnHand");
        this.tableModel.addColumn(POSConstants.VISIBLE.toUpperCase(), "visible");
        this.tableModel.addColumn("TAX GROUP", "taxGroup");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.21"), "sortOrder", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.23"), "buttonColor");
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.25"), "textColor");
        this.tableModel.addColumn(POSConstants.IMAGE.toUpperCase(), "image");
        int iconSize = PosUIManager.getSize(16);
        this.btnFirst = new JButton();
        this.btnFirst.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_PREVIOUS, (float)iconSize));
        this.btnBack = new JButton();
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        this.btnForward = new JButton();
        this.btnForward.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        this.btnLast = new JButton();
        this.btnLast.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_NEXT, (float)iconSize));
        this.lblNumberOfItem = new JLabel();
        this.menuItemExplorerTable = new MenuItemExplorerTable(this.tableModel);
        this.menuItemExplorerTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.menuItemExplorerTable.setSelectionMode(0);
        this.menuItemExplorerTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        IntegerTextField tfEditField = new IntegerTextField();
        tfEditField.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(tfEditField);
        editor.setClickCountToStart(1);
        this.menuItemExplorerTable.setDefaultEditor(this.menuItemExplorerTable.getColumnClass(8), editor);
        this.menuItemExplorerTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.menuItemExplorerTable.setRowHeight(PosUIManager.getSize(30));
        this.menuItemExplorerTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuItemExplorer.this.editSelectedRow();
                }
            }
        });
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.showMenuItems(MenuItemExplorer.this.tableModel.getPreviousRowIndex());
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.showMenuItems(MenuItemExplorer.this.tableModel.getNextRowIndex());
            }
        });
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.showMenuItems(0);
            }
        });
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int totalPage = MenuItemExplorer.this.tableModel.getNumRows() / MenuItemExplorer.this.tableModel.getPageSize();
                MenuItemExplorer.this.showMenuItems(totalPage * MenuItemExplorer.this.tableModel.getPageSize());
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)((Object)this.menuItemExplorerTable)));
        this.buttonPanel = this.createButtonPanel();
        this.add((Component)this.buttonPanel, "South");
        this.buildSearchForm = this.buildSearchForm();
        this.add((Component)this.buildSearchForm, "North");
        this.resizeColumnWidth((JTable)((Object)this.menuItemExplorerTable));
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        try {
            panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
            JLabel lblCategory = new JLabel(Messages.getString("MenuItemExplorer.4"));
            this.cbCategory = new JComboBox();
            this.cbCategory.addItem(Messages.getString("MenuItemExplorer.5"));
            List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAll();
            for (MenuCategory category : categories) {
                this.cbCategory.addItem(category);
            }
            this.cbCategory.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MenuItemExplorer.this.doSelectGroup(e);
                }
            });
            JLabel lblName = new JLabel(Messages.getString("MenuItemExplorer.0"));
            JLabel lblGroup = new JLabel(Messages.getString("MenuItemExplorer.1"));
            this.cbGroup = new JComboBox();
            this.cbGroup.addItem(Messages.getString("MenuItemExplorer.5"));
            this.tfName = new JTextField(15);
            this.cbItem = new JCheckBox(Messages.getString("MenuItemExplorer.13"));
            JButton searchBttn = new JButton(Messages.getString("MenuItemExplorer.3"));
            panel.add((Component)lblName, "align label");
            panel.add(this.tfName);
            panel.add(lblCategory);
            panel.add(this.cbCategory);
            panel.add(lblGroup);
            panel.add(this.cbGroup);
            panel.add(this.cbItem);
            panel.add(searchBttn);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("MenuItemExplorer.30"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuItemExplorer.this.showMenuItems();
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (MenuItemExplorer.this.tfName.getText().length() > 2) {
                        MenuItemExplorer.this.showMenuItems();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        MenuItemExplorer.this.showMenuItems();
                    }
                }
            };
            this.tfName.addKeyListener(keyListener);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    public void setMenuItems(List<MenuItem> items) {
        this.tableModel.removeAll();
        this.buttonPanel.setVisible(false);
        this.buildSearchForm.setVisible(false);
        this.tableModel.addRows(items);
    }

    private void showMenuItems() {
        this.showMenuItems(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMenuItems(Integer rowIndex) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object selectedCategory = this.cbCategory.getSelectedItem();
            String txName = this.tfName.getText();
            Boolean showAll = !this.cbItem.isSelected();
            MenuGroup group = null;
            MenuCategory category = null;
            Object selectedGroup = this.cbGroup.getSelectedItem();
            if (selectedGroup instanceof MenuGroup) {
                group = (MenuGroup)selectedGroup;
            }
            if (selectedCategory instanceof MenuCategory) {
                category = (MenuCategory)selectedCategory;
            }
            if (rowIndex != null) {
                this.tableModel.setCurrentRowIndex(rowIndex);
            }
            MenuItemDAO.getInstance().loadMenuItems(this.tableModel, showAll, group, txName, category, this.variant, false);
            int startNumber = this.tableModel.getCurrentRowIndex() + 1;
            int endNumber = this.tableModel.getNextRowIndex();
            int totalNumber = this.tableModel.getNumRows();
            if (endNumber > totalNumber) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
            this.btnFirst.setEnabled(this.tableModel.hasPrevious());
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
            this.btnLast.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private JPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.setText(Messages.getString("MenuItemExplorer.17"));
        editButton.setText(Messages.getString("MenuItemExplorer.18"));
        deleteButton.setText(Messages.getString("MenuItemExplorer.19"));
        JButton updateStockAmount = new JButton("UPDATE STOCK AMOUNT");
        updateStockAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doUpdateStockAmount();
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.editSelectedRow();
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doCreateNewMenuItem();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doDeleteMenuItem();
            }
        });
        JButton btnDuplicate = new JButton("DUPLICATE");
        btnDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuItemExplorer.this.doDuplicateMenuItem();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel actionButtonPanel = new TransparentPanel();
        if (!this.variant) {
            actionButtonPanel.add(addButton);
        }
        actionButtonPanel.add(editButton);
        actionButtonPanel.add(updateStockAmount);
        if (!this.variant) {
            actionButtonPanel.add(deleteButton);
            actionButtonPanel.add(btnDuplicate);
        }
        this.addInventoryButtonActions(actionButtonPanel);
        bottomPanel.add((Component)actionButtonPanel, "");
        JPanel navigationPanel = new JPanel(new FlowLayout(4));
        navigationPanel.add(this.lblNumberOfItem);
        navigationPanel.add(this.btnFirst);
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        navigationPanel.add(this.btnLast);
        bottomPanel.add((Component)navigationPanel, "grow");
        return bottomPanel;
    }

    private void addInventoryButtonActions(JPanel panel) {
        JButton inTransactionButton = new JButton("IN");
        JButton outTransactionButton = new JButton("OUT");
        JButton transferTransactionButton = new JButton("TRANSFER");
        inTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doShowStockInDialog(InventoryTransactionType.IN);
            }
        });
        outTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doAdjustStock(InventoryTransactionType.OUT, false);
            }
        });
        transferTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemExplorer.this.doAdjustStock(InventoryTransactionType.UNCHANGED, true);
            }
        });
        panel.add(inTransactionButton);
        panel.add(outTransactionButton);
        panel.add(transferTransactionButton);
    }

    private boolean doAdjustStock(InventoryTransactionType type, boolean transfer) {
        MenuItem menuItem = this.getSelectedItem();
        if (menuItem == null) {
            POSMessageDialog.showError(this, "Please select a row first");
            return false;
        }
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        if (transfer) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog dialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        dialog.setPreferredSize(PosUIManager.getSize(500, 500));
        dialog.open();
        return !dialog.isCanceled();
    }

    private boolean doShowStockInDialog(InventoryTransactionType type) {
        MenuItem menuItem = this.getSelectedItem();
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        InventoryStockInForm editor = null;
        if (menuItem == null) {
            editor = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            InventoryUnit unit = menuItem.getUnit();
            if (unit == null) {
                POSMessageDialog.showError(this, "No unit is set for the item. Please set item unit first.");
                return false;
            }
            Double replenishLevel = menuItem.getReplenishLevel();
            inventoryTransaction.setQuantity(replenishLevel);
            Double cost = menuItem.getCost();
            inventoryTransaction.setUnitCost(cost);
            inventoryTransaction.setTotal(replenishLevel * cost);
            inventoryTransaction.setUnit(menuItem.getUnit().getCode());
            editor = new InventoryStockInForm(inventoryTransaction);
        }
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.openWithScale(830, 630);
        if (dialog.isCanceled()) {
            return false;
        }
        this.showMenuItems();
        return true;
    }

    private MenuItem getSelectedItem() {
        int index = this.menuItemExplorerTable.getSelectedRow();
        MenuItem menuItem = null;
        if (index >= 0) {
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            menuItem = this.tableModel.getRow(index);
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        return menuItem;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(180);
        columnWidth.add(90);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(80);
        columnWidth.add(80);
        columnWidth.add(50);
        columnWidth.add(140);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(200);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            MenuItem menuItem = this.tableModel.getRow(index);
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            if (this.variant) {
                VariantForm editor = new VariantForm(menuItem);
                BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                this.doCreateSaveButtons(editor, dialog);
                dialog.openWithScale(1000, 700);
                if (!dialog.isCanceled()) {
                    this.tableModel.setRow(index, menuItem);
                    this.tableModel.fireTableRowsUpdated(index, index);
                }
            } else {
                MenuItemForm editor = new MenuItemForm(menuItem);
                BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), editor, true);
                dialog.openWithScale(1000, 700);
                if (!dialog.isCanceled()) {
                    this.tableModel.setRow(index, menuItem);
                    this.tableModel.fireTableRowsUpdated(index, index);
                }
            }
        }
        catch (Throwable x) {
            BOMessageDialog.showError(this, x.getMessage(), x);
        }
    }

    private void doCreateSaveButtons(final VariantForm editor, final BeanEditorDialog dialog) {
        PosButton btnSaveAndClose = new PosButton("SAVE");
        btnSaveAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!editor.save()) {
                    return;
                }
                dialog.dispose();
            }
        });
        PosButton btnOk = (PosButton)dialog.getButtonPanel().getComponent(0);
        btnOk.setText("<html><center>SAVE &<br> CLOSE</center></html>");
        PosButton btnClose = (PosButton)dialog.getButtonPanel().getComponent(1);
        btnClose.setText("CLOSE");
        dialog.getButtonPanel().add((Component)btnSaveAndClose, 0);
    }

    private void doUpdateStockAmount() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, "Please select a row to update stock amount");
                return;
            }
            MenuItem menuItem = this.tableModel.getRow(index);
            String amountString = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.8"), menuItem.getAvailableUnit());
            if (amountString == null || amountString.equals("")) {
                return;
            }
            double stockAmount = Double.parseDouble(amountString);
            if (stockAmount < 0.0) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.10"));
                return;
            }
            menuItem.setAvailableUnit(stockAmount);
            MenuItemInventoryStatusDAO.getInstance().saveOrUpdate(menuItem.getStockStatus());
            this.menuItemExplorerTable.repaint();
        }
        catch (NumberFormatException e1) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.11"));
            return;
        }
        catch (Exception e2) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, e2);
            return;
        }
    }

    private void doCreateNewMenuItem() {
        try {
            MenuItem menuItem = new MenuItem();
            Object selectedType = this.cbCategory.getSelectedItem();
            if (selectedType instanceof OrderType) {
                ArrayList<OrderType> types = new ArrayList<OrderType>();
                types.add((OrderType)selectedType);
                menuItem.setOrderTypeList(types);
            }
            MenuItemForm editor = new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), editor, true);
            dialog.openWithScale(1000, 700);
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem foodItem = (MenuItem)editor.getBean();
            this.tableModel.addRow(foodItem);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteMenuItem() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToDelete"));
                return;
            }
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItem item = this.tableModel.getRow(index);
            MenuItemDAO dao = MenuItemDAO.getInstance();
            dao.refresh(item);
            dao.releaseParentAndDelete(item);
            this.tableModel.removeRow(index);
        }
        catch (ConstraintViolationException ex) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This menu item is in use and cannot be deleted.");
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public void initData() {
        this.showMenuItems();
        List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup group : groups) {
            this.cbGroup.addItem(group);
        }
    }

    private void doSelectGroup(ItemEvent e) {
        try {
            Object item = e.getItem();
            this.cbGroup.removeAllItems();
            this.cbGroup.addItem(Messages.getString("MenuItemExplorer.5"));
            if (item instanceof MenuCategory) {
                MenuCategory category = (MenuCategory)item;
                List<MenuGroup> groups = MenuGroupDAO.getInstance().findByParent(category);
                for (MenuGroup group : groups) {
                    this.cbGroup.addItem(group);
                }
            } else {
                List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
                for (MenuGroup group : groups) {
                    this.cbGroup.addItem(group);
                }
            }
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void doDuplicateMenuItem() throws Exception {
        int index = this.menuItemExplorerTable.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showError(this, "Please select a row to make duplicate");
            return;
        }
        index = this.menuItemExplorerTable.convertRowIndexToModel(index);
        MenuItem existingMenuItem = this.tableModel.getRow(index);
        MenuItemDAO.getInstance().initialize(existingMenuItem);
        MenuItem newMenuItem = existingMenuItem.clone();
        MenuItemForm editor = new MenuItemForm(newMenuItem);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.openWithScale(1000, 700);
        if (dialog.isCanceled()) {
            return;
        }
        MenuItem menuItem = (MenuItem)editor.getBean();
        this.tableModel.addRow(menuItem);
        this.menuItemExplorerTable.getSelectionModel().addSelectionInterval(this.tableModel.getRowCount() - 1, this.tableModel.getRowCount() - 1);
        this.menuItemExplorerTable.scrollRowToVisible(this.tableModel.getRowCount() - 1);
    }

    private class MenuItemExplorerTable
    extends JXTable {
        public MenuItemExplorerTable(TableModel dm) {
            super(dm);
        }

        public void changeSelection(int row, int column, boolean toggle, boolean extend) {
            super.changeSelection(row, column, toggle, extend);
            MenuItemExplorer.this.menuItemExplorerTable.editCellAt(row, column);
            DefaultCellEditor editor = (DefaultCellEditor)MenuItemExplorer.this.menuItemExplorerTable.getCellEditor(row, column);
            if (editor.getComponent() instanceof IntegerTextField) {
                IntegerTextField textField = (IntegerTextField)editor.getComponent();
                textField.requestFocus();
                textField.selectAll();
            }
        }

        public void setValueAt(Object sortOrderObj, int row, int column) {
            MenuItem menuItem = (MenuItem)MenuItemExplorer.this.tableModel.getRow(row);
            Integer sOrder = 0;
            if (sortOrderObj != null && sortOrderObj instanceof Integer) {
                sOrder = (Integer)sortOrderObj;
            }
            super.setValueAt((Object)sOrder, row, column);
            if (column == 10) {
                menuItem.setSortOrder(sOrder);
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            }
        }
    }
}

