/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class PizzaModifierGroupExplorer
extends TransparentPanel {
    private List<ModifierGroup> mGroupList;
    private JXTable table;
    private ModifierGroupExplorerTableModel tableModel;

    public PizzaModifierGroupExplorer() {
        ModifierGroupDAO dao = new ModifierGroupDAO();
        dao.updateModifierGroupBooleanPropertyValue(true);
        this.mGroupList = dao.findPizzaModifierGroups();
        this.tableModel = new ModifierGroupExplorerTableModel();
        this.table = new JXTable((TableModel)this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        TransparentPanel panel = new TransparentPanel();
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = PizzaModifierGroupExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    index = PizzaModifierGroupExplorer.this.table.convertRowIndexToModel(index);
                    ModifierGroup category = (ModifierGroup)PizzaModifierGroupExplorer.this.mGroupList.get(index);
                    ModifierGroupForm editor = new ModifierGroupForm(category, (Boolean)true);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    PizzaModifierGroupExplorer.this.table.repaint();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModifierGroupForm editor = new ModifierGroupForm(new ModifierGroup(), (Boolean)true);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    ModifierGroup modifierGroup = (ModifierGroup)editor.getBean();
                    PizzaModifierGroupExplorer.this.tableModel.addModifierGroup(modifierGroup);
                }
                catch (Throwable x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = PizzaModifierGroupExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = PizzaModifierGroupExplorer.this.table.convertRowIndexToModel(index);
                    if (ConfirmDeleteDialog.showMessage(PizzaModifierGroupExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        ModifierGroup category = (ModifierGroup)PizzaModifierGroupExplorer.this.mGroupList.get(index);
                        ModifierGroupDAO modifierCategoryDAO = new ModifierGroupDAO();
                        modifierCategoryDAO.delete(category);
                        PizzaModifierGroupExplorer.this.tableModel.deleteModifierGroup(category, index);
                    }
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    try {
                        int index = PizzaModifierGroupExplorer.this.table.getSelectedRow();
                        if (index < 0) {
                            return;
                        }
                        index = PizzaModifierGroupExplorer.this.table.convertRowIndexToModel(index);
                        ModifierGroup category = (ModifierGroup)PizzaModifierGroupExplorer.this.mGroupList.get(index);
                        ModifierGroupForm editor = new ModifierGroupForm(category, (Boolean)true);
                        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                        dialog.open();
                        if (dialog.isCanceled()) {
                            return;
                        }
                        PizzaModifierGroupExplorer.this.table.repaint();
                    }
                    catch (Throwable x) {
                        BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                    }
                }
            }
        });
    }

    class ModifierGroupExplorerTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.MODIFIERS};

        ModifierGroupExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (PizzaModifierGroupExplorer.this.mGroupList == null) {
                return 0;
            }
            return PizzaModifierGroupExplorer.this.mGroupList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (PizzaModifierGroupExplorer.this.mGroupList == null) {
                return "";
            }
            ModifierGroup mgroup = (ModifierGroup)PizzaModifierGroupExplorer.this.mGroupList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return mgroup.getName();
                }
                case 1: {
                    return mgroup.getTranslatedName();
                }
                case 2: {
                    return mgroup.getModifiers().toString();
                }
            }
            return null;
        }

        public void addModifierGroup(ModifierGroup category) {
            int size = PizzaModifierGroupExplorer.this.mGroupList.size();
            PizzaModifierGroupExplorer.this.mGroupList.add(category);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteModifierGroup(ModifierGroup category, int index) {
            PizzaModifierGroupExplorer.this.mGroupList.remove(category);
            this.fireTableRowsDeleted(index, index);
        }
    }
}

