/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TaxSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class TaxGroupExplorer
extends TransparentPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JXTreeTable treeTable;
    private TaxGroupTreeTableModel noRootTreeTableModel;
    private List<TaxGroup> rootGroupList;

    public TaxGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.treeTable = new JXTreeTable();
        this.treeTable.setRowHeight(PosUIManager.getSize(30));
        this.treeTable.setRootVisible(false);
        this.rootGroupList = TaxGroupDAO.getInstance().findAll();
        this.createTree();
        this.treeTable.expandAll();
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int col = TaxGroupExplorer.this.treeTable.columnAtPoint(me.getPoint());
                if (me.getClickCount() == 2 && col == 0) {
                    TaxGroupExplorer.this.treeTable.expandPath(TaxGroupExplorer.this.treeTable.getPathForRow(TaxGroupExplorer.this.treeTable.getSelectedRow()));
                } else if (me.getClickCount() == 2 && col != 0) {
                    TaxGroupExplorer.this.editSelectedRow();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.treeTable), "Center");
        this.createButtonPanel();
        this.treeTable.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
    }

    private void createTree() {
        if (this.rootGroupList != null) {
            TaxGroup demo = new TaxGroup();
            demo.setId("0");
            demo.setName("Root");
            DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode((Object)demo);
            rootNode.setUserObject((Object)demo);
            for (TaxGroup inventoryGroup : this.rootGroupList) {
                DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryGroup);
                rootNode.add((MutableTreeTableNode)node);
                this.buildTaxTree(node);
            }
            this.noRootTreeTableModel = new TaxGroupTreeTableModel(rootNode);
            this.treeTable.setTreeTableModel((TreeTableModel)this.noRootTreeTableModel);
        }
    }

    private void buildTaxTree(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        TaxGroup attributeGroup = (TaxGroup)defaultMutableTreeTableNode.getUserObject();
        if (attributeGroup == null) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<Tax> attributeList = attributeGroup.getTaxes();
        for (Tax tax : attributeList) {
            DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)tax);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)node);
        }
    }

    private void createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btn_newGroup = new JButton("New Tax Group");
        JButton btn_newTax = new JButton("Add Tax");
        JButton editButton = explorerButton.getEditButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        btn_newGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)"Enter group name");
                if (groupName == null) {
                    return;
                }
                if (groupName.equals("")) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name cannot be empty.");
                    return;
                }
                if (groupName.length() > 30) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name too long.");
                    return;
                }
                TaxGroup inventoryGroup = new TaxGroup();
                inventoryGroup.setName(groupName);
                TaxGroupDAO inventoryGroupDAO = new TaxGroupDAO();
                inventoryGroupDAO.saveOrUpdate(inventoryGroup);
                if (inventoryGroup != null) {
                    MutableTreeTableNode root = (MutableTreeTableNode)TaxGroupExplorer.this.noRootTreeTableModel.getRoot();
                    TaxGroupExplorer.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)inventoryGroup), root, root.getChildCount());
                }
                TaxGroupExplorer.this.treeTable.expandAll();
            }
        });
        btn_newTax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxGroup selectedGroup = TaxGroupExplorer.this.getSelectedGroup();
                if (selectedGroup == null) {
                    POSMessageDialog.showError(TaxGroupExplorer.this, "Please select tax group");
                } else {
                    TaxSelectionDialog dialog = new TaxSelectionDialog(selectedGroup);
                    dialog.setSize(500, 400);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    List<Tax> taxes = dialog.getSelectedTaxList();
                    selectedGroup.setTaxes(taxes);
                    TaxGroupDAO.getInstance().saveOrUpdate(selectedGroup);
                    TaxGroupExplorer.this.rootGroupList = TaxGroupDAO.getInstance().findAll();
                    TaxGroupExplorer.this.createTree();
                    TaxGroupExplorer.this.treeTable.expandAll();
                }
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxGroupExplorer.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.deleteInventoryTax();
            }

            private void deleteInventoryTax() {
                try {
                    int index = TaxGroupExplorer.this.treeTable.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    TreePath treePath = TaxGroupExplorer.this.treeTable.getPathForRow(index);
                    DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    if (lastPathComponent.getUserObject() instanceof TaxGroup) {
                        TaxGroup taxGroup = (TaxGroup)lastPathComponent.getUserObject();
                        String message = "Are you sure to delete tax group '%s'?";
                        message = String.format(message, taxGroup.getName());
                        if (POSMessageDialog.showYesNoQuestionDialog(TaxGroupExplorer.this.getRootPane(), message, POSConstants.DELETE) != 0) {
                            return;
                        }
                        TaxGroupDAO inventoryGroupDAO = new TaxGroupDAO();
                        inventoryGroupDAO.delete(taxGroup);
                        MutableTreeTableNode tableNode = TaxGroupExplorer.this.findTreeNodeForTax((MutableTreeTableNode)TaxGroupExplorer.this.noRootTreeTableModel.getRoot(), taxGroup.getId());
                        if (tableNode.getParent() != null) {
                            TaxGroupExplorer.this.noRootTreeTableModel.removeNodeFromParent(tableNode);
                        }
                    } else if (lastPathComponent.getUserObject() instanceof Tax) {
                        Tax tax = (Tax)lastPathComponent.getUserObject();
                        TaxGroup taxGroup = (TaxGroup)lastPathComponent.getParent().getUserObject();
                        String message = "Are you sure to delete tax '%s' from group '%s'?";
                        message = String.format(message, tax.getName(), taxGroup.getName());
                        if (POSMessageDialog.showYesNoQuestionDialog(TaxGroupExplorer.this.getRootPane(), message, POSConstants.DELETE) != 0) {
                            return;
                        }
                        taxGroup.getTaxes().remove(tax);
                        TaxGroupDAO.getInstance().update(taxGroup);
                        MutableTreeTableNode tableNode = TaxGroupExplorer.this.findTreeNodeForTax((MutableTreeTableNode)TaxGroupExplorer.this.noRootTreeTableModel.getRoot(), tax.getId());
                        if (tableNode.getParent() != null) {
                            TaxGroupExplorer.this.noRootTreeTableModel.removeNodeFromParent(tableNode);
                        }
                    }
                    TaxGroupExplorer.this.treeTable.repaint();
                    TaxGroupExplorer.this.treeTable.revalidate();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(btn_newGroup);
        panel.add(btn_newTax);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    private void editSelectedRow() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (lastPathComponent.getUserObject() instanceof TaxGroup) {
                TaxGroup attributeGroup = (TaxGroup)lastPathComponent.getUserObject();
                String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), "Group name", attributeGroup.getName());
                if (groupName == null) {
                    return;
                }
                if (groupName.isEmpty()) {
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name cannot be empty.");
                    return;
                }
                if (groupName.length() > 30) {
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name too long.");
                    return;
                }
                attributeGroup.setName(groupName);
                TaxGroupDAO inventoryGroupDAO = new TaxGroupDAO();
                inventoryGroupDAO.saveOrUpdate(attributeGroup);
            } else if (lastPathComponent.getUserObject() instanceof Tax) {
                POSMessageDialog.showError(this, "Please select the tax group to edit.");
                return;
            }
            this.rootGroupList = TaxGroupDAO.getInstance().findAll();
            this.createTree();
            this.treeTable.expandAll();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public Tax getSelectedAtrribute() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                return null;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (lastPathComponent.getUserObject() instanceof TaxGroup) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select tax");
                return null;
            }
            if (lastPathComponent.getUserObject() instanceof Tax) {
                return (Tax)lastPathComponent.getUserObject();
            }
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return null;
    }

    public TaxGroup getSelectedGroup() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                return null;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (lastPathComponent.getUserObject() instanceof TaxGroup) {
                return (TaxGroup)lastPathComponent.getUserObject();
            }
            if (lastPathComponent.getUserObject() instanceof Tax) {
                return (TaxGroup)lastPathComponent.getParent().getUserObject();
            }
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return null;
    }

    public MutableTreeTableNode findTreeNodeForTax(MutableTreeTableNode attributeNode, String attributeId) {
        block5: {
            block4: {
                if (!(((DefaultMutableTreeTableNode)attributeNode).getUserObject() instanceof TaxGroup)) break block4;
                TaxGroup groupTax = (TaxGroup)attributeNode.getUserObject();
                if (attributeId.equals(groupTax.getId())) {
                    return attributeNode;
                }
                Enumeration children = attributeNode.children();
                while (children.hasMoreElements()) {
                    MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
                    MutableTreeTableNode findAttById = this.findTreeNodeForTax(treeTableNode, attributeId);
                    if (findAttById == null) continue;
                    return findAttById;
                }
                break block5;
            }
            if (!(((DefaultMutableTreeTableNode)attributeNode).getUserObject() instanceof Tax)) break block5;
            Tax attributeTax = (Tax)attributeNode.getUserObject();
            if (attributeId.equals(attributeTax.getId())) {
                return attributeNode;
            }
            Enumeration children = attributeNode.children();
            while (children.hasMoreElements()) {
                MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
                MutableTreeTableNode findAttById = this.findTreeNodeForTax(treeTableNode, attributeId);
                if (findAttById == null) continue;
                return findAttById;
            }
        }
        return null;
    }

    class TaxGroupTreeTableModel
    extends DefaultTreeTableModel {
        private final String[] COLUMN_NAMES;

        public TaxGroupTreeTableModel(DefaultMutableTreeTableNode rootTax) {
            super((TreeTableNode)rootTax);
            this.COLUMN_NAMES = new String[]{"Group", "Name", "Rate"};
        }

        public void setRoot(TreeTableNode root) {
            super.setRoot(root);
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public Object getValueAt(Object node, int column) {
            if (node instanceof DefaultMutableTreeTableNode) {
                if (((DefaultMutableTreeTableNode)node).getUserObject() instanceof TaxGroup) {
                    TaxGroup inventoryTax = (TaxGroup)((DefaultMutableTreeTableNode)node).getUserObject();
                    if (inventoryTax == null) {
                        return "";
                    }
                    switch (column) {
                        case 0: {
                            return inventoryTax.getName();
                        }
                    }
                } else if (((DefaultMutableTreeTableNode)node).getUserObject() instanceof Tax) {
                    Tax tax = (Tax)((DefaultMutableTreeTableNode)node).getUserObject();
                    if (tax == null) {
                        return "";
                    }
                    switch (column) {
                        case 1: {
                            return tax.getName();
                        }
                        case 2: {
                            return NumberUtil.trimDecilamIfNotNeeded(tax.getRate()) + "% ";
                        }
                    }
                }
            }
            return null;
        }
    }
}

