/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.actions.TerminalConfigurationAction;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class TerminalExplorer
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<Terminal> tableModel;

    public TerminalExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(Terminal.class);
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.0"), "id");
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.2"), "name");
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.4"), "department");
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.12"), "location");
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.10"), "hasCashDrawer");
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.1"), Terminal.PROP_IS_AUTO_LOG_OFF_ENABLED);
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.18"), "defaultPassLength");
        this.tableModel.addColumn(Messages.getString("TerminalExplorer.5"), "active");
        this.tableModel.addRows(TerminalDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    TerminalExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.getColumn(0).setCellRenderer(new IconRenderer());
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalExplorer.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = TerminalExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = TerminalExplorer.this.table.convertRowIndexToModel(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    Terminal term = (Terminal)TerminalExplorer.this.tableModel.getRow(index);
                    TerminalDAO termDao = new TerminalDAO();
                    termDao.delete(term);
                    TerminalExplorer.this.tableModel.removeRow(index);
                }
                catch (ConstraintViolationException ex) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This menu item is in use and cannot be deleted.");
                }
                catch (Exception x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        return panel;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Terminal terminal = this.tableModel.getRow(index);
            terminal = TerminalDAO.getInstance().initialize(terminal);
            this.tableModel.setRow(index, terminal);
            TerminalConfigurationAction action = new TerminalConfigurationAction(terminal);
            action.actionPerformed(null);
            this.table.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Terminal terminal = Application.getInstance().getTerminal();
            Terminal terminal2 = (Terminal)TerminalExplorer.this.tableModel.getRow(row);
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(null);
            if (terminal.equals(terminal2)) {
                label.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
                return label;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

