/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.menudesigner.PageItemActionSelectorDialog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class MenuPageDesignView
extends TransparentPanel {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 5;
    private List<MenuPageItem> items;
    private Dimension buttonSize;
    private MenuPage menuPage;
    private JPanel buttonPanelContainer = new JPanel((LayoutManager)new MigLayout("center,wrap 4"));
    private PageSelectionListener pageListener;
    private Integer cols;
    private Integer rows;
    private MenuPageItem dropItem = null;

    public MenuPageDesignView() {
        this.buttonSize = new Dimension(TerminalConfig.getMenuItemButtonWidth(), TerminalConfig.getMenuItemButtonHeight());
        TitledBorder border = new TitledBorder(POSConstants.ITEMS);
        border.setTitleJustification(2);
        this.setBorder(new CompoundBorder(border, new EmptyBorder(2, 2, 2, 2)));
        this.setLayout(new BorderLayout(5, 5));
        this.buttonPanelContainer.setBackground(Color.GRAY);
        this.buttonPanelContainer.setOpaque(true);
        this.add(this.buttonPanelContainer);
    }

    public void setPageListener(PageSelectionListener listener) {
        this.pageListener = listener;
    }

    public void setPageListener() {
    }

    public MenuPage getMenuPage() {
        return this.menuPage;
    }

    public void setMenuPage(MenuPage menuPage) {
        this.menuPage = menuPage;
        this.reset();
        try {
            if (menuPage == null) {
                return;
            }
            MenuPageDAO.getInstance().initialize(menuPage);
            this.cols = menuPage.getCols();
            if (this.cols <= 0) {
                this.cols = 4;
            }
            this.rows = menuPage.getRows();
            if (this.rows <= 0) {
                this.rows = 4;
            }
            MigLayout migLayout = new MigLayout("center,wrap " + this.cols);
            if (menuPage.isFlixibleButtonSize().booleanValue()) {
                migLayout.setLayoutConstraints((Object)"fill");
                migLayout.setColumnConstraints((Object)"fill,grow");
                migLayout.setRowConstraints((Object)"fill,grow");
            }
            this.buttonPanelContainer.setLayout((LayoutManager)migLayout);
            this.items = menuPage.getPageItems();
            this.renderItems();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void setMenuItems(List<MenuPageItem> items) {
        this.items = items;
        this.renderItems();
    }

    protected void renderItems() {
        try {
            String cellKey;
            this.reset();
            if (this.items == null) {
                this.items = new ArrayList<MenuPageItem>();
            }
            HashMap<String, ItemButton> cellItemMap = new HashMap<String, ItemButton>();
            for (int row = 0; row < this.rows; ++row) {
                for (int col = 0; col < this.cols; ++col) {
                    cellKey = String.valueOf(col) + String.valueOf(row);
                    MenuPageItem itemForCell = this.getMenuPageItemForCell(col, row, this.items);
                    ItemButton itemButton = (ItemButton)this.createItemButton(itemForCell);
                    cellItemMap.put(cellKey, itemButton);
                    String constraint = String.format("cell %s %s", col, row);
                    if (!this.menuPage.isFlixibleButtonSize().booleanValue()) {
                        constraint = constraint + String.format(", w %s!, h %s!", this.menuPage.getButtonWidth(), this.menuPage.getButtonHeight());
                    }
                    this.buttonPanelContainer.add((Component)itemButton, constraint);
                }
            }
            for (MenuPageItem item : this.items) {
                cellKey = String.valueOf(item.getCol()) + String.valueOf(item.getRow());
                ItemButton itemCellButton = (ItemButton)cellItemMap.get(cellKey);
                if (itemCellButton == null) continue;
                itemCellButton.setMenuItem(item.getMenuItem());
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public void reset() {
        this.buttonPanelContainer.removeAll();
    }

    public void fillSelectedPageItems(List<MenuPageItem> items) {
        int count = 0;
        for (int i = 0; i < this.buttonPanelContainer.getComponents().length; ++i) {
            ItemButton button = (ItemButton)this.buttonPanelContainer.getComponent(i);
            if (button.isEmptyItem()) {
                MenuPageItem pageItem = items.get(count);
                button.setMenuItem(pageItem.getMenuItem());
                ++count;
            }
            if (count == items.size()) break;
        }
    }

    protected AbstractButton createItemButton(Object item) {
        MenuPageItem menuPageItem = (MenuPageItem)item;
        ItemButton itemButton = new ItemButton(menuPageItem);
        return itemButton;
    }

    public void resetPage() {
        for (int i = 0; i < this.buttonPanelContainer.getComponents().length; ++i) {
            MenuPageItem pageItem;
            ItemButton button = (ItemButton)this.buttonPanelContainer.getComponent(i);
            if (button.isEmptyItem() || (pageItem = button.menuPageItem).getId() != null) continue;
            button.setMenuItem(null);
        }
        this.revalidate();
        this.repaint();
    }

    private MenuPageItem getMenuPageItemForCell(int col, int row, List<MenuPageItem> pageItems) {
        for (MenuPageItem menuPageItem : pageItems) {
            if (menuPageItem.getCol() != col || menuPageItem.getRow() != row) continue;
            return menuPageItem;
        }
        MenuPageItem itemForCell = new MenuPageItem(col, row);
        itemForCell.setMenuPage(this.menuPage);
        return itemForCell;
    }

    public class ItemButton
    extends PosButton
    implements MouseMotionListener,
    MouseListener,
    Transferable {
        MenuPageItem menuPageItem;
        private DataFlavor dataFlavor = new DataFlavor(MenuPageItem.class, "menuPageItem");
        private final DataFlavor[] flavors = new DataFlavor[]{this.dataFlavor};
        private DragAndDropTransferHandler dragDropTransferHandler;

        ItemButton(MenuPageItem menuPageItem) {
            this.menuPageItem = menuPageItem;
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setIconTextGap(0);
            this.setText("+");
            this.setPreferredSize(MenuPageDesignView.this.buttonSize);
            this.updateView();
            this.dragDropTransferHandler = new DragAndDropTransferHandler(this);
            this.setTransferHandler(this.dragDropTransferHandler);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        int getRow() {
            return this.menuPageItem.getRow();
        }

        int getCol() {
            return this.menuPageItem.getCol();
        }

        public void setMenuPageItem(MenuPageItem item) {
            this.menuPageItem = item;
        }

        public void setMenuItem(MenuItem menuItem) {
            this.menuPageItem.setMenuItem(menuItem);
            this.menuPageItem.setMenuPage(MenuPageDesignView.this.menuPage);
            this.updateView();
        }

        public boolean isEmptyItem() {
            return this.menuPageItem.getMenuItem() == null;
        }

        public void updateView() {
            Color textColor;
            MenuItem menuItem = this.menuPageItem.getMenuItem();
            if (menuItem == null) {
                this.setIcon(null);
                this.setBackground(UIManager.getColor("control"));
                this.setForeground(Color.BLACK);
                this.setText("<html><body><center>+</center></body></html>");
                return;
            }
            ImageIcon image = menuItem.getImage();
            if (image != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setText("");
                    this.setIcon(image);
                } else {
                    this.setIcon(image);
                    this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItem.getName() + "</center></body></html>");
            }
            Color buttonColor = menuItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            }
            if ((textColor = menuItem.getTextColor()) != null) {
                this.setForeground(textColor);
            }
        }

        private void doSelectMenuItem() {
            try {
                MenuItem menuItem = this.menuPageItem.getMenuItem();
                ArrayList<MenuItem> existingItems = new ArrayList<MenuItem>();
                if (menuItem != null) {
                    existingItems.add(menuItem);
                }
                if (menuItem == null) {
                    menuItem = this.doAddMenuItem();
                    if (menuItem == null) {
                        return;
                    }
                } else {
                    PageItemActionSelectorDialog dialog = new PageItemActionSelectorDialog(this.menuPageItem);
                    dialog.setSize(PosUIManager.getSize(500, 350));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    String actionCommand = dialog.getActionCommand();
                    if (actionCommand.equals("REPLACE")) {
                        menuItem = this.doAddMenuItem();
                        if (menuItem == null) {
                            return;
                        }
                    } else if (actionCommand.equals("EDIT")) {
                        this.doEditMenuPageItem(menuItem);
                    } else if (actionCommand.equals("DETACH")) {
                        menuItem = null;
                    }
                }
                this.menuPageItem.setMenuItem(menuItem);
                this.menuPageItem.setMenuPage(MenuPageDesignView.this.menuPage);
                this.updateView();
                if (MenuPageDesignView.this.pageListener == null) {
                    return;
                }
                MenuPageDesignView.this.menuPage.addTopageItems(this.menuPageItem);
                this.menuPageItem.setMenuPage(MenuPageDesignView.this.menuPage);
                MenuPageDesignView.this.pageListener.itemSelected(this.menuPageItem);
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "Select Menu Item Eror!", e);
            }
        }

        private MenuItem doAddMenuItem() {
            MenuItemSelectionDialog dialog = MenuItemSelectionDialog.getInstance();
            dialog.setSelectionMode(0);
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return null;
            }
            return dialog.getSelectedRowData();
        }

        public void doReplaceMenuPageItem(MenuItem menuItem) {
            try {
                menuItem = this.doAddMenuItem();
                if (menuItem == null) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
        }

        private void doEditMenuPageItem(MenuItem menuItem) {
            try {
                MenuItemDAO.getInstance().initialize(menuItem);
                MenuItemForm editor = new MenuItemForm(menuItem);
                BeanEditorDialog formDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                formDialog.openWithScale(1000, 700);
                if (formDialog.isCanceled()) {
                    return;
                }
                for (MenuPageItem mPageItem : MenuPageDesignView.this.items) {
                    if (mPageItem.getId() == null || !mPageItem.getMenuItemId().equals(this.menuPageItem.getMenuItemId())) continue;
                    mPageItem.setMenuItem(null);
                    MenuPageItemDAO.getInstance().refresh(mPageItem);
                }
                MenuPageDesignView.this.renderItems();
            }
            catch (Exception e) {
                POSMessageDialog.showError(this, e.getMessage(), e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                ItemButton itemButton = (ItemButton)e.getSource();
                TransferHandler transferHandler = itemButton.getTransferHandler();
                transferHandler.exportAsDrag(itemButton, e, 2);
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doSelectMenuItem();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!flavor.equals(this.flavors[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.dataFlavor)) {
                return this.menuPageItem;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public class DragAndDropTransferHandler
    extends TransferHandler {
        private ItemButton itemButton = null;

        public DragAndDropTransferHandler(ItemButton itemButton) {
            this.itemButton = itemButton;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return this.itemButton;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(this.itemButton.dataFlavor);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
            try {
                if (source instanceof ItemButton && MenuPageDesignView.this.dropItem != null) {
                    this.itemButton.setMenuPageItem(MenuPageDesignView.this.dropItem);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> pageItems = menuPage.getPageItems();
                    for (MenuPageItem menuPageItem : pageItems) {
                        if (menuPageItem == null || !menuPageItem.getRandomId().equals(MenuPageDesignView.this.dropItem.getRandomId())) continue;
                        menuPageItem.setRow(this.itemButton.getRow());
                        menuPageItem.setCol(this.itemButton.getCol());
                        break;
                    }
                    MenuPageDesignView.this.dropItem = null;
                    this.itemButton.updateView();
                    MenuPageDesignView.this.pageListener.uiUpdate();
                    this.itemButton.getModel().setPressed(false);
                }
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"), e);
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            boolean accept = false;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Transferable importTransferable = support.getTransferable();
                MenuPageItem transferData = (MenuPageItem)importTransferable.getTransferData(this.itemButton.dataFlavor);
                MenuPageDesignView.this.dropItem = this.itemButton.menuPageItem;
                if (transferData != null) {
                    int sourceRow = transferData.getRow();
                    int sourceCol = transferData.getCol();
                    transferData.setRow(this.itemButton.getRow());
                    transferData.setCol(this.itemButton.getCol());
                    this.itemButton.setMenuPageItem(transferData);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> pageItems = menuPage.getPageItems();
                    for (MenuPageItem menuPageItem : pageItems) {
                        if (menuPageItem == null || !menuPageItem.getRandomId().equals(transferData.getRandomId())) continue;
                        menuPageItem.setRow(this.itemButton.getRow());
                        menuPageItem.setCol(this.itemButton.getCol());
                        break;
                    }
                    MenuPageDesignView.this.dropItem.setRow(sourceRow);
                    MenuPageDesignView.this.dropItem.setCol(sourceCol);
                }
                this.itemButton.updateView();
                MenuPageDesignView.this.pageListener.uiUpdate();
                accept = true;
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"));
            }
            return accept;
        }
    }
}

