/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesignView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuPageForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class MenuPageDesigner
extends TransparentPanel
implements PageSelectionListener,
RefreshableView {
    private JList<MenuCategory> cbCategory;
    private JList<MenuGroup> cbGroup;
    private MenuPageDesignView itemView;
    private JList<MenuPage> listMenuPages;
    private ComboBoxModel menuPageListModel;
    private JButton btnSave;
    private JButton btnCancel;
    private JButton btnAutoBuildPages;
    private JButton btnHidePage;
    private JButton btnNewPage;
    private JButton btnEditPage;
    private JButton btnRemoveAllPage;
    private JButton btnRemovePage;
    private JButton btnNewCategory;
    private JButton btnNewGroup;
    private JButton btnDetachedAll;

    public MenuPageDesigner() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel topActionPanel = new JPanel(new GridLayout(0, 1));
        JPanel lefQuickAccessPanel = new JPanel(new BorderLayout());
        lefQuickAccessPanel.setPreferredSize(PosUIManager.getSize(300, 0));
        lefQuickAccessPanel.setBorder(new TitledBorder("-"));
        JPanel rightCategroyPanel = new JPanel();
        rightCategroyPanel.setPreferredSize(PosUIManager.getSize(130, 82));
        this.add((Component)rightCategroyPanel, "East");
        this.cbCategory = new JList(new ComboBoxModel());
        this.cbCategory.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.doSaveChanges();
                MenuPageDesigner.this.rendererSelectedCategory();
            }
        });
        this.cbGroup = new JList(new ComboBoxModel());
        this.cbGroup.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.doSaveChanges();
                MenuPageDesigner.this.rendererSelectedGroup();
            }
        });
        this.btnNewCategory = new JButton("+");
        this.btnNewGroup = new JButton("+");
        this.btnNewPage = new JButton("New Page");
        this.btnEditPage = new JButton("Edit Page");
        this.btnHidePage = new JButton("Hide Page");
        this.btnRemovePage = new JButton("Remove");
        this.btnRemoveAllPage = new JButton("Remove All");
        this.btnRemovePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doRemovePage();
            }
        });
        this.btnRemoveAllPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doRemoveAllPage();
            }
        });
        this.btnHidePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPage selectedPage = (MenuPage)MenuPageDesigner.this.listMenuPages.getSelectedValue();
                if (selectedPage == null) {
                    return;
                }
                selectedPage.setVisible(selectedPage.isVisible() == false);
                MenuPageDAO.getInstance().saveOrUpdate(selectedPage);
                MenuPageDesigner.this.btnHidePage.setText(selectedPage.isVisible() != false ? "Hide Page" : "Show Page");
            }
        });
        this.btnNewCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doAddNewCategory();
            }
        });
        this.btnNewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doAddNewGroup();
            }
        });
        this.btnNewPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doSaveChanges();
                MenuPageDesigner.this.doAddNewMenuPage();
            }
        });
        this.btnEditPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doSaveChanges();
                MenuPageDesigner.this.doEditMenuPage();
            }
        });
        this.btnAutoBuildPages = new JButton("Auto Build Pages");
        this.btnAutoBuildPages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doGenenateMenuPages();
            }
        });
        JScrollPane categoryScroller = new JScrollPane(this.cbCategory);
        categoryScroller.setBorder(new TitledBorder("Categories"));
        topActionPanel.add((Component)categoryScroller, String.format("grow, h %s", 200));
        JScrollPane groupScroller = new JScrollPane(this.cbGroup);
        groupScroller.setBorder(new TitledBorder("Groups"));
        topActionPanel.add((Component)groupScroller, String.format("newline, grow, h %s", 200));
        this.menuPageListModel = new ComboBoxModel();
        this.listMenuPages = new JList(this.menuPageListModel);
        this.listMenuPages.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.doSaveChanges();
                MenuPageDesigner.this.rendererSelectedPage();
            }
        });
        JScrollPane pageScroller = new JScrollPane(this.listMenuPages);
        pageScroller.setBorder(new TitledBorder("Pages"));
        topActionPanel.add((Component)pageScroller, String.format("newline, grow, wrap", new Object[0]));
        lefQuickAccessPanel.add(topActionPanel);
        JPanel leftButtonPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        leftButtonPanel.add((Component)this.btnAutoBuildPages, "growx");
        leftButtonPanel.add((Component)this.btnNewPage, "growx");
        leftButtonPanel.add((Component)this.btnEditPage, "growx,wrap");
        leftButtonPanel.add((Component)this.btnHidePage, "growx");
        leftButtonPanel.add((Component)this.btnRemovePage, "growx");
        leftButtonPanel.add((Component)this.btnRemoveAllPage, "growx");
        this.btnRemoveAllPage.setEnabled(false);
        lefQuickAccessPanel.add((Component)leftButtonPanel, "South");
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.itemView = new MenuPageDesignView();
        this.itemView.setPageListener(this);
        JPanel southItemActionPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JButton btnAddItem = new JButton("Add Item");
        btnAddItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doSelectPageItems();
            }
        });
        this.btnSave = new JButton("Save");
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doSaveMenuPage();
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPage menuPage = (MenuPage)MenuPageDesigner.this.listMenuPages.getSelectedValue();
                menuPage = MenuPageDAO.getInstance().get(menuPage.getId());
                MenuPageDesigner.this.btnCancel.setEnabled(false);
                MenuPageDesigner.this.btnSave.setEnabled(false);
                MenuPageDesigner.this.itemView.setMenuPage(menuPage);
            }
        });
        this.btnDetachedAll = new JButton("Detach All");
        this.btnDetachedAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuPageDesigner.this.doDetachAllItems();
            }
        });
        southItemActionPanel.add((Component)new JSeparator(), "grow,span");
        southItemActionPanel.add((Component)this.btnSave, "split 4");
        southItemActionPanel.add(this.btnCancel);
        southItemActionPanel.add(this.btnDetachedAll);
        this.itemView.add((Component)southItemActionPanel, "South");
        contentPanel.add(this.itemView);
        this.add((Component)lefQuickAccessPanel, "West");
        this.add(contentPanel);
        this.enableDisablePageButtons(false);
    }

    private void doSaveChanges() {
        if (this.btnSave.isEnabled()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Do you want to save the changes?", "Confirm") == 0) {
                this.doSaveMenuPage();
            } else {
                this.itemView.resetPage();
                this.btnSave.setEnabled(false);
                this.btnCancel.setEnabled(false);
            }
        }
    }

    protected void doSaveMenuPage() {
        MenuPage menuPage = this.listMenuPages.getSelectedValue();
        try {
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            this.btnSave.setEnabled(false);
            this.btnCancel.setEnabled(false);
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
    }

    private void doRemovePage() {
        try {
            MenuPage menuPage = this.listMenuPages.getSelectedValue();
            if (menuPage == null) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure you want to delete?", "Confirm") != 0) {
                return;
            }
            MenuPageDAO.getInstance().delete(menuPage);
            this.menuPageListModel.removeElement(menuPage);
            if (this.menuPageListModel.getSize() > 0) {
                this.listMenuPages.setSelectedIndex(this.menuPageListModel.getSize() - 1);
            } else {
                this.rendererSelectedPage();
            }
        }
        catch (Exception ex) {
            POSMessageDialog.showError(ex.getMessage());
        }
    }

    private void doRemoveAllPage() {
        try {
            List menuPageList = this.menuPageListModel.getDataList();
            if (menuPageList == null || menuPageList.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure you want to remove all pages from group " + this.cbGroup.getSelectedValue() + "?", "Confirm") != 0) {
                return;
            }
            MenuPageDAO.getInstance().deleteAll(menuPageList);
            this.menuPageListModel.removeAllElements();
            this.btnRemoveAllPage.setEnabled(false);
            this.rendererSelectedPage();
        }
        catch (Exception ex) {
            POSMessageDialog.showError(ex.getMessage());
        }
    }

    public void initData() {
        List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAll();
        ComboBoxModel categoryListModel = (ComboBoxModel)this.cbCategory.getModel();
        categoryListModel.setDataList(categories);
    }

    private void rendererSelectedCategory() {
        MenuCategory selectedCategory = this.cbCategory.getSelectedValue();
        if (selectedCategory == null) {
            return;
        }
        ComboBoxModel groupModel = (ComboBoxModel)this.cbGroup.getModel();
        groupModel.removeAllElements();
        this.menuPageListModel.removeAllElements();
        List<MenuGroup> groupList = MenuGroupDAO.getInstance().findByParent(selectedCategory);
        if (groupList != null) {
            groupModel.setDataList(groupList);
            if (groupList.size() > 0) {
                this.cbGroup.setSelectedIndex(0);
            }
        }
        this.listMenuPages.setSelectedValue(null, false);
        this.itemView.reset();
        this.itemView.revalidate();
        this.itemView.repaint();
    }

    private void rendererSelectedGroup() {
        this.menuPageListModel.removeAllElements();
        MenuGroup selectedGroup = this.cbGroup.getSelectedValue();
        if (selectedGroup != null) {
            List<MenuPage> menuPages = MenuPageDAO.getInstance().findByGroup(selectedGroup);
            if (menuPages != null && menuPages.size() > 0) {
                this.menuPageListModel.setDataList(menuPages);
                this.btnRemoveAllPage.setEnabled(true);
            } else {
                this.btnRemoveAllPage.setEnabled(false);
            }
        }
        this.rendererSelectedPage();
    }

    private void rendererSelectedPage() {
        MenuPage menuPage = null;
        if (this.menuPageListModel.getSize() > 0) {
            menuPage = this.listMenuPages.getSelectedValue();
            if (menuPage != null) {
                this.btnHidePage.setText(menuPage.isVisible() != false ? "Hide Page" : "Show Page");
                this.enableDisablePageButtons(true);
                this.btnRemoveAllPage.setEnabled(true);
            } else {
                this.enableDisablePageButtons(false);
            }
        } else {
            this.enableDisablePageButtons(false);
        }
        this.itemView.setMenuPage(menuPage);
    }

    private void enableDisablePageButtons(boolean enable) {
        this.btnEditPage.setEnabled(enable);
        this.btnHidePage.setEnabled(enable);
        this.btnRemovePage.setEnabled(enable);
        this.btnDetachedAll.setEnabled(enable);
    }

    public void doCreateNewPage() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Page not found.\n Do you want to create page?", "Confirm") != 0) {
            return;
        }
        int pageQuatity = (int)NumberSelectionDialog2.takeIntInput("Enter page quantity");
        if (pageQuatity < 1) {
            return;
        }
        ArrayList<MenuPage> menuPages = new ArrayList<MenuPage>();
        for (int i = 0; i < pageQuatity; ++i) {
            MenuPage page = new MenuPage();
            page.setName("Page " + (i + 1));
            menuPages.add(page);
        }
        try {
            MenuPageDAO.getInstance().saveOrUpdatePages(menuPages);
            this.menuPageListModel.setDataList(menuPages);
            this.listMenuPages.setSelectedIndex(0);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    protected List<MenuItem> getSelectedMenuItems(List<MenuItem> selectedItems) {
        MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
        dialog.setSelectionMode(1);
        dialog.setSize(PosUIManager.getSize(750, 515));
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        List<MenuItem> items = dialog.getSelectedItems();
        MenuPage page = this.listMenuPages.getSelectedValue();
        int pageSize = page.getCols() * page.getRows();
        if (items != null && items.size() > pageSize) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Maximum size is " + pageSize);
            return this.getSelectedMenuItems(items);
        }
        return items;
    }

    private void doAddNewCategory() {
        try {
            MenuCategoryForm editor = new MenuCategoryForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuCategory foodCategory = (MenuCategory)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbCategory.getModel();
            model.addElement(foodCategory);
            this.cbCategory.setSelectedValue(foodCategory, true);
        }
        catch (Exception e2) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, e2);
        }
    }

    private void doAddNewGroup() {
        try {
            MenuGroup group = new MenuGroup();
            MenuCategory menuCategory = this.cbCategory.getSelectedValue();
            if (menuCategory != null) {
                group.setMenuCategoryId(menuCategory.getId());
            } else {
                group.setMenuCategoryId(null);
            }
            MenuGroupForm editor = new MenuGroupForm(group);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuGroup foodGroup = (MenuGroup)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbGroup.getModel();
            model.addElement(foodGroup);
            this.cbCategory.setSelectedValue(foodGroup, true);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doSelectPageItems() {
        List<MenuItem> selectedItems;
        MenuPage menuPage = this.listMenuPages.getSelectedValue();
        if (menuPage == null) {
            POSMessageDialog.showMessage("Select page first.");
            return;
        }
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        HashMap<String, MenuPageItem> itemMap = new HashMap<String, MenuPageItem>();
        if (menuPage.getPageItems() != null) {
            for (MenuPageItem item : menuPage.getPageItems()) {
                if (item.getMenuItem() == null) continue;
                itemMap.put(item.getMenuItem().getId(), item);
                menuItems.add(item.getMenuItem());
            }
        }
        if ((selectedItems = this.getSelectedMenuItems(menuItems)) == null) {
            return;
        }
        if (menuPage.getPageItems() != null) {
            menuPage.getPageItems().clear();
        }
        ArrayList<MenuPageItem> newItems = new ArrayList<MenuPageItem>();
        for (MenuItem menuItem : selectedItems) {
            MenuPageItem pageItem = (MenuPageItem)itemMap.get(menuItem.getId());
            if (pageItem == null) {
                pageItem = new MenuPageItem();
                pageItem.setMenuItem(menuItem);
                pageItem.setMenuPage(menuPage);
                newItems.add(pageItem);
                continue;
            }
            menuPage.addTopageItems(pageItem);
        }
        this.btnSave.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.itemView.fillSelectedPageItems(newItems);
    }

    private void doGenenateMenuPages() {
        MenuGroup menuGroup = this.cbGroup.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Please select group first.");
            return;
        }
        List<MenuItem> items = MenuItemDAO.getInstance().findByParent(null, menuGroup, true);
        if (items == null || items.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Selected group has no item.");
            return;
        }
        MenuPageForm editor = new MenuPageForm(new MenuPage(), true);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        MenuPage menuPageWithInfo = (MenuPage)editor.getBean();
        int rows = menuPageWithInfo.getRows();
        int cols = menuPageWithInfo.getCols();
        int totalItemSize = items.size();
        int devideCount = (int)Math.ceil((double)totalItemSize / (double)(cols * rows));
        int loop = devideCount == 0 ? 1 : devideCount;
        ArrayList<MenuPageItem> pageItems = new ArrayList<MenuPageItem>();
        int index = 0;
        int count = 0;
        for (int i = 0; i < loop; ++i) {
            try {
                int totalItemPerPage;
                int size = this.menuPageListModel.getSize();
                MenuPage menuPage = null;
                if (menuPage == null) {
                    menuPage = new MenuPage();
                    menuPage.setMenuGroupId(menuGroup.getId());
                    menuPage.setName("Page " + (size + 1));
                    menuPage.setRows(rows);
                    menuPage.setCols(cols);
                    menuPage.setSortOrder(i);
                    menuPage.setFlixibleButtonSize(menuPageWithInfo.isFlixibleButtonSize());
                    menuPage.setButtonHeight(menuPageWithInfo.getButtonHeight());
                    menuPage.setButtonWidth(menuPageWithInfo.getButtonWidth());
                    MenuPageDAO.getInstance().saveOrUpdate(menuPage);
                    this.menuPageListModel.addElement(menuPage);
                }
                if (totalItemSize < (totalItemPerPage = cols * rows)) {
                    while (index < items.size()) {
                        MenuPageItem pageItem = new MenuPageItem();
                        pageItem.setMenuPage(menuPage);
                        pageItem.setMenuItem(items.get(index));
                        pageItems.add(pageItem);
                        menuPage.addTopageItems(pageItem);
                        ++index;
                    }
                } else {
                    int sub = 0;
                    while (sub < totalItemPerPage) {
                        MenuPageItem pageItem = new MenuPageItem();
                        pageItem.setMenuPage(menuPage);
                        pageItem.setMenuItem(items.get(index));
                        pageItems.add(pageItem);
                        menuPage.addTopageItems(pageItem);
                        ++sub;
                        ++index;
                    }
                }
                totalItemSize -= totalItemPerPage;
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols && count <= pageItems.size() - 1 && pageItems.get(count) != null; ++count, ++col) {
                        ((MenuPageItem)pageItems.get(count)).setRow(row);
                        ((MenuPageItem)pageItems.get(count)).setCol(col);
                    }
                }
                MenuPageDAO.getInstance().saveOrUpdate(menuPage);
                this.listMenuPages.setSelectedValue(menuPage, true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                BOMessageDialog.showError(ex.getMessage());
            }
        }
        this.itemView.repaint();
        this.itemView.revalidate();
    }

    private void doAddNewMenuPage() {
        MenuGroup selectedGroup = this.cbGroup.getSelectedValue();
        if (selectedGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Select group first.");
            return;
        }
        try {
            MenuPage page = new MenuPage();
            page.setMenuGroupId(selectedGroup.getId());
            page.setCols(4);
            page.setRows(4);
            int lastNum = this.getRandomNumber();
            page.setName("Page " + lastNum);
            page.setSortOrder(lastNum);
            MenuPageDAO.getInstance().saveOrUpdate(page);
            this.menuPageListModel.addElement(page);
            this.listMenuPages.setSelectedValue(page, true);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private int getRandomNumber() {
        String in = "";
        if (this.menuPageListModel.getSize() > 0) {
            MenuPage lastPage = (MenuPage)this.menuPageListModel.getElementAt(this.menuPageListModel.getSize() - 1);
            in = lastPage.getName();
        }
        Pattern p = Pattern.compile(".* ([0-9]+)");
        Matcher m = p.matcher(in);
        int nextNumber = this.menuPageListModel.getSize() + 1;
        if (m.find()) {
            try {
                int previousNumber = Integer.parseInt(m.group(1));
                if (previousNumber + 1 > nextNumber) {
                    nextNumber = previousNumber + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nextNumber;
    }

    private void doEditMenuPage() {
        MenuPage page = this.listMenuPages.getSelectedValue();
        if (page == null) {
            return;
        }
        MenuPageForm editor = new MenuPageForm(page, false);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        MenuPage menuPage = (MenuPage)editor.getBean();
        MenuPageDAO dao = new MenuPageDAO();
        dao.saveOrUpdate(menuPage);
        this.listMenuPages.setSelectedValue(menuPage, true);
        this.rendererSelectedPage();
    }

    private void doDetachAllItems() {
        MenuPage menuPage = this.listMenuPages.getSelectedValue();
        if (menuPage == null || menuPage.getPageItems() == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "No item to detach.");
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure you want to detach all?", "Confirm") != 0) {
            return;
        }
        if (menuPage.getPageItems() != null) {
            menuPage.getPageItems().clear();
        }
        MenuPageDAO.getInstance().saveOrUpdate(menuPage);
        this.itemView.setMenuPage(menuPage);
    }

    @Override
    public void itemSelected(Object item) {
        this.btnSave.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    @Override
    public void refresh() {
        MenuPage menuPage = this.itemView.getMenuPage();
        MenuPage menuPage2 = MenuPageDAO.getInstance().get(menuPage.getId());
        this.itemView.setMenuPage(menuPage2);
    }

    @Override
    public void uiUpdate() {
        this.btnSave.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }
}

