/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class DefaultModifierTable
extends JTable {
    private DefaultModifierTableModel model;

    public DefaultModifierTable(List<DefaultMenuModifier> defaultModifiers) {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.model = new DefaultModifierTableModel();
        this.model.setRows(defaultModifiers);
        this.setModel(this.model);
        this.getTableHeader().setPreferredSize(new Dimension(0, 35));
        this.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.setRowHeight(PosUIManager.getSize(40));
        List<Multiplier> multipliers = MultiplierDAO.getInstance().findAll();
        JComboBox<Object> cbMultipliers = new JComboBox<Object>(multipliers.toArray());
        cbMultipliers.setSelectedItem("");
        JTextComponent editor = (JTextComponent)cbMultipliers.getEditor().getEditorComponent();
        editor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    JComponent ja = (JComponent)e.getSource();
                    JComboBox jcbloc = (JComboBox)ja.getParent();
                    JTable jtb = (JTable)jcbloc.getParent();
                    jtb.changeSelection(0, 1, false, false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent ja = (JComponent)e.getSource();
                JComponent jcbloc = (JComponent)ja.getParent();
                JComboBox jcb = (JComboBox)jcbloc;
                jcb.setPopupVisible(true);
                JTextComponent editor = (JTextComponent)jcb.getEditor().getEditorComponent();
                editor.setSelectionStart(0);
                editor.setSelectionEnd(editor.getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        TableColumn colCombo = this.getColumnModel().getColumn(1);
        cbMultipliers.setEditable(true);
        ComboBoxEditor cbe = new ComboBoxEditor(cbMultipliers);
        colCombo.setCellEditor(cbe);
        TableColumn colQuantity = this.getColumnModel().getColumn(2);
        TextCellEditor quantityEditor = new TextCellEditor(new JTextField());
        colQuantity.setCellEditor(quantityEditor);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 1 || column == 2) {
            return true;
        }
        return super.isCellEditable(row, column);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (columnIndex > -1 && this.editCellAt(rowIndex, columnIndex)) {
            Component editor = this.getEditorComponent();
            editor.requestFocusInWindow();
            if (editor instanceof JTextField) {
                JTextField jf = (JTextField)editor;
                jf.select(0, jf.toString().length());
            }
            if (editor instanceof JComboBox) {
                JComboBox jcb = (JComboBox)editor;
                jcb.setPopupVisible(true);
                JTextComponent editorCombo = (JTextComponent)jcb.getEditor().getEditorComponent();
                editorCombo.setSelectionStart(0);
                editorCombo.setSelectionEnd(editorCombo.getText().length());
            }
        }
    }

    public void setItems(List<DefaultMenuModifier> defaultModifers) {
        this.model.setRows(defaultModifers);
    }

    public class TextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField jtextfield;

        public TextCellEditor(JTextField jtf) {
            this.jtextfield = jtf;
        }

        @Override
        public Object getCellEditorValue() {
            return this.jtextfield.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                // empty if block
            }
            if (value == null) {
                value = "";
            }
            if ((value = value.toString()) instanceof Integer) {
                value = value.toString();
            }
            this.jtextfield.setText((String)value);
            return this.jtextfield;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }

    public class ComboBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox comboBox;

        public ComboBoxEditor(JComboBox jcb) {
            this.comboBox = jcb;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comboBox.setSelectedItem(value);
            return this.comboBox;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }

    private class DefaultModifierTableModel
    extends ListTableModel<DefaultMenuModifier> {
        public DefaultModifierTableModel() {
            super(new String[]{"Modifier", "Multiplier", "Quantity"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DefaultMenuModifier item = (DefaultMenuModifier)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return item.getModifier();
                }
                case 1: {
                    return item.getMultiplier();
                }
                case 2: {
                    return item.getQuantity();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DefaultMenuModifier item = (DefaultMenuModifier)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    item.setMultiplier((Multiplier)aValue);
                    break;
                }
                case 2: {
                    double quantity = 1.0;
                    try {
                        quantity = Double.valueOf(String.valueOf(aValue));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    item.setQuantity(quantity);
                    break;
                }
                default: {
                    super.setValueAt(aValue, rowIndex, columnIndex);
                }
            }
        }
    }
}

