/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.ui.model.MultipleModifierSelectionView;
import com.floreantpos.ui.model.PizzaModifierForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ModifierSelectionDialog
extends POSDialog
implements ActionListener {
    private MultipleModifierSelectionView menuSelectorPanel;
    private List<MenuModifier> modifierList;
    private boolean pizzaModifierGroup;
    private boolean singleSelectionEnable;
    private TitlePanel titelpanel;
    private static ModifierSelectionDialog instance;
    private PosButton btnAdd;

    public ModifierSelectionDialog(List<MenuModifier> modifierList, boolean pizzaModifierGroup) {
        super(POSUtil.getFocusedWindow(), "");
        this.modifierList = modifierList;
        this.pizzaModifierGroup = pizzaModifierGroup;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle("Select Modifier");
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle("Select one or more modifiers");
        this.add((Component)this.titelpanel, "North");
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.menuSelectorPanel = new MultipleModifierSelectionView(this.modifierList, this.pizzaModifierGroup);
        contentPane.add((Component)this.menuSelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton("SELECT");
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        PosButton btnEdit = new PosButton();
        this.btnAdd = new PosButton();
        this.btnAdd.setText(POSConstants.ADD.toUpperCase());
        btnEdit.setText(POSConstants.EDIT.toUpperCase());
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierSelectionDialog.this.editSelectedRow();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuModifier menuModifier = new MenuModifier();
                    BeanEditor editor = null;
                    editor = ModifierSelectionDialog.this.pizzaModifierGroup ? new PizzaModifierForm(menuModifier) : new MenuModifierForm(menuModifier);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuModifier modifierItem = (MenuModifier)editor.getBean();
                    ModifierSelectionDialog.this.menuSelectorPanel.getModel().addRow(modifierItem);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        footerPanel.add(this.btnAdd);
        footerPanel.add(btnEdit);
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
    }

    public void setSingleSelectionEnable(boolean enable) {
        this.singleSelectionEnable = enable;
        if (enable) {
            this.titelpanel.setTitle("SELECT A MODIFIER");
        }
        this.menuSelectorPanel.setSingleSelectionEnable(enable);
    }

    public void setSelectedGroup(ModifierGroup group) {
        this.menuSelectorPanel.setSelectedGroup(group);
    }

    private void doOk() {
        if (this.singleSelectionEnable) {
            MenuModifier modifier = this.getSelectedRowData();
            if (modifier == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select modifier");
                return;
            }
        } else {
            List<MenuModifier> menuModifiers = this.menuSelectorPanel.getSelectedMenuModifierList();
            if (menuModifiers == null || menuModifiers.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select modifier");
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    private void editSelectedRow() {
        try {
            int index = this.menuSelectorPanel.getSelectedRow();
            if (index < 0) {
                return;
            }
            MenuModifier menuModifier = this.menuSelectorPanel.getModel().getRow(index);
            this.menuSelectorPanel.getModel().setRow(index, menuModifier);
            BeanEditor editor = null;
            editor = menuModifier.isPizzaModifier() != false ? new PizzaModifierForm(menuModifier) : new MenuModifierForm(menuModifier);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.menuSelectorPanel.repaintTable();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuModifier> getSelectedMenuModifierList() {
        return this.menuSelectorPanel.getSelectedMenuModifierList();
    }

    public MenuModifier getSelectedRowData() {
        int index = this.menuSelectorPanel.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.menuSelectorPanel.getModel().getRow(index);
    }

    public static ModifierSelectionDialog getInstance(List<MenuModifier> modifierList, boolean pizzaModifierGroup, boolean singleSelection) {
        if (instance == null) {
            instance = new ModifierSelectionDialog(modifierList, pizzaModifierGroup);
            instance.setSingleSelectionEnable(singleSelection);
        }
        return instance;
    }

    public void setModifiers(List<MenuModifier> modifiers) {
        this.btnAdd.setVisible(false);
        this.menuSelectorPanel.setModifiers(modifiers);
    }
}

